/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.filepanel;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.filepanel.ColumnComparator;
import wjhk.jupload2.policies.UploadPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilePanelDataModel2
extends AbstractTableModel {
    private static final long serialVersionUID = 1473262424494858913L;
    public static final int COLINDEX_NAME = 0;
    public static final int COLINDEX_SIZE = 1;
    public static final int COLINDEX_DIRECTORY = 2;
    public static final int COLINDEX_MODIFIED = 3;
    private UploadPolicy uploadPolicy = null;
    private String COL_NAME = null;
    private String COL_SIZE = null;
    private String COL_DIRECTORY = null;
    private String COL_MODIFIED = null;
    protected String[] columnNames = null;
    protected int[] columnSizePercentage = null;
    protected Class<?>[] columnClasses = null;
    private Vector<FileData> rows = new Vector();

    public FilePanelDataModel2(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
        this.COL_NAME = uploadPolicy.getLocalizedString("colName", new Object[0]);
        this.COL_SIZE = uploadPolicy.getLocalizedString("colSize", new Object[0]);
        this.COL_DIRECTORY = uploadPolicy.getLocalizedString("colDirectory", new Object[0]);
        this.COL_MODIFIED = uploadPolicy.getLocalizedString("colModified", new Object[0]);
        this.columnNames = new String[]{this.COL_NAME, this.COL_SIZE, this.COL_DIRECTORY, this.COL_MODIFIED};
        this.columnSizePercentage = new int[]{30, 13, 37, 20};
        int total = 0;
        for (int i = 0; i < this.columnSizePercentage.length; ++i) {
            total += this.columnSizePercentage[i];
        }
        if (total != 100) {
            throw new AssertionError((Object)("Total sum of '" + this.getClass().getName() + ".columnSizePercentage' should be 100% (but was " + total + ")"));
        }
        this.columnClasses = new Class[]{String.class, Long.class, String.class, Date.class, Boolean.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(File file) {
        boolean found = false;
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            Iterator<FileData> i = this.rows.iterator();
            while (i.hasNext()) {
                if (!file.equals(i.next().getFile())) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, File root) throws JUploadExceptionStopAddingFiles {
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            if (this.contains(file)) {
                this.uploadPolicy.displayWarn("File " + file.getName() + " already exists");
            } else {
                FileData df = this.uploadPolicy.createFileData(file, root);
                if (df != null) {
                    this.rows.add(df);
                    this.fireTableDataChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileAt(int row) {
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            FileData fileData = this.rows.get(row);
            return fileData == null ? null : fileData.getFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileData getFileDataAt(int row) {
        int size = -1;
        if (row >= 0) {
            try {
                Vector<FileData> vector = this.rows;
                synchronized (vector) {
                    size = this.rows.size();
                    return row < size ? this.rows.get(row) : null;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + " in FilePanelDataModel2.getFileDataAt(" + row + ")");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeRow(int row) {
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            this.rows.remove(row);
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeRow(FileData fileData) {
        boolean found = false;
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            for (FileData item : this.rows) {
                if (!item.getFile().equals(fileData.getFile())) continue;
                this.rows.removeElement(item);
                found = true;
                break;
            }
        }
        if (found) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            return this.rows.size();
        }
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortColumn(int col, boolean ascending) {
        Vector<FileData> vector = this.rows;
        synchronized (vector) {
            Collections.sort(this.rows, new ColumnComparator(col, ascending));
        }
        this.fireTableDataChanged();
    }

    public boolean isSortable(int col) {
        return Boolean.class != this.getColumnClass(col);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return this.columnClasses[arg0];
    }

    @Override
    public Object getValueAt(int row, int col) {
        FileData fileData = this.getFileDataAt(row);
        if (fileData != null) {
            String colName = this.getColumnName(col);
            if (colName.equals(this.COL_NAME)) {
                return fileData.getFileName();
            }
            if (colName.equals(this.COL_SIZE)) {
                return fileData.getFileLength();
            }
            if (colName.equals(this.COL_DIRECTORY)) {
                return fileData.getDirectory();
            }
            if (colName.equals(this.COL_MODIFIED)) {
                return fileData.getLastModified();
            }
            this.uploadPolicy.displayErr("Unknown column in " + this.getClass().getName() + ": " + colName);
        }
        return null;
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        this.uploadPolicy.displayWarn(this.getClass().getName() + ".setValueAt: no action");
    }

    @Override
    public String getColumnName(int arg0) {
        return this.columnNames[arg0];
    }

    public int getColumnSizePercentage(int col) {
        return this.columnSizePercentage[col];
    }
}

