/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.util.ArrayList;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.UploadFileData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadFilePacket
extends ArrayList<UploadFileData> {
    UploadPolicy uploadPolicy = null;
    long nbBytes = 0L;
    long maxNbBytes = -1L;
    long maxNbFiles = -1L;

    UploadFilePacket(UploadPolicy uploadPolicy) {
        super(Math.min(uploadPolicy.getNbFilesPerRequest(), uploadPolicy.getContext().getUploadPanel().getFilePanel().getFilesLength()));
        this.uploadPolicy = uploadPolicy;
        this.maxNbBytes = this.uploadPolicy.getMaxChunkSize();
        this.maxNbFiles = Math.min(uploadPolicy.getNbFilesPerRequest(), uploadPolicy.getContext().getUploadPanel().getFilePanel().getFilesLength());
    }

    public synchronized boolean canAdd(UploadFileData uploadFileData) {
        if (this.size() == 0) {
            return true;
        }
        if ((long)this.size() == this.maxNbFiles) {
            return false;
        }
        return this.nbBytes + uploadFileData.getUploadLength() <= this.maxNbBytes;
    }

    public synchronized boolean isFull() {
        return (long)this.size() == this.maxNbFiles || this.nbBytes >= this.maxNbBytes;
    }

    @Override
    public synchronized boolean add(UploadFileData uploadFileData) {
        if (!this.canAdd(uploadFileData)) {
            return false;
        }
        if (!super.add(uploadFileData)) {
            return false;
        }
        this.nbBytes += uploadFileData.getUploadLength();
        return true;
    }

    public boolean isPoisonned() {
        return false;
    }

    @Override
    public UploadFileData remove(int index) {
        throw new UnsupportedOperationException("Removing a file from an UploadFilePacket is prohibited");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Removing a file from an UploadFilePacket is prohibited");
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Removing a file from an UploadFilePacket is prohibited");
    }
}

