SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE IF NOT EXISTS `#__action_logs` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE IF NOT EXISTS `#__action_logs_extensions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin');

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE IF NOT EXISTS `#__action_logs_users` (
  `user_id` int(11) UNSIGNED NOT NULL,
  `notify` tinyint(1) UNSIGNED NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE IF NOT EXISTS `#__action_log_config` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');

DROP TABLE IF EXISTS `#__acymailing_action`;
CREATE TABLE IF NOT EXISTS `#__acymailing_action` (
  `action_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `frequency` int(10) UNSIGNED NOT NULL,
  `nextdate` int(10) UNSIGNED NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` varchar(50) NOT NULL,
  `connection_method` varchar(10) NOT NULL DEFAULT '0',
  `secure_method` varchar(10) NOT NULL DEFAULT '0',
  `self_signed` tinyint(4) NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `conditions` text,
  `actions` text,
  `report` text,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `delete_wrong_emails` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_config`;
CREATE TABLE IF NOT EXISTS `#__acymailing_config` (
  `namekey` varchar(200) NOT NULL,
  `value` text,
  PRIMARY KEY (`namekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_config` (`namekey`, `value`) VALUES
('level', 'Starter'),
('version', '5.10.1'),
('smtp_port', '25'),
('from_name', ''),
('from_email', ''),
('bounce_email', ''),
('mailer_method', 'phpmail'),
('sendmail_path', '/usr/sbin/sendmail'),
('smtp_secured', ''),
('smtp_auth', '0'),
('smtp_username', ''),
('smtp_password', ''),
('reply_name', ''),
('reply_email', ''),
('cron_sendto', 'admin@admin.com'),
('add_names', '1'),
('encoding_format', '8bit'),
('charset', 'UTF-8'),
('word_wrapping', '150'),
('hostname', ''),
('embed_images', '0'),
('embed_files', '1'),
('editor', 'acyeditor'),
('multiple_part', '1'),
('smtp_host', 'localhost'),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_type', 'auto'),
('queue_try', '3'),
('queue_pause', '120'),
('allow_visitor', '1'),
('require_confirmation', '0'),
('priority_newsletter', '3'),
('allowedfiles', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('uploadfolder', 'media/com_acymailing/upload'),
('confirm_redirect', ''),
('subscription_message', '1'),
('notification_unsuball', ''),
('cron_next', '1251990901'),
('confirmation_message', '1'),
('welcome_message', '1'),
('unsub_message', '1'),
('cron_last', '0'),
('cron_fromip', ''),
('cron_report', ''),
('cron_frequency', '900'),
('cron_sendreport', '2'),
('cron_fullreport', '1'),
('cron_savereport', '2'),
('cron_savepath', 'media/com_acymailing/logs/report{year}_{month}.log'),
('notification_created', ''),
('notification_accept', ''),
('notification_refuse', ''),
('forward', '0'),
('description_starter', 'Joomla!® Mailing Extension'),
('description_essential', 'Joomla!® E-mail Marketing'),
('description_business', 'Joomla!® Mailing Extension'),
('description_enterprise', 'Joomla!® Newsletter Extension'),
('priority_followup', '2'),
('unsub_redirect', ''),
('show_footer', '0'),
('use_sef', '0'),
('itemid', '0'),
('css_module', ''),
('css_frontend', 'default'),
('css_backend', ''),
('bootstrap_frontend', '0'),
('menu_position', 'above'),
('unsub_reasons', 'a:2:{i:0;s:21:\"UNSUB_SURVEY_FREQUENT\";i:1;s:21:\"UNSUB_SURVEY_RELEVANT\";}'),
('security_key', 'VvpaKMHVvjyqdWN9RX4g42Ukd2b5GC'),
('installcomplete', '1'),
('Starter', '0'),
('Essential', '1'),
('Business', '2'),
('Enterprise', '3'),
('website', 'http://localhost/joomla/master-b3-t3_update11/test/full/'),
('max_execution_time', '0'),
('last_maxexec_check', '1503508032'),
('ssl_links', '0'),
('smtp_keepalive', '1'),
('elasticemail_username', ''),
('elasticemail_password', ''),
('elasticemail_port', 'rest'),
('bounce_action_maxtry', 'noaction'),
('bounce_action_lists_maxtry', '1'),
('sendorder', 'subid,ASC'),
('autosub', 'None'),
('allow_modif', 'data'),
('generate_name', '1'),
('notification_unsub', ''),
('notification_contact', ''),
('notification_contact_menu', ''),
('notification_confirm', ''),
('sub_redirect', ''),
('modif_redirect', ''),
('module_redirect', ''),
('redirect_tags', '0'),
('show_order', '1'),
('unsubscription_message', '1'),
('confirm_message', '0'),
('comments_feature', ''),
('disqus_shortname', ''),
('frontend_subject', '1'),
('frontend_print', '0'),
('show_description', '1'),
('show_filter', '1'),
('show_headings', '1'),
('show_senddate', '1'),
('show_colnumber', '1'),
('open_popup', '1'),
('popup_width', '750'),
('popup_height', '550'),
('indexFollow', '1'),
('unsub_intro', 'UNSUB_INTRO'),
('unsub_dispoptions', '1'),
('unsub_survey', '1'),
('acyrss_format', ''),
('acyrss_name', ''),
('acyrss_description', ''),
('acyrss_element', '20'),
('acyrss_order', 'senddate'),
('email_checkdomain', '0'),
('email_botscout', '0'),
('email_botscout_key', ''),
('email_stopforumspam', '0'),
('email_iptimecheck', '0'),
('mediafolder', 'media/com_acymailing/upload'),
('description_sidekick', 'Joomla!® Newsletter System'),
('Sidekick', '4'),
('captcha_plugin', 'no'),
('latestversion', '5.10.1'),
('expirationdate', '0'),
('lastlicensecheck', '1528122609'),
('special_chars', '0'),
('unsub_dispothersubs', '0'),
('pluginNeedUpdate', ''),
('export_excelsecurity', '1'),
('gdpr_export', '0'),
('anonymous_tracking', '0'),
('anonymizeold', '0');

DROP TABLE IF EXISTS `#__acymailing_fields`;
CREATE TABLE IF NOT EXISTS `#__acymailing_fields` (
  `fieldid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `fieldname` varchar(250) NOT NULL,
  `namekey` varchar(50) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `value` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` smallint(5) UNSIGNED DEFAULT '99',
  `options` text,
  `core` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `required` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `backend` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `frontcomp` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `default` text,
  `listing` tinyint(3) UNSIGNED DEFAULT NULL,
  `frontlisting` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaregistration` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `joomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `fieldcat` int(11) NOT NULL DEFAULT '0',
  `listingfilter` tinyint(4) DEFAULT NULL,
  `frontlistingfilter` tinyint(4) DEFAULT NULL,
  `frontform` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`fieldid`),
  UNIQUE KEY `namekey` (`namekey`),
  KEY `orderingindex` (`published`,`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_fields` (`fieldid`, `fieldname`, `namekey`, `type`, `value`, `published`, `ordering`, `options`, `core`, `required`, `backend`, `frontcomp`, `default`, `listing`, `frontlisting`, `frontjoomlaprofile`, `frontjoomlaregistration`, `joomlaprofile`, `access`, `fieldcat`, `listingfilter`, `frontlistingfilter`, `frontform`) VALUES
(1, 'NAMECAPTION', 'name', 'text', '', 1, 1, '', 1, 0, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(2, 'EMAILCAPTION', 'email', 'text', '', 1, 2, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(3, 'RECEIVE', 'html', 'radio', '0::JOOMEXT_TEXT\n1::HTML', 1, 3, '', 1, 1, 1, 1, '1', 1, 0, 0, 0, 0, 'all', 0, NULL, NULL, 1);

DROP TABLE IF EXISTS `#__acymailing_filter`;
CREATE TABLE IF NOT EXISTS `#__acymailing_filter` (
  `filid` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `lasttime` int(10) UNSIGNED DEFAULT NULL,
  `trigger` text,
  `report` text,
  `action` text,
  `filter` text,
  `daycron` int(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`filid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_forward`;
CREATE TABLE IF NOT EXISTS `#__acymailing_forward` (
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `nbforwarded` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`subid`,`mailid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_geolocation`;
CREATE TABLE IF NOT EXISTS `#__acymailing_geolocation` (
  `geolocation_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `geolocation_subid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_type` varchar(255) NOT NULL DEFAULT 'subscription',
  `geolocation_ip` varchar(255) NOT NULL DEFAULT '',
  `geolocation_created` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_latitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_longitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_postal_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_city` varchar(255) NOT NULL DEFAULT '',
  `geolocation_continent` varchar(255) NOT NULL DEFAULT '',
  `geolocation_timezone` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`geolocation_id`),
  KEY `geolocation_type` (`geolocation_subid`,`geolocation_type`),
  KEY `geolocation_ip_created` (`geolocation_ip`,`geolocation_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_history`;
CREATE TABLE IF NOT EXISTS `#__acymailing_history` (
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(50) NOT NULL COMMENT 'different actions: created,modified,confirmed',
  `data` text,
  `source` text,
  `mailid` mediumint(8) UNSIGNED DEFAULT NULL,
  KEY `subid` (`subid`,`date`),
  KEY `dateindex` (`date`),
  KEY `actionindex` (`action`,`mailid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_history` (`subid`, `date`, `ip`, `action`, `data`, `source`, `mailid`) VALUES
(3, 1418120944, '192.168.9.17', 'created', '', 'HTTP_REFERER::http://192.168.9.17/framework/default/index.php/user-registration\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/framework/default/index.php/user-registration?task=registration.register\nQUERY_STRING::task=registration.register', 0),
(3, 1418121419, '192.168.9.17', 'confirmed', 'EXECUTED_BY::846 ( demo )', 'HTTP_REFERER::http://192.168.9.17/framework/default/administrator/index.php?option=com_users\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/framework/default/administrator/index.php?option=com_users&view=users\nQUERY_STRING::option=com_users&view=users', 0),
(4, 1418121448, '192.168.9.17', 'created', '', 'HTTP_REFERER::http://192.168.9.17/framework/default/index.php/user-registration\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/framework/default/index.php/user-registration?task=registration.register\nQUERY_STRING::task=registration.register', 0),
(4, 1418121459, '192.168.9.17', 'confirmed', 'EXECUTED_BY::846 ( demo )', 'HTTP_REFERER::http://192.168.9.17/framework/default/administrator/index.php?option=com_users&view=users\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/framework/default/administrator/index.php?option=com_users&view=users\nQUERY_STRING::option=com_users&view=users', 0),
(5, 1418218543, '192.168.9.125', 'created', '', 'HTTP_REFERER::http://192.168.9.17/framework/default/\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.1\nREQUEST_URI::/framework/default/index.php', 0),
(6, 1427376525, '192.168.9.17', 'created', '', 'HTTP_REFERER::http://192.168.9.17/framework/\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:36.0) Gecko/20100101 Firefox/36.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/framework/index.php', 0),
(2, 1430752922, '192.168.9.17', 'modified', 'EXECUTED_BY::846 ( demo )', 'HTTP_REFERER::http://192.168.9.17/framework/\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:37.0) Gecko/20100101 Firefox/37.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/framework/index.php', 0),
(7, 1443442316, '192.168.9.17', 'created', '', 'HTTP_REFERER::http://192.168.9.17/joomla/beta/\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.0\nHTTP_HOST::192.168.9.17\nSERVER_ADDR::192.168.9.17\nREMOTE_ADDR::192.168.9.17\nREQUEST_URI::/joomla/beta/index.php', 0),
(8, 1466683696, '192.168.9.155', 'created', '', 'HTTP_REFERER::http://192.168.9.155/joomla/master-update/v1/\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:47.0) Gecko/20100101 Firefox/47.0\nHTTP_HOST::192.168.9.155\nSERVER_ADDR::192.168.9.155\nREMOTE_ADDR::192.168.9.155\nREQUEST_URI::/joomla/master-update/v1/index.php', 0),
(9, 1517242706, '127.0.0.1', 'created', '', 'HTTP_REFERER::http://localhost/joomla/master-b3-t3_update2/master/\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0\nHTTP_HOST::localhost\nSERVER_ADDR::127.0.0.1\nREMOTE_ADDR::127.0.0.1\nREQUEST_URI::/joomla/master-b3-t3_update2/master/index.php', 0),
(10, 1532357995, '192.168.9.55', 'created', '', 'HTTP_REFERER::http://192.168.9.55/framework/2018/06June/theme3589/index.php/user-registration\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 6.1; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0\nHTTP_HOST::192.168.9.55\nSERVER_ADDR::192.168.9.55\nREMOTE_ADDR::192.168.9.55\nREQUEST_URI::/framework/2018/06June/theme3589/index.php/user-registration?task=registration.register\nQUERY_STRING::task=registration.register', 0);

DROP TABLE IF EXISTS `#__acymailing_list`;
CREATE TABLE IF NOT EXISTS `#__acymailing_list` (
  `name` varchar(250) NOT NULL,
  `description` text,
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `listid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `published` tinyint(4) DEFAULT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `welmailid` mediumint(9) DEFAULT NULL,
  `unsubmailid` mediumint(9) DEFAULT NULL,
  `type` enum('list','campaign') NOT NULL DEFAULT 'list',
  `access_sub` varchar(250) NOT NULL DEFAULT 'all',
  `access_manage` varchar(250) NOT NULL DEFAULT 'none',
  `languages` varchar(250) NOT NULL DEFAULT 'all',
  `startrule` varchar(50) NOT NULL DEFAULT '0',
  `category` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`listid`),
  KEY `typeorderingindex` (`type`,`ordering`),
  KEY `useridindex` (`userid`),
  KEY `typeuseridindex` (`type`,`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_list` (`name`, `description`, `ordering`, `listid`, `published`, `userid`, `alias`, `color`, `visible`, `welmailid`, `unsubmailid`, `type`, `access_sub`, `access_manage`, `languages`, `startrule`, `category`) VALUES
('Newsletters', 'Receive our latest news', 1, 1, 1, 846, 'mailing_list', '#3366ff', 1, NULL, NULL, 'list', 'all', 'none', 'all', '0', '');

DROP TABLE IF EXISTS `#__acymailing_listcampaign`;
CREATE TABLE IF NOT EXISTS `#__acymailing_listcampaign` (
  `campaignid` smallint(5) UNSIGNED NOT NULL,
  `listid` smallint(5) UNSIGNED NOT NULL,
  PRIMARY KEY (`campaignid`,`listid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_listmail`;
CREATE TABLE IF NOT EXISTS `#__acymailing_listmail` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  PRIMARY KEY (`listid`,`mailid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_listsub`;
CREATE TABLE IF NOT EXISTS `#__acymailing_listsub` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `subdate` int(10) UNSIGNED DEFAULT NULL,
  `unsubdate` int(10) UNSIGNED DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  PRIMARY KEY (`listid`,`subid`),
  KEY `subidindex` (`subid`),
  KEY `listidstatusindex` (`listid`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_listsub` (`listid`, `subid`, `subdate`, `unsubdate`, `status`) VALUES
(1, 1, 1415263735, NULL, 1),
(1, 2, 1415263735, NULL, 1),
(1, 5, 1418218543, NULL, 1),
(1, 6, 1427376525, NULL, 1),
(1, 7, 1443442316, NULL, 1),
(1, 8, 1466683696, NULL, 1),
(1, 9, 1517242706, NULL, 1);

DROP TABLE IF EXISTS `#__acymailing_mail`;
CREATE TABLE IF NOT EXISTS `#__acymailing_mail` (
  `mailid` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `subject` text,
  `body` longtext NOT NULL,
  `altbody` longtext NOT NULL,
  `published` tinyint(4) DEFAULT '1',
  `senddate` int(10) UNSIGNED DEFAULT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `type` enum('news','autonews','followup','unsub','welcome','notification','joomlanotification','action','article') NOT NULL DEFAULT 'news',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `attach` text,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `tempid` smallint(6) NOT NULL DEFAULT '0',
  `key` varchar(200) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `params` text,
  `sentby` int(10) UNSIGNED DEFAULT NULL,
  `metakey` text,
  `metadesc` text,
  `filter` text,
  `language` varchar(50) NOT NULL DEFAULT '',
  `abtesting` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `summary` text NOT NULL,
  `favicon` text,
  `bccaddresses` varchar(250) DEFAULT NULL,
  `lastupdate` int(10) UNSIGNED DEFAULT NULL,
  `userlastupdate` int(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`mailid`),
  KEY `senddate` (`senddate`),
  KEY `typemailidindex` (`type`,`mailid`),
  KEY `useridindex` (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_mail` (`mailid`, `subject`, `body`, `altbody`, `published`, `senddate`, `created`, `fromname`, `fromemail`, `replyname`, `replyemail`, `type`, `visible`, `userid`, `alias`, `attach`, `html`, `tempid`, `key`, `frequency`, `params`, `sentby`, `metakey`, `metadesc`, `filter`, `language`, `abtesting`, `thumb`, `summary`, `favicon`, `bccaddresses`, `lastupdate`, `userlastupdate`) VALUES
(1, 'New Subscriber on your website : {user:email}', '<p>Hello {subtag:name},</p><p>A new user has been created in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_created', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(2, 'A User unsubscribed from all your lists : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from all your lists</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsuball', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(3, 'A User unsubscribed : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from your list</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsub', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(4, 'A User refuses to receive e-mails from your website : {user:email}', '<p>The User {user:name} : {user:email} refuses to receive any e-mail anymore from your website.</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_refuse', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(5, 'New contact from your website : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(6, 'A user subscribed or modified his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact_menu', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(7, 'A user confirmed his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user confirmed his subscription : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_confirm', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(8, '{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}', '<div style=\"text-align: center; width: 100%; background-color: #ffffff;\">\r\n			<table style=\"text-align:justify; margin:auto; background-color:#ebebeb; border:1px solid #e7e7e7\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" align=\"center\" bgcolor=\"#ebebeb\">\r\n			<tbody>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"38px\"><img src=\"media/com_acymailing/templates/newsletter-4/top.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			<tr>\r\n			<td style=\"text-align:center\" width=\"600\">\r\n			<table style=\"margin:auto;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"520\">\r\n			<tbody>\r\n			<tr>\r\n			<td style=\"background-color: #ffffff; border: 1px solid #dbdbdb; padding: 20px; width: 500px; margin: 15px auto; text-align: left;\">\r\n			<h1>Hello {subtag:name|ucfirst},</h1>\r\n			<p>{trans:CONFIRM_MSG}<br /><br />{trans:CONFIRM_MSG_ACTIVATE}</p>\r\n			<br />\r\n			<p style=\"text-align:center;\"><strong>{confirm}{trans:CONFIRM_SUBSCRIPTION}{/confirm}</strong></p>\r\n			</td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</td>\r\n			</tr>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"40px\"><img src=\"media/com_acymailing/templates/newsletter-4/bottom.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'confirmation', NULL, 1, 1, NULL, NULL, 'a:3:{s:6:\"action\";s:7:\"confirm\";s:13:\"actionbtntext\";s:28:\"{trans:CONFIRM_SUBSCRIPTION}\";s:9:\"actionurl\";s:19:\"{confirm}{/confirm}\";}', NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(9, 'AcyMailing Cron Report {mainreport}', '<p>{report}</p><p>{detailreport}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'report', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(10, 'Modify your subscription', '<p>Hello {subtag:name}, </p><p>You requested some changes on your subscription,</p><p>Please {modify}click here{/modify} to be identified as the owner of this account and then modify your subscription.</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'modif', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(11, '{joomlacontent:current| type:title}', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n		<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width: 600px;\">\r\n			<tbody>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_2\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\" id=\"zone_3\"><img id=\"zone_29\" alt=\" - - - \" border=\"0\" src=\"http://localhost/joomla/master-b3-t3_update2/master//media/com_acymailing/templates/newsletter-4/images/top.png\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_4\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_5\"></td>\r\n					<td class=\"w520 acyeditor_text\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: #ebebeb;\" width=\"520\" id=\"zone_6\"><strong>​</strong>​​​​​​​​<img alt=\"-\" border=\"0\" src=\"http://localhost/joomla/master-b3-t3_update2/master//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float: left; margin-right: 10px;\">\r\n						<h3>{joomlacontent:current| type:title}<span style=\"display: none;\">&nbsp;</span></h3>\r\n					</td>\r\n					<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_7\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_8\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_9\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_10\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_11\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_12\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_13\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_14\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_15\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_16\"></td>\r\n					<td class=\"w480 pict acyeditor_text\" style=\"background-color: #fff; text-align: left;\" width=\"480\" id=\"zone_17\">{joomlacontent:current| type:intro| format:TOP_LEFT| pict:1| link}</td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_18\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_19\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_20\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_21\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_22\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_23\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_24\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_25\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_26\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #ebebeb;\" width=\"600\" id=\"zone_27\"><img id=\"zone_31\" alt=\" - - - \" border=\"0\" src=\"http://localhost/joomla/master-b3-t3_update2/master//media/com_acymailing/templates/newsletter-4/images/bottom.png\"></td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n		</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'article', 0, NULL, 'send-in-article', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL);

DROP TABLE IF EXISTS `#__acymailing_queue`;
CREATE TABLE IF NOT EXISTS `#__acymailing_queue` (
  `senddate` int(10) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `priority` tinyint(3) UNSIGNED DEFAULT '3',
  `try` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `paramqueue` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`subid`,`mailid`),
  KEY `listingindex` (`senddate`,`subid`),
  KEY `mailidindex` (`mailid`),
  KEY `orderingindex` (`priority`,`senddate`,`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_rules`;
CREATE TABLE IF NOT EXISTS `#__acymailing_rules` (
  `ruleid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL,
  PRIMARY KEY (`ruleid`),
  KEY `ordering` (`published`,`ordering`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_stats`;
CREATE TABLE IF NOT EXISTS `#__acymailing_stats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `senthtml` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senttext` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senddate` int(10) UNSIGNED NOT NULL,
  `openunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `opentotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `bounceunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `fail` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `clicktotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `clickunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `unsub` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `forward` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `bouncedetails` text,
  PRIMARY KEY (`mailid`),
  KEY `senddateindex` (`senddate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_subscriber`;
CREATE TABLE IF NOT EXISTS `#__acymailing_subscriber` (
  `subid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` varchar(200) NOT NULL,
  `userid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL DEFAULT '',
  `created` int(10) UNSIGNED DEFAULT NULL,
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `accept` tinyint(4) NOT NULL DEFAULT '1',
  `ip` varchar(100) DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `key` varchar(250) DEFAULT NULL,
  `confirmed_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `confirmed_ip` varchar(100) DEFAULT NULL,
  `lastopen_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastopen_ip` varchar(100) DEFAULT NULL,
  `lastclick_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastsent_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `source` varchar(50) NOT NULL DEFAULT '',
  `filterflags` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`subid`),
  UNIQUE KEY `email` (`email`),
  KEY `userid` (`userid`),
  KEY `queueindex` (`enabled`,`accept`,`confirmed`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_subscriber` (`subid`, `email`, `userid`, `name`, `created`, `confirmed`, `enabled`, `accept`, `ip`, `html`, `key`, `confirmed_date`, `confirmed_ip`, `lastopen_date`, `lastopen_ip`, `lastclick_date`, `lastsent_date`, `source`, `filterflags`) VALUES
(1, 'admin@admin.com', 787, 'Super User', 1414757087, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', ''),
(2, 'demo@demolink.org', 846, 'Demo User', 1350460572, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', ''),
(3, 'lorem_ipsum@demolink.org', 847, 'Lorem Ipsum', 1418120944, 1, 1, 1, '192.168.9.17', 1, 'VgqgGnB4hRm6xz', 1418121419, '192.168.9.17', 0, NULL, 0, 0, 'joomla', ''),
(4, 'dolor_sit@demolink.org', 848, 'Dolor Sit', 1418121448, 1, 1, 1, '192.168.9.17', 1, 'GrHSwPnkMc0MCT', 1418121459, '192.168.9.17', 0, NULL, 0, 0, 'joomla', ''),
(5, 'rwrw2@1312.aa', 0, 'Rwrw', 1418218543, 0, 1, 1, '192.168.9.125', 1, 'jcRABK1Y1ZSxa9', 0, NULL, 0, NULL, 0, 0, '', ''),
(6, 'admin@admin.co', 0, 'Admin', 1427376525, 0, 1, 1, '192.168.9.17', 1, 'bywCJIRslYdTAD', 0, NULL, 0, NULL, 0, 0, '', ''),
(7, 'm@m.com', 0, 'M', 1443442316, 0, 1, 1, '192.168.9.17', 1, 'XzmOX7h6mH83Cx', 0, NULL, 0, NULL, 0, 0, '', ''),
(8, 'as@as.cxom', 0, 'As', 1466683696, 0, 1, 1, '192.168.9.155', 1, 'VQvZj62Cnyia8z', 0, NULL, 0, NULL, 0, 0, '', ''),
(9, 'asgas@asd.com', 0, 'sad', 1517242706, 0, 1, 1, '127.0.0.1', 1, 'TiE9eySsrjDhyx', 0, NULL, 0, NULL, 0, 0, 'module_279', ''),
(10, 'xfd@dfg.dswer', 849, 'gfhgfh', 1532357994, 0, 0, 1, '192.168.9.55', 1, 'ddyg583iqgydFx', 0, NULL, 0, NULL, 0, 0, 'joomla', '');

DROP TABLE IF EXISTS `#__acymailing_tag`;
CREATE TABLE IF NOT EXISTS `#__acymailing_tag` (
  `tagid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`tagid`),
  KEY `useridindex` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_tagmail`;
CREATE TABLE IF NOT EXISTS `#__acymailing_tagmail` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  PRIMARY KEY (`tagid`,`mailid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_template`;
CREATE TABLE IF NOT EXISTS `#__acymailing_template` (
  `tempid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `body` longtext,
  `altbody` longtext,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `premium` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `namekey` varchar(50) NOT NULL,
  `styles` text,
  `subject` varchar(250) DEFAULT NULL,
  `stylesheet` text,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `readmore` varchar(250) DEFAULT NULL,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `category` varchar(250) NOT NULL DEFAULT '',
  `header` longtext,
  PRIMARY KEY (`tempid`),
  UNIQUE KEY `namekey` (`namekey`),
  KEY `orderingindex` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_template` (`tempid`, `name`, `description`, `body`, `altbody`, `created`, `published`, `premium`, `ordering`, `namekey`, `styles`, `subject`, `stylesheet`, `fromname`, `fromemail`, `replyname`, `replyemail`, `thumb`, `readmore`, `access`, `category`, `header`) VALUES
(1, 'Notification template', '', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don\'t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 1, 'newsletter-4', 'a:10:{s:6:\"tag_h1\";s:76:\"color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;\";s:6:\"tag_h2\";s:106:\"color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;\";s:6:\"tag_h3\";s:144:\"color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;\";s:6:\"tag_h4\";s:117:\"color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;\";s:5:\"tag_a\";s:71:\"color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;\";s:19:\"acymailing_readmore\";s:90:\"font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;\";s:17:\"acymailing_online\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:16:\"acymailing_unsub\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:8:\"color_bg\";s:7:\"#ffffff\";s:18:\"acymailing_content\";s:19:\"text-align:justify;\";}', NULL, 'div,table,p, td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	table[class=w600], td[class=w600] { width: 320px !important;}\r\n	table[class=w520], td[class=w520] { width: 280px !important;}\r\n	table[class=w480], td[class=w480] { width: 260px !important;}\r\n	td[class=w40] { width: 20px !important;}\r\n	td[class=w20] { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	table[class=w600], td[class=w600] { width: 480px !important;}\r\n	table[class=w520], td[class=w520] { width: 440px !important;}\r\n	table[class=w480], td[class=w480] { width: 420px !important;}\r\n	td[class=w40] { width: 20px !important;}\r\n	td[class=w20] { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600] { width: 600px !important;}\r\n	table[class=w520], td[class=w520] { width: 520px !important;}\r\n	table[class=w480], td[class=w480] { width: 480px !important;}\r\n	td[class=w40] { width40px !important;}\r\n	td[class=w20] { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-4/newsletter-4.png', '', 'all', '', NULL),
(2, 'Newspaper', '', '<div align=\"center\" style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#454545;\" width=\"600\">\r\n		<tr>\r\n			<td class=\"w600\">\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n					<tr class=\"acyeditor_delete\" >\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n						<td class=\"acyeditor_text w540\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left\" width=\"540\">&nbsp;\r\n						<h1><img alt=\"logo\" src=\"media/com_acymailing/templates/newsletter-5/images/logo.png\" style=\"float: right; width: 107px; height: 70px;\" /></h1>\r\n\r\n						<h1>Your title here</h1>\r\n\r\n						<h3>your subtitle</h3>\r\n						</td>\r\n						<td class=\"w30\" style=\"line-height:0px; background-color:#ffffff\" width=\"30\"></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#e4e4e4\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/header.png\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#ffffff\" valign=\"top\" width=\"600\"><img alt=\"banner\" src=\"media/com_acymailing/templates/newsletter-5/images/banner.png\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/separator.png\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n						<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\" width=\"540\">\r\n							<div>This issue will present the 5 last articles.<br />\r\n							{tableofcontents}<br />\r\n							{autocontent:|max:5|order:id,DESC|type:intro|link|pict:1}</div>\r\n						</td>\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n					</tr>\r\n					<tr style=\"line-height: 0px;\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"background-color:#ffffff\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer1.png\" width=\"600\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td class=\"acyfooter acyeditor_text w600\" colspan=\"3\" height=\"25\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" width=\"600\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n					</tr>\r\n					<tr style=\"line-height: 0px;\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"background-color:#454545;\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer2.png\" width=\"600\" /></td>\r\n					</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', NULL, 1, 0, 2, 'newsletter-5', 'a:10:{s:6:\"tag_h1\";s:71:\"color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;\";s:6:\"tag_h2\";s:145:\"color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;\";s:6:\"tag_h3\";s:76:\"color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;\";s:6:\"tag_h4\";s:67:\"color:#e52323 !important; font-weight:bold; margin:0px; padding:0px\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#9d0000; text-decoration:none; border:none;\";s:19:\"acymailing_readmore\";s:152:\"cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;\";s:17:\"acymailing_online\";s:148:\"color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;\";s:8:\"color_bg\";s:7:\"#454545\";s:18:\"acymailing_content\";s:0:\"\";s:16:\"acymailing_unsub\";s:131:\"color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px\";}', NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p, td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (min-width:10px){\r\n	table[class=w600], td[class=w600] { width:320px !important; }\r\n	table[class=w540], td[class=w540] { width:260px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img {max-width:320px; height:auto !important; }\r\n	.w540 img {max-width:260px; height:auto !important; }\r\n}\r\n\r\n@media (min-width: 480px){\r\n	table[class=w600], td[class=w600] { width:480px !important; }\r\n	table[class=w540], td[class=w540] { width:420px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img {max-width:480px; height:auto !important; }\r\n	.w540 img {max-width:420px; height:auto !important; }\r\n}\r\n\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600] { width:600px !important; }\r\n	table[class=w540], td[class=w540] { width:540px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img     {max-width:600px; height:auto !important; }\r\n	.w540 img {max-width:540px; height:auto !important; }\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-5/newsletter-5.png', '', 'all', '', NULL),
(3, 'Build Bio', '', '<div align=\"center\" style=\"width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#575757;\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr>\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#eeeeee\" valign=\"bottom\" width=\"600\"><img alt=\"mail\" height=\"41\" src=\"media/com_acymailing/templates/newsletter-6/images/header.png\" width=\"600\" /></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w30\" style=\"color:#ffffff;\" width=\"30\"></td>\r\n					<td class=\"acyeditor_picture w540\" style=\"line-height:0px; background-color:#ffffff; text-align:center\" width=\"540\"><img alt=\"\" src=\"media/com_acymailing/templates/newsletter-6/images/banner.png\" style=\"width: 540px; height: 122px;\" /></td>\r\n					<td class=\"w30\" height=\"122\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n					<td class=\"acyeditor_text w540\" height=\"25\" style=\"text-align:right; background-color:#b9cf00; color:#ffffff;\" width=\"540\"><span class=\"hide\">Newsletter</span> {date:3}</td>\r\n					<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w600\" colspan=\"3\" height=\"25\" style=\"background-color:#ffffff\" width=\"600\"></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n					<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; background-color:#ffffff\" width=\"540\"><span class=\"intro\">Hello {subtag:name},</span><br />\r\n					<br />\r\n					Your introduction text here\r\n					<br />\r\n					<h2>Your title</h2>\r\n					<strong>Your catchphrase</strong><br />\r\n					Your content here <a href=\"#\">with some link</a><br />\r\n					<br />\r\n					More content<br />\r\n					<br />\r\n					<span class=\"acymailing_readmore\">Read More</span>\r\n\r\n					<h2>Another title</h2>\r\n					<img alt=\"picture\" height=\"160\" src=\"media/com_acymailing/templates/newsletter-6/images/picture.png\" style=\"float:left;\" width=\"193\" /> <strong>Another catchphrase</strong> Some content and <a href=\"#\">another link</a><br />\r\n					<br />\r\n					More content<br />\r\n					<br />\r\n					<span class=\"acymailing_readmore\">Read More</span></td>\r\n					<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n				</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n				<tr style=\"line-height: 0px;\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#efefef;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"18\" src=\"media/com_acymailing/templates/newsletter-6/images/footer1.png\" width=\"600\" /></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n					<td class=\"acyfooter acyeditor_text w540\" style=\"text-align:right; background-color:#efefef; color:#575757;\" width=\"540\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">Contact</a><a href=\"#\"><img alt=\"message\" class=\"hide\" src=\"media/com_acymailing/templates/newsletter-6/images/mail.png\" style=\"border: medium none; width: 35px; height: 20px;\" /></a></td>\r\n					<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n				</tr>\r\n				<tr style=\"line-height: 0px;\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"background-color:#efefef; line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"24\" src=\"media/com_acymailing/templates/newsletter-6/images/footer2.png\" width=\"600\" /></td>\r\n				</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\" >{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 3, 'newsletter-6', 'a:9:{s:6:\"tag_h1\";s:69:\"font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;\";s:6:\"tag_h2\";s:129:\"color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;\";s:6:\"tag_h3\";s:149:\"color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;\";s:6:\"tag_h4\";s:84:\"color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;\";s:8:\"color_bg\";s:7:\"#3c3c3c\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#a2b500; text-decoration:none; border:none;\";s:17:\"acymailing_online\";s:91:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px\";s:16:\"acymailing_unsub\";s:88:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px\";s:19:\"acymailing_readmore\";s:73:\"cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;\";}', NULL, 'table, div, p, td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n\r\n@media (min-width: 10px){\r\n	table[class=w600], td[class=w600]  { width:320px !important; }\r\n	table[class=w540], td[class=w540]  { width:260px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img{max-width:320px; height:auto !important}\r\n	.w540 img{max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	table[class=w600], td[class=w600]  { width:480px !important; }\r\n	table[class=w540], td[class=w540]  { width:420px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img{max-width:480px; height:auto !important}\r\n	.w540 img{max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600]  { width:600px !important; }\r\n	table[class=w540], td[class=w540]  { width:540px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img{max-width:600px; height:auto !important}\r\n	.w540 img{max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-6/newsletter-6.png', '', 'all', '', NULL),
(4, 'Technology', '', '<div align=\"center\" style=\"width:100%; background-color:#575757; padding-bottom:20px; color:#999999;\">\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"background-color:#fff; color:#999999; margin:auto\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_online\">{readonline}If you can\'t see this e-mail properly, <span style=\"text-decoration:underline\">view it online</span>{/readonline}</span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowtop.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/top.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text links w540\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab\" width=\"540\"><a href=\"#\"><img alt=\"mail\" src=\"media/com_acymailing/templates/technology_resp/images/mail.jpg\" style=\"float:right; border:none\" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href=\"#\">www.acyba.com</a> |</td>\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" width=\"540\"><img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic1.jpg\" style=\"float:right\" />\r\n			<h1>Your title !</h1>\r\n\r\n			<h3>Your catchphrase</h3>\r\n			Your introduction content here</td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator1.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"background-color:#fafafa; color:#999999\" width=\"540\">\r\n			<h2>Your subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic2.jpg\" style=\"float:left\" />\r\n			<h3>Your catchphrase</h3>\r\n			Your content here<br />\r\n			<a href=\"#\">Some link</a> and some content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /><br />\r\n			<br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Another subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic3.jpg\" style=\"float:right\" />\r\n			<h3>Another catchphrase</h3>\r\n			Other content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator2.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text special w540\" style=\"color:#999999\" width=\"540\">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt=\"read more\" src=\"media/com_acymailing/templates/technology_resp/images/readmore.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab\" valign=\"bottom\" width=\"540\">Follow us | <img alt=\"facebook\" src=\"media/com_acymailing/templates/technology_resp/images/facebook.jpg\" style=\"border:none\" /> <img alt=\"twitter\" src=\"media/com_acymailing/templates/technology_resp/images/twitter.jpg\" style=\"border:none\" /> <img alt=\"pinterest\" src=\"media/com_acymailing/templates/technology_resp/images/pinterest.jpg\" style=\"border:none\" /> <img alt=\"rss\" src=\"media/com_acymailing/templates/technology_resp/images/rss.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/bottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_unsub\">{unsubscribe}If you don\'t want to receive our news anymore, <span style=\"text-decoration:underline\">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', NULL, 1, 0, 4, 'technology_resp', 'a:9:{s:6:\"tag_h1\";s:104:\"font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;\";s:6:\"tag_h2\";s:165:\"font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;\";s:6:\"tag_h3\";s:104:\"color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;\";s:6:\"tag_h4\";s:0:\"\";s:8:\"color_bg\";s:7:\"#575757\";s:5:\"tag_a\";s:62:\"cursor:pointer;color:#01bbe5;text-decoration:none;border:none;\";s:17:\"acymailing_online\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:16:\"acymailing_unsub\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:19:\"acymailing_readmore\";s:88:\"cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;\";}', NULL, 'table, div, p , td{\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (min-width:10px){\r\n	table[class=w600], td[class=w600] { width:320px !important;}\r\n	table[class=w540], td[class=w540] { width:260px !important;}\r\n	td[class=w30] { width:30px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w540 img {max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	table[class=w600], td[class=w600] { width:480px !important;}\r\n	table[class=w540], td[class=w540] { width:420px !important;}\r\n	td[class=w30] { width:30px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w540 img {max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600] { width:600px !important;}\r\n	table[class=w540], td[class=w540] { width:540px !important;}\r\n	td[class=w30] { width:30px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w540 img {max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/technology_resp/thumb.jpg', '', 'all', '', NULL);

DROP TABLE IF EXISTS `#__acymailing_url`;
CREATE TABLE IF NOT EXISTS `#__acymailing_url` (
  `urlid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`urlid`),
  KEY `url` (`url`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_urlclick`;
CREATE TABLE IF NOT EXISTS `#__acymailing_urlclick` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `click` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`urlid`,`mailid`,`subid`),
  KEY `dateindex` (`date`),
  KEY `mailidindex` (`mailid`),
  KEY `subidindex` (`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_userstats`;
CREATE TABLE IF NOT EXISTS `#__acymailing_userstats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `html` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `sent` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `senddate` int(10) UNSIGNED NOT NULL,
  `open` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opendate` int(11) NOT NULL,
  `bounce` tinyint(4) NOT NULL DEFAULT '0',
  `fail` tinyint(4) NOT NULL DEFAULT '0',
  `ip` varchar(100) DEFAULT NULL,
  `browser` varchar(255) DEFAULT NULL,
  `browser_version` tinyint(3) UNSIGNED DEFAULT NULL,
  `is_mobile` tinyint(3) UNSIGNED DEFAULT NULL,
  `mobile_os` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `bouncerule` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`mailid`,`subid`),
  KEY `senddateindex` (`senddate`),
  KEY `subidindex` (`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=882 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 769, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 18, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(8, 1, 19, 302, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(9, 1, 303, 304, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 305, 306, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 307, 308, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(12, 1, 309, 310, 1, 'com_login', 'com_login', '{}'),
(13, 1, 311, 312, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 313, 314, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 315, 316, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 317, 322, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(17, 1, 323, 324, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 325, 506, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(19, 1, 507, 510, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(20, 1, 511, 512, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(21, 1, 513, 514, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
(22, 1, 515, 516, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 517, 518, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(24, 1, 519, 522, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(25, 1, 523, 526, 1, 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(26, 1, 527, 528, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 29, 2, 'com_content.category.2', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(30, 19, 508, 509, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(31, 25, 524, 525, 2, 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(32, 24, 520, 521, 1, 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(33, 1, 529, 530, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 531, 532, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
(35, 1, 533, 534, 1, 'com_tags', 'com_tags', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(36, 1, 535, 536, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 537, 538, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 539, 540, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 326, 327, 2, 'com_modules.module.2', 'Login', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(41, 18, 328, 329, 2, 'com_modules.module.3', 'Popular Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(42, 18, 330, 331, 2, 'com_modules.module.4', 'Recently Added Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(43, 18, 332, 333, 2, 'com_modules.module.8', 'Toolbar', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(44, 18, 334, 335, 2, 'com_modules.module.9', 'Quick Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(45, 18, 336, 337, 2, 'com_modules.module.10', 'Logged-in Users', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(46, 18, 338, 339, 2, 'com_modules.module.12', 'Admin Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(47, 18, 340, 341, 2, 'com_modules.module.13', 'Admin Submenu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(48, 18, 342, 343, 2, 'com_modules.module.14', 'User Status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(49, 18, 344, 345, 2, 'com_modules.module.15', 'Title', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(52, 18, 346, 347, 2, 'com_modules.module.79', 'Multilanguage status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(53, 18, 348, 349, 2, 'com_modules.module.86', 'Joomla Version', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(54, 18, 350, 351, 2, 'com_modules.module.87', 'Komento activities', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(55, 18, 352, 353, 2, 'com_modules.module.88', 'Komento comments', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(61, 18, 354, 355, 2, 'com_modules.module.93', 'Superfish menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(62, 18, 356, 357, 2, 'com_modules.module.94', 'Recent templates', ''),
(63, 1, 541, 542, 1, 'com_kunena', 'com_kunena', '{}'),
(64, 8, 30, 39, 2, 'com_content.category.8', 'Home', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(65, 8, 40, 41, 2, 'com_content.category.9', 'About', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(66, 8, 42, 45, 2, 'com_content.category.10', 'Policies', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(67, 8, 46, 83, 2, 'com_content.category.11', 'Blog', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(70, 67, 47, 50, 3, 'com_content.category.14', 'Recent', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(71, 67, 51, 54, 3, 'com_content.category.15', 'Latest', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(74, 475, 172, 179, 4, 'com_content.category.18', 'Accordions and Toggles', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(81, 342, 109, 122, 3, 'com_content.category.25', 'History', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(82, 342, 123, 142, 3, 'com_content.category.26', 'Team', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(83, 342, 143, 156, 3, 'com_content.category.27', 'FAQs', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(84, 342, 157, 170, 3, 'com_content.category.28', 'Testimonials', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(85, 8, 84, 87, 2, 'com_content.category.29', 'Help', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(91, 66, 43, 44, 3, 'com_content.article.6', 'Privacy policy', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(96, 406, 56, 57, 4, 'com_content.article.11', 'Children\'s Book Exhibition', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(97, 70, 48, 49, 4, 'com_content.article.12', 'Participate in discussion of an important topic', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(98, 71, 52, 53, 4, 'com_content.article.13', 'Improving your confidence and self-defense skills', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(99, 407, 60, 61, 4, 'com_content.article.14', 'Pen & Paintbruh', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(100, 409, 72, 73, 4, 'com_content.article.15', 'Music is now officially proved to have influence on us', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(101, 74, 173, 174, 5, 'com_content.article.16', 'Do you offer replacement parts?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(102, 74, 175, 176, 5, 'com_content.article.17', 'Do you offer delivery services?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(103, 74, 177, 178, 5, 'com_content.article.18', 'Meet Our Experts', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(120, 81, 110, 111, 4, 'com_content.article.35', 'Our first steps on the market', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(121, 81, 112, 113, 4, 'com_content.article.36', 'Continuous innovation and transformation', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(122, 81, 114, 115, 4, 'com_content.article.37', 'Further development', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(123, 81, 116, 117, 4, 'com_content.article.38', 'Company acquisition', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(124, 81, 118, 119, 4, 'com_content.article.39', 'The Hayford was established in 1940 in New York as the National Committee of Investment Companies.', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(125, 81, 120, 121, 4, 'com_content.article.40', 'When we decided to set up our operations 25 years ago, we had a list of principles that we all stood', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(126, 82, 124, 125, 4, 'com_content.article.41', 'Jorinde Voigt', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(127, 82, 126, 127, 4, 'com_content.article.42', 'Allen Jones', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(128, 82, 128, 129, 4, 'com_content.article.43', 'Megan Ramos', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(129, 82, 130, 131, 4, 'com_content.article.44', 'Steve Donavan', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(130, 82, 132, 133, 4, 'com_content.article.45', 'Andrew Rooney', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(131, 82, 134, 135, 4, 'com_content.article.46', 'Frank Roberts', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(133, 84, 158, 159, 4, 'com_content.article.48', 'Guy Richie', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(134, 84, 160, 161, 4, 'com_content.article.49', 'Lenny Stevens', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(135, 84, 162, 163, 4, 'com_content.article.50', 'Adam Cooper', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(136, 83, 144, 145, 4, 'com_content.article.51', '6. Do I need an account and what are the benefits?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(137, 83, 146, 147, 4, 'com_content.article.52', '5. How long will my order take to be delivered?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(138, 83, 148, 149, 4, 'com_content.article.53', '4. Can I return an item?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(139, 83, 150, 151, 4, 'com_content.article.54', '3. Can I track my order?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(140, 83, 152, 153, 4, 'com_content.article.55', '2. How can I pay for my order?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(141, 83, 154, 155, 4, 'com_content.article.56', '1. How can I change something in my order?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(142, 85, 85, 86, 3, 'com_content.article.57', 'Template settings', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(144, 7, 16, 17, 2, 'com_contact.category.30', 'Website Administrators', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(167, 18, 358, 359, 2, 'com_modules.module.103', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(168, 18, 360, 361, 2, 'com_modules.module.104', 'JoomGallery News', ''),
(169, 1, 559, 646, 1, 'com_joomgallery', 'joomgallery', '{}'),
(170, 169, 560, 645, 2, 'com_joomgallery.category.2', 'Gallery', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":{\"6\":1,\"3\":1},\"joom.create.inown\":[],\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(198, 27, 21, 22, 3, 'com_content.article.65', '404 Page', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(206, 18, 362, 363, 2, 'com_modules.module.111', 'Pinterest feed', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(208, 18, 364, 365, 2, 'com_modules.module.113', 'Pinterest feed', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(210, 18, 366, 367, 2, 'com_modules.module.115', 'TM Ajax Contact Form', '{}'),
(273, 342, 231, 250, 3, 'com_content.category.31', 'Portfolio', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(274, 800, 247, 248, 5, 'com_content.article.66', 'Popular', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(275, 800, 245, 246, 5, 'com_content.article.67', 'Architecture', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(276, 799, 241, 242, 5, 'com_content.article.68', 'Art & Illustration', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(277, 799, 239, 240, 5, 'com_content.article.69', 'Web & Interactive', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(278, 798, 235, 236, 5, 'com_content.article.70', 'Promotional', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(279, 798, 233, 234, 5, 'com_content.article.71', 'Games & Entertainment', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(284, 342, 89, 108, 3, 'com_content.category.32', 'Pricing table', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(285, 304, 97, 98, 5, 'com_content.article.75', 'Basic', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(286, 304, 95, 96, 5, 'com_content.article.76', 'Advanced', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(287, 304, 93, 94, 5, 'com_content.article.77', 'Elite', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(288, 304, 91, 92, 5, 'com_content.article.78', 'Deluxe', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(289, 18, 368, 369, 2, 'com_modules.module.118', 'Detailed', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(304, 284, 90, 99, 4, 'com_content.category.35', 'Detailed', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(305, 284, 100, 107, 4, 'com_content.category.36', 'Simple', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(307, 305, 101, 102, 5, 'com_content.article.88', 'Basic', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(308, 305, 103, 104, 5, 'com_content.article.89', 'Advanced', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(309, 305, 105, 106, 5, 'com_content.article.90', 'Professional', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(310, 18, 370, 371, 2, 'com_modules.module.122', 'Simple', '{}'),
(315, 18, 372, 373, 2, 'com_modules.module.126', 'Lorem ipsum', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(316, 18, 374, 375, 2, 'com_modules.module.127', 'Dolor sit', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(317, 18, 376, 377, 2, 'com_modules.module.128', 'Fusce molestie', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(318, 18, 378, 379, 2, 'com_modules.module.129', 'Aenean sem', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(319, 18, 380, 381, 2, 'com_modules.module.130', 'Duis vitae', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(320, 18, 382, 383, 2, 'com_modules.module.131', 'Maecenas vestibulum', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(342, 8, 88, 281, 2, 'com_content.category.43', 'Pages', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(348, 18, 384, 385, 2, 'com_modules.module.145', 'Accordion 1', '{}'),
(353, 438, 185, 186, 5, 'com_content.article.100', 'Tab Title 3', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(354, 438, 183, 184, 5, 'com_content.article.101', 'Tab Title 2', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(355, 438, 181, 182, 5, 'com_content.article.102', 'Tab Title 1', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(357, 84, 164, 165, 4, 'com_content.article.103', 'Adam Smith', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(358, 84, 166, 167, 4, 'com_content.article.104', 'Nick Harris', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(359, 84, 168, 169, 4, 'com_content.article.105', 'John Anderson', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(374, 342, 213, 230, 3, 'com_content.category.46', 'Careers', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(375, 374, 214, 215, 4, 'com_content.article.110', 'We truly believe that the success of our business depends on our employees.', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(376, 374, 216, 223, 4, 'com_content.category.47', 'Careers additional info', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(377, 18, 386, 387, 2, 'com_modules.module.159', 'Careers accordion', '{}'),
(378, 374, 224, 225, 4, 'com_content.article.111', 'The Sunday Times Best Company to work for', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(379, 374, 226, 227, 4, 'com_content.article.112', 'IT Careers', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(380, 18, 388, 389, 2, 'com_modules.module.160', 'Apply now', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(381, 374, 228, 229, 4, 'com_content.article.113', 'Machine learning', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(382, 18, 390, 391, 2, 'com_modules.module.161', 'Requirements', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(383, 18, 392, 393, 2, 'com_modules.module.162', 'What we Expect from you?', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(384, 376, 217, 218, 5, 'com_content.article.114', 'Business intelligence (BI) professionals', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(385, 376, 219, 220, 5, 'com_content.article.115', 'Business Program Managers (BPM)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(386, 376, 221, 222, 5, 'com_content.article.116', 'Software Engineers (SWE)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(387, 18, 394, 395, 2, 'com_modules.module.163', 'Careers accordion', '{}'),
(388, 18, 396, 397, 2, 'com_modules.module.164', 'Careers accordion', '{}'),
(389, 18, 398, 399, 2, 'com_modules.module.165', 'Careers accordion', '{}'),
(390, 18, 400, 401, 2, 'com_modules.module.166', 'Pages', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(391, 18, 402, 403, 2, 'com_modules.module.167', 'Blog posts', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(392, 18, 404, 405, 2, 'com_modules.module.168', 'Portfolio posts', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(393, 18, 406, 407, 2, 'com_modules.module.169', 'User menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(395, 18, 408, 409, 2, 'com_modules.module.170', 'Breadcrumbs', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(398, 18, 410, 411, 2, 'com_modules.module.171', 'Our team', '{}'),
(400, 18, 412, 413, 2, 'com_modules.module.173', 'Frequently asked questions', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(405, 1, 647, 648, 1, 'com_komento', 'com_komento', '{}'),
(406, 67, 55, 58, 3, 'com_content.category.48', 'Archived publications', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(407, 67, 59, 66, 3, 'com_content.category.49', 'Events & Programs', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(409, 67, 71, 74, 3, 'com_content.category.51', 'Fresh topic', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(410, 67, 67, 70, 3, 'com_content.category.52', 'Information', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(411, 67, 79, 82, 3, 'com_content.category.53', 'News', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(412, 67, 75, 78, 3, 'com_content.category.54', 'Updates', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(425, 410, 68, 69, 4, 'com_content.article.118', 'Things I’ve Learned about Investing and Business', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(427, 411, 80, 81, 4, 'com_content.article.119', 'LinkedIn Stock Downgraded After Microsoft Deal ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(429, 412, 76, 77, 4, 'com_content.article.120', 'London SE in Frankfurt?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(433, 475, 210, 211, 4, 'com_content.article.121', 'Elements', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(437, 18, 414, 415, 2, 'com_modules.module.183', 'Tabs', '{}'),
(438, 475, 180, 187, 4, 'com_content.category.57', 'Tabs', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(442, 18, 416, 417, 2, 'com_modules.module.184', 'Accordion 2', '{}'),
(446, 475, 188, 209, 4, 'com_content.category.58', 'Progress Bars', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(447, 446, 189, 198, 5, 'com_content.category.59', 'Horizontal', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(448, 446, 199, 208, 5, 'com_content.category.60', 'Circle', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(449, 447, 190, 191, 6, 'com_content.article.125', 'Leadership', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(450, 447, 192, 193, 6, 'com_content.article.126', 'Management', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(451, 447, 194, 195, 6, 'com_content.article.127', 'Innovation and creativity', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(452, 448, 200, 201, 6, 'com_content.article.128', 'Leadership', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(453, 448, 202, 203, 6, 'com_content.article.129', 'Management', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(454, 448, 204, 205, 6, 'com_content.article.130', 'Innovation and creativity', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(456, 18, 418, 419, 2, 'com_modules.module.189', 'Pricing Tables', '{}'),
(457, 18, 420, 421, 2, 'com_modules.module.190', 'Simple', '{}'),
(459, 18, 422, 423, 2, 'com_modules.module.192', 'Accordions and Toggles', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(462, 18, 424, 425, 2, 'com_modules.module.195', 'Menu search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(475, 342, 171, 212, 3, 'com_content.category.62', 'Elements', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(476, 447, 196, 197, 6, 'com_content.article.135', 'Resilience', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(477, 448, 206, 207, 6, 'com_content.article.136', 'Resilience', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(478, 64, 31, 38, 3, 'com_content.category.63', 'Slider', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(479, 478, 32, 33, 4, 'com_content.article.137', 'Professional Investment Consulting', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(480, 478, 34, 35, 4, 'com_content.article.138', 'Set your own pace', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(481, 478, 36, 37, 4, 'com_content.article.139', 'Why You Need an Advisor?', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(519, 8, 282, 283, 2, 'com_content.category.64', 'Site map', '{}'),
(521, 170, 561, 574, 3, 'com_joomgallery.category.9', 'Gallery 1', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":[],\"joom.create.inown\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(522, 170, 575, 588, 3, 'com_joomgallery.category.10', 'Gallery 2', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":[],\"joom.create.inown\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(523, 170, 589, 602, 3, 'com_joomgallery.category.11', 'Gallery 3', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":[],\"joom.create.inown\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(524, 170, 603, 616, 3, 'com_joomgallery.category.12', 'Gallery 4', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":[],\"joom.create.inown\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(525, 170, 617, 630, 3, 'com_joomgallery.category.13', 'Gallery 5', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":[],\"joom.create.inown\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(526, 170, 631, 644, 3, 'com_joomgallery.category.14', 'Gallery 6', '{\"joom.upload\":[],\"joom.upload.inown\":[],\"core.create\":[],\"joom.create.inown\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(672, 1, 737, 738, 1, 'com_slogin', 'com_slogin', '{}'),
(676, 1, 739, 740, 1, 'com_fields', 'com_fields', '{}'),
(677, 1, 741, 742, 1, 'com_associations', 'com_associations', '{}'),
(679, 16, 318, 319, 2, 'com_menus.menu.19', 'Header menu', '{}'),
(697, 1, 743, 744, 1, '#__ucm_content.9', '#__ucm_content.9', '[]'),
(698, 1, 745, 746, 1, '#__ucm_content.10', '#__ucm_content.10', '[]'),
(699, 1, 747, 748, 1, '#__ucm_content.11', '#__ucm_content.11', '{}'),
(713, 16, 320, 321, 2, 'com_menus.menu.20', 'Navigation', '{}'),
(718, 1, 749, 750, 1, '#__ucm_content.8', '#__ucm_content.8', '[]'),
(719, 1, 751, 752, 1, '#__ucm_content.1', '#__ucm_content.1', '{}'),
(738, 521, 562, 563, 4, 'com_joomgallery.image.219', 'gallery-image01', '{}'),
(739, 521, 564, 565, 4, 'com_joomgallery.image.220', 'gallery-image02', '{}'),
(740, 521, 566, 567, 4, 'com_joomgallery.image.221', 'gallery-image03', '{}'),
(741, 521, 568, 569, 4, 'com_joomgallery.image.222', 'gallery-image04', '{}'),
(742, 521, 570, 571, 4, 'com_joomgallery.image.223', 'gallery-image05', '{}'),
(743, 521, 572, 573, 4, 'com_joomgallery.image.224', 'gallery-image06', '{}'),
(744, 522, 576, 577, 4, 'com_joomgallery.image.225', 'gallery-image07', '{}'),
(745, 522, 578, 579, 4, 'com_joomgallery.image.226', 'gallery-image08', '{}'),
(746, 522, 580, 581, 4, 'com_joomgallery.image.227', 'gallery-image09', '{}'),
(747, 522, 582, 583, 4, 'com_joomgallery.image.228', 'gallery-image10', '{}'),
(748, 522, 584, 585, 4, 'com_joomgallery.image.229', 'gallery-image11', '{}'),
(749, 522, 586, 587, 4, 'com_joomgallery.image.230', 'gallery-image12', '{}'),
(750, 523, 590, 591, 4, 'com_joomgallery.image.231', 'gallery-image13', '{}'),
(751, 523, 592, 593, 4, 'com_joomgallery.image.232', 'gallery-image14', '{}'),
(752, 523, 594, 595, 4, 'com_joomgallery.image.233', 'gallery-image15', '{}'),
(753, 523, 596, 597, 4, 'com_joomgallery.image.234', 'gallery-image16', '{}'),
(754, 523, 598, 599, 4, 'com_joomgallery.image.235', 'gallery-image17', '{}'),
(755, 523, 600, 601, 4, 'com_joomgallery.image.236', 'gallery-image18', '{}'),
(756, 524, 604, 605, 4, 'com_joomgallery.image.237', 'gallery-image19', '{}'),
(757, 524, 606, 607, 4, 'com_joomgallery.image.238', 'gallery-image20', '{}'),
(758, 524, 608, 609, 4, 'com_joomgallery.image.239', 'gallery-image21', '{}'),
(759, 524, 610, 611, 4, 'com_joomgallery.image.240', 'gallery-image22', '{}'),
(760, 524, 612, 613, 4, 'com_joomgallery.image.241', 'gallery-image23', '{}'),
(761, 524, 614, 615, 4, 'com_joomgallery.image.242', 'gallery-image24', '{}'),
(762, 525, 618, 619, 4, 'com_joomgallery.image.243', 'gallery-image25', '{}'),
(763, 525, 620, 621, 4, 'com_joomgallery.image.244', 'gallery-image26', '{}'),
(764, 525, 622, 623, 4, 'com_joomgallery.image.245', 'gallery-image27', '{}'),
(765, 525, 624, 625, 4, 'com_joomgallery.image.246', 'gallery-image28', '{}'),
(766, 525, 626, 627, 4, 'com_joomgallery.image.247', 'gallery-image29', '{}'),
(767, 525, 628, 629, 4, 'com_joomgallery.image.248', 'gallery-image30', '{}'),
(768, 526, 632, 633, 4, 'com_joomgallery.image.249', 'gallery-image31', '{}'),
(769, 526, 634, 635, 4, 'com_joomgallery.image.250', 'gallery-image32', '{}'),
(770, 526, 636, 637, 4, 'com_joomgallery.image.251', 'gallery-image33', '{}'),
(771, 526, 638, 639, 4, 'com_joomgallery.image.252', 'gallery-image34', '{}'),
(772, 526, 640, 641, 4, 'com_joomgallery.image.253', 'gallery-image35', '{}'),
(773, 526, 642, 643, 4, 'com_joomgallery.image.254', 'gallery-image36', '{}'),
(774, 1, 753, 754, 1, '#__ucm_content.6', '#__ucm_content.6', '{}'),
(775, 1, 755, 756, 1, '#__ucm_content.4', '#__ucm_content.4', '[]'),
(776, 1, 757, 758, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(778, 82, 136, 137, 4, 'com_content.article.164', 'Steven Jackson', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(779, 82, 138, 139, 4, 'com_content.article.165', 'Andrew Edwards', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(780, 18, 426, 427, 2, 'com_modules.module.234', 'Text Elements', '{}'),
(781, 18, 428, 429, 2, 'com_modules.module.235', 'TM Ajax Style Switcher', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(783, 1, 759, 760, 1, 'com_acymailing', 'AcyMailing', '{}'),
(784, 18, 430, 431, 2, 'com_modules.module.238', 'Portfolio', '{}'),
(785, 18, 432, 433, 2, 'com_modules.module.239', 'Linear bars', '{}'),
(786, 18, 434, 435, 2, 'com_modules.module.240', 'Radial bars', '{}'),
(787, 18, 436, 437, 2, 'com_modules.module.241', 'Tags', '{}'),
(788, 18, 438, 439, 2, 'com_modules.module.242', 'Recent posts', '{}'),
(789, 18, 440, 441, 2, 'com_modules.module.243', 'Categories', '{}'),
(794, 18, 442, 443, 2, 'com_modules.module.248', 'Blog categories', '{}'),
(795, 18, 444, 445, 2, 'com_modules.module.249', 'Latest posts', '{}'),
(797, 18, 446, 447, 2, 'com_modules.module.251', 'Latest works', '{}'),
(798, 273, 232, 237, 4, 'com_content.category.70', 'Category 1', '{}'),
(799, 273, 238, 243, 4, 'com_content.category.71', 'Category 2', '{}'),
(800, 273, 244, 249, 4, 'com_content.category.72', 'Category 3', '{}'),
(801, 18, 448, 449, 2, 'com_modules.module.252', 'Login form megamenu', '{}'),
(802, 18, 450, 451, 2, 'com_modules.module.253', 'Social menu', '{}'),
(817, 18, 452, 453, 2, 'com_modules.module.268', 'Counters', '{}'),
(818, 18, 454, 455, 2, 'com_modules.module.269', 'Google map', '{}'),
(822, 18, 456, 457, 2, 'com_modules.module.273', 'Portfolio default', '{}'),
(823, 18, 458, 459, 2, 'com_modules.module.274', 'Portfolio masonry', '{}'),
(824, 82, 140, 141, 4, 'com_content.article.166', 'Karl Williams', '{}'),
(825, 18, 460, 461, 2, 'com_modules.module.275', 'Working time', '{}'),
(826, 342, 251, 252, 3, 'com_content.article.167', 'Do You Have any Questions?', '{}'),
(827, 18, 462, 463, 2, 'com_modules.module.276', 'Do You Have any Questions?', '{}'),
(828, 342, 253, 266, 3, 'com_content.category.73', 'Partners', '{}'),
(829, 828, 254, 255, 4, 'com_content.article.168', 'Partner 1', '{}'),
(830, 828, 256, 257, 4, 'com_content.article.169', 'Partner 2', '{}'),
(831, 828, 258, 259, 4, 'com_content.article.170', 'Partner 3', '{}'),
(832, 828, 260, 261, 4, 'com_content.article.171', 'Partner 4', '{}'),
(833, 828, 262, 263, 4, 'com_content.article.172', 'Partner 5', '{}'),
(834, 828, 264, 265, 4, 'com_content.article.173', 'Partner 6', '{}'),
(835, 18, 464, 465, 2, 'com_modules.module.277', 'Partners', '{}'),
(836, 342, 267, 280, 3, 'com_content.category.74', 'Services', '{}'),
(837, 836, 268, 269, 4, 'com_content.article.174', 'Preconstruction planning', '{}'),
(838, 836, 270, 271, 4, 'com_content.article.175', 'Building engineering', '{}'),
(839, 836, 272, 273, 4, 'com_content.article.176', 'Interior design', '{}'),
(840, 836, 274, 275, 4, 'com_content.article.177', 'Architecture & building', '{}'),
(841, 836, 276, 277, 4, 'com_content.article.178', 'House renovation', '{}'),
(842, 836, 278, 279, 4, 'com_content.article.179', 'Construction Consultant', '{}'),
(843, 18, 466, 467, 2, 'com_modules.module.278', 'Services prices', '{}'),
(844, 18, 468, 469, 2, 'com_modules.module.279', 'Popular questions', '{}'),
(845, 18, 470, 471, 2, 'com_modules.module.280', 'Our services', '{}'),
(847, 18, 472, 473, 2, 'com_modules.module.282', 'Google map footer', '{}'),
(848, 18, 474, 475, 2, 'com_modules.module.283', 'Get in Touch', '{}'),
(849, 18, 476, 477, 2, 'com_modules.module.284', 'Welcome img', '{}'),
(850, 27, 23, 24, 3, 'com_content.article.180', 'Magical World of Art', '{}'),
(851, 18, 478, 479, 2, 'com_modules.module.285', 'Welcome to artesma', '{}'),
(852, 18, 480, 481, 2, 'com_modules.module.286', 'Exhibitions', '{}'),
(853, 18, 482, 483, 2, 'com_modules.module.287', 'Exhibitions gallery', '{}'),
(854, 8, 284, 291, 2, 'com_content.category.75', 'Home services 1', '{}'),
(855, 18, 484, 485, 2, 'com_modules.module.288', 'Home services 1', '{}'),
(856, 854, 285, 286, 3, 'com_content.article.181', 'Meet Our Experts', '{}'),
(857, 854, 287, 288, 3, 'com_content.article.182', 'Tour the Gallery', '{}'),
(858, 854, 289, 290, 3, 'com_content.article.183', 'Visitor Information', '{}'),
(859, 27, 25, 26, 3, 'com_content.article.184', 'exhibitions', '{}'),
(860, 18, 486, 487, 2, 'com_modules.module.289', 'exhibitions', '{}'),
(861, 18, 488, 489, 2, 'com_modules.module.290', 'our blog', '{}'),
(862, 18, 490, 491, 2, 'com_modules.module.291', 'Home Blog', '{}'),
(863, 407, 62, 63, 4, 'com_content.article.185', 'Etching Demonstration', '{}'),
(864, 1, 761, 762, 1, '#__ucm_content.12', '#__ucm_content.12', '{}'),
(865, 407, 64, 65, 4, 'com_content.article.186', 'Miniature Art Show', '{}'),
(866, 1, 763, 764, 1, '#__ucm_content.13', '#__ucm_content.13', '{}'),
(867, 18, 492, 493, 2, 'com_modules.module.292', 'who we are', '{}'),
(868, 27, 27, 28, 3, 'com_content.article.187', 'We Are ARTESMA', '{}'),
(869, 8, 292, 301, 2, 'com_content.category.76', 'About services', '{}'),
(870, 18, 494, 495, 2, 'com_modules.module.293', 'About services', '{}'),
(871, 869, 293, 294, 3, 'com_content.article.188', 'Years of Experience', '{}'),
(872, 869, 295, 296, 3, 'com_content.article.189', ' Famous Artists', '{}'),
(873, 869, 297, 298, 3, 'com_content.article.190', ' Successful Exhibitions', '{}'),
(874, 869, 299, 300, 3, 'com_content.article.191', 'Current Exhibitions', '{}'),
(875, 18, 496, 497, 2, 'com_modules.module.294', 'meet the Team', '{}'),
(876, 18, 498, 499, 2, 'com_modules.module.295', 'Our Artists', '{}'),
(877, 18, 500, 501, 2, 'com_modules.module.296', 'what people say', '{}'),
(878, 18, 502, 503, 2, 'com_modules.module.297', 'Questions img', '{}'),
(879, 18, 504, 505, 2, 'com_modules.module.298', 'FAQ', '{}'),
(880, 1, 765, 766, 1, 'com_privacy', 'com_privacy', '{}'),
(881, 1, 767, 768, 1, 'com_actionlogs', 'com_actionlogs', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 93, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '{}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 31, 32, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 33, 34, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 35, 36, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 37, 38, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 39, 40, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 64, 1, 3, 6, 1, 'home', 'com_content', 'Home', 'home', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 65, 1, 7, 8, 1, 'about', 'com_content', 'About', 'about', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(10, 66, 1, 27, 28, 1, 'policies', 'com_content', 'Policies', 'policies', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 67, 1, 9, 26, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(14, 70, 11, 10, 11, 2, 'blog/recent', 'com_content', 'Recent', 'recent', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(15, 71, 11, 12, 13, 2, 'blog/latest', 'com_content', 'Latest', 'latest', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(18, 74, 62, 65, 66, 3, 'pages/elements/accordions-and-toggles', 'com_content', 'Accordions and Toggles', 'accordions-and-toggles', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(25, 81, 43, 54, 55, 2, 'pages/history', 'com_content', 'History', 'history', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(26, 82, 43, 52, 53, 2, 'pages/team', 'com_content', 'Team', 'team', '', '<p><strong> </strong></p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(27, 83, 43, 50, 51, 2, 'pages/faqs', 'com_content', 'FAQs', 'faqs', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(28, 84, 43, 56, 57, 2, 'pages/testimonials', 'com_content', 'Testimonials', 'testimonials', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(29, 85, 1, 29, 30, 1, 'help', 'com_content', 'Help', 'help', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(30, 144, 1, 41, 42, 1, 'website-administrators', 'com_contact', 'Website Administrators', 'website-administrators', '', '<p>\'Website Administrators\' contact category description. Ut sapien enim, rhoncus sit amet fermentum at, sagittis ac massa. Fusce quis odio sit amet ipsum gravida faucibus vel et turpis. Aliquam a dui pretium elit feugiat interdum. Suspendisse tortor velit, bibendum vitae sollicitudin non, congue quis risus. Aliquam lacus nibh, viverra ut porta ac, luctus sit amet orci. Etiam euismod lacinia lectus et pulvinar. Integer dictum, dui id fermentum auctor, sem nunc ultricies ipsum, sed sagittis est justo nec neque. Integer sit amet justo elit, a dictum nisl.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(31, 273, 43, 74, 81, 2, 'pages/portfolio', 'com_content', 'Portfolio', 'portfolio', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(32, 284, 43, 44, 49, 2, 'pages/pricing-table', 'com_content', 'Pricing table', 'pricing-table', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(35, 304, 32, 45, 46, 3, 'pages/pricing-table/detailed', 'com_content', 'Detailed', 'detailed', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(36, 305, 32, 47, 48, 3, 'pages/pricing-table/simple', 'com_content', 'Simple', 'simple', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(43, 342, 1, 43, 86, 1, 'pages', 'com_content', 'Pages', 'pages', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(46, 374, 43, 58, 61, 2, 'pages/careers', 'com_content', 'Careers', 'careers', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(47, 376, 46, 59, 60, 3, 'pages/careers/careers-additional-info', 'com_content', 'Careers additional info', 'careers-additional-info', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '0000-00-00 00:00:00', 0, '*', 1),
(48, 406, 11, 14, 15, 2, 'blog/archived-publications', 'com_content', 'Archived publications', 'archived-publications', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(49, 407, 11, 16, 17, 2, 'blog/events-programs', 'com_content', 'Events & Programs', 'events-programs', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 846, '2018-06-29 13:23:53', 0, '*', 1),
(51, 409, 11, 18, 19, 2, 'blog/fresh-topic', 'com_content', 'Fresh topic', 'fresh-topic', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(52, 410, 11, 20, 21, 2, 'blog/information', 'com_content', 'Information', 'information', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(53, 411, 11, 22, 23, 2, 'blog/news', 'com_content', 'News', 'news', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(54, 412, 11, 24, 25, 2, 'blog/updates', 'com_content', 'Updates', 'updates', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(57, 438, 62, 63, 64, 3, 'pages/elements/tabs', 'com_content', 'Tabs', 'tabs', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(58, 446, 62, 67, 72, 3, 'pages/elements/progress-bars', 'com_content', 'Progress Bars', 'progress-bars', 'For \"Elements\" page', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(59, 447, 58, 68, 69, 4, 'pages/elements/progress-bars/horizontal', 'com_content', 'Horizontal', 'horizontal', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(60, 448, 58, 70, 71, 4, 'pages/elements/progress-bars/vertical', 'com_content', 'Circle', 'vertical', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(62, 475, 43, 62, 73, 2, 'pages/elements', 'com_content', 'Elements', 'elements', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(63, 478, 8, 4, 5, 2, 'home/slider', 'com_content', 'Slider', 'slider', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(64, 519, 1, 87, 88, 1, 'site-map', 'com_content', 'Site map', 'site-map', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 213, '2018-06-25 16:06:04', 0, '*', 1),
(70, 798, 31, 75, 76, 3, 'pages/portfolio/category-1', 'com_content', 'Category 1', 'category-1', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(71, 799, 31, 77, 78, 3, 'pages/portfolio/category-2', 'com_content', 'Category 2', 'category-2', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(72, 800, 31, 79, 80, 3, 'pages/portfolio/category-3', 'com_content', 'Category 3', 'category-3', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(73, 828, 43, 82, 83, 2, 'pages/partners', 'com_content', 'Partners', 'partners', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(74, 836, 43, 84, 85, 2, 'pages/services', 'com_content', 'Services', 'services', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 213, '2018-06-25 16:06:04', 0, '2018-06-25 16:06:04', 0, '*', 1),
(75, 854, 1, 89, 90, 1, 'home-services-1', 'com_content', 'Home services 1', 'home-services-1', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 846, '2018-06-29 09:32:28', 0, '2018-06-29 09:32:28', 0, '*', 1),
(76, 869, 1, 91, 92, 1, 'about-services', 'com_content', 'About services', 'about-services', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 846, '2018-06-29 16:33:46', 0, '2018-06-29 16:33:46', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Website Owner', 'website-owner', 'website owner', '138 Atlantis Ln', 'Kingsport', 'Illinois', 'U.S.', '121164', '800-2345-6789', '800-2345-6789', '<p>Email us with any questions or inquiries or use our contact data.</p>', '', 'mail@demolink.org', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_tags\":\"\",\"show_name\":\"0\",\"show_position\":\"0\",\"show_email\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"\",\"show_telephone\":\"1\",\"show_mobile\":\"0\",\"show_fax\":\"1\",\"show_webpage\":\"\",\"show_misc\":\"1\",\"show_image\":\"0\",\"allow_vcard\":\"1\",\"show_articles\":\"0\",\"articles_display_num\":\"\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"0\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 846, 30, 1, '+1 959 603 6035', 'http://demolink.org', '', '', '', '*', '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 980);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(6, 91, 'Privacy policy', 'privacy-policy', '<h4>What does this privacy policy cover?</h4>\r\n<p>We take your privacy very seriously. This privacy policy governs and details the main privacy principles we apply to the data we collect through our services.Click here to access our privacy policy governing our corporate website.</p>\r\n\r\n<h4>About our services</h4>\r\n<p>We specialize in a variety of services. Our aim is to deliver services based on your recent browsing behavior. With our service, you should receive personalized help that is more relevant for you than the standard one you would receive without us. Click here for more information on our services.</p>\r\n\r\n<h4>User Choices</h4>\r\n<p>If you do not want to receive ads displayed by us, on your current browser and browsers we have linked to your technical identifier you can disable the display of our ads here.If you only want to opt out from your current browser uncheck the opt-out box.You can also opt-out of all matched browsers and know more about user choices.</p>\r\n\r\n<h4>Our commitments and adherence</h4>\r\n<p>Our company is an early adopter to initiatives of greater transparency and control for users. Read more about transparency and control.</p>\r\n\r\n<h4>Our Technology</h4>\r\n<p>We collect information via technical cookies placed on your browser. Read more about our technology.</p>\r\n\r\n<h4>Data security and retention</h4>\r\n<p>The security of your information is fundamental to us. We have implemented industry-standard security measures, which include the use of firewalls and encryption. Read more about data security and retention.</p>\r\n\r\n<p>Please note that we may update or change this privacy policy. If we revise our privacy policy, we will post those changes to this privacy statement, and to other places we deem appropriate, so that you are aware of what information we collect, how we use it, and under what circumstances, if any we disclose it. If we make any material changes we will notify you by means of a notice on this site prior to the change becoming effective. Please click here for the latest version of the privacy policy.</p>\r\n\r\n<p>E-mail: <a href=\"mailto:info@demolink.org\">info@demolink.org</a></p>', '', 1, 10, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 14, 1, '', '', 1, 95, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(11, 96, 'Children\'s Book Exhibition', 'anniversary-showcase-of-fox-tv-shows-and-movies', '<p>In this article, you will find out about the Children\'s Book Exhibition - an annual event that gathers the world\'s most famous authors of infantile and teenage literature.</p>\r\n', '\r\n<p>Children\'s Book Exhibition is a very important event for modern literature as well as for young and talented authors whose aim is to make modern infantile and teenage literature better. Every year the event takes place in a different American city. Previous year it was Seattle, WA, and this year the exhibition was hosted by LA Tower Center, located in Los Angeles, CA.</p>\r\n\r\n<p>This year, the Children\'s Book Exhibition celebrates the important anniversary of 35 years since the Children\'s Literature Committee has started its work in the USA. At this exhibition visitors could see and visit stands of famous publishing houses and authors and get autographs of the latter while children could take a photo with their favorite book heroes and have fun at the children\'s playground constructed specifically for this event.</p>\r\n\r\n<p>The event was a great chance for everyone interested in literature to show their knowledge of their favorite books as well as to take part in various contests. According to the words of the visitors and organizers, it was an outstanding opportunity where both children and teenagers could participate and win valuable prizes.</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 48, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb8.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img8.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:blog\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 54, 1, '', '', 1, 512, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(12, 97, 'Participate in discussion of an important topic', 'participate-in-discussion-of-an-important-topic', '<p>Are you a journalist or a creative personality? Do you want to share information with the world? Then our new project will be perfect for you to express your ideas and concepts.</p>\r\n', '\r\n<p>This project will change the way of public discussions we used to have 5 or 10 years ago in various clubs and non-profit organizations devoted to solving problems and answering the questions experts could not deal with.</p>\r\n<p>We are talking about a new social idea - a project that will unite people of various ages, interests, and professions into a discussion club that will be created on a basis of our website. If you have an idea to share with the world and society, or would like to offer a solution to a problem that seems to be unsolvable but is very important for your country, city or town, you will be a valuable member of our discussion club.<br>\r\nMembers of our club will have a unique opportunity to take part in discussions concerning world problems featuring America\'s leading political and economic consultants, celebrities, and just people who want to express their opinions about various concerns.</p>\r\n\r\n<p>\"We will create four groups, each consisting of 15 volunteers aged from 18 to 60. Representatives of these groups will cooperate with scientists and psychologists to search for solutions to local and national economic and social issues\", says Jim Smith, the coordinator of the project.</p>\r\n\r\n<p>As an experimental startup, the discussion club will concentrate on the following topics this year:</p>\r\n<ol>\r\n  <li>Social diversity and cultural competence;</li>\r\n  <li>Demographic situation in developing countries and possible methods of its control;</li>\r\n  <li>Economic crisis, its influence on situation in the world, and possible improvements that could be introduced.</li>\r\n</ol>\r\n<p>If you are interested in the activity of our discussion club or would like to join it, don\'t hesitate to contact us and ask your questions to find out more.</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 14, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb7.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img7.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 33, 0, '', '', 1, 16, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(13, 98, 'Improving your confidence and self-defense skills', 'improving-your-confidence-and-self-defense-skills', '<p>Today we would like to touch the topic which is gaining popularity among employees of big and small companies as well as students, teachers and other strata of the population.</p>\r\n', '\r\n<blockquote>\r\n<p>If you have experienced assault and aggression of your colleagues, coworkers or roommates, then this set of courses and tutorials devoted to self-defense is worth paying your attention to.</p>\r\n<cite>Bradley Roberts</cite>\r\n</blockquote>\r\n<p>Self-defense is of great importance for every member of modern society aged 12 and older. While 10 years ago we could only visit training or courses about self-defense measures in specialized centers, today it is not necessary to pay money to specialists if you have the desire to train your self-defense skills. Various tutorials on The Web are designed to help you deal with your fear of assaulter and give you necessary recommendations of preventing traumas in case of unavoidable attack.<br />\r\nOur business partner Bradley Roberts is the licensed provider of self-defense training services. He is also widely known for offering effective tutorials, some of which you can find on the Internet and download for free.</p>\r\n\r\n<p>Bradley has recently designed a special self-defense tutorial course that will help you deal with prevailing issues of assault, avoid panicking and raise your confidence.</p>\r\n\r\n<p>Here\'s what this course includes and what you will learn with benefit from it:</p>\r\n<ol>\r\n  <li>Theory of self-defense and basics of various defense techniques;</li>\r\n  <li>Famous defense technique of Brandon Roberts - combining elements of martial arts for self-defense with practical training;</li>\r\n  <li>Developing your self-confidence and eliminating your fear of unknown people as well as various threat sources.</li>\r\n</ol>\r\n<p>This course of tutorials is available exclusively to anyone who subscribes to our newsletter (and it\'s absolutely free). Every tutorial video is fully downloadable via our website.</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 15, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb6.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img6.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 24, 0, '', '', 1, 16, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(14, 99, 'Pen & Paintbruh', 'pen-paintbruh', '<p>Discover the top secrets of creating a beautiful and original painting with a pen and a paintbrush...</p>\r\n', '\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>\r\n\r\n<p>Recent years have showed a great rise of Bernard\'s paintings popularity among young people and businessmen. \"It is not a coincidence\", says Jessica McMillan, James Bernard\'s manager. \"Today people want to experience a wide range of emotions when they look at the painting of an artist. James knows what modern lovers of art need, and he expresses it through his innovative and captivating artworks.\"</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 49, '2018-06-25 16:06:04', 213, '', '2018-06-29 13:25:32', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb5.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img5.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 29, 2, '', '', 1, 15, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(15, 100, 'Music is now officially proved to have influence on us', 'music-is-now-officially-proved-to-have-influence-on-us', '<p>During our latest visit, the scientists of the Seattle Scientific Company laboratory have unveiled some information about their current project, and today we can share the results of their research with you.</p>\r\n', '\r\n<p>The main goal of the research was to confirm or refute the positive influence of music on a human being. Ann Johnson, Ph.D., states that everything we hear around us is not just sound waves of different amplitude. According to her words, every wave includes some \"emotional substance\" that defines the way we perceive it on subliminal level.<br>\r\nThe other participant of the research team, John Robertson, Ph.D. says that even sounds we do not actually pay attention to, are very important to the sonic perception of the environment. Moreover, music we listen to defines our mood and some streaks of our character.</p>\r\n\r\n<p>\"We created two groups, each consisting of 10 volunteers aged from 15 to 60. Representatives of the first group listened to fast-paced, merry and cheerful music of various genres\", says Mr. Robertson. Then he added that the second group was given heavy electronic and rock music as well as classic yet a bit gloomy melodies to listen to.</p>\r\n\r\n<p>The results of research confirm what all music fans have already guessed:</p>\r\n\r\n<ol>\r\n  <li>As each group went through a constantly increasing amount of \"music therapy\", the scientists made a suggestion that amount of music you listen to during a day, only increases its influence on you.</li>\r\n  <li>The emotional impact can be positive and negative - it depends on what kind of music you listen to (though even Metalcore and Dubstep may benefit to the way you feel).</li>\r\n  <li>You can select music according to your own tastes, but don\'t forget to pay attention to the feelings of the people around you - remember that tastes differ.</li>\r\n</ol>\r\n<p>We will keep you informed about further interesting researches of Seattle Scientific Company.</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 51, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb4.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img4.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:blog\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 29, 0, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(16, 101, 'Do you offer replacement parts?', 'do-you-offer-replacement-parts', '<p>Need an expert opinion? Our dedicated staff works to ensure that all the details of the artists\' representation are handled efficiently.</p>', '', 1, 18, '2018-06-25 16:06:04', 213, '', '2018-06-26 15:38:56', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 10, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(17, 102, 'Do you offer delivery services?', 'do-you-offer-delivery-services', '<p>Need an expert opinion? Our dedicated staff works to ensure that all the details of the artists\' representation are handled efficiently.</p>', '', 1, 18, '2018-06-25 16:06:04', 213, '', '2018-06-26 15:38:51', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 13, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(18, 103, 'Meet Our Experts', 'meet-our-experts', '<p>Need an expert opinion? Our dedicated staff works to ensure that all the details of the artists\' representation are handled efficiently.</p>', '', 1, 18, '2018-06-25 16:06:04', 213, '', '2018-06-26 15:38:49', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 12, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(35, 120, 'Our first steps on the market', 'excepteur-sint-occaecat-cupidatat', '<p>Our history begins back in 1998, when the first European office was opened in Cham, Switzerland, by the Anglo-Swiss Company. The founder of the company, himself an immigrant from Germany, was instrumental in turning his Company towards international expansion from the very start. We owe more than our name, our logo and our first product to our founder. He embodied many of the key attitudes and values that form part and parcel of our corporate culture: pragmatism, flexibility, the willingness to learn, an open mind and respect for other people and cultures.</p>', '', 1, 25, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 6, 1, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(36, 121, 'Continuous innovation and transformation', 'phasellus-vitae-risus-non-erat-euismod', '<p>Continuous innovation and rapid transformation have been themes throughout our history, which the company traces to the 1998 with the installation of the first computer system for commercial use in the United States at General Electric’s Park facility. The company has built its solid reputation thanks to thorough employees selection. By the 2001, the company began offering a new breed of solutions to clients - solutions that aligned organizations\' technologies, processes and people with their strategies.</p>', '', 1, 25, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 11, 2, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(37, 122, 'Further development', 'etiam-dignissim-leo-quam', '<p>Throughout its history, the company has expanded its offerings and capitalized on evolving management trends and technologies to benefit its clients. The company pioneered systems integration and business integration; led the deployment of enterprise resource planning, customer relationship management and electronic services; and has established itself as a leader in today\'s global marketplace. Combining unparalleled experience, comprehensive capabilities across all industries and business functions, and extensive research on the world’s most successful companies, we collaborate with clients to help them in each and every requirement.<br /><br /></p>', '', 1, 25, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 6, 3, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(38, 123, 'Company acquisition', 'nullam-auctor-vehicula-dui', '<p>In 2009 the Co Name Group was acquired from Co Name, thereby creating one of the leading European companies. At the time of the acquisition, Co Name Group employed 20,000 staff and generated annual revenues of approximately EUR 2.4 billion. Co Name employed 26,500 staff, generating annual revenues of more than EUR 3 billion. The acquisition of Co Name and the beneficial partnership is the logical continuation of the company strategy. With a workforce of more than 48,000 employees, Co Name generated revenues of over EUR 5 billion during the year.</p>', '', 1, 25, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 11, 4, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(39, 124, 'The Hayford was established in 1940 in New York as the National Committee of Investment Companies.', 'the-hayford-was-established-in-1940-in-new-york-as-the-national-committee-of-investment-companies', '<p>It became the National Association of Investment Companies in 1941. In 1940, company members included 68 mutual funds and 43 closed-end funds, and assets for the fund industry totaled $2.1 billion. The Hayford instituted its first public information program in 1943, published its first annual statistical summary in 1958, and held its first General Membership Meeting in 1959. Unit investment trusts were welcomed as Institute members in 1985. In 2015, the company celebrated the 75th anniversary of its founding and of the key legislation that gave rise to the modern fund industry.</p>\r\n', '\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>', 1, 25, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/history\\/history-2.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 5, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(40, 125, 'When we decided to set up our operations 25 years ago, we had a list of principles that we all stood by, as co-founders...', 'history-1', '<p>They did not change a bit. It was and still is a distinct desire to deliver complex, 360° investment consulting services, that would fill any gap in any business’ daily, monthly and yearly operations. With that in mind, we continue to implement our expertise to help hundreds of companies! The Hayford enjoys all guarantees and concessions provided by the national and foreign investment codes in the shareholder countries. In particular, its assets are granted full mobility and freedom of expatriation and are immune against nationalization and expropriation.</p>\r\n', '\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>', 1, 25, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/history\\/history-1.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 10, 6, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(41, 126, 'Jorinde Voigt', 'jorinde-voigt', '<p class=\"post\">Portrait Art​​​​​​​</p>\r\n\r\n', '\r\n<p>Jorinde Voigt manages the warehouse aspect of each of BuildWall’s projects. Anthony receives materials for each project at BuildWall’s warehouse.</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Portrait Art​​​​​​​</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Anthony manages the warehouse aspect of each of BuildWall’s projects. Anthony receives materials for each project at BuildWall’s warehouse. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Anthony is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Anthony approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Steven acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:38:39', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-1.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-1.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 15, 1, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(42, 127, 'Allen Jones', 'allen-jones', '<p class=\"post\">Expressionist Paintings</p>\r\n', '\r\n<p>Allen Jones is the best expert in eco design. Her favourite materials are wood and stone. With them Allen Jones creates amazing</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Expressionist Paintings</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Stacey is the best expert in eco design. Her favourite materials are wood and stone. With them Stacey creates amazing works. She is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Stacey is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind her, Stacey approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>She is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to her clients and to the production crews that she oversees. Vicky acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to her.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:34:21', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-2.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-2.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 15, 2, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(43, 128, 'Megan Ramos', 'megan-ramos', '<p class=\"post\">Modern Art</p>\r\n\r\n', '\r\n<p>Megan Ramos is at your service on any organisation and finance issues. She surpervises every project and can answer your non-design</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Modern Art</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Jerry is at your service on any organisation and finance issues. He surpervises every project and can answer your non-design questions. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Jerry is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Anthony approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Steven acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:38:21', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-3.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-3.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 16, 3, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(44, 129, 'Steve Donavan', 'steve-donavan', '<p class=\"post\">Experimental Art</p>\r\n\r\n', '\r\n<p>Nick managed the warehouse for 2 years and was promoted to be a Project Manager. </p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Experimental Art</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Nick managed the warehouse for 2 years and was promoted to be a Project Manager. He values customer service and is known for his ethics. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Nick is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Anthony approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Nick acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:40:46', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-4.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-4.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 18, 4, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(45, 130, 'Andrew Rooney', 'andrew-rooney', '<p class=\"post\">Remodeling Consultant</p>\r\n\r\n', '\r\n<p>With a decade at BuidWall and a lifetime in the industry, Andrew Rooney has been an invaluable...</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Remodeling Consultant</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>With a decade at BuidWall and a lifetime in the industry, Andrew Rooney has been an invaluable part of our puzzle. He values customer service and is known for his ethics. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Andrew is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Andrew approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Andrew acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:41:10', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-5.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-5.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 16, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(46, 131, 'Frank Roberts', 'frank-roberts', '<p class=\"post\">Senior Foreman</p>\r\n\r\n', '\r\n<p>Frank is in charge of all our workers. He joined us in 2006 and managed to organize a close-knit team...</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Senior Foreman</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Frank is in charge of all our workers. He joined us in 2006 and managed to organize a close-knit team, where every person is at his place. He values customer service and is known for his ethics. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Frank is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Andrew approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Frank acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:41:28', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-6.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-6.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 17, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(48, 133, 'Guy Richie', 'guy-richie', '<blockquote><p>I never thought that I would ever need anyone\'s help managing my fund... But after making a fatal decision to buy real estate bonds in 2007, I changed my mind. This firm\'s consultants helped me to recover my finances and achieve a steady growth once more!</p><small>Guy Richie</small></blockquote>\r\n', '', 1, 28, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/testimonials\\/testimonials-3.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/testimonials\\/testimonials-3.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"1\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 11, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(49, 134, 'Lenny Stevens', 'lenny-stevens', '<blockquote><p>Whenever I feel like I am head over heels with the decision on which exact investment option to take, I call these guys up. They\'ve made me more than $789 million in profit, and that\'s just in the last few years! Whatever they advised me, turned out to be gold!</p><small>Lenny Stevens</small></blockquote>', '', 1, 28, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/testimonials\\/testimonials-2.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/testimonials\\/testimonials-2.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"1\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 12, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(50, 135, 'Adam Cooper', 'adam-cooper', '<blockquote><p>The guys at your company are amazing! Your service has added a great value to my life. I love that I can jump to your site any time and have access to support 24/7.</p><small>Adam Cooper</small></blockquote>', '', 1, 28, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/testimonials\\/testimonials-1.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/testimonials\\/testimonials-1.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"1\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 11, 3, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(51, 136, '6. Do I need an account and what are the benefits?', '6-do-i-need-an-account-and-what-are-the-benefits', '<p>It\'s not required to create an account. But, having an account provides easier checkout, the ability to create and send a wishlist, and a customized shopping experience.</p>', '', 1, 27, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 9, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(52, 137, '5. How long will my order take to be delivered?', '5-how-long-will-my-order-take-to-be-delivered', '<p>Delivery times will depend on your location. Once payment is confirmed your order will be packaged. Delivery can be expected within 10 business days.</p>', '', 1, 27, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(53, 138, '4. Can I return an item?', '4-can-i-return-an-item', '<p>Please visit our Returns & Exchanges page for more information.</p>', '', 1, 27, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 8, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(54, 139, '3. Can I track my order?', '3-can-i-track-my-order', '<p>Yes, you can! After placing your order you will receive an order confirmation via email. Each order starts production 24 hours after your order is placed. Within 72 hours of you placing your order, you will receive an expected delivery date. When the order ships, you will receive another email with the tracking number and a link to trace the order online with the carrier.</p>', '', 1, 27, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 10, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(55, 140, '2. How can I pay for my order?', '2-how-can-i-pay-for-my-order', '<p>We accept Visa, MasterCard, and American Express credit and debit cards for your convenience.</p>', '', 1, 27, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 5, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(56, 141, '1. How can I change something in my order?', '1-how-can-i-change-something-in-my-order', '<p>If you need to change something your order, please contact us immediately. We usually process orders within 2-4 hours, and once we have processed your order, we will be unable to make any changes.</p>', '', 1, 27, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 6, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(57, 142, 'Template settings', 'template-settings', '<h5>Modules configuration table</h5>\r\n<p>This table shows theme modules settings. Please make sure you have read <a href=\"http://www.templatemonster.com/help/quick-start-guide/joomla-templates/v3-2/index_en.html#modules-config-table\" target=\"_blank\">theme documentation. </a> </p>\r\n\r\n<div id=\"mod_table\">\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>1 - Search</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_search</li>\r\n				<li><strong>Position:</strong> 404-search</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>2 - TM Ajax Contact Form</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_ajax_contact_form</li>\r\n				<li><strong>Position:</strong> contact-form</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>3 - Detailed</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-7</li>\r\n				<li><strong>Class Suffix:</strong> pricing_detailed</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>4 - Simple</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> pricing_simple</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 2</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>5 - Accordion 1</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> custom</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 11</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>6 - Careers accordion</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>7 - Apply now</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_ajax_contact_form</li>\r\n				<li><strong>Position:</strong> sidebar-2</li>\r\n				<li><strong>Class Suffix:</strong> careers_form</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>8 - Requirements</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> careers-accordion-requirements</li>\r\n				<li><strong>Class Suffix:</strong>  requirements</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>9 - What we Expect from you?</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> careers-accordion-expect</li>\r\n				<li><strong>Class Suffix:</strong>  expect</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>10 - Careers accordion</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>11 - Careers accordion</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>12 - Careers accordion</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-4</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>13 - Pages</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>14 - Blog posts</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_category</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong>  site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>15 - Portfolio posts</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_category</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong>  site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>16 - User menu</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>17 - Breadcrumbs</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_breadcrumbs</li>\r\n				<li><strong>Position:</strong> breadcrumbs</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>18 - Our team</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-top</li>\r\n				<li><strong>Class Suffix:</strong> team</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>19 - Frequently asked questions</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 3</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>20 - Tabs</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstraptabs</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 13</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>21 - Accordion 2</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 10</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>22 - Pricing Tables</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> pricing_detailed</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 14</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>23 - Simple</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> pricing_simple</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 15</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>24 - Accordions and Toggles</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> title_only</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 9</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>25 - Menu search</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_search</li>\r\n				<li><strong>Position:</strong> modal</li>\r\n				<li><strong>Class Suffix:</strong>  modal_search</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>26 - Text Elements</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>27 - TM Ajax Style Switcher</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_style_switcher</li>\r\n				<li><strong>Position:</strong> fixed-sidebar-left</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>28 - Portfolio</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_portfolio</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 4</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>29 - Linear bars</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_progress_bars</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 5</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>30 - Radial bars</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_progress_bars</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 6</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>31 - Tags</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tags_popular</li>\r\n				<li><strong>Position:</strong> sidebar-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 5</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>32 - Recent posts</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> sidebar-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 6</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>33 - Categories</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_categories</li>\r\n				<li><strong>Position:</strong> sidebar-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 2</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>34 - Blog categories</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_categories</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>35 - Latest posts</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>36 - Latest works</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>37 - Login form megamenu</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_slogin</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>38 - Social menu</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>39 - Counters</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_counters</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 8</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>40 - Google map</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_google_map</li>\r\n				<li><strong>Position:</strong> map</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>41 - Portfolio default</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_portfolio</li>\r\n				<li><strong>Position:</strong> position-6</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 4</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>42 - Portfolio masonry</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_portfolio</li>\r\n				<li><strong>Position:</strong> position-6</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 4</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>43 - Working time</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> sidebar-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 3</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>44 - Do You Have any Questions?</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> sidebar-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 4</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>45 - Partners</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-top</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>46 - Services prices</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>47 - Popular questions</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> none</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>48 - Our services</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>49 - Google map home</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_google_map</li>\r\n				<li><strong>Position:</strong> map</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>50 - Get in Touch</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> footer</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>51 - Welcome img</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>52 - Welcome to artesma</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>53 - Exhibitions</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> position-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>54 - Exhibitions gallery</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_owl_carousel</li>\r\n				<li><strong>Position:</strong> position-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>55 - Home services 1</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>56 - exhibitions</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> position-4</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>57 - our blog</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> position-5</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>58 - Home Blog</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-5</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>59 - who we are</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> position-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>60 - About services</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>61 - meet the Team</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> position-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>62 - Our Artists</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> position-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>63 - what people say</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_owl_carousel</li>\r\n				<li><strong>Position:</strong> position-4</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>64 - Questions img</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> position-5</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=\'module\'>\r\n	<div class=\'row\'>\r\n		<div class=\'col-sm-3\'><b>65 - FAQ</b></div>\r\n\r\n		<div class=\'col-sm-4\'>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> position-5</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=\'col-sm-5\'>\r\n			<ul>\r\n				<li><strong>Pages:</strong> </li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=\'clearfix\'></div>\r\n	</div>\r\n	</div>\r\n</div>', '', 1, 29, '2018-06-25 16:06:04', 213, '', '2018-06-30 13:52:10', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 14, 1, '', '', 1, 74, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(65, 198, '404 Page', '404-page', '<h1>404</h1>\r\n<h3>Sorry!<br> Page Not Found</h3>\r\n<big>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</big>\r\n<p>Please try using our search box below to look for information on the internet.</p>\r\n{loadposition 404-search}', '', 1, 2, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 18, 3, '', '', 1, 345, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(66, 274, 'Popular', 'popular', '\r\n', '\r\n<p>Here you will find artworks that are most frequently viewed and liked by site visitors.</p>\r\n<ul class=\"portfolio-meta-list\">\r\n	<li><strong class=\"portfolio-meta-key\">Client:</strong><span>Popular</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Date:</strong><span>07/07/2012</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Info:</strong><span>Mighty creative studio</span></li>\r\n</ul>\r\n<p><a href=\"#\" target=\"_blank\" class=\"btn btn-info\">View Project</a></p>\r\n<p>Would you like to know what do other people love the most? Click here and view. You will come across a really inspiring stuff. Have creative works of your own to show to the public? Post them and see if they are enjoyed by many people. This maybe your own way to popularity. As a rule, if some content becomes really popular on the Internet, the users tend to make a research about its author. Every gifted person has chances to become appreciated, loved and followed.</p>', 1, 72, '2018-06-25 16:06:04', 213, '', '2018-06-28 15:36:38', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/project-thumb1.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"Popular\",\"image_fulltext\":\"images\\/portfolio\\/project1.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 45, 1, '', '', 1, 219, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(67, 275, 'Architecture', 'architecture', '\r\n', '\r\n<p>Here we feature artworks related to architecture.</p>\r\n<ul class=\"portfolio-meta-list\">\r\n	<li><strong class=\"portfolio-meta-key\">Client:</strong><span>Architecture</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Date:</strong><span>07/07/2012</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Info:</strong><span>leading architecture technology</span></li>\r\n</ul>\r\n<p><a href=\"#\" target=\"_blank\" class=\"btn btn-info\">View Project</a></p>\r\n<p>Architecture is both the process and the product of planning, designing, and constructing buildings and other physical structures. Architectural works, in the material form of buildings, are often perceived as cultural symbols and as works of art. Historical civilizations are often identified with their surviving architectural achievements. Architecture has to do with planning, designing and constructing form, space and ambience to reflect functional, technical, social, environmental and aesthetic considerations. It requires the creative manipulation and coordination of materials and technology, and of light and shadow.</p>', 1, 72, '2018-06-25 16:06:04', 213, '', '2018-06-28 15:36:23', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/project-thumb2.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"Architecture\",\"image_fulltext\":\"images\\/portfolio\\/project2.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 32, 2, '', '', 1, 53, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(68, 276, 'Art & Illustration', 'art-illustration', '\r\n', '\r\n<p>An illustration is a visual approach to a verbal story.</p>\r\n<ul class=\"portfolio-meta-list\">\r\n	<li><strong class=\"portfolio-meta-key\">Client:</strong><span>Art & Illustration</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Date:</strong><span>07/07/2012</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Info:</strong><span>Interactive form of visual communication</span></li>\r\n</ul>\r\n<p><a href=\"#\" target=\"_blank\" class=\"btn btn-info\">View Project</a></p>\r\n<p>Is there any difference between art and illustration? In an illustration, there is little, if anything, for the viewer to do. All the information is there available for the viewer to see. There can be several themes at once but it precisely includes all the visual information the audience is expected to use upon viewing it.  Illustration is easily given words to express it that are appropriate to it. Art is something else and represents a more interactive form of visual communication. It does require something from the viewer in order to be recognized. Art is not intended as a verbal communication represented in a visual format.</p>', 1, 71, '2018-06-25 16:06:04', 213, '', '2018-06-28 15:36:01', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/project-thumb3.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"Art & Illustration\",\"image_fulltext\":\"images\\/portfolio\\/project3.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 27, 3, '', '', 1, 25, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(69, 277, 'Web & Interactive', 'web-interactive', '\r\n', '\r\n<p>Best website designs showcased.</p>\r\n<ul class=\"portfolio-meta-list\">\r\n	<li><strong class=\"portfolio-meta-key\">Client:</strong><span>Web & Interactivem</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Date:</strong><span>07/07/2012</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Info:</strong><span>The collection has about 100.000 pieces of art in total.</span></li>\r\n</ul>\r\n<p><a href=\"#\" target=\"_blank\" class=\"btn btn-info\">View Project</a></p>\r\n<p>The collection has about 100.000 pieces of art in total. Just like a real visit to the museum it is possible to discuss a piece of art, or ask a question with all registered users of the site. Active discussions or questions are shown on the user account page. It is also possible to choose your favorite detail of an artwork and discuss it with other users. There is a lot of cross-referencing going on between all these content types and nodes to create certain elements. Especially the interactive elements make heavy use of this.</p>', 1, 71, '2018-06-25 16:06:04', 213, '', '2018-06-28 15:35:47', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/project-thumb4.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"Web & Interactive\",\"image_fulltext\":\"images\\/portfolio\\/project4.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 30, 4, '', '', 1, 12, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(70, 278, 'Promotional', 'promotional', '', '\r\n<p>Promotion can be done by different media. Here you will see the artistic approach to promotion.</p>\r\n<ul class=\"portfolio-meta-list\">\r\n	<li><strong class=\"portfolio-meta-key\">Client:</strong><span>Promotional</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Date:</strong><span>07/07/2012</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Info:</strong><span>Present information to consumers and others.</span></li>\r\n</ul>\r\n<p><a href=\"#\" target=\"_blank\" class=\"btn btn-info\">View Project</a></p>\r\n<p>The purpose of a promotion can have a wide range, including: sales increases, new product acceptance, creation of brand equity, positioning, competitive retaliations, or creation of a corporate image. The goal of a promotion is then to reach the most people possible in a time efficient and a cost efficient manner. Fundamentally, there are three basic objectives of promotion. These are: to present information to consumers and others, to increase demand, to differentiate a product.</p>', 1, 70, '2018-06-25 16:06:04', 213, '', '2018-06-28 15:35:31', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/project-thumb5.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"Promotional\",\"image_fulltext\":\"images\\/portfolio\\/project5.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 31, 5, '', '', 1, 33, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(71, 279, 'Games & Entertainment', 'games-entertainment', '', '\r\n<p>Traditional art forms are things you cannot win; you can only experience them.</p>\r\n<ul class=\"portfolio-meta-list\">\r\n	<li><strong class=\"portfolio-meta-key\">Client:</strong><span>Games & Entertainment</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Date:</strong><span>07/07/2012</span></li>\r\n	<li><strong class=\"portfolio-meta-key\">Info:</strong><span>Controlled passage through an overwhelming aesthetic experience.</span></li>\r\n</ul>\r\n<p><a href=\"#\" target=\"_blank\" class=\"btn btn-info\">View Project</a></p>\r\n<p>Video games can be measured as art of imitation nature and reality. Games and entertainment art grows better the more it improves or alters nature through a passage through what we might call the artist\'s soul, or vision. Video games are nothing if not experiential. They are visuals and music and poetry all wrapped up into a single package. A video game isn\'t just a game—it is a controlled passage through an overwhelming aesthetic experience.</p>', 1, 70, '2018-06-25 16:06:04', 213, '', '2018-06-28 15:30:41', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/project-thumb6.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"Games & Entertainment\",\"image_fulltext\":\"images\\/portfolio\\/project6.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 32, 6, '', '', 1, 34, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(75, 285, 'Basic', 'first-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Basic</h6>\r\n    <em class=\"pricing-table__subtitle\">Basic plan great for online, small & local businesses</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">100</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__list\">\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Object analysis</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Territory analysis</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Options selection</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Details discussion</span>\r\n      </div>\r\n    </div>\r\n  </div> \r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 35, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 13, 0, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(76, 286, 'Advanced', 'second-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Advanced</h6>\r\n    <em class=\"pricing-table__subtitle\">Advanced plan great for online, small & local businesses</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">245</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__list\">\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Object analysis</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Calculations</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Options selection</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Materials selection</span>\r\n      </div>\r\n    </div>\r\n  </div> \r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 35, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 17, 0, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(77, 287, 'Elite', 'third-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Elite</h6>\r\n    <em class=\"pricing-table__subtitle\">Elite plan great for online, small & local businesses</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">345</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__list\">\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Object analysis</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Calculations</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Options selection</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Materials selection</span>\r\n      </div>\r\n    </div>\r\n  </div> \r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 35, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 13, 0, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(78, 288, 'Deluxe', 'fourth-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Deluxe</h6>\r\n    <em class=\"pricing-table__subtitle\">Deluxe plan great for online, small & local businesses</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">499</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__list\">\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Object analysis</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Calculations</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item active\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Options selection</span>\r\n      </div>\r\n    </div>\r\n    <div class=\"pricing__list-item\">\r\n      <div class=\"pricing-feature__inner\">\r\n        <i class=\"item-icon\"></i>\r\n        <span class=\"pricing-feature__text\">Materials selection</span>\r\n      </div>\r\n    </div>\r\n  </div> \r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 35, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 13, 0, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(88, 307, 'Basic', 'first-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Basic</h6>\r\n    <em class=\"pricing-table__subtitle\">Special offer</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">100</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 36, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 15, 0, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(89, 308, 'Advanced', 'second-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Advanced</h6>\r\n    <em class=\"pricing-table__subtitle\">For first-time clients</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">200</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 36, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 12, 0, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(90, 309, 'Professional', 'third-package', '<div class=\"pricing-table\">\r\n  <div class=\"pricing-table__heading\">\r\n    <h6 class=\"pricing-table__title\">Professional</h6>\r\n    <em class=\"pricing-table__subtitle\">For businesses</em>\r\n    <div class=\"pricing-table__price\">\r\n      <span class=\"pricing-table__price-prefix\">$</span>\r\n      <span class=\"pricing-table__price-val\">299</span>\r\n      <span class=\"pricing-table__price-suffix\">/mo</span>\r\n    </div>\r\n  </div>\r\n  <div class=\"pricing-table__action\">\r\n    <a class=\"btn\" href=\"#\">Buy Now</a>\r\n  </div> \r\n</div>', '', 1, 36, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 10, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(100, 353, 'Tab Title 3', 'tab-title-3', '<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. </p>', '', 1, 57, '2018-06-25 16:06:04', 213, '', '2018-06-27 13:21:10', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 12, -1, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(101, 354, 'Tab Title 2', 'tab-title-2', '<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. </p>', '', 1, 57, '2018-06-25 16:06:04', 213, '', '2018-06-27 12:21:20', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 12, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(102, 355, 'Tab Title 1', 'tab-title-1', '<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. </p>', '', 1, 57, '2018-06-25 16:06:04', 213, '', '2018-06-27 12:21:14', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 13, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(103, 357, 'Adam Smith', 'adam-smith', '<blockquote><p>I just don\'t know how to describe your services... They are extraordinary! I am quite happy with them! Just keep up going this way!</p><small>Adam Smith</small></blockquote>', '', 1, 28, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/testimonials\\/testimonials-4.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/testimonials\\/testimonials-1.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"1\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 15, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(104, 358, 'Nick Harris', 'nick-harris', '<blockquote><p>Great organization!! Your prompt answer became a pleasant surprise for me. You’ve rendered an invaluable service! Thank you very much!</p><small>Nick Harris</small></blockquote>', '', 1, 28, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/testimonials\\/testimonials-5.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/testimonials\\/testimonials-2.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"1\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 14, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(105, 359, 'John Anderson', 'john-anderson', '<blockquote><p>I just want to thank you for your help. I was so pleased and grateful. Keep up the excellent work. Your site provides the best support I have ever encountered.</p><small>John Anderson</small></blockquote>\r\n', '', 1, 28, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/testimonials\\/testimonials-6.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/testimonials\\/testimonials-3.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"1\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 14, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(110, 375, 'We truly believe that the success of our business depends on our employees.', 'lorem-ipsum-dolor-sit-amet', '<p>We offer excellent opportunities for individuals seeking to strive and flourish in the research and consultancy industry, focusing on their professional as well as personal development. Our distinctive environment offers careers that are exciting, challenging and rewarding. We encourage our people to learn, experiment and grow - for both their own personal benefit and the company’s.</p>\r\n{loadposition careers-accordion-1}', '', 1, 46, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 9, -1, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(111, 378, 'The Sunday Times Best Company to work for', 'etiam-in-neque-non-sapien-lobortis', '<p>We’re proud to say that our office has made The Sunday Times Best Small Companies to work for list at our first attempt. Our Company is the top-ranking research consultancy in the small companies category to have achieved a listing, achieving 50th place out of the top 100  companies  recognised as great places to work in the UK. The accolade acknowledges “that senior employees truly live the values of the firm”, that people say “their jobs are good for growth” and the company “clearly values new ideas from employees”. We received top rankings for the My Manager, Personal Growth and Fair Deal categories. This is truly a testament to the talented collection of people, special energy and morale we have at The Futures Company.</p>\r\n{loadposition careers-accordion-2}', '', 1, 46, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 9, -1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(112, 379, 'IT Careers', 'porro-magni-dolore-eos-eius-ducimus', '<p>Each day our world creates new technology: devices, apps, and services. Which means new ways to do things, new ways to connect, new things to learn. While each holds the promise of helping us get more done with less effort, they also can become one more thing competing for our scarce time and attention.</p>\r\n{loadposition careers-accordion-3}', '', 1, 46, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 10, 1, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(113, 381, 'Machine learning', 'vestibulum-commodo-mollis', '<p>We are looking to hire mathematically minded people who have the talent to analyze and derive meaning from data, as well as those who know how to deploy techniques of machine learning. We work with a diverse set of technologies, including deep learning, probabilistic programming, large-scale learning, and causal reasoning. For scientists who’ve got algorithmic ability, this skill set can be the ticket to one of the hottest jobs on the market.</p>\r\n{loadposition careers-accordion-4}', '', 1, 46, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 11, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(114, 384, 'Business intelligence (BI) professionals', 'business-intelligence-bi-professionals', '{loadposition careers-accordion-requirements}', '', 1, 47, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 5, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(115, 385, 'Business Program Managers (BPM)', 'business-program-managers-bpm', '{loadposition careers-accordion-expect}', '', 1, 47, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(116, 386, 'Software Engineers (SWE)', 'software-engineers-swe', '<p>They’re responsible for production code quality and service performance, and accountable for automation of test cases to enable flighting. These engineers can evaluate requirements, estimate costs, design, implement, validate and measure to understand the quality of the end users’ experience. They can improve engineering processes, assure quality, communicate status, and manage risks.</p>', '', 1, 47, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 4, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(118, 425, 'Things I’ve Learned about Investing and Business', 'things-i-ve-learned-about-investing-and-business', '<p>The North American Auto Show, one of the most important annual events that influence the international automotive industry and exhibits its main achievements, is eventually confirmed to take place in Chicago, IL. Located on the southwestern coast of Lake Michigan, this city will host representatives of vehicle manufacturers from all over the world. They include American companies (Ford, General Motors), European (Alfa Romeo, Lotus, BMW, FIAT, Seat) as well as Japanese ones and many others.</p>\r\n', '\r\n<p>The North American Auto Show, one of the most important annual events that influence the international automotive industry and exhibits its main achievements, is eventually confirmed to take place in Chicago, IL. Located on the southwestern coast of Lake Michigan, this city will host representatives of vehicle manufacturers from all over the world. They include American companies (Ford, General Motors), European (Alfa Romeo, Lotus, BMW, FIAT, Seat) as well as Japanese ones and many others.</p>\r\n<p>Even if you are not considered to be a fan of cool cars and international automotive industry, this event is worth visiting. This year organizers promise not just great exhibits to be presented at the event, but also a great amount of entertainment for adults and children. If you happen to be in Chicago this summer, you should definitely visit this show. Unlike any other car exhibition, be it muscle car show or old car show, the North American Auto Show offers vast possibilities of entertaining and spending free time for your good.</p>\r\n\r\n<p>The North American Show was first held in 1970 in Ontario, Canada. During more than 30 years of the exhibition\'s history, it has been attracting a lot of attention of automotive industry representatives including vehicle manufacturers and investors. The exhibition takes place in one of three North American countries - Mexico, USA or Canada.</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 52, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb1.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img1.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 56, 1, '', '', 1, 372, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(119, 427, 'LinkedIn Stock Downgraded After Microsoft Deal ', 'linkedin-stock-downgraded-after-microsoft-deal', '<p>Fox TV Channel is showcasing the most successful series and full-length films of 20th Century Fox this month in all American cinemas with wide promotional campaign of their upcoming projects.</p>\r\n', '\r\n<p>Fox TV Channel is showcasing the most successful series and full-length films of 20th Century Fox this month in all American cinemas with wide promotional campaign of their upcoming projects.</p>\r\n<p><b>What is Fox TV?</b><br>You all probably know the famous intro of 20th Century Fox that we all have seen (of course if you have visited cinema at least once). This company is a part of Fox International Company, a global media corporation that delivers high-quality content pleasing your eyes and ears. One of its other subsidiaries is Fox TV Channel. So here\'s the main point:</p>\r\n<blockquote><p>20th Century Fox brings to your screen full-length films and cartoons that we all love.</p></blockquote>\r\n<blockquote><p>Fox Television is offering us unique content, broadcasting amazing series and shows of the channel\'s own production.</p></blockquote>\r\n\r\n<p><b>Anniversary Showcase</b><br>This year, the Fox International Company celebrates the great anniversary of 70 years since their film production activity has started. Managers and executive officers of the company have decided to give all American residents and guests a chance to enjoy the films, cartoons and the best moments of series and shows that they love so much. To make it possible, almost all big cinemas take part in Fox 70th Anniversary Showcase - an event that promotes the art of making memorable movies and series, and also raises money for charity worldwide. Everyone is invited to watch the greatest movies and series of all times throughout the USA!</p>\r\n\r\n<p><b>Taking Part in the Event</b><br>Though this event is free for participation, it still requires registration. All you need is to proceed to Fox\'s official website and enter next data:</p>\r\n<ol>\r\n<li>your name and surname;</li>\r\n<li>your age;</li>\r\n<li>your place of residence (country and region, state or province);</li>\r\n<li>number of people that will accompany you at the event.</li>\r\n</ol>\r\n<p>After that you will be given an electronic ticket to the nearest Fox 70th Anniversary Showcase alongside with a program of the event. And that\'s all you need to do! Just print your ticket, invite your friends, and enjoy the greatest hits of Fox International Company!</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 53, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb2.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img2.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 31, 0, '', '', 1, 24, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(120, 429, 'London SE in Frankfurt?', 'london-se-in-frankfurt', '<p>Recently our partner, Jerry Conrad Lewis has revealed some of his own global plans alongside with a new set of social measures, designed to improve the world we live in.</p>\r\n', '\r\n<p>Recently our partner, Jerry Conrad Lewis has revealed some of his own global plans alongside with a new set of social measures, designed to improve the world we live in.</p>\r\n<blockquote>\r\n<p>Due to global changes our planet is experiencing, we all have surely thought about something that would complement governmental measures, so that our way of life could be improved.</p>\r\n<cite>Jerry C. Lewis</cite>\r\n</blockquote>\r\n<p>Our partner and good friend who is also a great scientist, has recently revealed some of his own global plans. \"As you probably know, I strive for excellence in every sphere of my activity, be it science or art, and that\'s why I would like to present you how I see changing the future and society for the better\", said Jerry C. Lewis at the Pinarini Ecologic conference in Milan, Italy.<br />\r\nAccording to his words, he extensively deals with various spheres of activity, e.g. technology, traditional art, IT, web design, business consulting etc., and this year he is going to concentrate his efforts on social development and ecological improvement of the environment we all live in.</p>\r\n\r\n<p>\"I hope to improve worldwide social and ecological policies of local governments that influence us as citizens\", said Jerry. He also added that his upcoming innovations would help small companies and individual entrepreneurs to develop and improve their internal infrastructure.</p>\r\n\r\n<p>Here\'s what is planned to be offered to your region during next 12 months:</p>\r\n\r\n<ol>\r\n  <li>Greening encouragement. It means encouraging people to devote more time and efforts to make their region greener, so that it could be possible to resist the urbanization problems.</li>\r\n  <li>	Social experiments. It is a series of social measures used to control the limit of poverty and to help people in need that fill the streets of European and American towns and cities.</li>\r\n  <li>Promoting social projects. It helps social activists and members of international organizations promote their projects as governmental acts, making them easier to implement.</li>\r\n</ol>\r\n<p>Of course, these programs and services won\'t work without your participation. So take your chance today in changing the world around you!</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 54, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb3.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img3.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 38, 0, '', '', 1, 24, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(121, 433, 'Elements', 'elements', '<h1 class=\"heading-style-1\">Heading style 1</h1>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.<b>this is strong text</b>  We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<h2 class=\"heading-style-2\">Heading style 2</h2>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. <a href=\"#\">this is inline link </a>  We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<h3 class=\"heading-style-3\">Heading style 3</h3>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.<mark> this is marked out text</mark>  We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<h4 class=\"heading-style-4\">Heading style 4</h4>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.  We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<h5 class=\"heading-style-5\">Heading style 5</h5>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.  We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<h6 class=\"heading-style-6\">Heading style 6</h6>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.  We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<div class=\"spacer\"></div>\r\n<div class=\"row\">\r\n	<div class=\"col-sm-4\">\r\n		<div class=\"item_img img-intro__none img-offset1\">\r\n			<img src=\"images/elements_img1.jpg\" alt=\"\" />\r\n		</div>\r\n		<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.</p>\r\n	</div>\r\n	<div class=\"col-sm-8\">\r\n		<div class=\"item_img img-intro__left img-offset1\">\r\n			<img src=\"images/elements_img2.jpg\" alt=\"\" />\r\n		</div>\r\n		<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n		<div class=\"row\">\r\n			<div class=\"col-sm-12\">\r\n				<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. </p>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"spacer\"></div>\r\n<div class=\"row\">\r\n	    <div class=\"col-sm-4\">\r\n        <ul class=\"list\">\r\n            <li><a href=\"#\">Modern Art</a></li>\r\n            <li><a href=\"#\">Portrait Art</a></li>\r\n            <li><a href=\"#\">Expressionist Paintings</a></li>\r\n            <li><a href=\"#\">Miniature Paintings</a></li>\r\n            <li><a href=\"#\">Experimental Art</a></li>\r\n            <li><a href=\"#\">Tempera Painting​​​​​​​</a></li>\r\n        </ul>\r\n    </div>\r\n    <div class=\"col-sm-4\">\r\n        <ol>\r\n            <li><a href=\"#\">Modern Art</a></li>\r\n            <li><a href=\"#\">Portrait Art</a></li>\r\n            <li><a href=\"#\">Expressionist Paintings</a></li>\r\n            <li><a href=\"#\">Miniature Paintings</a></li>\r\n            <li><a href=\"#\">Experimental Art</a></li>\r\n            <li><a href=\"#\">Tempera Painting​​​​​​​</a></li>\r\n        </ol>\r\n    </div>\r\n</div>\r\n<div class=\"spacer\"></div>\r\n\r\n<blockquote>\r\n	<p>I love your exhibitions; there are many different styles of paintings and a big range of types of art with affordable prices. Seeing so much variety of art is exciting and there\'s something for everyone. I\'ve never been to a gallery before, but after visiting your gallery I feel in love with fine art.</p>\r\n	<small>Mark Johnson</small>\r\n</blockquote>\r\n\r\n<div class=\"spacer\"></div>\r\n<div class=\"page_header\">\r\n	<h1 class=\"center\">Get Started</h1>\r\n</div>\r\n<form>\r\n	<div class=\"row\">\r\n		<div class=\"control control-group-input col-sm-4\">\r\n			<div class=\"controls\">\r\n				<input type=\"text\" placeholder=\"Text input\">\r\n			</div>\r\n			<div class=\"controls\">\r\n				<input type=\"text\" placeholder=\"Text input:\" class=\"error\"><mark><label class=\"error\">This field is required.</label></mark>\r\n			</div>\r\n		</div>\r\n		<div class=\"col-sm-4\">\r\n			<div class=\"controls\">\r\n				<textarea placeholder=\"Text area field\"></textarea>\r\n			</div>\r\n		</div>\r\n		<div class=\"col-sm-4\">\r\n			<div class=\"control-group\">\r\n				<select>\r\n					<option disabled selected value=\"\">Select option</option>\r\n					<option>Option 1</option>\r\n					<option>Option 2</option>\r\n				</select>\r\n			</div>\r\n			<div class=\"row\">\r\n				<div class=\"col-sm-6\">\r\n					<div class=\"control-group reset-margin\">\r\n						<input type=\"checkbox\" id=\"checkbox_1\" checked>\r\n						<label for=\"checkbox_1\" class=\"inline\">Checkbox label</label>\r\n					</div>\r\n					<div class=\"control-group\">\r\n						<input type=\"checkbox\" id=\"checkbox_2\">\r\n						<label for=\"checkbox_2\" class=\"inline\">Checkbox label</label>\r\n					</div>\r\n				</div>\r\n				<div class=\"col-sm-6\">\r\n					<div class=\"control-group reset-margin\">\r\n						<input type=\"radio\" id=\"radio_1\" name=\"radio\" checked>\r\n						<label for=\"radio_1\" class=\"inline\">Radio label</label>\r\n					</div>\r\n					<div class=\"control-group\">\r\n						<input type=\"radio\" id=\"radio_2\" name=\"radio\">\r\n						<label for=\"radio_2\" class=\"inline\">Radio label</label>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class=\"col-sm-12\">\r\n			<a href=\"#\" class=\"btn\">send message</a>\r\n		</div>\r\n	</div>\r\n</form>', '', 1, 62, '2018-06-25 16:06:04', 213, '', '2018-06-27 12:10:32', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 116, 1, '', '', 1, 1830, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(125, 449, 'Leadership', 'conse-ctetu', '', '', 1, 59, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"0\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(126, 450, 'Management', 'dolor-sit-amet-conse', '', '', 1, 59, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"25\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 6, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(127, 451, 'Innovation and creativity', 'sit-amet-conse', '', '', 1, 59, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"75\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(128, 452, 'Leadership', 'conse-ctetu', '', '', 1, 60, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"0\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(129, 453, 'Management', 'dolor-sit-amet-conse', '', '', 1, 60, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"25\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 6, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(130, 454, 'Innovation and creativity', 'sit-amet-conse', '', '', 1, 60, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"75\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 6, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(135, 476, 'Resilience', 'sit-amet-consectetur', '', '', 1, 59, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"100\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(136, 477, 'Resilience', 'sit-amet-consectetur', '', '', 1, 60, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"100\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(137, 479, 'Professional Investment Consulting', 'slide-1', '<p>We are an international acknowledged management consulting firm that provides localized solutions in partnership with our clients. Our aim is to enhance corporate competency and performance through result-based solutions to match clients’ individual requirements.</p>\r\n', '\r\n<p>We are an international acknowledged management consulting firm that provides localized solutions in partnership with our clients. Our aim is to enhance corporate competency and performance through result-based solutions to match clients’ individual requirements.</p>\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>\r\n<p>Recent years have showed a great rise of Bernard\'s paintings popularity among young people and businessmen. \"It is not a coincidence\", says Jessica McMillan, James Bernard\'s manager. \"Today people want to experience a wide range of emotions when they look at the painting of an artist. James knows what modern lovers of art need, and he expresses it through his innovative and captivating artworks.\"</p>\r\n', 1, 63, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/slider\\/slide-thumb-1.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/slider\\/slide-1.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 13, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(138, 480, 'Set your own pace', 'slide-2', '<p>We are confident about the fact, that clear goals, a long-term investment philosophy, a balanced portfolio, and low costs create a path to your financial goals. There\'s investing, and there\'s smart investing. We\'re the latter, we\'re better!</p>\r\n', '\r\n<p>We are confident about the fact, that clear goals, a long-term investment philosophy, a balanced portfolio, and low costs create a path to your financial goals. There\'s investing, and there\'s smart investing. We\'re the latter, we\'re better!</p>\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>\r\n<p>Recent years have showed a great rise of Bernard\'s paintings popularity among young people and businessmen. \"It is not a coincidence\", says Jessica McMillan, James Bernard\'s manager. \"Today people want to experience a wide range of emotions when they look at the painting of an artist. James knows what modern lovers of art need, and he expresses it through his innovative and captivating artworks.\"</p>', 1, 63, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/slider\\/slide-thumb-2.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/slider\\/slide-2.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 8, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(139, 481, 'Why You Need an Advisor?', 'slide-3', '<p>We help you in creating a financial strategy that represents your personality. Getting to know you is financial advisor’s primary goal. - An approach centered around your life’s priorities. It’s time for a financial strategy that puts your needs and priorities front and center.</p>\r\n', '\r\n<p>We help you in creating a financial strategy that represents your personality. Getting to know you is financial advisor’s primary goal. - An approach centered around your life’s priorities. It’s time for a financial strategy that puts your needs and priorities front and center.</p>\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>\r\n<p>Recent years have showed a great rise of Bernard\'s paintings popularity among young people and businessmen. \"It is not a coincidence\", says Jessica McMillan, James Bernard\'s manager. \"Today people want to experience a wide range of emotions when they look at the painting of an artist. James knows what modern lovers of art need, and he expresses it through his innovative and captivating artworks.\"</p>', 1, 63, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/slider\\/slide-thumb-3.jpg\",\"float_intro\":\"left\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/slider\\/slide-3.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 9, 1, '', '', 1, 15, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(164, 778, 'Steven Jackson', 'steven-jackson', '<p class=\"post\">Owner</p>\r\n\r\n', '\r\n<p>Steven co-founded BuildWall in 1990. Steven is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to his clients and to the production crews that he oversees. He is involved in every step of the process. Steven is known for his exceptional attention to organization</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Owner</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Steven co-founded BuildWall in 1990. Steven is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to his clients and to the production crews that he oversees. He is involved in every step of the process.</p>\r\n      <p>Steven is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Steven approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Steven acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:42:00', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-7.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-7.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 5, 7, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(165, 779, 'Andrew Edwards', 'andrew-edwards', '<p class=\"post\">Architect</p>\r\n\r\n', '\r\n<p>Andrew can create design of any complexity. He has 15 years of experience working in industrial design sphere..</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Architect</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Andrew can create design of any complexity. He has 15 years of experience working in industrial design sphere.. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Andrew is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Gary approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Andrew acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:42:30', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-8.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-8.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 8, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(166, 824, 'Karl Williams', 'karl-williams', '<p class=\"post\">Interior Designer</p>\r\n\r\n', '\r\n<p>Karl Williams began working with BuildWall in 2012. Karl is reliable and safety-oriented with over 10 years of experience.</p>\r\n<div class=\"team-content-wrap\">\r\n	<div class=\"post\">Interior Designer</div>\r\n	<div class=\"team-meta\">\r\n		<div class=\"team-meta-location\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-map-marker\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Address Info</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item location\">4578 Marmora Road, Glasgow</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-phone\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-telephone\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">Phones:</h5>\r\n			<span class=\"team-macros\">\r\n				<span class=\"team-meta_item phone\">+7-495-1234567; +7-495-1234568</span>\r\n			</span>\r\n		</div>\r\n		<div class=\"team-meta-email\">\r\n			<span class=\"team-icon\">\r\n				<i class=\"linearicons-envelope\"></i>\r\n			</span>\r\n			<h5 class=\"team-meta-title\">E-mail:</h5>\r\n			<span class=\"team-email\">\r\n				<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\r\n			</span>\r\n		</div>\r\n	</div>\r\n        <div class=\"team-socials\">\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.facebook.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-facebook\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://twitter.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-twitter\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.google.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-google\"></i>\r\n			</a>\r\n		</div>\r\n		<div class=\"team-socials_item\">\r\n			<a href=\"https://www.instagram.com\" class=\"team-socials_link\" rel=\"nofollow\">\r\n				<i class=\"fa fa-instagram\"></i>\r\n			</a>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class=\"post-content\">\r\n       <p>Karl Williams began working with BuildWall in 2012. Karl is reliable and safety-oriented with over 10 years of experience. He is also an amazing visualizer who creates the vas majority of our design-projects either for private residences and for commercial ones.</p>\r\n      <p>Karl is known for her exceptional attention to organization and her hands-on approach to management. With twelve years of experience behind him, Karl approaches every project ready to manage a workflow that is efficient, organized, and ultimately successful.</p>\r\n      <p>He is constantly discovering new solutions to issues that arise during the work process and is a dependable supervisor both to him clients and to the production crews that she oversees. Steven acts as a liaison between the production and design teams and the client throughout the entire process of every BuildWall project. Vicky is the eyes and ears of every project and is a trusted presence both to clients and to the architects, managers, and contractors who report to him.</p>\r\n</div>', 1, 26, '2018-06-25 16:06:04', 213, '', '2018-06-30 07:42:49', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/team\\/team-9.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/team\\/team-9.jpg\",\"float_fulltext\":\"left\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"theme3589:team\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 6, 9, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(167, 826, 'Do You Have any Questions?', 'do-you-have-any-questions', '<p>Submit a business inquiry online or visit the nearest office.</p>', '', 1, 43, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/questions.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(168, 829, 'Partner 1', 'partner-1', '<h5 class=\"item_title\">Project Management, Construction</h5>\r\n<h6 class=\"item_subtitle\">2016 revenues: $10.2 billion</h6>\r\n<p>Hytellux is a professional services firm providing engineering consultancy, design, planning, project management and consulting services for all aspects of buildings, infrastructure and the environment.</p>', '', 1, 73, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/partners\\/partner-01.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(169, 830, 'Partner 2', 'partner-2', '<h5 class=\"item_title\">Construction, Engineering</h5>\r\n<h6 class=\"item_subtitle\">2017 revenues: $6.5 billion</h6>\r\n<p>Berksho Construction is a Canadian multinational consultancy, engineering and project management company headquartered in Alberta, Canada. It is focused on the infrastructure markets and has offices in over 50 countries worldwide.</p>', '', 1, 73, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/partners\\/partner-02.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(170, 831, 'Partner 3', 'partner-3', '<h5 class=\"item_title\">Construction, Manufacturing, Plastic Products</h5>\r\n<h6 class=\"item_subtitle\">2016 revenues: $10.1 billion</h6>\r\n<p>Fatestar Group is a Pennsylvania corporation incorporated in 1891. It is an international designer and manufacturer of floors and ceilings. Based in Lancaster, Pennsylvania, Fatestar Group operates 32 plants in 8 countries.</p>', '', 1, 73, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/partners\\/partner-03.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(171, 832, 'Partner 4', 'partner-4', '<h5 class=\"item_title\">Project Management, Construction</h5>\r\n<h6 class=\"item_subtitle\">2016 revenues: $8.6 billion</h6>\r\n<p>TMT Corporation is the largest construction and civil engineering company in the United States, ranking as the 4th-largest privately owned company in the United States. Its headquarters are in the South of Market, San Francisco.</p>', '', 1, 73, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/partners\\/partner-04.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(172, 833, 'Partner 5', 'partner-5', '<h5 class=\"item_title\">Civil Engineering, Construction</h5>\r\n<h6 class=\"item_subtitle\">2016 revenues: $9.7 billion</h6>\r\n<p>Pigliri Pro is a global contracting and development company that designs, builds and maintains property and infrastructure assets. Headquartered in Cranbury, New Jersey, it works all over North America.</p>', '', 1, 73, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/partners\\/partner-05.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(173, 834, 'Partner 6', 'partner-6', '<h5 class=\"item_title\">Infrastructure, Civil Engineering</h5>\r\n<h6 class=\"item_subtitle\">2016 revenues: $5.2 billion</h6>\r\n<p>Fireball is a global design, engineering and management consulting company based in Toronto, Ontario, Canada. It has its origins in 1868. The company is a member of the Next 150 index.</p>', '', 1, 73, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/partners\\/partner-06.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(174, 837, 'Preconstruction planning', 'preconstruction-planning', '<p>You will have a meeting with one of our consultants and discuss all the details regarding your future project.</p>\r\n', '\r\n<div class=\"service-content\">\r\n  <h5>Service overview</h5>\r\n  <p>With experience in commercial contracting and professional industry practices, our consultants understand technical, business, regulatory and legal matters, allowing them to identify key issues quickly and find the best solutions for our clients. Our clients hire us to ensure that every aspect of their capital program or project is properly governed, well-executed and fully supported from beginning to end.</p>\r\n  <p>BuildWall Consulting draws on its breadth of international construction experience and knowledge to deliver the best outcome for our clients, wherever their projects may be located.</p>\r\n\r\n    <div class=\"row\">\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img1.jpg\" alt=\"\">\r\n      </div>\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img2.jpg\" alt=\"\">\r\n      </div>\r\n    </div>\r\n\r\n  <h5>Details</h5>\r\n  <p>Our professionals are industry leaders who understand technical, business, regulatory and legal matters and are seasoned in giving expert testimony. They represent top talent across disciplines, including engineers, architects, accountants, quantity surveyors, planning and scheduling specialists, cost engineers, project managers communications professionals.</p>\r\n  <table class=\"service-table\">\r\n    <tbody>\r\n      <tr>\r\n        <th>Construction Advisory</th>\r\n        <td>Defining the key construction issues</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Cost Analytics</th>\r\n        <td>Discussing preliminary estimate</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Risk Management</th>\r\n        <td>Eliminating possible risks</td>\r\n      </tr>\r\n     <tr>\r\n        <th>Planning &amp; Scheduling</th>\r\n        <td>Discussing future plan of work </td>\r\n      </tr>\r\n      <tr>\r\n        <th>Contract</th>\r\n        <td>Reading the contract</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h5>Our price list</h5>\r\n  {loadmodule mod_articles_news_adv, Services prices}\r\n  {loadmodule mod_bootstrap_collapse, Popular questions}\r\n</div>', 1, 74, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/services\\/service-thumb01.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/services\\/service01.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 5, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(175, 838, 'Building engineering', 'building-engineering', '<p>You will have a meeting with one of our consultants and discuss all the details regarding your future project.</p>\r\n', '\r\n<div class=\"service-content\">\r\n  <h5>Service overview</h5>\r\n  <p>With experience in commercial contracting and professional industry practices, our consultants understand technical, business, regulatory and legal matters, allowing them to identify key issues quickly and find the best solutions for our clients. Our clients hire us to ensure that every aspect of their capital program or project is properly governed, well-executed and fully supported from beginning to end.</p>\r\n  <p>BuildWall Consulting draws on its breadth of international construction experience and knowledge to deliver the best outcome for our clients, wherever their projects may be located.</p>\r\n\r\n    <div class=\"row\">\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img1.jpg\" alt=\"\">\r\n      </div>\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img2.jpg\" alt=\"\">\r\n      </div>\r\n    </div>\r\n\r\n  <h5>Details</h5>\r\n  <p>Our professionals are industry leaders who understand technical, business, regulatory and legal matters and are seasoned in giving expert testimony. They represent top talent across disciplines, including engineers, architects, accountants, quantity surveyors, planning and scheduling specialists, cost engineers, project managers communications professionals.</p>\r\n  <table class=\"service-table\">\r\n    <tbody>\r\n      <tr>\r\n        <th>Construction Advisory</th>\r\n        <td>Defining the key construction issues</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Cost Analytics</th>\r\n        <td>Discussing preliminary estimate</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Risk Management</th>\r\n        <td>Eliminating possible risks</td>\r\n      </tr>\r\n     <tr>\r\n        <th>Planning &amp; Scheduling</th>\r\n        <td>Discussing future plan of work </td>\r\n      </tr>\r\n      <tr>\r\n        <th>Contract</th>\r\n        <td>Reading the contract</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h5>Our price list</h5>\r\n  {loadmodule mod_articles_news_adv, Services prices}\r\n  {loadmodule mod_bootstrap_collapse, Popular questions}\r\n</div>\r\n', 1, 74, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/services\\/service-thumb02.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/services\\/service02.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(176, 839, 'Interior design', 'interior-design', '<p>You will have a meeting with one of our consultants and discuss all the details regarding your future project.</p>\r\n', '\r\n<div class=\"service-content\">\r\n  <h5>Service overview</h5>\r\n  <p>With experience in commercial contracting and professional industry practices, our consultants understand technical, business, regulatory and legal matters, allowing them to identify key issues quickly and find the best solutions for our clients. Our clients hire us to ensure that every aspect of their capital program or project is properly governed, well-executed and fully supported from beginning to end.</p>\r\n  <p>BuildWall Consulting draws on its breadth of international construction experience and knowledge to deliver the best outcome for our clients, wherever their projects may be located.</p>\r\n\r\n    <div class=\"row\">\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img1.jpg\" alt=\"\">\r\n      </div>\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img2.jpg\" alt=\"\">\r\n      </div>\r\n    </div>\r\n\r\n  <h5>Details</h5>\r\n  <p>Our professionals are industry leaders who understand technical, business, regulatory and legal matters and are seasoned in giving expert testimony. They represent top talent across disciplines, including engineers, architects, accountants, quantity surveyors, planning and scheduling specialists, cost engineers, project managers communications professionals.</p>\r\n  <table class=\"service-table\">\r\n    <tbody>\r\n      <tr>\r\n        <th>Construction Advisory</th>\r\n        <td>Defining the key construction issues</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Cost Analytics</th>\r\n        <td>Discussing preliminary estimate</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Risk Management</th>\r\n        <td>Eliminating possible risks</td>\r\n      </tr>\r\n     <tr>\r\n        <th>Planning &amp; Scheduling</th>\r\n        <td>Discussing future plan of work </td>\r\n      </tr>\r\n      <tr>\r\n        <th>Contract</th>\r\n        <td>Reading the contract</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h5>Our price list</h5>\r\n  {loadmodule mod_articles_news_adv, Services prices}\r\n  {loadmodule mod_bootstrap_collapse, Popular questions}\r\n</div>\r\n', 1, 74, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 213, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/services\\/service-thumb03.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/services\\/service03.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 3, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(177, 840, 'Architecture & building', 'architecture-building', '<p>You will have a meeting with one of our consultants and discuss all the details regarding your future project.</p>\r\n', '\r\n<div class=\"service-content\">\r\n  <h5>Service overview</h5>\r\n  <p>With experience in commercial contracting and professional industry practices, our consultants understand technical, business, regulatory and legal matters, allowing them to identify key issues quickly and find the best solutions for our clients. Our clients hire us to ensure that every aspect of their capital program or project is properly governed, well-executed and fully supported from beginning to end.</p>\r\n  <p>BuildWall Consulting draws on its breadth of international construction experience and knowledge to deliver the best outcome for our clients, wherever their projects may be located.</p>\r\n\r\n    <div class=\"row\">\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img1.jpg\" alt=\"\">\r\n      </div>\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img2.jpg\" alt=\"\">\r\n      </div>\r\n    </div>\r\n\r\n  <h5>Details</h5>\r\n  <p>Our professionals are industry leaders who understand technical, business, regulatory and legal matters and are seasoned in giving expert testimony. They represent top talent across disciplines, including engineers, architects, accountants, quantity surveyors, planning and scheduling specialists, cost engineers, project managers communications professionals.</p>\r\n  <table class=\"service-table\">\r\n    <tbody>\r\n      <tr>\r\n        <th>Construction Advisory</th>\r\n        <td>Defining the key construction issues</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Cost Analytics</th>\r\n        <td>Discussing preliminary estimate</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Risk Management</th>\r\n        <td>Eliminating possible risks</td>\r\n      </tr>\r\n     <tr>\r\n        <th>Planning &amp; Scheduling</th>\r\n        <td>Discussing future plan of work </td>\r\n      </tr>\r\n      <tr>\r\n        <th>Contract</th>\r\n        <td>Reading the contract</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h5>Our price list</h5>\r\n  {loadmodule mod_articles_news_adv, Services prices}\r\n  {loadmodule mod_bootstrap_collapse, Popular questions}\r\n</div>\r\n', 1, 74, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/services\\/service-thumb04.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/services\\/service04.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(178, 841, 'House renovation', 'house-renovation', '<p>You will have a meeting with one of our consultants and discuss all the details regarding your future project.</p>\r\n', '\r\n<div class=\"service-content\">\r\n  <h5>Service overview</h5>\r\n  <p>With experience in commercial contracting and professional industry practices, our consultants understand technical, business, regulatory and legal matters, allowing them to identify key issues quickly and find the best solutions for our clients. Our clients hire us to ensure that every aspect of their capital program or project is properly governed, well-executed and fully supported from beginning to end.</p>\r\n  <p>BuildWall Consulting draws on its breadth of international construction experience and knowledge to deliver the best outcome for our clients, wherever their projects may be located.</p>\r\n\r\n    <div class=\"row\">\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img1.jpg\" alt=\"\">\r\n      </div>\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img2.jpg\" alt=\"\">\r\n      </div>\r\n    </div>\r\n\r\n  <h5>Details</h5>\r\n  <p>Our professionals are industry leaders who understand technical, business, regulatory and legal matters and are seasoned in giving expert testimony. They represent top talent across disciplines, including engineers, architects, accountants, quantity surveyors, planning and scheduling specialists, cost engineers, project managers communications professionals.</p>\r\n  <table class=\"service-table\">\r\n    <tbody>\r\n      <tr>\r\n        <th>Construction Advisory</th>\r\n        <td>Defining the key construction issues</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Cost Analytics</th>\r\n        <td>Discussing preliminary estimate</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Risk Management</th>\r\n        <td>Eliminating possible risks</td>\r\n      </tr>\r\n     <tr>\r\n        <th>Planning &amp; Scheduling</th>\r\n        <td>Discussing future plan of work </td>\r\n      </tr>\r\n      <tr>\r\n        <th>Contract</th>\r\n        <td>Reading the contract</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h5>Our price list</h5>\r\n  {loadmodule mod_articles_news_adv, Services prices}\r\n  {loadmodule mod_bootstrap_collapse, Popular questions}\r\n</div>\r\n', 1, 74, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/services\\/service-thumb05.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/services\\/service05.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 1, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(179, 842, 'Construction Consultant', 'construction-consultant', '<p>You will have a meeting with one of our consultants and discuss all the details regarding your future project.</p>\r\n', '\r\n<div class=\"service-content\">\r\n  <h5>Service overview</h5>\r\n  <p>With experience in commercial contracting and professional industry practices, our consultants understand technical, business, regulatory and legal matters, allowing them to identify key issues quickly and find the best solutions for our clients. Our clients hire us to ensure that every aspect of their capital program or project is properly governed, well-executed and fully supported from beginning to end.</p>\r\n  <p>BuildWall Consulting draws on its breadth of international construction experience and knowledge to deliver the best outcome for our clients, wherever their projects may be located.</p>\r\n\r\n    <div class=\"row\">\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img1.jpg\" alt=\"\">\r\n      </div>\r\n      <div class=\"col-sm-6\">\r\n        <img src=\"images/elements_img2.jpg\" alt=\"\">\r\n      </div>\r\n    </div>\r\n\r\n  <h5>Details</h5>\r\n  <p>Our professionals are industry leaders who understand technical, business, regulatory and legal matters and are seasoned in giving expert testimony. They represent top talent across disciplines, including engineers, architects, accountants, quantity surveyors, planning and scheduling specialists, cost engineers, project managers communications professionals.</p>\r\n  <table class=\"service-table\">\r\n    <tbody>\r\n      <tr>\r\n        <th>Construction Advisory</th>\r\n        <td>Defining the key construction issues</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Cost Analytics</th>\r\n        <td>Discussing preliminary estimate</td>\r\n      </tr>\r\n      <tr>\r\n        <th>Risk Management</th>\r\n        <td>Eliminating possible risks</td>\r\n      </tr>\r\n     <tr>\r\n        <th>Planning &amp; Scheduling</th>\r\n        <td>Discussing future plan of work </td>\r\n      </tr>\r\n      <tr>\r\n        <th>Contract</th>\r\n        <td>Reading the contract</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <h5>Our price list</h5>\r\n  {loadmodule mod_articles_news_adv, Services prices}\r\n  {loadmodule mod_bootstrap_collapse, Popular questions}\r\n</div>\r\n', 1, 74, '2018-06-25 16:06:04', 213, '', '2018-06-25 16:06:04', 0, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/services\\/service-thumb06.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/services\\/service06.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(180, 850, 'Magical World of Art', 'magical-world-of-art', '<p><b>Welcome this magical world of art, masterpieces and amazing collections!</b></p>\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>\r\n', '\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>\r\n', 1, 2, '2018-06-28 10:20:41', 846, '', '2018-06-28 10:55:28', 846, 0, '0000-00-00 00:00:00', '2018-06-28 10:20:41', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"more info\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(181, 856, 'Meet Our Experts', 'meet-our-experts', '<p>Need an expert opinion? Our dedicated staff works to ensure that all the details of the artists\' representation are handled efficiently.</p>\r\n', '\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>', 1, 75, '2018-06-29 10:45:11', 846, '', '2018-06-29 10:45:11', 0, 0, '0000-00-00 00:00:00', '2018-06-29 10:45:11', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"linearicons linearicons-users2 \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(182, 857, 'Tour the Gallery', 'tour-the-gallery', '<p>The Gallery is located in the heart of New York City’s renowned Chelsea art district, home to some of the world’s most prestigious galleries.</p>\r\n', '\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>', 1, 75, '2018-06-29 10:45:11', 846, '', '2018-06-29 10:51:53', 846, 0, '0000-00-00 00:00:00', '2018-06-29 10:45:11', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"linearicons linearicons-picture2 \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(183, 858, 'Visitor Information', 'visitor-information', '<p>The Gallery showcases the variety and skill present in contemporary art – so be sure to visit us during your time in our city!</p>\r\n', '\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n<p>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide. We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>', 1, 75, '2018-06-29 10:45:11', 846, '', '2018-06-29 10:53:08', 846, 0, '0000-00-00 00:00:00', '2018-06-29 10:45:11', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"linearicons linearicons-document2 \",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(184, 859, 'exhibitions', 'peasant-scenes-and-landscapes', '<h1>Peasant Scenes and Landscapes</h1>\r\n<div class=\'list-1\'>\r\n    <ul class=\'list\'>\r\n        <li><i class=\"flinearicons linearicons-clock3 \"></i> 19 July - 19 August, 2018</li>\r\n        <li><i class=\"linearicons linearicons-map-marker \"></i>WEST, LONDON MUSEUM</li>\r\n    </ul>\r\n</div>\r\n<p>This exhibition was named after world-known book by Larry Silver, although there is no connection with the content. It’s fully devoted to gorgeous landscapes of North America depicted by the best US modern artists.</p>\r\n', '\r\n<p>This exhibition was named after world-known book by Larry Silver, although there is no connection with the content. It’s fully devoted to gorgeous landscapes of North America depicted by the best US modern artists.</p>\r\n<p>This exhibition was named after world-known book by Larry Silver, although there is no connection with the content. It’s fully devoted to gorgeous landscapes of North America depicted by the best US modern artists.</p>\r\n<p>This exhibition was named after world-known book by Larry Silver, although there is no connection with the content. It’s fully devoted to gorgeous landscapes of North America depicted by the best US modern artists.</p>', 1, 2, '2018-06-29 11:51:19', 846, '', '2018-06-29 12:15:01', 846, 0, '0000-00-00 00:00:00', '2018-06-29 11:51:19', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/home\\/page1_img2.jpg\",\"float_intro\":\"right\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/home\\/page1_img2.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"more info\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 7, 1, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(185, 863, 'Etching Demonstration', 'etching-demonstration', '<p>Meet the renowned artists during their demonstrations on September 4th through 7th...</p>\r\n', '\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>\r\n\r\n<p>Recent years have showed a great rise of Bernard\'s paintings popularity among young people and businessmen. \"It is not a coincidence\", says Jessica McMillan, James Bernard\'s manager. \"Today people want to experience a wide range of emotions when they look at the painting of an artist. James knows what modern lovers of art need, and he expresses it through his innovative and captivating artworks.\"</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 49, '2018-06-25 16:06:04', 213, '', '2018-06-29 14:30:36', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb9.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img9.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(186, 865, 'Miniature Art Show', 'miniature-art-show', '<p>Visit the world\'s most original Miniature Art Show that will take place in our art gallery...</p>\r\n', '\r\n<p>James R. Bernard is famous for his unique style of paintings that comprises elements of contemporary and abstract art as well as photography and computer graphics. This approach allows him to transfer images of the surrounding world into canvas preserving the original idea of the author. In one of his latest interviews, James said that the atmosphere of sunny weather and friendly people had always attracted him and had been a great source of inspiration for a lot of his widely known artworks, it was not a surprise that the exhibition of his school\'s artworks would take place in this great city.</p>\r\n\r\n<p>Recent years have showed a great rise of Bernard\'s paintings popularity among young people and businessmen. \"It is not a coincidence\", says Jessica McMillan, James Bernard\'s manager. \"Today people want to experience a wide range of emotions when they look at the painting of an artist. James knows what modern lovers of art need, and he expresses it through his innovative and captivating artworks.\"</p>\r\n\r\n<div class=\"video_frame\" style=\"padding-top: 56%\"><iframe src=\"http://www.youtube.com/embed/Ok2VamxrYAY?rel=0&amp;controls=0&amp;showinfo=0&amp;wmode=transparent\" allowfullscreen>&nbsp;</iframe></div>', 1, 49, '2018-06-25 16:06:04', 213, '', '2018-06-29 14:31:45', 846, 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog-thumb3.jpg\",\"float_intro\":\"none\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-img10.jpg\",\"float_fulltext\":\"none\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(187, 868, 'We Are ARTESMA', 'we-are-artesma', '<p><b>It is our mission to make it easy for you to discover and collect fine art from renowned artists, galleries, and cultural institutions worldwide.  </b></p>\r\n<p>We celebrate creativity, openness, tolerance, and generosity. We aim to be inclusive places—both onsite and online—where diverse cultural, artistic, social, and political positions are welcome. We’re committed to sharing the most thought-provoking modern and contemporary art, and hope you will join us in exploring the art, ideas, and issues of our time.</p>\r\n', '\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>\r\n<p>Our Gallery was established by Helen Stone to provide opportunities to artists entering the global art market. Ms. Stone was a visionary who founded the gallery on the principle that all artists benefit from having their artwork promoted by a professional gallery. </p>', 1, 2, '2018-06-28 10:20:41', 846, '', '2018-06-29 16:15:20', 846, 0, '0000-00-00 00:00:00', '2018-06-28 10:20:41', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/about\\/page2_img1.jpg\",\"float_intro\":\"right\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/about\\/page2_img1.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"more info\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 5, 0, '', '', 1, 6, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(188, 871, 'Years of Experience', 'years-of-experience', '<p>Our gallery was established in 2002 to display masterpieces from all over the world.</p>', '', 1, 76, '2018-06-29 16:41:32', 846, '', '2018-06-29 16:41:54', 846, 0, '0000-00-00 00:00:00', '2018-06-29 16:41:32', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"15\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(189, 872, ' Famous Artists', 'famous-artists', '<p>We have gathered the greatest artworks of 20th century.</p>', '', 1, 76, '2018-06-29 16:41:32', 846, '', '2018-06-29 16:42:46', 846, 0, '0000-00-00 00:00:00', '2018-06-29 16:41:32', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"34\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(190, 873, ' Successful Exhibitions', 'successful-exhibitions', '<p>Amazing collections of modern and experimental art, abstract and portrait art  was represented in our gallery.</p>', '', 1, 76, '2018-06-29 16:41:32', 846, '', '2018-06-29 16:43:23', 846, 0, '0000-00-00 00:00:00', '2018-06-29 16:41:32', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"89\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(191, 874, 'Current Exhibitions', 'current-exhibitions', '<p>We have a selection of thousands of artworks from some of the best names in contemporary fine art.</p>', '', 1, 76, '2018-06-29 16:41:32', 846, '', '2018-06-30 06:46:12', 846, 0, '0000-00-00 00:00:00', '2018-06-29 16:41:32', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"25\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 3, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 1, 11, 7, '2018-06-25 16:06:04', 1),
('com_content.article', 1, 11, 17, '2018-06-25 16:06:04', 1),
('com_content.article', 5, 12, 9, '2018-06-25 16:06:04', 1),
('com_content.article', 5, 12, 10, '2018-06-25 16:06:04', 1),
('com_content.article', 4, 13, 3, '2018-06-25 16:06:04', 1),
('com_content.article', 4, 13, 8, '2018-06-25 16:06:04', 1),
('com_content.article', 6, 14, 11, '2018-06-29 13:25:33', 1),
('com_content.article', 6, 14, 12, '2018-06-29 13:25:33', 1),
('com_content.article', 8, 15, 15, '2018-06-25 16:06:04', 1),
('com_content.article', 8, 15, 16, '2018-06-25 16:06:04', 1),
('com_content.article', 9, 118, 7, '2018-06-25 16:06:04', 1),
('com_content.article', 9, 118, 17, '2018-06-25 16:06:04', 1),
('com_content.article', 10, 119, 4, '2018-06-25 16:06:04', 1),
('com_content.article', 10, 119, 14, '2018-06-25 16:06:04', 1),
('com_content.article', 11, 120, 3, '2018-06-25 16:06:04', 1),
('com_content.article', 11, 120, 5, '2018-06-25 16:06:04', 1),
('com_content.article', 11, 120, 6, '2018-06-25 16:06:04', 1),
('com_content.article', 12, 185, 11, '2018-06-29 14:30:36', 1),
('com_content.article', 12, 185, 12, '2018-06-29 14:30:36', 1),
('com_content.article', 13, 186, 11, '2018-06-29 14:31:45', 1),
('com_content.article', 13, 186, 12, '2018-06-29 14:31:45', 1);

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(75, 2),
(88, 1);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{}}', 'WeblinksHelperRoute::getWeblinkRoute', '{\"formFile\":\"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"featured\",\"images\"], \"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(3, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(5, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'WeblinksHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(11, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(12, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(13, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(14, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(15, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10243 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"0\",\"history_limit\":5}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"0\",\"history_limit\":5,\"show_contact_list\":\"1\",\"presentation_style\":\"plain\",\"show_name\":\"0\",\"show_position\":\"0\",\"show_email\":\"0\",\"show_street_address\":\"0\",\"show_suburb\":\"0\",\"show_state\":\"0\",\"show_postcode\":\"0\",\"show_country\":\"0\",\"show_telephone\":\"0\",\"show_mobile\":\"0\",\"show_fax\":\"0\",\"show_webpage\":\"0\",\"show_misc\":\"1\",\"show_image\":\"0\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_tags\":\"1\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"1\",\"show_fax_headings\":\"1\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"0\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 0, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"target\":\"0\",\"save_history\":\"0\",\"history_limit\":5,\"count_clicks\":\"1\",\"icons\":1,\"link_icons\":\"\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_num_links\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_links_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"0\",\"show_link_description\":\"1\",\"show_link_hits\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"0\",\"history_limit\":10,\"show_urls_images_frontend\":\"1\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"none\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"0\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"0\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"0\",\"maxLevelcat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"0\",\"show_cat_num_articles_cat\":\"0\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"4\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"-1\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"order\",\"order_date\":\"published\",\"show_pagination\":\"0\",\"show_pagination_results\":\"0\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"custom_fields_enable\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"0\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"0\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"1\",\"tag_list_show_tag_description\":\"1\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"0\",\"tag_list_orderby\":\"c.core_title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"1\",\"tag_list_show_date\":\"published\",\"tag_list_show_item_image\":\"1\",\"tag_list_show_item_description\":\"1\",\"tag_list_item_maximum_characters\":10000,\"min_term_length\":\"3\",\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"publish_up\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"1\",\"all_tags_show_tag_descripion\":\"1\",\"all_tags_tag_maximum_characters\":10000,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"0\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', 1, 1, 1, 1, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', 1, 1, 1, 1, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 0, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, 'false', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 0, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{\"name\":\"SimplePie\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"SimplePie\",\"copyright\":\"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/simplepie.org\\/\",\"version\":\"1.2\",\"description\":\"LIB_SIMPLEPIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"simplepie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"69edebc11a4c714c2d211ace8965238d\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 0, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.40.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2018\",\"author\":\"Ephox Corporation\",\"copyright\":\"Ephox Corporation\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"http:\\/\\/www.tinymce.com\",\"version\":\"4.5.9\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 0, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 21, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 13, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', '', 0, '0000-00-00 00:00:00', 14, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', '', 0, '0000-00-00 00:00:00', 17, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', '', 0, '0000-00-00 00:00:00', 18, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', '', 0, '0000-00-00 00:00:00', 12, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"strong_passwords\":\"1\",\"autoregister\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"version\":\"1.0\",\"public_key\":\" \",\"private_key\":\" \",\"theme\":\"clean\",\"theme2\":\"light\",\"size\":\"normal\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', '', 0, '0000-00-00 00:00:00', 16, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 0, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '{\"section\":\"3\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '{\"section\":\"3\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(481, 0, 'plg_fields_repeatable', 'plugin', 'repeatable', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_repeatable\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"repeatable\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(483, 0, 'PLG_SYSTEM_ACTIONLOGS', 'plugin', 'actionlogs', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_ACTIONLOGS\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(484, 0, 'PLG_ACTIONLOG_JOOMLA', 'plugin', 'joomla', 'actionlog', 0, 1, 1, 0, '{\"name\":\"PLG_ACTIONLOG_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1549559004}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(487, 0, 'plg_privacy_user', 'plugin', 'user', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(489, 0, 'plg_user_terms', 'plugin', 'terms', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(491, 0, 'plg_privacy_content', 'plugin', 'content', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(492, 0, 'plg_privacy_message', 'plugin', 'message', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 0, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"February 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.3\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 0, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"February 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.3\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"February 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.3\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"February 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.3.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 0, 'mod_articles_single', 'module', 'mod_articles_single', '', 0, 1, 0, 0, '{\"name\":\"mod_articles_single\",\"type\":\"module\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.2.2\",\"description\":\"MOD_ARTICLES_SINGLE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"item_heading\":\"h4\",\"item_title\":\"0\",\"published_on\":\"0\",\"show_intro_image\":\"1\",\"readmore\":\"0\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 0, 'mod_articles_news_adv', 'module', 'mod_articles_news_adv', '', 0, 1, 0, 0, '{\"name\":\"mod_articles_news_adv\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (c) 2012-2014 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.5.5\",\"description\":\"MOD_ARTICLES_NEWS_ADV_XML_DESCRIPTION\",\"group\":\"\"}', '{\"catid\":\"\",\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"5\",\"columns\":\"1\",\"ordering\":\"a.publish_up\",\"article_ordering_direction\":\"DESC\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"item_title\":\"0\",\"item_heading\":\"h4\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"masonry\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10011, 0, 'mod_tm_templates', 'module', 'mod_tm_templates', '', 1, 1, 2, 0, '{\"name\":\"mod_tm_templates\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"MOD_TM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10013, 0, 'Content - TM AddThis', 'plugin', 'tmaddthis', 'content', 0, 1, 1, 0, '{\"name\":\"Content - TM AddThis\",\"type\":\"plugin\",\"creationDate\":\"April 2013\",\"author\":\"TM\",\"copyright\":\"Copyright (C) 2012 All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0.8\",\"description\":\"AddThis content plugin\",\"group\":\"\"}', '{\"addthis_id\":\"ra-5497f2254123130b\",\"addthis_categories\":[\"2\",\"10\",\"29\",\"62\"]}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10014, 0, 'bundle', 'package', 'pkg_bundle', '', 0, 1, 1, 0, '{\"name\":\"bundle\",\"type\":\"package\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.6.5\",\"description\":\"\\n\\t\\t\\n\\t\\t\\t<p>This package installs the following Joomla extensions:<\\/p>\\n\\t\\t\\t<ul>\\n\\t\\t\\t\\t<li>Module Articles Single<\\/li>\\n\\t\\t\\t\\t<li>Module Newsflash Advanced<\\/li>\\n\\t\\t\\t\\t<li>Module Image Swoop<\\/li>\\n\\t\\t\\t\\t<li>Module Superfish Menu<\\/li>\\n\\t\\t\\t\\t<li>Plugin Google Map<\\/li>\\n\\t\\t\\t\\t<li>Plugin AddThis<\\/li>\\n\\t\\t\\t\\t<li>Module CarouFredSel<\\/li>\\n\\t\\t\\t\\t<li>Module Recent templates (admin panel)<\\/li>\\n\\t\\t\\t<\\/ul>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 10020, 'plg_system_kunena', 'plugin', 'kunena', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SYSTEM_KUNENA_DESC\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"jcontentevents\":\"0\",\"jcontentevent_target\":\"body\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10016, 10020, 'plg_quickicon_kunena', 'plugin', 'kunena', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_QUICKICON_KUNENA_DESC\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"context\":\"mod_quickicon\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10018, 10020, 'Kunena Media Files', 'file', 'kunena_media', '', 0, 1, 0, 0, '{\"name\":\"Kunena Media Files\",\"type\":\"file\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"Kunena media files.\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10019, 10020, 'com_kunena', 'component', 'com_kunena', '', 1, 1, 0, 0, '{\"name\":\"com_kunena\",\"type\":\"component\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"COM_KUNENA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 0, 'Kunena Forum Package', 'package', 'pkg_kunena', '', 0, 1, 1, 0, '{\"name\":\"Kunena Forum Package\",\"type\":\"package\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"Kunena Forum Package.\",\"group\":\"\",\"filename\":\"pkg_kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'plg_kunena_community', 'plugin', 'community', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_community\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_COMMUNITY_DESCRIPTION\",\"group\":\"\",\"filename\":\"community\"}', '{\"access\":\"1\",\"login\":\"1\",\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"private\":\"1\",\"activity_points_limit\":\"0\",\"activity_stream_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10023, 0, 'plg_kunena_comprofiler', 'plugin', 'comprofiler', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_comprofiler\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_COMPROFILER_DESCRIPTION\",\"group\":\"\",\"filename\":\"comprofiler\"}', '{\"access\":\"1\",\"login\":\"1\",\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"private\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10024, 0, 'plg_kunena_gravatar', 'plugin', 'gravatar', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_gravatar\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_GRAVATAR_DESCRIPTION\",\"group\":\"\",\"filename\":\"gravatar\"}', '{\"avatar\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10025, 0, 'plg_kunena_uddeim', 'plugin', 'uddeim', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_uddeim\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_UDDEIM_DESCRIPTION\",\"group\":\"\",\"filename\":\"uddeim\"}', '{\"private\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10026, 0, 'plg_kunena_kunena', 'plugin', 'kunena', 'kunena', 0, 1, 1, 0, '{\"name\":\"plg_kunena_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_KUNENA_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"avatar\":\"1\",\"profile\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10027, 0, 'plg_kunena_joomla', 'plugin', 'joomla', 'kunena', 0, 1, 1, 0, '{\"name\":\"plg_kunena_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_JOOMLA_25_30_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"access\":\"1\",\"login\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10032, 0, 'JoomGallery', 'component', 'com_joomgallery', '', 1, 1, 0, 0, '{\"name\":\"JoomGallery\",\"type\":\"component\",\"creationDate\":\"2018\\/01\\/21\",\"author\":\"JoomGallery::ProjectTeam\",\"copyright\":\"This component is released under the GNU\\/GPL License\",\"authorEmail\":\"team@joomgallery.net\",\"authorUrl\":\"http:\\/\\/www.joomgallery.net\",\"version\":\"3.3.4\",\"description\":\"JoomGallery 3 is a native Joomla! 3.x gallery component\",\"group\":\"\",\"filename\":\"joomgallery\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 0, 'PLG_JOOMGALLERY_JOOMFANCYBOX', 'plugin', 'joomfancybox', 'joomgallery', 0, 1, 1, 0, '{\"name\":\"PLG_JOOMGALLERY_JOOMFANCYBOX\",\"type\":\"plugin\",\"creationDate\":\"20.01.2013\",\"author\":\"fabrice jossa\",\"copyright\":\"Copyright (C) 2013 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"team@joomgallery.net\",\"authorUrl\":\"http:\\/\\/www.en.joomgallery.net\",\"version\":\"1.1\",\"description\":\"PLG_JOOMGALLERY_JOOMFANCYBOX_XML_DESCRIPTION\",\"group\":\"\"}', '{\"global_box_existent\":\"1\",\"mousewheel\":\"0\",\"buttons\":\"0\",\"thumbs\":\"0\",\"init_script\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 0, 'system - EUCookieDirectiveLite', 'plugin', 'EUCookieDirectiveLite', 'system', 0, 0, 1, 0, '{\"name\":\"system - EUCookieDirectiveLite\",\"type\":\"plugin\",\"creationDate\":\"2013-11-19\",\"author\":\"Channel Digital.\",\"copyright\":\"All rights reserved by channeldigital.co.uk 2013.\",\"authorEmail\":\"info@channeldigital.co.uk\",\"authorUrl\":\"www.channeldigital.co.uk\",\"version\":\"1.1.1\",\"description\":\"Displays a cookie acceptance banner at the top of the site to warn about the site using cookies.\",\"group\":\"\"}', '{\"width\":\"0\",\"warningMessage\":\"We use cookies to improve our website and your experience when using it. Cookies used for the essential operation of this site have already been set. To find out more about the cookies we use and how to delete them, see our privacy policy.\\r\\nBy clicking \\\"Agree\\\" button, you accept cookies from this site and you give permission to use your personal data within the EU\'s General Data Protection Regulation (GDPR)\",\"detailsUrl\":\"index.php\"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10044, 0, 'TM Ajax Contact Form', 'module', 'mod_tm_ajax_contact_form', '', 0, 1, 0, 0, '{\"name\":\"TM Ajax Contact Form\",\"type\":\"module\",\"creationDate\":\"August ,2014\",\"author\":\"TemplateMonster\",\"copyright\":\"Copyright (c) 2012-2014 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"MOD_TM_AJAX_CONTACT_FORM_XML_DESCRIPTION\",\"group\":\"\"}', '{\"email_req\":\"required\",\"phone_req\":\"required\",\"admin_email\":\"\",\"cc_email\":\"\",\"bcc_email\":\"\",\"success_notify\":\"Thank You! Your message has been sent.\",\"failure_notify\":\"Something went wrong, please try again later.\",\"recaptcha_failure_notify\":\"Please enter a correct Captcha answer.\",\"msg_minlength\":\"0\",\"errors_position\":\"right-top\",\"captcha_req\":\"0\",\"public_key\":\"\",\"private_key\":\"\",\"captcha_theme\":\"red\",\"email_publish\":\"1\",\"phone_publish\":\"1\",\"subject_publish\":\"1\",\"subject_type\":\"1\",\"reset_publish\":\"1\",\"name_name\":\"Name\",\"email_name\":\"Email\",\"phone_name\":\"Phone\",\"subject_name\":\"Subject\",\"message_name\":\"Message\",\"br_name\":\"Clear\",\"bs_name\":\"Send\",\"labels_pos\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10065, 0, 'Bootstrap Collapse', 'module', 'mod_bootstrap_collapse', '', 0, 1, 0, 0, '{\"name\":\"Bootstrap Collapse\",\"type\":\"module\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (c) 2012-20013 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"MOD_BOOTSTRAP_COLLAPSE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"catid\":\"\",\"count\":\"5\",\"ordering\":\"a.publish_up\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10066, 0, 'Bootstrap Tabs', 'module', 'mod_bootstraptabs', '', 0, 1, 0, 0, '{\"name\":\"Bootstrap Tabs\",\"type\":\"module\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (c) 2012-20013 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.2\",\"description\":\"MOD_BOOTSTRAPTABS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"catid\":\"\",\"count\":\"5\",\"ordering\":\"a.publish_up\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10067, 0, 'Content - Komento', 'plugin', 'komento', 'content', 0, 1, 1, 0, '{\"name\":\"Content - Komento\",\"type\":\"plugin\",\"creationDate\":\"01\\/01\\/2012\",\"author\":\"StackIdeas\",\"copyright\":\"Copyright (C) 2012 StackIdeas. All rights reserved.\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/www.stackideas.com\",\"version\":\"1.0\",\"description\":\"This plugin adds a discussion\\/comment interface at the bottom of the article\",\"group\":\"\",\"filename\":\"komento\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10068, 0, 'System - Komento', 'plugin', 'komento', 'system', 0, 1, 1, 0, '{\"name\":\"System - Komento\",\"type\":\"plugin\",\"creationDate\":\"07\\/01\\/2012\",\"author\":\"StackIdeas\",\"copyright\":\"Copyright (C) 2012 StackIdeas. All rights reserved.\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/www.stackideas.com\",\"version\":\"1.0\",\"description\":\"This plugin adds a discussion\\/comment interface at the bottom of the article\",\"group\":\"\",\"filename\":\"komento\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10069, 0, 'User - Komento Users', 'plugin', 'komentousers', 'user', 0, 1, 1, 0, '{\"name\":\"User - Komento Users\",\"type\":\"plugin\",\"creationDate\":\"February 2012\",\"author\":\"StackIdeas\",\"copyright\":\"Copyright 2012 StackIdeas. All rights reserved.\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/www.stackideas.com\",\"version\":\"1.0.0\",\"description\":\"Komento user plugin. This plugin is responsible to delete user\'s related records.\",\"group\":\"\",\"filename\":\"komentousers\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10070, 0, 'Komento Activities', 'module', 'mod_komento_activities', '', 0, 1, 0, 0, '{\"name\":\"Komento Activities\",\"type\":\"module\",\"creationDate\":\"May 2012\",\"author\":\"StackIdeas\",\"copyright\":\"Copyright 2009 - 2012 Stack Ideas. All rights reserved.\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/www.stackideas.com\",\"version\":\"1.0.4\",\"description\":\"Display activities from Komento\",\"group\":\"\",\"filename\":\"mod_komento_activities\"}', '{\"limit\":\"5\",\"component\":\"all\",\"includelikes\":\"1\",\"includecomments\":\"1\",\"includereplies\":\"1\",\"showcomment\":\"1\",\"maxcommentlength\":\"100\",\"maxtitlelength\":\"30\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10071, 0, 'Komento Comments', 'module', 'mod_komento_comments', '', 0, 1, 0, 0, '{\"name\":\"Komento Comments\",\"type\":\"module\",\"creationDate\":\"May 2012\",\"author\":\"StackIdeas\",\"copyright\":\"Copyright 2009 - 2012 Stack Ideas. All rights reserved.\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/www.stackideas.com\",\"version\":\"1.0.7\",\"description\":\"Display comments from Komento\",\"group\":\"\",\"filename\":\"mod_komento_comments\"}', '{\"limit\":\"5\",\"component\":\"all\",\"category\":\"\",\"sort\":\"latest\",\"random\":\"0\",\"filtersticked\":\"0\",\"showtitle\":\"1\",\"showcomponent\":\"1\",\"showavatar\":\"1\",\"showauthor\":\"1\",\"maxcommentlength\":\"100\",\"maxtitlelength\":\"30\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10072, 0, 'com_komento', 'component', 'com_komento', '', 1, 1, 0, 0, '{\"name\":\"com_komento\",\"type\":\"component\",\"creationDate\":\"Jan 2012\",\"author\":\"Stack Ideas\",\"copyright\":\"Copyright 2012 Stack Ideas. All rights reserved\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/www.stackideas.com\",\"version\":\"2.0.4\",\"description\":\"\\n\\t\\tKomento is a Joomla! comment component.\\n\\t\",\"group\":\"\",\"filename\":\"komento\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10103, 0, 'plg_system_tmwrapper', 'plugin', 'tmwrapper', 'system', 0, 1, 1, 0, '{\"name\":\"TM Wrapper\",\"type\":\"plugin\",\"creationDate\":\"2015-05-29\",\"author\":\"Template Monster\",\"copyright\":\"Copyright 2014 Template Monster. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0.0\",\"description\":\"PLG_TMWRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tmwrapper\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10120, 0, 'mod_owl_carousel', 'module', 'mod_owl_carousel', '', 0, 1, 1, 0, '{\"name\":\"mod_owl_carousel\",\"type\":\"module\",\"creationDate\":\"February 2016\",\"author\":\"TemplateMonster\",\"copyright\":\"Copyright (c) 2012-2016 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"MOD_OWL_CAROUSEL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_owl_carousel\"}', '{\"catid\":\"\",\"image\":\"0\",\"item_title\":\"0\",\"published\":\"0\",\"item_heading\":\"h4\",\"show_tags\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"readmore\":\"0\",\"count\":\"5\",\"ordering\":\"a.publish_up\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"theme\":\"0\",\"script\":\"0\",\"items\":\"4\",\"autoplay\":\"1\",\"autoplay_speed\":\"5000\",\"scene_padding_0\":\"50\",\"items_padding_0\":\"50\",\"use_responsive\":\"1\",\"scene_padding_1200\":\"50\",\"items_padding_1200\":\"50\",\"scene_padding_992\":\"50\",\"items_padding_992\":\"50\",\"scene_padding_768\":\"50\",\"items_padding_768\":\"50\",\"scene_padding_480\":\"50\",\"items_padding_480\":\"50\",\"navigation\":\"1\",\"pagination\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10122, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 0, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10123, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"interval\":\"12\",\"mode\":\"1\",\"lastrun\":\"\",\"debug\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10124, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"email\":\"\",\"language_override\":\"\",\"lastrun\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10125, 0, 'System - Form XML Override', 'plugin', 'form_xml_override', 'system', 0, 1, 1, 0, '{\"name\":\"System - Form XML Override\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"iCueProject, Randy Carey\",\"copyright\":\"(C) 2013-2014 Randy Carey, iCue Project. All rights reserved.\",\"authorEmail\":\"support@iCueProject.com\",\"authorUrl\":\"http:\\/\\/iCueProject.com\",\"version\":\"1.0.1\",\"description\":\"PLG_FORM_XML_OVERRIDE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"form_xml_override\"}', '{\"admin_com_name\":\"com_modules\",\"site_com_name\":\"\",\"slash_dir\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10138, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10139, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10140, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10143, 10163, 'com_slogin', 'component', 'com_slogin', '', 1, 1, 0, 0, '{\"name\":\"com_slogin\",\"type\":\"component\",\"creationDate\":\"13.03.2018\",\"author\":\"SmokerMan, Arkadiy, Joomline\",\"copyright\":\"\\u00a9 2012-2018. All rights reserved.\",\"authorEmail\":\"sale@joomline.ru\",\"authorUrl\":\"\",\"version\":\"2.7.2\",\"description\":\"COM_SLOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"slogin\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10144, 10163, 'mod_slogin', 'module', 'mod_slogin', '', 0, 1, 0, 0, '{\"name\":\"mod_slogin\",\"type\":\"module\",\"creationDate\":\"02.03.2018\",\"author\":\"SmokerMan, Arkadiy, Joomline\",\"copyright\":\"\\u00a9 2012-2018. All rights reserved.\",\"authorEmail\":\"sale@joomline.ru\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"2.4.0\\t\",\"description\":\"MOD_SLOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_slogin\"}', '{\"slogin_link_profile\":\"1\",\"slogin_link_auch_edit\":\"1\",\"cache\":\"0\",\"load_css\":\"0\",\"load_js\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10147, 10163, 'Social Login', 'plugin', 'slogin', 'user', 0, 1, 1, 0, '{\"name\":\"Social Login\",\"type\":\"plugin\",\"creationDate\":\"21.09.2012\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.0\",\"description\":\"Delete User info from slogin table\",\"group\":\"\",\"filename\":\"slogin\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10148, 10163, 'Plugin profile Slogin', 'plugin', 'profile', 'slogin_integration', 0, 1, 1, 0, '{\"name\":\"Plugin profile Slogin\",\"type\":\"plugin\",\"creationDate\":\"20.11.2014\",\"author\":\"Arkadiy Sedelnikov, Joomline\",\"copyright\":\"(C) 2012. All rights reserved.\",\"authorEmail\":\"a.sedelnikov@gmail.com\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.0.2\",\"description\":\"PLG_SLOGIN_PROFILE_DESC\",\"group\":\"\",\"filename\":\"profile\"}', '{\"rootfolder\":\"images\\/avatar\",\"img_quality\":\"80\",\"imgparam\":\"150\",\"updatetime\":\"86400\",\"enable_geo\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10149, 10163, 'Social Login Facebook auth', 'plugin', 'facebook', 'slogin_auth', 0, 1, 1, 0, '{\"name\":\"Social Login Facebook auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Facebook auth\",\"group\":\"\",\"filename\":\"facebook\"}', '{\"id\":\"1770184923308057\",\"password\":\"acb935bae3641b597d3bdd8dafc5530d\",\"callback_url\":null}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10150, 10163, 'Social Login Google auth', 'plugin', 'google', 'slogin_auth', 0, 1, 1, 0, '{\"name\":\"Social Login Google auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Google auth\",\"group\":\"\",\"filename\":\"google\"}', '{\"id\":\"4ea43331a8b16c6ddb33685fc03635a8\",\"password\":\"Apmhll5UyD-Llm7-FJRsbWuP\",\"callback_url\":null}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10151, 10163, 'Social Login mail.ru auth', 'plugin', 'mail', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login mail.ru auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"mail.ru auth\",\"group\":\"\",\"filename\":\"mail\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10152, 10163, 'Social Login Odnoklassniki auth', 'plugin', 'odnoklassniki', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Odnoklassniki auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Odnoklassniki auth\",\"group\":\"\",\"filename\":\"odnoklassniki\"}', '{\"id\":\"\",\"password\":\"\",\"public_key\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10153, 10163, 'Social Login Twitter auth', 'plugin', 'twitter', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Twitter auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Twitter auth\",\"group\":\"\",\"filename\":\"twitter\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10154, 10163, 'Social Login Vkontakte auth', 'plugin', 'vkontakte', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Vkontakte auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.3.0\",\"description\":\"Vkontakte auth\",\"group\":\"\",\"filename\":\"vkontakte\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10155, 10163, 'Social Login Yandex auth', 'plugin', 'yandex', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Yandex auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Yandex auth. Instructions for setting up the plugin: http:\\/\\/joomline.ru\\/stati\\/53-komponenty\\/306-sozdanie-prilozhenij-dlja-socialnoj-avtoriziacii.html\",\"group\":\"\",\"filename\":\"yandex\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10156, 10163, 'Social Login LinkedIn auth', 'plugin', 'linkedin', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login LinkedIn auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"LinkedIn auth\",\"group\":\"\",\"filename\":\"linkedin\"}', '{\"api_key\":\"\",\"secret_key\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10157, 10163, 'Social Login Ulogin auth', 'plugin', 'ulogin', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Ulogin auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Ulogin auth. Instructions for setting up the plugin: http:\\/\\/joomline.ru\\/stati\\/53-komponenty\\/306-sozdanie-prilozhenij-dlja-socialnoj-avtoriziacii.html\",\"group\":\"\",\"filename\":\"ulogin\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10158, 10163, 'Social Login Live.com auth', 'plugin', 'live', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Live.com auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Live.com auth\",\"group\":\"\",\"filename\":\"live\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10159, 10163, 'Social Login Yahoo auth', 'plugin', 'yahoo', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Yahoo auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Yahoo auth\",\"group\":\"\",\"filename\":\"yahoo\"}', '{\"key\":\"\",\"secret\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10160, 10163, 'Social Login Wordpress auth', 'plugin', 'wordpress', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Wordpress auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Wordpress auth\",\"group\":\"\",\"filename\":\"wordpress\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10161, 10163, 'Social Login Instagram auth', 'plugin', 'instagram', 'slogin_auth', 0, 0, 1, 0, '{\"name\":\"Social Login Instagram auth\",\"type\":\"plugin\",\"creationDate\":\"26.05.2017\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012-2017. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.2.0\",\"description\":\"Instagram auth\",\"group\":\"\",\"filename\":\"instagram\"}', '{\"id\":\"\",\"password\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10162, 10163, 'Social Login Auth', 'plugin', 'slogin', 'authentication', 0, 1, 1, 0, '{\"name\":\"Social Login Auth\",\"type\":\"plugin\",\"creationDate\":\"21.09.2012\",\"author\":\"Arkadiy, Joomline\",\"copyright\":\"(C) 2012. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.0\",\"description\":\"Authenticate User on SLogin data\",\"group\":\"\",\"filename\":\"slogin\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10163, 0, 'Pkg Slogin', 'package', 'pkg_slogin', '', 0, 1, 1, 0, '{\"name\":\"Pkg Slogin\",\"type\":\"package\",\"creationDate\":\"13.03.2018\",\"author\":\"SmokerMan, Arkadiy, Joomline\",\"copyright\":\"\\u00a9 2012 - 2018. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.7.2\",\"description\":\"Packet authentication via social networking joomla. The package: plugin, module, component. After installing the plugin activate Social Login.<iframe frameborder=\'0\' allowtransparency=\'true\' scrolling=\'no\' src=\'https:\\/\\/joomline.ru\\/donateen.html\' width=\'100%\' height=\'700\'>\",\"group\":\"\",\"filename\":\"pkg_slogin\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10164, 10193, 'T3 Framework', 'plugin', 't3', 'system', 0, 1, 1, 0, '{\"name\":\"T3 Framework\",\"type\":\"plugin\",\"creationDate\":\"May 04, 2018\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"info@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"2.7.1\",\"description\":\"\\n\\t\\n\\t<div align=\\\"center\\\">\\n\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2018 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"t3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10167, 0, 'theme3589', 'template', 'theme3589', '', 0, 1, 1, 0, '{\"name\":\"theme3589\",\"type\":\"template\",\"creationDate\":\"April 2017\",\"author\":\"Unknown\",\"copyright\":\"Copyright  2003-2017 template-help.com. All Rights Reserved.\",\"authorEmail\":\"info@template-help.com\",\"authorUrl\":\"\",\"version\":\"1.0.0\",\"description\":\"\\n\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"templateDetails\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10168, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10169, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10170, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10171, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 0, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10172, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 0, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10173, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 0, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10174, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10175, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10176, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10177, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '{\"buttons\":\"0\",\"width\":\"100%\",\"height\":\"250px\",\"filter\":\"JComponentHelper::filterText\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10178, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '{\"directory\":\"\\/\",\"multiple\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10179, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10180, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '{\"multiple\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10181, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"preview\":\"tooltip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10182, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10183, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '{\"multiple\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10184, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '{\"filter\":\"JComponentHelper::filterText\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10185, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '{\"rows\":\"10\",\"cols\":\"10\",\"filter\":\"JComponentHelper::filterText\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10186, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '{\"relative\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10187, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10188, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '{\"multiple\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10189, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 0, 1, 0, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10190, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10193, 0, 'T3 Framework Package', 'package', 'pkg_t3', '', 0, 1, 1, 0, '{\"name\":\"T3 Framework Package\",\"type\":\"package\",\"creationDate\":\"May 04, 2018\",\"author\":\"t3-framework.org\",\"copyright\":\"(C) 2012 - 2018. All rights reserved.\",\"authorEmail\":\"support@t3-framework.org\",\"authorUrl\":\"www.t3-framework.org\",\"version\":\"2.7.1\",\"description\":\"\\t\\n\\t\\n\\t<div align=\\\"center\\\">\\n\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2018 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"pkg_t3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10196, 0, 'mod_tm_style_switcher', 'module', 'mod_tm_style_switcher', '', 0, 1, 0, 0, '{\"name\":\"mod_tm_style_switcher\",\"type\":\"module\",\"creationDate\":\"February, 2013\",\"author\":\"TemplateMonster\",\"copyright\":\"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.2\",\"description\":\"MOD_TM_STYLE_SWITCHER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tm_style_switcher\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10197, 0, 'TM Progress bars', 'module', 'mod_tm_progress_bars', '', 0, 1, 0, 0, '{\"name\":\"TM Progress bars\",\"type\":\"module\",\"creationDate\":\"June, 2017\",\"author\":\"TemplateMonster http:\\/\\/www.templatemonster.com\",\"copyright\":\"Copyright (c) 2012-2017 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"Thanks for installing TM Progress bars\",\"group\":\"\",\"filename\":\"mod_tm_progress_bars\"}', '{\"choose_type\":\"0\",\"columns\":\"1\",\"items_data2\":\"{\\\"item_name\\\":[\\\"Name\\\"],\\\"item_value\\\":[\\\"30\\\"],\\\"item_color1\\\":[\\\"#eaeaea\\\"],\\\"item_color2\\\":[\\\"#eaeaea\\\"],\\\"item_color3\\\":[\\\"#f5f5f5\\\"]}\",\"items_data\":\"{\\\"item_name\\\":[\\\"Name\\\"],\\\"item_value\\\":[\\\"30\\\"],\\\"item_color\\\":[\\\"#eaeaea\\\"]}\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10199, 0, 'plg_finder_kunena', 'plugin', 'kunena', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_FINDER_KUNENA_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10200, 0, 'plg_kunena_altauserpoints', 'plugin', 'altauserpoints', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_altauserpoints\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_ALTAUSERPOINTS_DESCRIPTION\",\"group\":\"\",\"filename\":\"altauserpoints\"}', '{\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"activity_points_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10201, 0, 'PLG_KUNENA_EASYPROFILE', 'plugin', 'easyprofile', 'kunena', 0, 0, 1, 0, '{\"name\":\"PLG_KUNENA_EASYPROFILE\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Onlinecommunityhub\",\"copyright\":\"https:\\/\\/onlinecommunityhub.nl\",\"authorEmail\":\"info@onlinecommunityhub.nl\",\"authorUrl\":\"https:\\/\\/onlinecommunityhub.nl\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_EASYPROFILE_DESCRIPTION\",\"group\":\"\",\"filename\":\"easyprofile\"}', '{\"avatar\":\"1\",\"guestavatar\":\"easyprofile\",\"profile\":\"1\",\"userlist\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10202, 0, 'plg_kunena_easysocial', 'plugin', 'easysocial', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_easysocial\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"StackIdeas\",\"copyright\":\"http:\\/\\/stackideas.com\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"http:\\/\\/stackideas.com\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_EASYSOCIAL_DESCRIPTION\",\"group\":\"\",\"filename\":\"easysocial\"}', '{\"login\":\"1\",\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"private\":\"1\",\"activity_badge_limit\":\"0\",\"activity_points_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10203, 0, 'plg_kunena_finder', 'plugin', 'finder', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"PLG_KUNENA_FINDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10204, 0, 'AcyMailing', 'component', 'com_acymailing', '', 1, 1, 0, 0, '{\"name\":\"AcyMailing\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2018 ACYBA SAS - All rights reserved.\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"5.10.1\",\"description\":\"Manage your Mailing lists, Newsletters, e-mail marketing campaigns\",\"group\":\"\",\"filename\":\"acymailing_j3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10205, 0, 'AcyMailing : trigger Joomla Content plugins', 'plugin', 'contentplugin', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"November 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10206, 0, 'AcyMailing Manage text', 'plugin', 'managetext', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"October 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10207, 0, 'AcyMailing Tag : Website links', 'plugin', 'online', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10208, 0, 'AcyMailing : share on social networks', 'plugin', 'share', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"August 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10209, 0, 'AcyMailing : Statistics Plugin', 'plugin', 'stats', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10210, 0, 'AcyMailing table of contents generator', 'plugin', 'tablecontents', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"January 2011\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10211, 0, 'AcyMailing Tag : content insertion', 'plugin', 'tagcontent', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10212, 0, 'AcyMailing Tag : Subscriber information', 'plugin', 'tagsubscriber', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10213, 0, 'AcyMailing Tag : Manage the Subscription', 'plugin', 'tagsubscription', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10214, 0, 'AcyMailing Tag : Date / Time', 'plugin', 'tagtime', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10215, 0, 'AcyMailing Tag : Joomla User Information', 'plugin', 'taguser', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10216, 0, 'AcyMailing Template Class Replacer', 'plugin', 'template', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 52, 0),
(10217, 0, 'AcyMailing Editor', 'plugin', 'acyeditor', 'editors', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10218, 0, 'AcyMailing : (auto)Subscribe during Joomla registration', 'plugin', 'regacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10219, 0, 'AcyMailing Module', 'module', 'mod_acymailing', '', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10220, 0, 'mod_tm_portfolio', 'module', 'mod_tm_portfolio', '', 0, 1, 0, 0, '{\"name\":\"mod_tm_portfolio\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"TemplateMonster\",\"copyright\":\"Copyright (c) 2012-2017 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"MOD_TM_PORTFOLIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tm_portfolio\"}', '{\"catid\":\"\",\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"5\",\"columns\":\"1\",\"show_filter\":\"1\",\"show_sort\":\"1\",\"ordering\":\"a.publish_up\",\"article_ordering_direction\":\"DESC\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h4\",\"limit_introtext\":\"0\",\"show_introtext\":\"1\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"show_modify_date\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"masonry\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10223, 0, 'AcyMailing JCE integration', 'plugin', 'jceacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.10.1\",\"author\":\"Acyba\",\"creationDate\":\"May 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 23, 0),
(10228, 0, 'TM Counters', 'module', 'mod_tm_counters', '', 0, 1, 1, 0, '{\"name\":\"TM Counters\",\"type\":\"module\",\"creationDate\":\"December, 2017\",\"author\":\"TemplateMonster http:\\/\\/www.templatemonster.com\",\"copyright\":\"Copyright (c) 2012-2017 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"Thanks for installing TM Counters\",\"group\":\"\",\"filename\":\"mod_tm_counters\"}', '{\"columns\":\"1\",\"animation_speed\":\"6000\",\"items_data\":\"{\\\"item_name\\\":[\\\"Name\\\"],\\\"item_value\\\":[\\\"30\\\"]}\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10229, 0, 'TM Google map', 'module', 'mod_tm_google_map', '', 0, 1, 1, 0, '{\"name\":\"TM Google map\",\"type\":\"module\",\"creationDate\":\"December, 2017\",\"author\":\"TemplateMonster http:\\/\\/www.templatemonster.com\",\"copyright\":\"Copyright (c) 2012-2017 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.0\",\"description\":\"Thanks for installing TM Google map\",\"group\":\"\",\"filename\":\"mod_tm_google_map\"}', '{\"animation_speed\":\"6000\",\"items_data\":\"{\\\"item_x\\\":[\\\"-73.9874068\\\"],\\\"item_y\\\":[\\\"40.643180\\\"],\\\"item_label\\\":[\\\"2130 Fulton Street San Diego, CA 94117-1080 USA\\\"]}\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10236, 10163, 'slogin', 'library', 'slogin_oauth', '', 0, 1, 1, 0, '{\"name\":\"slogin\",\"type\":\"library\",\"creationDate\":\"2013-04-28\",\"author\":\"Arkadiy Sedelnikov, Joomline\",\"copyright\":\"\",\"authorEmail\":\"a.sedelnikov@gmail.com\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.0\",\"description\":\"\\n  \\n  \\u0411\\u0438\\u0431\\u043b\\u0438\\u043e\\u0442\\u0435\\u043a\\u0430 \\u0430\\u0432\\u0442\\u043e\\u0440\\u0438\\u0437\\u0430\\u0446\\u0438\\u0438 OAuth \\u0441 \\u0438\\u0437\\u043c\\u0435\\u043d\\u0435\\u043d\\u043d\\u044b\\u043c\\u0438 \\u043d\\u0430\\u0437\\u0432\\u0430\\u043d\\u0438\\u044f\\u043c\\u0438 \\u043a\\u043b\\u0430\\u0441\\u0441\\u043e\\u0432 \\u0434\\u043b\\u044f \\u0438\\u0441\\u043a\\u043b\\u044e\\u0447\\u0435\\u043d\\u0438\\u044f \\u043a\\u043e\\u043d\\u0444\\u043b\\u0438\\u043a\\u0442\\u043e\\u0432 \\u0438\\u043c\\u0435\\u043d.\\n  \\n  \",\"group\":\"\",\"filename\":\"slogin_oauth\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10237, 10163, 'amcharts', 'library', 'amcharts', '', 0, 1, 1, 0, '{\"name\":\"amcharts\",\"type\":\"library\",\"creationDate\":\"2014-04-21\",\"author\":\"Arkadiy Sedelnikov, Joomline\",\"copyright\":\"\",\"authorEmail\":\"a.sedelnikov@gmail.com\",\"authorUrl\":\"http:\\/\\/joomline.ru\",\"version\":\"1.0\",\"description\":\"\\n         Chart Library AmCharts \\n    \",\"group\":\"\",\"filename\":\"amcharts\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10240, 10020, 'Kunena Framework', 'library', 'kunena', '', 0, 1, 1, 0, '{\"name\":\"Kunena Framework\",\"type\":\"library\",\"creationDate\":\"2018-05-13\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.1.0\",\"description\":\"Kunena Framework.\",\"group\":\"\",\"filename\":\"kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10241, 0, 'mod_sw_twitterdisplay', 'module', 'mod_sw_twitterdisplay', '', 0, 0, 1, 0, '{\"name\":\"SW Twitter Display\",\"type\":\"module\",\"creationDate\":\"October, 2013\",\"author\":\"Muhammad Riduan\",\"copyright\":\"Copyright - Social Widgets\",\"authorEmail\":\"admin@socialwidgets.net\",\"authorUrl\":\"http:\\/\\/socialwidgets.net\\/\",\"version\":\"1.0\",\"description\":\"Thanks for installing SW Twitter Display\",\"group\":\"\",\"filename\":\"mod_sw_twitterdisplay\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, -1),
(10242, 0, 'mod_tm_facebook_page_plugin', 'module', 'mod_tm_facebook_page_plugin', '', 0, 0, 1, 0, '{\"name\":\"mod_tm_facebook_page_plugin\",\"type\":\"module\",\"creationDate\":\"May 2015\",\"author\":\"TemplateMonster\",\"copyright\":\"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com\",\"authorEmail\":\"\",\"authorUrl\":\"www.templatemonster.com\",\"version\":\"1.0.3\",\"description\":\"MOD_TM_FACEBOOK_PAGE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tm_facebook_page_plugin\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, -1);

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE IF NOT EXISTS `#__fields` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__joomgallery`;
CREATE TABLE IF NOT EXISTS `#__joomgallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `imgtitle` text NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `imgauthor` varchar(50) DEFAULT NULL,
  `imgtext` text NOT NULL,
  `imgdate` datetime NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `downloads` int(11) NOT NULL DEFAULT '0',
  `imgvotes` int(11) NOT NULL DEFAULT '0',
  `imgvotesum` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL,
  `imgfilename` varchar(255) NOT NULL,
  `imgthumbname` varchar(255) NOT NULL,
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `owner` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `useruploaded` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_catid` (`catid`),
  KEY `idx_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8;

INSERT INTO `#__joomgallery` (`id`, `asset_id`, `catid`, `imgtitle`, `alias`, `imgauthor`, `imgtext`, `imgdate`, `hits`, `downloads`, `imgvotes`, `imgvotesum`, `access`, `published`, `hidden`, `featured`, `imgfilename`, `imgthumbname`, `checked_out`, `owner`, `approved`, `useruploaded`, `ordering`, `params`, `metakey`, `metadesc`) VALUES
(219, 738, 9, 'gallery-image01', 'gallery-image01-219', '', '', '2017-06-13 07:52:55', 4, 0, 0, 0, 1, 1, 0, 0, 'gallery-image01_20170613_1642419993.jpg', 'gallery-image01_20170613_1642419993.jpg', 0, 0, 1, 0, 1, '', '', ''),
(220, 739, 9, 'gallery-image02', 'gallery-image02-220', '', '', '2017-06-13 07:53:04', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image02_20170613_1954889876.jpg', 'gallery-image02_20170613_1954889876.jpg', 0, 0, 1, 0, 2, '', '', ''),
(221, 740, 9, 'gallery-image03', 'gallery-image03-221', '', '', '2017-06-13 07:53:13', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image03_20170613_1473578199.jpg', 'gallery-image03_20170613_1473578199.jpg', 0, 0, 1, 0, 3, '', '', ''),
(222, 741, 9, 'gallery-image04', 'gallery-image04-222', '', '', '2017-06-13 07:53:19', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image04_20170613_1808821392.jpg', 'gallery-image04_20170613_1808821392.jpg', 0, 0, 1, 0, 4, '', '', ''),
(223, 742, 9, 'gallery-image05', 'gallery-image05-223', '', '', '2017-06-13 07:53:29', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image05_20170613_1142159046.jpg', 'gallery-image05_20170613_1142159046.jpg', 0, 0, 1, 0, 5, '', '', ''),
(224, 743, 9, 'gallery-image06', 'gallery-image06-224', '', '', '2017-06-13 07:53:40', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image06_20170613_1566802544.jpg', 'gallery-image06_20170613_1566802544.jpg', 0, 0, 1, 0, 6, '', '', ''),
(225, 744, 10, 'gallery-image07', 'gallery-image07-225', '', '', '2017-06-13 07:57:07', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image07_20170613_1163557361.jpg', 'gallery-image07_20170613_1163557361.jpg', 0, 0, 1, 0, 1, '', '', ''),
(226, 745, 10, 'gallery-image08', 'gallery-image08-226', '', '', '2017-06-13 07:57:21', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image08_20170613_1081681655.jpg', 'gallery-image08_20170613_1081681655.jpg', 0, 0, 1, 0, 2, '', '', ''),
(227, 746, 10, 'gallery-image09', 'gallery-image09-227', '', '', '2017-06-13 07:57:22', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image09_20170613_1092974928.jpg', 'gallery-image09_20170613_1092974928.jpg', 0, 0, 1, 0, 3, '', '', ''),
(228, 747, 10, 'gallery-image10', 'gallery-image10-228', '', '', '2017-06-13 07:57:39', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image10_20170613_1155577399.jpg', 'gallery-image10_20170613_1155577399.jpg', 0, 0, 1, 0, 4, '', '', ''),
(229, 748, 10, 'gallery-image11', 'gallery-image11-229', '', '', '2017-06-13 07:57:51', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image11_20170613_1760941948.jpg', 'gallery-image11_20170613_1760941948.jpg', 0, 0, 1, 0, 5, '', '', ''),
(230, 749, 10, 'gallery-image12', 'gallery-image12-230', '', '', '2017-06-13 07:58:03', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image12_20170613_1079538080.jpg', 'gallery-image12_20170613_1079538080.jpg', 0, 0, 1, 0, 6, '', '', ''),
(231, 750, 11, 'gallery-image13', 'gallery-image13-231', '', '', '2017-06-13 07:59:03', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image13_20170613_1750916203.jpg', 'gallery-image13_20170613_1750916203.jpg', 0, 0, 1, 0, 1, '', '', ''),
(232, 751, 11, 'gallery-image14', 'gallery-image14-232', '', '', '2017-06-13 07:59:19', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image14_20170613_1387647013.jpg', 'gallery-image14_20170613_1387647013.jpg', 0, 0, 1, 0, 2, '', '', ''),
(233, 752, 11, 'gallery-image15', 'gallery-image15-233', '', '', '2017-06-13 07:59:26', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image15_20170613_1503213720.jpg', 'gallery-image15_20170613_1503213720.jpg', 0, 0, 1, 0, 3, '', '', ''),
(234, 753, 11, 'gallery-image16', 'gallery-image16-234', '', '', '2017-06-13 07:59:45', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image16_20170613_1917512631.jpg', 'gallery-image16_20170613_1917512631.jpg', 0, 0, 1, 0, 4, '', '', ''),
(235, 754, 11, 'gallery-image17', 'gallery-image17-235', '', '', '2017-06-13 07:59:51', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image17_20170613_1427981441.jpg', 'gallery-image17_20170613_1427981441.jpg', 0, 0, 1, 0, 5, '', '', ''),
(236, 755, 11, 'gallery-image18', 'gallery-image18-236', '', '', '2017-06-13 07:59:59', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image18_20170613_1977506227.jpg', 'gallery-image18_20170613_1977506227.jpg', 0, 0, 1, 0, 6, '', '', ''),
(237, 756, 12, 'gallery-image19', 'gallery-image19-237', '', '', '2017-06-13 08:01:18', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image19_20170613_1275119800.jpg', 'gallery-image19_20170613_1275119800.jpg', 0, 0, 1, 0, 1, '', '', ''),
(238, 757, 12, 'gallery-image20', 'gallery-image20-238', '', '', '2017-06-13 08:01:30', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image20_20170613_1600031160.jpg', 'gallery-image20_20170613_1600031160.jpg', 0, 0, 1, 0, 2, '', '', ''),
(239, 758, 12, 'gallery-image21', 'gallery-image21-239', '', '', '2017-06-13 08:01:37', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image21_20170613_1866437866.jpg', 'gallery-image21_20170613_1866437866.jpg', 0, 0, 1, 0, 3, '', '', ''),
(240, 759, 12, 'gallery-image22', 'gallery-image22-240', '', '', '2017-06-13 08:01:38', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image22_20170613_1668831893.jpg', 'gallery-image22_20170613_1668831893.jpg', 0, 0, 1, 0, 4, '', '', ''),
(241, 760, 12, 'gallery-image23', 'gallery-image23-241', '', '', '2017-06-13 08:01:47', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image23_20170613_1421546958.jpg', 'gallery-image23_20170613_1421546958.jpg', 0, 0, 1, 0, 5, '', '', ''),
(242, 761, 12, 'gallery-image24', 'gallery-image24-242', '', '', '2017-06-13 08:01:54', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image24_20170613_1503564385.jpg', 'gallery-image24_20170613_1503564385.jpg', 0, 0, 1, 0, 6, '', '', ''),
(243, 762, 13, 'gallery-image25', 'gallery-image25-243', '', '', '2017-06-13 08:04:13', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image25_20170613_1577153239.jpg', 'gallery-image25_20170613_1577153239.jpg', 0, 0, 1, 0, 1, '', '', ''),
(244, 763, 13, 'gallery-image26', 'gallery-image26-244', '', '', '2017-06-13 08:04:25', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image26_20170613_1440346434.jpg', 'gallery-image26_20170613_1440346434.jpg', 0, 0, 1, 0, 2, '', '', ''),
(245, 764, 13, 'gallery-image27', 'gallery-image27-245', '', '', '2017-06-13 08:04:33', 1, 0, 0, 0, 1, 1, 0, 0, 'gallery-image27_20170613_1255706010.jpg', 'gallery-image27_20170613_1255706010.jpg', 0, 0, 1, 0, 3, '', '', ''),
(246, 765, 13, 'gallery-image28', 'gallery-image28-246', '', '', '2017-06-13 08:04:43', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image28_20170613_1776623647.jpg', 'gallery-image28_20170613_1776623647.jpg', 0, 0, 1, 0, 4, '', '', ''),
(247, 766, 13, 'gallery-image29', 'gallery-image29-247', '', '', '2017-06-13 08:04:52', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image29_20170613_1937311829.jpg', 'gallery-image29_20170613_1937311829.jpg', 0, 0, 1, 0, 5, '', '', ''),
(248, 767, 13, 'gallery-image30', 'gallery-image30-248', '', '', '2017-06-13 08:05:20', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image30_20170613_1300295342.jpg', 'gallery-image30_20170613_1300295342.jpg', 0, 0, 1, 0, 6, '', '', ''),
(249, 768, 14, 'gallery-image31', 'gallery-image31-249', '', '', '2017-06-13 08:06:50', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image31_20170613_1202462711.jpg', 'gallery-image31_20170613_1202462711.jpg', 0, 0, 1, 0, 1, '', '', ''),
(250, 769, 14, 'gallery-image32', 'gallery-image32-250', '', '', '2017-06-13 08:07:00', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image32_20170613_2083019644.jpg', 'gallery-image32_20170613_2083019644.jpg', 0, 0, 1, 0, 2, '', '', ''),
(251, 770, 14, 'gallery-image33', 'gallery-image33-251', '', '', '2017-06-13 08:07:13', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image33_20170613_1682111566.jpg', 'gallery-image33_20170613_1682111566.jpg', 0, 0, 1, 0, 3, '', '', ''),
(252, 771, 14, 'gallery-image34', 'gallery-image34-252', '', '', '2017-06-13 08:07:23', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image34_20170613_1096610765.jpg', 'gallery-image34_20170613_1096610765.jpg', 0, 0, 1, 0, 4, '', '', ''),
(253, 772, 14, 'gallery-image35', 'gallery-image35-253', '', '', '2017-06-13 08:07:37', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image35_20170613_1628331383.jpg', 'gallery-image35_20170613_1628331383.jpg', 0, 0, 1, 0, 5, '', '', ''),
(254, 773, 14, 'gallery-image36', 'gallery-image36-254', '', '', '2017-06-13 08:07:53', 0, 0, 0, 0, 1, 1, 0, 0, 'gallery-image36_20170613_1795893777.jpg', 'gallery-image36_20170613_1795893777.jpg', 0, 0, 1, 0, 6, '', '', '');

DROP TABLE IF EXISTS `#__joomgallery_category_details`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_category_details` (
  `id` int(11) NOT NULL,
  `details_key` varchar(255) NOT NULL,
  `details_value` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`,`details_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_catg`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_catg` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(2048) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `description` text,
  `access` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `in_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(100) NOT NULL DEFAULT '',
  `owner` int(11) DEFAULT '0',
  `thumbnail` int(11) DEFAULT NULL,
  `img_position` int(10) DEFAULT '0',
  `catpath` varchar(2048) NOT NULL,
  `params` text NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `exclude_toplists` int(1) NOT NULL,
  `exclude_search` int(1) NOT NULL,
  PRIMARY KEY (`cid`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `#__joomgallery_catg` (`cid`, `asset_id`, `name`, `alias`, `parent_id`, `lft`, `rgt`, `level`, `description`, `access`, `published`, `hidden`, `in_hidden`, `password`, `owner`, `thumbnail`, `img_position`, `catpath`, `params`, `metakey`, `metadesc`, `exclude_toplists`, `exclude_search`) VALUES
(1, 0, 'ROOT', 'root', 0, 0, 15, 0, NULL, 1, 1, 0, 0, '', 0, NULL, 0, '', '', '', '', 0, 0),
(2, 170, 'Gallery', 'gallery', 1, 1, 14, 1, '', 1, 1, 0, 0, '', 846, 0, -1, 'gallery_2', '', '', '', 0, 0),
(9, 521, 'Gallery 1', 'gallery/gallery-1', 2, 2, 3, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_1_9', '', '', '', 0, 0),
(10, 522, 'Gallery 2', 'gallery/gallery-2', 2, 4, 5, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_2_10', '', '', '', 0, 0),
(11, 523, 'Gallery 3', 'gallery/gallery-3', 2, 6, 7, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_3_11', '', '', '', 0, 0),
(12, 524, 'Gallery 4', 'gallery/gallery-4', 2, 8, 9, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_4_12', '', '', '', 0, 0),
(13, 525, 'Gallery 5', 'gallery/gallery-5', 2, 10, 11, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_5_13', '', '', '', 0, 0),
(14, 526, 'Gallery 6', 'gallery/gallery-6', 2, 12, 13, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_6_14', '', '', '', 0, 0);

DROP TABLE IF EXISTS `#__joomgallery_comments`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_comments` (
  `cmtid` int(11) NOT NULL AUTO_INCREMENT,
  `cmtpic` int(11) NOT NULL DEFAULT '0',
  `cmtip` varchar(15) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `cmtname` varchar(50) NOT NULL DEFAULT '',
  `cmttext` text NOT NULL,
  `cmtdate` datetime NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cmtid`),
  KEY `idx_cmtpic` (`cmtpic`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_config`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_config` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `ordering` int(11) NOT NULL,
  `jg_pathimages` varchar(100) NOT NULL,
  `jg_pathoriginalimages` varchar(100) NOT NULL,
  `jg_paththumbs` varchar(100) NOT NULL,
  `jg_pathftpupload` varchar(100) NOT NULL,
  `jg_pathtemp` varchar(100) NOT NULL,
  `jg_wmpath` varchar(100) NOT NULL,
  `jg_wmfile` varchar(50) NOT NULL,
  `jg_use_real_paths` int(1) NOT NULL,
  `jg_checkupdate` int(1) NOT NULL,
  `jg_filenamewithjs` int(1) NOT NULL,
  `jg_filenamereplace` text NOT NULL,
  `jg_thumbcreation` varchar(5) NOT NULL,
  `jg_fastgd2thumbcreation` int(1) NOT NULL,
  `jg_impath` varchar(50) NOT NULL,
  `jg_resizetomaxwidth` int(1) NOT NULL,
  `jg_maxwidth` int(5) NOT NULL,
  `jg_picturequality` int(3) NOT NULL,
  `jg_useforresizedirection` int(1) NOT NULL,
  `jg_cropposition` int(1) NOT NULL,
  `jg_thumbwidth` int(5) NOT NULL,
  `jg_thumbheight` int(5) NOT NULL,
  `jg_thumbquality` int(3) NOT NULL,
  `jg_uploadorder` int(1) NOT NULL,
  `jg_useorigfilename` int(1) NOT NULL,
  `jg_filenamenumber` int(1) NOT NULL,
  `jg_delete_original` int(1) NOT NULL,
  `jg_msg_upload_type` int(1) NOT NULL,
  `jg_msg_upload_recipients` text NOT NULL,
  `jg_msg_download_type` int(1) NOT NULL,
  `jg_msg_download_recipients` text NOT NULL,
  `jg_msg_zipdownload` int(1) NOT NULL,
  `jg_msg_comment_type` int(1) NOT NULL,
  `jg_msg_comment_recipients` text NOT NULL,
  `jg_msg_comment_toowner` int(1) NOT NULL,
  `jg_msg_nametag_type` int(1) NOT NULL,
  `jg_msg_nametag_recipients` text NOT NULL,
  `jg_msg_nametag_totaggeduser` int(1) NOT NULL,
  `jg_msg_nametag_toowner` int(1) NOT NULL,
  `jg_msg_report_type` int(1) NOT NULL,
  `jg_msg_report_recipients` text NOT NULL,
  `jg_msg_report_toowner` int(1) NOT NULL,
  `jg_msg_rejectimg_type` int(1) NOT NULL,
  `jg_msg_global_from` int(1) NOT NULL,
  `jg_realname` int(1) NOT NULL,
  `jg_contentpluginsenabled` int(1) NOT NULL,
  `jg_itemid` varchar(10) NOT NULL,
  `jg_ajaxcategoryselection` int(1) NOT NULL,
  `jg_disableunrequiredchecks` int(1) NOT NULL,
  `jg_use_listbox_max_user_count` int(1) NOT NULL,
  `jg_userspace` int(1) NOT NULL,
  `jg_useruploaddefaultcat` int(1) NOT NULL,
  `jg_approve` int(1) NOT NULL,
  `jg_unregistered_permissions` int(1) NOT NULL,
  `jg_maxusercat` int(5) NOT NULL,
  `jg_maxuserimage` int(9) NOT NULL,
  `jg_maxuserimage_timespan` int(9) NOT NULL,
  `jg_maxfilesize` int(9) NOT NULL,
  `jg_usercatacc` int(1) NOT NULL,
  `jg_usercatthumbalign` int(1) NOT NULL,
  `jg_useruploadsingle` int(1) NOT NULL,
  `jg_maxuploadfields` int(3) NOT NULL,
  `jg_useruploadajax` int(1) NOT NULL,
  `jg_useruploadbatch` int(1) NOT NULL,
  `jg_useruploadjava` int(1) NOT NULL,
  `jg_useruseorigfilename` int(1) NOT NULL,
  `jg_useruploadnumber` int(1) NOT NULL,
  `jg_special_gif_upload` int(1) NOT NULL,
  `jg_delete_original_user` int(1) NOT NULL,
  `jg_newpiccopyright` int(1) NOT NULL,
  `jg_newpicnote` int(1) NOT NULL,
  `jg_redirect_after_upload` int(1) NOT NULL,
  `jg_edit_metadata` int(1) NOT NULL,
  `jg_download` int(1) NOT NULL,
  `jg_download_unreg` int(1) NOT NULL,
  `jg_download_hint` int(1) NOT NULL,
  `jg_downloadfile` int(1) NOT NULL,
  `jg_downloadwithwatermark` int(1) NOT NULL,
  `jg_showrating` int(1) NOT NULL,
  `jg_maxvoting` int(1) NOT NULL,
  `jg_ratingcalctype` int(1) NOT NULL,
  `jg_ratingdisplaytype` int(1) NOT NULL,
  `jg_ajaxrating` int(1) NOT NULL,
  `jg_votingonlyonce` int(1) NOT NULL,
  `jg_votingonlyreg` int(1) NOT NULL,
  `jg_showcomment` int(1) NOT NULL,
  `jg_anoncomment` int(1) NOT NULL,
  `jg_namedanoncomment` int(1) NOT NULL,
  `jg_anonapprovecom` int(1) NOT NULL,
  `jg_approvecom` int(1) NOT NULL,
  `jg_bbcodesupport` int(1) NOT NULL,
  `jg_smiliesupport` int(1) NOT NULL,
  `jg_anismilie` int(1) NOT NULL,
  `jg_smiliescolor` varchar(10) NOT NULL,
  `jg_report_images` int(1) NOT NULL,
  `jg_report_unreg` int(1) NOT NULL,
  `jg_report_hint` int(1) NOT NULL,
  `jg_alternative_layout` varchar(255) NOT NULL,
  `jg_anchors` int(1) NOT NULL,
  `jg_tooltips` int(1) NOT NULL,
  `jg_dyncrop` int(1) NOT NULL,
  `jg_dyncropposition` int(1) NOT NULL,
  `jg_dyncropwidth` int(5) NOT NULL,
  `jg_dyncropheight` int(5) NOT NULL,
  `jg_dyncropbgcol` varchar(12) NOT NULL,
  `jg_hideemptycats` int(1) NOT NULL,
  `jg_skipcatview` int(1) NOT NULL,
  `jg_imgalign` int(3) NOT NULL,
  `jg_showrestrictedcats` int(1) NOT NULL,
  `jg_showrestrictedhint` int(1) NOT NULL,
  `jg_firstorder` varchar(20) NOT NULL,
  `jg_secondorder` varchar(20) NOT NULL,
  `jg_thirdorder` varchar(20) NOT NULL,
  `jg_pagetitle_cat` text NOT NULL,
  `jg_pagetitle_detail` text NOT NULL,
  `jg_showgalleryhead` int(1) NOT NULL,
  `jg_showpathway` int(1) NOT NULL,
  `jg_completebreadcrumbs` int(1) NOT NULL,
  `jg_search` int(1) NOT NULL,
  `jg_searchcols` int(1) NOT NULL,
  `jg_searchthumbalign` int(1) NOT NULL,
  `jg_searchtextalign` int(1) NOT NULL,
  `jg_showsearchdownload` int(1) NOT NULL,
  `jg_showsearchfavourite` int(1) NOT NULL,
  `jg_search_report_images` int(1) NOT NULL,
  `jg_showsearcheditorlinks` int(1) NOT NULL,
  `jg_showallpics` int(1) NOT NULL,
  `jg_showallhits` int(1) NOT NULL,
  `jg_showbacklink` int(1) NOT NULL,
  `jg_suppresscredits` int(1) NOT NULL,
  `jg_showuserpanel` int(1) NOT NULL,
  `jg_showuserpanel_hint` int(1) NOT NULL,
  `jg_showuserpanel_unreg` int(1) NOT NULL,
  `jg_showallpicstoadmin` int(1) NOT NULL,
  `jg_showminithumbs` int(1) NOT NULL,
  `jg_openjs_padding` int(3) NOT NULL,
  `jg_openjs_background` varchar(12) NOT NULL,
  `jg_dhtml_border` varchar(12) NOT NULL,
  `jg_show_title_in_popup` int(1) NOT NULL,
  `jg_show_description_in_popup` int(1) NOT NULL,
  `jg_lightbox_speed` int(3) NOT NULL,
  `jg_lightbox_slide_all` int(1) NOT NULL,
  `jg_resize_js_image` int(1) NOT NULL,
  `jg_disable_rightclick_original` int(1) NOT NULL,
  `jg_showgallerysubhead` int(1) NOT NULL,
  `jg_showallcathead` int(1) NOT NULL,
  `jg_colcat` int(1) NOT NULL,
  `jg_catperpage` int(1) NOT NULL,
  `jg_ordercatbyalpha` int(1) NOT NULL,
  `jg_showgallerypagenav` int(1) NOT NULL,
  `jg_showcatcount` int(1) NOT NULL,
  `jg_showcatthumb` int(1) NOT NULL,
  `jg_showrandomcatthumb` int(1) NOT NULL,
  `jg_ctalign` int(1) NOT NULL,
  `jg_showtotalcatimages` int(1) NOT NULL,
  `jg_showtotalcathits` int(1) NOT NULL,
  `jg_showcatasnew` int(1) NOT NULL,
  `jg_catdaysnew` int(3) NOT NULL,
  `jg_showdescriptioningalleryview` int(1) NOT NULL,
  `jg_uploadicongallery` int(1) NOT NULL,
  `jg_showsubsingalleryview` int(1) NOT NULL,
  `jg_category_rss` int(9) NOT NULL,
  `jg_category_rss_icon` varchar(10) NOT NULL,
  `jg_uploadiconcategory` int(1) NOT NULL,
  `jg_showcathead` int(1) NOT NULL,
  `jg_usercatorder` int(1) NOT NULL,
  `jg_usercatorderlist` varchar(50) NOT NULL,
  `jg_showcatdescriptionincat` int(1) NOT NULL,
  `jg_showpagenav` int(1) NOT NULL,
  `jg_showpiccount` int(1) NOT NULL,
  `jg_perpage` int(3) NOT NULL,
  `jg_catthumbalign` int(1) NOT NULL,
  `jg_colnumb` int(3) NOT NULL,
  `jg_detailpic_open` varchar(50) NOT NULL,
  `jg_lightboxbigpic` int(1) NOT NULL,
  `jg_showtitle` int(1) NOT NULL,
  `jg_showpicasnew` int(1) NOT NULL,
  `jg_daysnew` int(3) NOT NULL,
  `jg_showhits` int(1) NOT NULL,
  `jg_showdownloads` int(1) NOT NULL,
  `jg_showauthor` int(1) NOT NULL,
  `jg_showowner` int(1) NOT NULL,
  `jg_showcatcom` int(1) NOT NULL,
  `jg_showcatrate` int(1) NOT NULL,
  `jg_showcatdescription` int(1) NOT NULL,
  `jg_showcategorydownload` int(1) NOT NULL,
  `jg_showcategoryfavourite` int(1) NOT NULL,
  `jg_category_report_images` int(1) NOT NULL,
  `jg_showcategoryeditorlinks` int(1) NOT NULL,
  `jg_showsubcathead` int(1) NOT NULL,
  `jg_showsubcatcount` int(1) NOT NULL,
  `jg_colsubcat` int(3) NOT NULL,
  `jg_subperpage` int(3) NOT NULL,
  `jg_showpagenavsubs` int(1) NOT NULL,
  `jg_subcatthumbalign` int(1) NOT NULL,
  `jg_showsubthumbs` int(1) NOT NULL,
  `jg_showrandomsubthumb` int(1) NOT NULL,
  `jg_showdescriptionincategoryview` int(1) NOT NULL,
  `jg_ordersubcatbyalpha` int(1) NOT NULL,
  `jg_showtotalsubcatimages` int(1) NOT NULL,
  `jg_showtotalsubcathits` int(1) NOT NULL,
  `jg_uploadiconsubcat` int(1) NOT NULL,
  `jg_showdetailpage` int(1) NOT NULL,
  `jg_disabledetailpage` int(1) NOT NULL,
  `jg_showdetailnumberofpics` int(1) NOT NULL,
  `jg_cursor_navigation` int(1) NOT NULL,
  `jg_disable_rightclick_detail` int(1) NOT NULL,
  `jg_detail_report_images` int(1) NOT NULL,
  `jg_showdetaileditorlinks` int(1) NOT NULL,
  `jg_showdetailtitle` int(1) NOT NULL,
  `jg_showdetail` int(1) NOT NULL,
  `jg_showdetailaccordion` int(1) NOT NULL,
  `jg_accordionduration` int(3) NOT NULL,
  `jg_accordiondisplay` int(3) NOT NULL,
  `jg_accordionopacity` int(1) NOT NULL,
  `jg_accordionalwayshide` int(1) NOT NULL,
  `jg_accordioninitialeffect` int(1) NOT NULL,
  `jg_showdetaildescription` int(1) NOT NULL,
  `jg_showdetaildatum` int(1) NOT NULL,
  `jg_showdetailhits` int(1) NOT NULL,
  `jg_showdetaildownloads` int(1) NOT NULL,
  `jg_showdetailrating` int(1) NOT NULL,
  `jg_showdetailfilesize` int(1) NOT NULL,
  `jg_showdetailauthor` int(1) NOT NULL,
  `jg_showoriginalfilesize` int(1) NOT NULL,
  `jg_showdetaildownload` int(1) NOT NULL,
  `jg_watermark` int(1) NOT NULL,
  `jg_watermarkpos` int(1) NOT NULL,
  `jg_watermarkzoom` int(1) NOT NULL,
  `jg_watermarksize` int(1) NOT NULL,
  `jg_bigpic` int(1) NOT NULL,
  `jg_bigpic_unreg` int(1) NOT NULL,
  `jg_bigpic_open` varchar(50) NOT NULL,
  `jg_bbcodelink` int(1) NOT NULL,
  `jg_showcommentsunreg` int(1) NOT NULL,
  `jg_showcommentsarea` int(1) NOT NULL,
  `jg_send2friend` int(1) NOT NULL,
  `jg_minis` int(1) NOT NULL,
  `jg_motionminis` int(1) NOT NULL,
  `jg_motionminiWidth` int(3) NOT NULL,
  `jg_motionminiHeight` int(3) NOT NULL,
  `jg_motionminiLimit` int(2) NOT NULL DEFAULT '0',
  `jg_miniWidth` int(3) NOT NULL,
  `jg_miniHeight` int(3) NOT NULL,
  `jg_minisprop` int(1) NOT NULL,
  `jg_nameshields` int(1) NOT NULL,
  `jg_nameshields_others` int(1) NOT NULL,
  `jg_nameshields_unreg` int(1) NOT NULL,
  `jg_show_nameshields_unreg` int(1) NOT NULL,
  `jg_nameshields_height` int(3) NOT NULL,
  `jg_nameshields_width` int(3) NOT NULL,
  `jg_slideshow` int(1) NOT NULL,
  `jg_slideshow_timer` int(3) NOT NULL,
  `jg_slideshow_transition` int(1) NOT NULL,
  `jg_slideshow_transtime` int(3) NOT NULL,
  `jg_slideshow_maxdimauto` int(1) NOT NULL,
  `jg_slideshow_width` int(3) NOT NULL,
  `jg_slideshow_heigth` int(3) NOT NULL,
  `jg_slideshow_infopane` int(1) NOT NULL,
  `jg_slideshow_carousel` int(1) NOT NULL,
  `jg_slideshow_arrows` int(1) NOT NULL,
  `jg_slideshow_repeat` int(1) NOT NULL,
  `jg_showexifdata` int(1) NOT NULL,
  `jg_showgeotagging` int(1) NOT NULL,
  `jg_geotaggingkey` text NOT NULL,
  `jg_subifdtags` text NOT NULL,
  `jg_ifdotags` text NOT NULL,
  `jg_gpstags` text NOT NULL,
  `jg_showiptcdata` int(1) NOT NULL,
  `jg_iptctags` text NOT NULL,
  `jg_showtoplist` int(1) NOT NULL,
  `jg_toplist` int(3) NOT NULL,
  `jg_topthumbalign` int(1) NOT NULL,
  `jg_toptextalign` int(1) NOT NULL,
  `jg_toplistcols` int(3) NOT NULL,
  `jg_whereshowtoplist` int(1) NOT NULL,
  `jg_showrate` int(1) NOT NULL,
  `jg_showlatest` int(1) NOT NULL,
  `jg_showcom` int(1) NOT NULL,
  `jg_showthiscomment` int(1) NOT NULL,
  `jg_showmostviewed` int(1) NOT NULL,
  `jg_showtoplistdownload` int(1) NOT NULL,
  `jg_showtoplistfavourite` int(1) NOT NULL,
  `jg_toplist_report_images` int(1) NOT NULL,
  `jg_showtoplisteditorlinks` int(1) NOT NULL,
  `jg_favourites` int(1) NOT NULL,
  `jg_favouritesshownotauth` int(1) NOT NULL,
  `jg_maxfavourites` int(5) NOT NULL,
  `jg_zipdownload` int(1) NOT NULL,
  `jg_usefavouritesforpubliczip` int(1) NOT NULL,
  `jg_usefavouritesforzip` int(1) NOT NULL,
  `jg_allimagesofcategory` int(1) NOT NULL,
  `jg_showfavouritesdownload` int(1) NOT NULL,
  `jg_showfavouriteseditorlinks` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__joomgallery_config` (`id`, `group_id`, `ordering`, `jg_pathimages`, `jg_pathoriginalimages`, `jg_paththumbs`, `jg_pathftpupload`, `jg_pathtemp`, `jg_wmpath`, `jg_wmfile`, `jg_use_real_paths`, `jg_checkupdate`, `jg_filenamewithjs`, `jg_filenamereplace`, `jg_thumbcreation`, `jg_fastgd2thumbcreation`, `jg_impath`, `jg_resizetomaxwidth`, `jg_maxwidth`, `jg_picturequality`, `jg_useforresizedirection`, `jg_cropposition`, `jg_thumbwidth`, `jg_thumbheight`, `jg_thumbquality`, `jg_uploadorder`, `jg_useorigfilename`, `jg_filenamenumber`, `jg_delete_original`, `jg_msg_upload_type`, `jg_msg_upload_recipients`, `jg_msg_download_type`, `jg_msg_download_recipients`, `jg_msg_zipdownload`, `jg_msg_comment_type`, `jg_msg_comment_recipients`, `jg_msg_comment_toowner`, `jg_msg_nametag_type`, `jg_msg_nametag_recipients`, `jg_msg_nametag_totaggeduser`, `jg_msg_nametag_toowner`, `jg_msg_report_type`, `jg_msg_report_recipients`, `jg_msg_report_toowner`, `jg_msg_rejectimg_type`, `jg_msg_global_from`, `jg_realname`, `jg_contentpluginsenabled`, `jg_itemid`, `jg_ajaxcategoryselection`, `jg_disableunrequiredchecks`, `jg_use_listbox_max_user_count`, `jg_userspace`, `jg_useruploaddefaultcat`, `jg_approve`, `jg_unregistered_permissions`, `jg_maxusercat`, `jg_maxuserimage`, `jg_maxuserimage_timespan`, `jg_maxfilesize`, `jg_usercatacc`, `jg_usercatthumbalign`, `jg_useruploadsingle`, `jg_maxuploadfields`, `jg_useruploadajax`, `jg_useruploadbatch`, `jg_useruploadjava`, `jg_useruseorigfilename`, `jg_useruploadnumber`, `jg_special_gif_upload`, `jg_delete_original_user`, `jg_newpiccopyright`, `jg_newpicnote`, `jg_redirect_after_upload`, `jg_edit_metadata`, `jg_download`, `jg_download_unreg`, `jg_download_hint`, `jg_downloadfile`, `jg_downloadwithwatermark`, `jg_showrating`, `jg_maxvoting`, `jg_ratingcalctype`, `jg_ratingdisplaytype`, `jg_ajaxrating`, `jg_votingonlyonce`, `jg_votingonlyreg`, `jg_showcomment`, `jg_anoncomment`, `jg_namedanoncomment`, `jg_anonapprovecom`, `jg_approvecom`, `jg_bbcodesupport`, `jg_smiliesupport`, `jg_anismilie`, `jg_smiliescolor`, `jg_report_images`, `jg_report_unreg`, `jg_report_hint`, `jg_alternative_layout`, `jg_anchors`, `jg_tooltips`, `jg_dyncrop`, `jg_dyncropposition`, `jg_dyncropwidth`, `jg_dyncropheight`, `jg_dyncropbgcol`, `jg_hideemptycats`, `jg_skipcatview`, `jg_imgalign`, `jg_showrestrictedcats`, `jg_showrestrictedhint`, `jg_firstorder`, `jg_secondorder`, `jg_thirdorder`, `jg_pagetitle_cat`, `jg_pagetitle_detail`, `jg_showgalleryhead`, `jg_showpathway`, `jg_completebreadcrumbs`, `jg_search`, `jg_searchcols`, `jg_searchthumbalign`, `jg_searchtextalign`, `jg_showsearchdownload`, `jg_showsearchfavourite`, `jg_search_report_images`, `jg_showsearcheditorlinks`, `jg_showallpics`, `jg_showallhits`, `jg_showbacklink`, `jg_suppresscredits`, `jg_showuserpanel`, `jg_showuserpanel_hint`, `jg_showuserpanel_unreg`, `jg_showallpicstoadmin`, `jg_showminithumbs`, `jg_openjs_padding`, `jg_openjs_background`, `jg_dhtml_border`, `jg_show_title_in_popup`, `jg_show_description_in_popup`, `jg_lightbox_speed`, `jg_lightbox_slide_all`, `jg_resize_js_image`, `jg_disable_rightclick_original`, `jg_showgallerysubhead`, `jg_showallcathead`, `jg_colcat`, `jg_catperpage`, `jg_ordercatbyalpha`, `jg_showgallerypagenav`, `jg_showcatcount`, `jg_showcatthumb`, `jg_showrandomcatthumb`, `jg_ctalign`, `jg_showtotalcatimages`, `jg_showtotalcathits`, `jg_showcatasnew`, `jg_catdaysnew`, `jg_showdescriptioningalleryview`, `jg_uploadicongallery`, `jg_showsubsingalleryview`, `jg_category_rss`, `jg_category_rss_icon`, `jg_uploadiconcategory`, `jg_showcathead`, `jg_usercatorder`, `jg_usercatorderlist`, `jg_showcatdescriptionincat`, `jg_showpagenav`, `jg_showpiccount`, `jg_perpage`, `jg_catthumbalign`, `jg_colnumb`, `jg_detailpic_open`, `jg_lightboxbigpic`, `jg_showtitle`, `jg_showpicasnew`, `jg_daysnew`, `jg_showhits`, `jg_showdownloads`, `jg_showauthor`, `jg_showowner`, `jg_showcatcom`, `jg_showcatrate`, `jg_showcatdescription`, `jg_showcategorydownload`, `jg_showcategoryfavourite`, `jg_category_report_images`, `jg_showcategoryeditorlinks`, `jg_showsubcathead`, `jg_showsubcatcount`, `jg_colsubcat`, `jg_subperpage`, `jg_showpagenavsubs`, `jg_subcatthumbalign`, `jg_showsubthumbs`, `jg_showrandomsubthumb`, `jg_showdescriptionincategoryview`, `jg_ordersubcatbyalpha`, `jg_showtotalsubcatimages`, `jg_showtotalsubcathits`, `jg_uploadiconsubcat`, `jg_showdetailpage`, `jg_disabledetailpage`, `jg_showdetailnumberofpics`, `jg_cursor_navigation`, `jg_disable_rightclick_detail`, `jg_detail_report_images`, `jg_showdetaileditorlinks`, `jg_showdetailtitle`, `jg_showdetail`, `jg_showdetailaccordion`, `jg_accordionduration`, `jg_accordiondisplay`, `jg_accordionopacity`, `jg_accordionalwayshide`, `jg_accordioninitialeffect`, `jg_showdetaildescription`, `jg_showdetaildatum`, `jg_showdetailhits`, `jg_showdetaildownloads`, `jg_showdetailrating`, `jg_showdetailfilesize`, `jg_showdetailauthor`, `jg_showoriginalfilesize`, `jg_showdetaildownload`, `jg_watermark`, `jg_watermarkpos`, `jg_watermarkzoom`, `jg_watermarksize`, `jg_bigpic`, `jg_bigpic_unreg`, `jg_bigpic_open`, `jg_bbcodelink`, `jg_showcommentsunreg`, `jg_showcommentsarea`, `jg_send2friend`, `jg_minis`, `jg_motionminis`, `jg_motionminiWidth`, `jg_motionminiHeight`, `jg_motionminiLimit`, `jg_miniWidth`, `jg_miniHeight`, `jg_minisprop`, `jg_nameshields`, `jg_nameshields_others`, `jg_nameshields_unreg`, `jg_show_nameshields_unreg`, `jg_nameshields_height`, `jg_nameshields_width`, `jg_slideshow`, `jg_slideshow_timer`, `jg_slideshow_transition`, `jg_slideshow_transtime`, `jg_slideshow_maxdimauto`, `jg_slideshow_width`, `jg_slideshow_heigth`, `jg_slideshow_infopane`, `jg_slideshow_carousel`, `jg_slideshow_arrows`, `jg_slideshow_repeat`, `jg_showexifdata`, `jg_showgeotagging`, `jg_geotaggingkey`, `jg_subifdtags`, `jg_ifdotags`, `jg_gpstags`, `jg_showiptcdata`, `jg_iptctags`, `jg_showtoplist`, `jg_toplist`, `jg_topthumbalign`, `jg_toptextalign`, `jg_toplistcols`, `jg_whereshowtoplist`, `jg_showrate`, `jg_showlatest`, `jg_showcom`, `jg_showthiscomment`, `jg_showmostviewed`, `jg_showtoplistdownload`, `jg_showtoplistfavourite`, `jg_toplist_report_images`, `jg_showtoplisteditorlinks`, `jg_favourites`, `jg_favouritesshownotauth`, `jg_maxfavourites`, `jg_zipdownload`, `jg_usefavouritesforpubliczip`, `jg_usefavouritesforzip`, `jg_allimagesofcategory`, `jg_showfavouritesdownload`, `jg_showfavouriteseditorlinks`) VALUES
(1, 1, 1, 'images/joomgallery/details/', 'images/joomgallery/originals/', 'images/joomgallery/thumbnails/', 'administrator/components/com_joomgallery/temp/ftp_upload/', 'administrator/components/com_joomgallery/temp/', 'media/joomgallery/images/', 'watermark.png', 1, 1, 1, 'Š|S,Œ|O,Ž|Z,š|s,œ|oe,ž|z,Ÿ|Y,¥|Y,µ|u,À|A,Á|A,Â|A,Ã|A,Ä|AE,Å|A,Æ|A,Ç|C,È|E,É|E,Ê|E,Ë|E,Ì|I,Í|I,Î|I,Ï|I,Ð|D,Ñ|N,Ò|O,Ó|O,Ô|O,Õ|O,Ö|OE,Ø|O,Ù|U,Ú|U,Û|U,Ü|UE,Ý|Y,à|a,á|a,â|a,ã|a,ä|ae,å|a,æ|a,ç|c,è|e,é|e,ê|e,ë|e,ì|i,í|i,î|i,ï|i,ð|o,ñ|n,ò|o,ó|o,ô|o,õ|o,ö|oe,ø|o,ù|u,ú|u,û|u,ü|ue,ý|y,ÿ|y,ß|ss,ă|a,ş|s,ţ|t,ț|t,Ț|T,Ș|S,ș|s,Ş|S', 'gd2', 1, '', 1, 1900, 100, 2, 2, 768, 540, 100, 2, 1, 1, 0, 2, '-1', 2, '-1', 0, 2, '-1', 0, 2, '-1', 1, 0, 2, '-1', 0, 1, 0, 0, 1, '', 0, 0, 25, 0, 0, 0, 0, 10, 500, 0, 2000000, 1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 2, 1, 0, 5, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 'grey', 0, 1, 1, '_:default', 0, 0, 0, 2, 100, 100, '#ffffff', 0, 0, 0, 1, 0, 'ordering ASC', 'imgdate DESC', 'imgtitle DESC', '#page_title - [! COM_JOOMGALLERY_COMMON_CATEGORY!]: #cat', '#page_title - [! COM_JOOMGALLERY_COMMON_CATEGORY!]: #cat - [! COM_JOOMGALLERY_COMMON_IMAGE!]:  #img', 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '#000000', '#808080', 1, 1, 5, 1, 1, 1, 1, 0, 3, 9, 0, 1, 0, 1, 3, 3, 0, 0, 0, 7, 0, 0, 0, 10, '0', 0, 0, 0, 'date', 0, 3, 0, 9, 3, 3, 'fancyBox', 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 9, 1, 3, 2, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 300, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 15, 0, 0, '6', 0, 0, 1, 0, 0, 2, 400, 50, 0, 28, 28, 2, 0, 1, 1, 0, 10, 6, 0, 6000, 0, 2000, 0, 640, 480, 0, 0, 0, 0, 0, 0, '', '', '', '', 0, '', 0, 12, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

DROP TABLE IF EXISTS `#__joomgallery_countstop`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_countstop` (
  `cspicid` int(11) NOT NULL DEFAULT '0',
  `csip` varchar(20) NOT NULL,
  `cssessionid` varchar(200) DEFAULT NULL,
  `cstime` datetime DEFAULT NULL,
  KEY `idx_cspicid` (`cspicid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__joomgallery_countstop` (`cspicid`, `csip`, `cssessionid`, `cstime`) VALUES
(219, '::1', 'VnASaXKwCjt25MVwuahjg4nYqf8b3nya', '2018-03-14 13:49:38');

DROP TABLE IF EXISTS `#__joomgallery_image_details`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_image_details` (
  `id` int(11) NOT NULL,
  `details_key` varchar(255) NOT NULL,
  `details_value` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`,`details_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_maintenance`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_maintenance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `owner` int(11) NOT NULL,
  `title` text NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `img` varchar(255) NOT NULL,
  `orig` varchar(255) NOT NULL,
  `thumborphan` int(11) NOT NULL,
  `imgorphan` int(11) NOT NULL,
  `origorphan` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_nameshields`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_nameshields` (
  `nid` int(11) NOT NULL AUTO_INCREMENT,
  `npicid` int(11) NOT NULL DEFAULT '0',
  `nuserid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `nxvalue` int(11) NOT NULL DEFAULT '0',
  `nyvalue` int(11) NOT NULL DEFAULT '0',
  `by` int(11) NOT NULL DEFAULT '0',
  `nuserip` varchar(15) NOT NULL DEFAULT '0',
  `ndate` datetime NOT NULL,
  `nzindex` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`),
  KEY `idx_picid` (`npicid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_orphans`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_orphans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullpath` varchar(255) NOT NULL,
  `type` varchar(7) NOT NULL,
  `refid` int(11) NOT NULL,
  `title` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fullpath` (`fullpath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_users`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_users` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `uuserid` int(11) NOT NULL DEFAULT '0',
  `piclist` text,
  `layout` int(1) NOT NULL,
  `time` datetime NOT NULL,
  `zipname` varchar(70) NOT NULL,
  PRIMARY KEY (`uid`),
  KEY `idx_uid` (`uuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_votes`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_votes` (
  `voteid` int(11) NOT NULL AUTO_INCREMENT,
  `picid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `userip` varchar(15) NOT NULL DEFAULT '0',
  `datevoted` datetime NOT NULL,
  `vote` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`voteid`),
  KEY `idx_picid` (`picid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_acl`;
CREATE TABLE IF NOT EXISTS `#__komento_acl` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cid` varchar(255) NOT NULL,
  `component` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `komento_acl_content_type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `#__komento_acl` (`id`, `cid`, `component`, `type`, `rules`) VALUES
(1, '1', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":false,\"report_comment\":false,\"share_comment\":true,\"reply_comment\":false,\"upload_attachment\":false,\"download_attachment\":true,\"edit_own_comment\":false,\"delete_own_comment\":false,\"delete_own_attachment\":false,\"author_edit_comment\":false,\"author_delete_comment\":false,\"author_publish_comment\":false,\"author_unpublish_comment\":false,\"author_stick_comment\":false,\"author_delete_attachment\":false,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":false,\"unpublish_all_comment\":false,\"stick_all_comment\":false,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(2, '9', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":false,\"report_comment\":false,\"share_comment\":true,\"reply_comment\":false,\"upload_attachment\":false,\"download_attachment\":true,\"edit_own_comment\":false,\"delete_own_comment\":false,\"delete_own_attachment\":false,\"author_edit_comment\":false,\"author_delete_comment\":false,\"author_publish_comment\":false,\"author_unpublish_comment\":false,\"author_stick_comment\":false,\"author_delete_attachment\":false,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":false,\"unpublish_all_comment\":false,\"stick_all_comment\":false,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(3, '2', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":false,\"delete_own_comment\":false,\"delete_own_attachment\":false,\"author_edit_comment\":false,\"author_delete_comment\":false,\"author_publish_comment\":false,\"author_unpublish_comment\":false,\"author_stick_comment\":false,\"author_delete_attachment\":false,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":false,\"unpublish_all_comment\":false,\"stick_all_comment\":false,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(4, '6', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":true,\"delete_own_comment\":true,\"delete_own_attachment\":true,\"author_edit_comment\":false,\"author_delete_comment\":false,\"author_publish_comment\":false,\"author_unpublish_comment\":false,\"author_stick_comment\":false,\"author_delete_attachment\":false,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":false,\"unpublish_all_comment\":false,\"stick_all_comment\":false,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(5, '7', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":true,\"delete_own_comment\":true,\"delete_own_attachment\":true,\"author_edit_comment\":false,\"author_delete_comment\":false,\"author_publish_comment\":false,\"author_unpublish_comment\":false,\"author_stick_comment\":false,\"author_delete_attachment\":false,\"edit_all_comment\":true,\"delete_all_comment\":true,\"publish_all_comment\":true,\"unpublish_all_comment\":true,\"stick_all_comment\":true,\"delete_all_attachment\":true,\"read_others_comment\":true}'),
(6, '3', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":true,\"delete_own_comment\":false,\"delete_own_attachment\":false,\"author_edit_comment\":true,\"author_delete_comment\":true,\"author_publish_comment\":true,\"author_unpublish_comment\":true,\"author_stick_comment\":true,\"author_delete_attachment\":true,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":false,\"unpublish_all_comment\":false,\"stick_all_comment\":false,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(7, '4', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":true,\"delete_own_comment\":false,\"delete_own_attachment\":false,\"author_edit_comment\":true,\"author_delete_comment\":true,\"author_publish_comment\":true,\"author_unpublish_comment\":true,\"author_stick_comment\":true,\"author_delete_attachment\":true,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":false,\"unpublish_all_comment\":false,\"stick_all_comment\":false,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(8, '5', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":true,\"delete_own_comment\":false,\"delete_own_attachment\":false,\"author_edit_comment\":true,\"author_delete_comment\":true,\"author_publish_comment\":true,\"author_unpublish_comment\":true,\"author_stick_comment\":true,\"author_delete_attachment\":true,\"edit_all_comment\":false,\"delete_all_comment\":false,\"publish_all_comment\":true,\"unpublish_all_comment\":true,\"stick_all_comment\":true,\"delete_all_attachment\":false,\"read_others_comment\":true}'),
(9, '8', 'com_content', 'usergroup', '{\"read_comment\":true,\"read_stickies\":true,\"read_lovies\":true,\"add_comment\":true,\"like_comment\":true,\"report_comment\":true,\"share_comment\":true,\"reply_comment\":true,\"upload_attachment\":true,\"download_attachment\":true,\"edit_own_comment\":true,\"delete_own_comment\":true,\"delete_own_attachment\":true,\"author_edit_comment\":true,\"author_delete_comment\":true,\"author_publish_comment\":true,\"author_unpublish_comment\":true,\"author_stick_comment\":true,\"author_delete_attachment\":true,\"edit_all_comment\":true,\"delete_all_comment\":true,\"publish_all_comment\":true,\"unpublish_all_comment\":true,\"stick_all_comment\":true,\"delete_all_attachment\":true,\"read_others_comment\":true}');

DROP TABLE IF EXISTS `#__komento_actions`;
CREATE TABLE IF NOT EXISTS `#__komento_actions` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `comment_id` bigint(20) UNSIGNED NOT NULL,
  `action_by` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `actioned` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `komento_actions` (`type`,`comment_id`,`action_by`),
  KEY `komento_actions_comment_id` (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_activities`;
CREATE TABLE IF NOT EXISTS `#__komento_activities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `comment_id` bigint(20) NOT NULL,
  `uid` bigint(20) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

INSERT INTO `#__komento_activities` (`id`, `type`, `comment_id`, `uid`, `created`, `published`) VALUES
(2, 'comment', 30, 0, '2016-05-06 14:28:30', 1),
(3, 'comment', 29, 0, '2016-05-06 14:28:30', 1),
(4, 'comment', 50, 0, '2016-05-06 14:28:41', 1),
(5, 'comment', 49, 0, '2016-05-06 14:28:41', 1),
(6, 'comment', 48, 0, '2016-05-06 14:28:41', 1),
(7, 'comment', 47, 0, '2016-05-06 14:28:41', 1),
(8, 'comment', 46, 0, '2016-05-06 14:28:41', 1),
(9, 'comment', 45, 0, '2016-05-06 14:28:41', 1),
(10, 'comment', 44, 0, '2016-05-06 14:28:41', 1),
(11, 'comment', 43, 0, '2016-05-06 14:28:41', 1),
(12, 'comment', 42, 0, '2016-05-06 14:28:41', 1),
(13, 'comment', 41, 0, '2016-05-06 14:28:41', 1),
(14, 'comment', 40, 0, '2016-05-06 14:28:41', 1),
(15, 'comment', 39, 0, '2016-05-06 14:28:41', 1),
(16, 'comment', 38, 0, '2016-05-06 14:28:41', 1),
(17, 'comment', 37, 0, '2016-05-06 14:28:41', 1),
(18, 'comment', 36, 0, '2016-05-06 14:28:41', 1),
(19, 'comment', 35, 0, '2016-05-06 14:28:41', 1),
(20, 'comment', 34, 0, '2016-05-06 14:28:41', 1),
(21, 'comment', 33, 0, '2016-05-06 14:28:41', 1),
(22, 'comment', 32, 0, '2016-05-06 14:28:41', 1),
(23, 'comment', 31, 0, '2016-05-06 14:28:41', 1);

DROP TABLE IF EXISTS `#__komento_captcha`;
CREATE TABLE IF NOT EXISTS `#__komento_captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `response` varchar(5) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_comments`;
CREATE TABLE IF NOT EXISTS `#__komento_comments` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL,
  `cid` bigint(20) UNSIGNED NOT NULL,
  `comment` text,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `ip` varchar(255) DEFAULT '',
  `created_by` bigint(20) UNSIGNED DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) UNSIGNED DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `deleted_by` bigint(20) UNSIGNED DEFAULT '0',
  `deleted` datetime DEFAULT '0000-00-00 00:00:00',
  `flag` tinyint(1) DEFAULT '0',
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `sticked` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `sent` tinyint(1) DEFAULT '0',
  `parent_id` int(11) UNSIGNED DEFAULT '0',
  `lft` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `rgt` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `depth` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `address` text,
  `params` text,
  `ratings` int(11) UNSIGNED DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `komento_threaded` (`component`,`cid`,`published`,`lft`,`rgt`),
  KEY `komento_threaded_reverse` (`component`,`cid`,`published`,`rgt`),
  KEY `komento_module_comments` (`component`,`cid`,`published`,`created`),
  KEY `komento_backend` (`parent_id`,`created`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8;

INSERT INTO `#__komento_comments` (`id`, `component`, `cid`, `comment`, `name`, `title`, `email`, `url`, `ip`, `created_by`, `created`, `modified_by`, `modified`, `deleted_by`, `deleted`, `flag`, `published`, `publish_up`, `publish_down`, `sticked`, `sent`, `parent_id`, `lft`, `rgt`, `depth`, `latitude`, `longitude`, `address`, `params`, `ratings`) VALUES
(1, 'com_content', 118, 'The author did a great job with all these research work. Really valuable information, thank you!', 'James Bernard', '', 'james_bernard@gmail.com', '', '127.0.0.1', 0, '2014-05-03 09:58:29', 846, '2015-10-15 12:20:08', 0, '0000-00-00 00:00:00', 0, 0, '2015-02-25 13:41:36', '2016-04-01 05:36:34', 0, 0, 0, 1, 4, 0, '', '', '', '{}', 0),
(2, 'com_content', 118, 'Completely agree with the author. Modern businessmen should involve young people, introduce brands to them, socialize… Looks like a fresh product market!', 'Bill Brown', '', 'bill_brown@gmail.com', '', '127.0.0.1', 0, '2014-05-03 09:59:15', 846, '2015-10-15 12:20:34', 0, '0000-00-00 00:00:00', 0, 0, '2014-05-03 09:59:30', '2016-04-01 05:36:27', 0, 0, 0, 5, 8, 0, '', '', '', '{}', 0),
(3, 'com_content', 118, 'That’s awesome! Future belongs to youngsters, so businessmen can’t ignore their needs in any case.', 'Demo User', '', 'demo@demoolink.org', '', '127.0.0.1', 846, '2014-05-03 10:02:21', 846, '2015-10-15 12:20:52', 0, '0000-00-00 00:00:00', 0, 0, '2014-05-03 10:02:21', '2016-04-01 05:36:27', 0, 0, 2, 6, 7, 1, '', '', '', '{}', 0),
(4, 'com_content', 118, 'fdghfsdfg', 'asdasd', '', 'asdas@r.ru', '', '192.168.9.111', 0, '2015-07-03 14:13:52', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 9, 10, 0, '', '', '', NULL, 0),
(5, 'com_content', 118, 'DSFGJHGDFDGH', 'asdsad', '', 'ssad@r.ru', '', '192.168.9.111', 0, '2015-07-03 14:21:06', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 11, 12, 0, '', '', '', NULL, 0),
(29, 'com_content', 118, 'I\'ve already been to this show several times. Each time the organizers have something to amaze the visitors with - various kinds of vehicles, new concept cars, amazing presentations etc. Last year exhibition was outstanding, and I think this show is definitely worth visiting.', 'Diane Howard', '', 'howard@demolink.org', '', '::1', 0, '2016-05-06 14:12:10', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:30', '0000-00-00 00:00:00', 0, 0, 0, 13, 14, 0, '', '', '', '{}', 0),
(30, 'com_content', 118, 'I believe all enthusiasts know about this show. As for me, I was really excited when I visited it in Ontario, Canada, 6 years ago. I hope it has not changed much or at least changed for the better, as it is the only source of getting the latest information about motor industry trends and its fresh news.', 'James Cox', '', 'cox@demolink.org', '', '::1', 0, '2016-05-06 14:12:58', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:30', '0000-00-00 00:00:00', 0, 0, 0, 15, 16, 0, '', '', '', '{}', 0),
(31, 'com_content', 119, 'Wow, it\'s great news! I am a big fan of everything Fox TV produces, especially of their successful show \"Bones\" that has already experienced more than 10 years of broadcast. I will certainly invite my friends to this highly anticipated event!', 'Keith Hernandez', '', 'hernandez@demolink.org', '', '::1', 0, '2016-05-06 14:14:11', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(32, 'com_content', 119, 'I heard enough rumors about this event from executive directors and employees of other American TV channels but still couldn\'t believe it can be done in such scale. However, I am satisfied that Fox\'s board of directors decided to make this venture real, and I hope it will be successful.', 'Fred Martin', '', 'martin@demolink.org', '', '::1', 0, '2016-05-06 14:14:40', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(33, 'com_content', 120, 'The works by Mr. Lewis have always attracted me with their topicality, and his civic stand is the reason why I became a specialist in ecology. I am glad that his ideas will be used to change the situation of environment protection in our world.', 'Nancy Phillips', '', 'phillips@demolink.org', '', '::1', 0, '2016-05-06 14:15:32', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(34, 'com_content', 120, 'I do not support Jerry C. Lewis in everything he does, but his latest ideas and initiatives are really worthy ones. I hope they can be implemented in the world\'s governmental acts without any difficulties. The issue of climate regulation and environmental protection is now the most critical one.', 'Russell Hughes', '', 'hughes@demolink.org', '', '::1', 0, '2016-05-06 14:16:22', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(35, 'com_content', 15, 'I haven\'t expected science can be beneficial to studying human feelings and emotions. However, the result of the research appeared to be quite predictable. Music is often the only relief for me when I feel depressed or sad. Still, we have to respect the tastes of others as it is a key to our musical satisfaction.', 'Rose Torres', '', 'torres@demolink.org', '', '::1', 0, '2016-05-06 14:19:55', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(36, 'com_content', 15, 'I\'m not surprised that scientists have come to such a result. Music has been human\'s concomitant since the beginning of our civilization and I think music and humanity are closely connected. However, if you do not enjoy a certain style, it will be hard for you to benefit from music emotionally.', 'Daniel Richards', '', 'richards@demolink.org', '', '::1', 0, '2016-05-06 14:20:19', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(37, 'com_content', 8, 'As a resident of Miami, I\'m not very satisfied with the decision of organizers to change the venue. However, it must have really been a forced step. I hope this year fair will be worthy or even better than last year. And I hope Miami Exhibition Center will become available again next year.', 'Jonathan Russell', '', 'russell@demolink.org', '', '::1', 0, '2016-05-06 14:20:57', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(38, 'com_content', 8, 'As for me, the American Tea and Coffee Fair is one of the most original events devoted to two widely spread drinks. If you love tea and enjoy drinking coffee, this fair is number one event for you. You can freely invite your family and friends to visit it and benefit from your free time.', 'Peter Clark', '', 'clark@demolink.org', '', '::1', 0, '2016-05-06 14:21:52', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(39, 'com_content', 14, 'My sister has been talking a lot about Bernard\'s pictures and his special approach to every masterpiece he creates. It all sounded so interesting that I could not resist visiting his exhibition in Dallas 3 months ago. What I saw surpassed my expectations. James\'s works are really spectacular. If you live in LA, I recommend you to visit the upcoming exhibition in this city.', 'Russell Turner', '', 'turner@demolink.org', '', '::1', 0, '2016-05-06 14:22:25', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(40, 'com_content', 14, 'Great news! I visited the exhibition of Bernard\'s Art School in 2010 and it was spectacular. I was completely satisfied with what I saw last month in Miami at his art exhibition. You should definitely visit the upcoming one in LA, you won\'t regret!', 'Jim Johnson', '', 'johnson@demolink.org', '', '::1', 0, '2016-05-06 14:22:58', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(41, 'com_content', 12, 'I doubt that simple discussion can change anything in our country, but if you really have an idea to share, this is your chance to shake our government up. It\'s quite a good initiative, but to my mind, it will only work when all results of discussion are formed into real suggestions for statesmen.', 'Bonnie Ross', '', 'ross@demolink.org', '', '::1', 0, '2016-05-06 14:23:38', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(42, 'com_content', 12, 'I hope this project will change something in our social and political state because many of our state\'s residents are really fed up with the current situation including the world economic crisis, poverty, overpopulation etc.', 'Katherine Cook', '', 'cook@demolink.org', '', '::1', 0, '2016-05-06 14:24:09', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(43, 'com_content', 13, 'I am grateful for the opportunities you provide to everyone who wants to learn basic and advanced defense skills. Every evening I have to make my way through a dangerous area, and your course is a real rescue for me.', 'Jane Ramirez', '', 'ramirez@demolink.org', '', '::1', 0, '2016-05-06 14:24:37', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(44, 'com_content', 13, 'This course includes everything you may need to learn basic self-defense skills. As a professional fighter, I recommend you to check out the video tutorials of Bradley Roberts. He is the acknowledged and licensed professional in self-defense and martial arts. With his guidance, you can benefit from learning how to defend yourself.', 'Wesley Mills', '', 'mills@demolink.org', '', '::1', 0, '2016-05-06 14:25:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(45, 'com_content', 9, 'Management is an important element of every company\'s work, but cost management is even more important because it gives every businessman an opportunity to control the financial side of his company, and manage its resources effectively.', 'Kelly Murphy', '', 'murphy@demolink.org', '', '::1', 0, '2016-05-06 14:25:39', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(46, 'com_content', 9, 'It\'s amazing! These services have really helped my company to manage several important projects and to establish good reputation of my business. And I think if cost management is applied correctly, it can improve the whole financial state of any company.', 'Kate Doyle', '', 'doyle@demolink.org', '', '::1', 0, '2016-05-06 14:26:04', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(47, 'com_content', 10, 'My town has always been deprived of the latest technological achievements of humanity. It\'s great news that our government has supported this initiative. I hope we will have high-quality digital television network by next year.', 'Bert McGuire', '', 'mcguire@demolink.org', '', '::1', 0, '2016-05-06 14:26:36', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(48, 'com_content', 10, 'This initiative may seem very risky, but I am very glad that my city is one of the first introduced to the digital broadcasting technologies and entertainment in my country.', 'Brandon Morrison', '', 'morrison@demolink.org', '', '::1', 0, '2016-05-06 14:27:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0),
(49, 'com_content', 11, 'My younger sister was not interested in reading books at all until we visited this exhibition. It was an experience full of positive emotions and great impressions. The most important fact is that the event aroused her interest in reading, though I didn\'t expect it to happen.', 'Mary Lee', '', 'lee@demolink.org', '', '::1', 0, '2016-05-06 14:27:39', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 1, 2, 0, '', '', '', '{}', 0),
(50, 'com_content', 11, 'My son had a lot of fun at the exhibition - he took photos of his favorite book heroes, read some short stories by young yet exceptionally talented authors and had a good time at the CBE\'s playground. It was a perfect opportunity to spend our free time and learn something new.', 'Michael jenkins', '', 'jenkins@demolink.org', '', '::1', 0, '2016-05-06 14:28:05', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 1, '2016-05-06 14:28:41', '0000-00-00 00:00:00', 0, 0, 0, 3, 4, 0, '', '', '', '{}', 0);

DROP TABLE IF EXISTS `#__komento_configs`;
CREATE TABLE IF NOT EXISTS `#__komento_configs` (
  `component` varchar(255) NOT NULL,
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__komento_configs` (`component`, `params`) VALUES
('com_komento_comments_columns', '{\"column_comment\":\"1\",\"column_published\":\"1\",\"column_sticked\":\"1\",\"column_link\":\"1\",\"column_edit\":\"1\",\"column_component\":\"1\",\"column_article\":\"1\",\"column_date\":\"1\",\"column_author\":\"1\",\"column_id\":\"1\",\"column_email\":\"1\",\"column_homepage\":\"0\",\"column_ip\":\"0\",\"column_latitude\":\"0\",\"column_longitude\":\"0\",\"column_address\":\"0\"}'),
('com_komento_pending_columns', '{\"column_comment\":1,\"column_published\":1,\"column_link\":1,\"column_edit\":1,\"column_component\":1,\"column_article\":1,\"column_date\":1,\"column_author\":1,\"column_id\":1}'),
('com_komento_reports_columns', '{\"column_comment\":1,\"column_published\":1,\"column_link\":1,\"column_edit\":1,\"column_component\":1,\"column_article\":1,\"column_date\":1,\"column_author\":1,\"column_id\":1}'),
('com_komento', '{\"profile_enable\":\"0\",\"profile_tab_comments\":\"1\",\"profile_tab_activities\":\"1\",\"profile_tab_popular\":\"1\",\"profile_tab_sticked\":\"1\",\"name_type\":\"default\",\"layout_avatar_integration\":\"gravatar\",\"layout_phpbb_path\":\"\",\"layout_phpbb_url\":\"\",\"profile_activities_comments\":\"1\",\"profile_activities_replies\":\"1\",\"profile_activities_likes\":\"1\"}'),
('com_content', '{\"enable_komento\":\"1\",\"disable_komento_on_tmpl_component\":\"1\",\"allowed_categories_mode\":\"1\",\"allowed_categories\":[\"11\",\"12\",\"13\",\"14\",\"15\",\"48\",\"49\",\"50\",\"51\",\"52\",\"53\",\"54\"],\"enable_orphanitem_convert\":\"0\",\"orphanitem_ownership\":\"0\",\"enable_login_form\":\"0\",\"login_provider\":\"joomla\",\"enable_moderation\":\"1\",\"requires_moderation\":[\"1\",\"9\",\"2\"],\"subscription_auto\":\"0\",\"subscription_confirmation\":\"0\",\"pagebreak_load\":\"last\",\"antispam_akismet\":\"0\",\"antispam_akismet_key\":\"\",\"antispam_akismet_trackback\":\"0\",\"antispam_flood_control\":\"0\",\"antispam_flood_interval\":\"10\",\"antispam_min_length_enable\":\"0\",\"antispam_min_length\":\"10\",\"antispam_max_length_enable\":\"0\",\"antispam_max_length\":\"300\",\"filter_word\":\"0\",\"filter_word_text\":\"\",\"blacklist_ip\":\"\",\"antispam_captcha_enable\":\"0\",\"antispam_captcha_type\":\"0\",\"show_captcha\":[\"1\"],\"antispam_recaptcha_ssl\":\"0\",\"antispam_recaptcha_public_key\":\"\",\"antispam_recaptcha_private_key\":\"\",\"antispam_recaptcha_theme\":\"clean\",\"antispam_recaptcha_lang\":\"en\",\"layout_theme\":\"kuro\",\"enable_responsive\":\"1\",\"tabbed_comments\":\"0\",\"max_threaded_level\":\"5\",\"enable_threaded\":\"1\",\"thread_indentation\":\"20\",\"show_sort_buttons\":\"0\",\"default_sort\":\"oldest\",\"load_previous\":\"0\",\"max_comments_per_page\":\"10\",\"layout_template_override\":\"1\",\"layout_component_override\":\"1\",\"layout_inherit_kuro_css\":\"0\",\"layout_css_admin\":\"kmt-comment-item-admin\",\"layout_css_registered\":\"kmt-comment-item-registered\",\"layout_css_author\":\"kmt-comment-item-author\",\"layout_css_public\":\"kmt-comment-item-public\",\"name_type\":\"default\",\"guest_label\":\"1\",\"auto_hyperlink\":\"1\",\"links_nofollow\":\"1\",\"datetime_permalink\":\"1\",\"date_format\":\"l, M j Y g:i:sa\",\"max_image_width\":\"300\",\"max_image_height\":\"300\",\"allow_video\":\"1\",\"bbcode_video_width\":\"350\",\"bbcode_video_height\":\"350\",\"layout_frontpage_comment\":\"1\",\"layout_frontpage_readmore\":\"1\",\"layout_frontpage_readmore_use_joomla\":\"1\",\"layout_frontpage_hits\":\"0\",\"layout_frontpage_alignment\":\"left\",\"enable_lapsed_time\":\"1\",\"layout_avatar_enable\":\"1\",\"enable_guest_link\":\"0\",\"enable_permalink\":\"0\",\"enable_share\":\"1\",\"enable_likes\":\"1\",\"enable_reply\":\"1\",\"enable_report\":\"0\",\"enable_location\":\"0\",\"enable_info\":\"0\",\"enable_syntax_highlighting\":\"0\",\"enable_id\":\"0\",\"enable_reply_reference\":\"1\",\"enable_rank_bar\":\"0\",\"enable_live_notification\":\"1\",\"live_notification_interval\":\"30\",\"form_position\":\"0\",\"form_toggle_button\":\"0\",\"autohide_form_notification\":\"1\",\"form_show_moderate_message\":\"1\",\"scroll_to_comment\":\"1\",\"show_location\":\"0\",\"enable_bbcode\":\"0\",\"enable_subscription\":\"0\",\"tnc_text\":\"Before submitting the comment, you agree that:\\r\\n\\r\\na. To accept full responsibility for the comment that you submit.\\r\\nb. To use this function only for lawful purposes.\\r\\nc. Not to post defamatory, abusive, offensive, racist, sexist, threatening, vulgar, obscene, hateful or otherwise inappropriate comments, or to post comments which will constitute a criminal offense or give rise to civil liability.\\r\\nd. Not to post or make available any material which is protected by copyright, trade mark or other proprietary right without the express permission of the owner of the copyright, trade mark or any other proprietary right.\\r\\ne. To evaluate for yourself the accuracy of any opinion, advice or other content.\",\"show_name\":\"1\",\"show_email\":\"1\",\"show_website\":\"1\",\"require_name\":\"1\",\"require_email\":\"1\",\"require_website\":\"0\",\"enable_email_regex\":\"1\",\"email_regex\":[\"%5CS%2B%40%5CS%2B\"],\"enable_website_regex\":\"1\",\"website_regex\":[\"%28http%3A%2F%2F%7Cftp%3A%2F%2F%7Cwww%29%5CS%2B\"],\"layout_avatar_integration\":\"gravatar\",\"use_komento_profile\":\"1\",\"easysocial_profile_popbox\":\"0\",\"gravatar_default_avatar\":\"mm\",\"layout_phpbb_path\":\"\",\"layout_phpbb_url\":\"\",\"bbcode_bold\":\"1\",\"bbcode_italic\":\"1\",\"bbcode_underline\":\"1\",\"bbcode_link\":\"1\",\"bbcode_picture\":\"1\",\"bbcode_video\":\"1\",\"bbcode_bulletlist\":\"1\",\"bbcode_numericlist\":\"1\",\"bbcode_bullet\":\"1\",\"bbcode_quote\":\"1\",\"bbcode_code\":\"1\",\"bbcode_clean\":\"1\",\"bbcode_smile\":\"1\",\"bbcode_happy\":\"1\",\"bbcode_surprised\":\"1\",\"bbcode_tongue\":\"1\",\"bbcode_unhappy\":\"1\",\"bbcode_wink\":\"1\",\"smileycode\":[],\"smileypath\":[],\"share_facebook\":\"1\",\"share_twitter\":\"1\",\"share_googleplus\":\"1\",\"share_linkedin\":\"1\",\"share_tumblr\":\"1\",\"share_digg\":\"1\",\"share_delicious\":\"1\",\"share_reddit\":\"1\",\"share_stumbleupon\":\"1\",\"enable_conversation_bar\":\"0\",\"conversation_bar_max_authors\":\"10\",\"conversation_bar_include_guest\":\"0\",\"enable_stickies\":\"0\",\"max_stickies\":\"5\",\"enable_lovies\":\"0\",\"minimum_likes_lovies\":\"0\",\"max_lovies\":\"5\",\"syntaxhighlighter_theme\":\"default\",\"notification_enable\":\"0\",\"notification_sendmailonpageload\":\"0\",\"notification_sendmailinhtml\":\"0\",\"notification_event_new_comment\":\"0\",\"notification_event_new_reply\":\"0\",\"notification_event_new_pending\":\"0\",\"notification_event_reported_comment\":\"0\",\"notification_to_author\":\"0\",\"notification_to_subscribers\":\"0\",\"activities_comment\":\"1\",\"activities_reply\":\"1\",\"activities_like\":\"1\",\"trigger_method\":\"component\",\"target\":\"com_content\",\"tnc\":\"\",\"show_tnc\":[],\"notification_to_usergroup_comment\":[],\"notification_to_usergroup_reply\":[],\"notification_to_usergroup_pending\":[],\"notification_to_usergroup_reported\":[],\"notification_es_to_usergroup_comment\":[],\"notification_es_to_usergroup_reply\":[],\"notification_es_to_usergroup_like\":[]}');

DROP TABLE IF EXISTS `#__komento_hashkeys`;
CREATE TABLE IF NOT EXISTS `#__komento_hashkeys` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `uid` bigint(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `key` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_ipfilter`;
CREATE TABLE IF NOT EXISTS `#__komento_ipfilter` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `komento_ipfilter` (`component`,`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_mailq`;
CREATE TABLE IF NOT EXISTS `#__komento_mailq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mailfrom` varchar(255) DEFAULT NULL,
  `fromname` varchar(255) DEFAULT NULL,
  `recipient` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `created` datetime NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'text',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `komento_mailq_status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_subscription`;
CREATE TABLE IF NOT EXISTS `#__komento_subscription` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `component` varchar(255) NOT NULL,
  `cid` bigint(20) UNSIGNED NOT NULL,
  `userid` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `fullname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `komento_subscription` (`type`,`component`,`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__komento_uploads`;
CREATE TABLE IF NOT EXISTS `#__komento_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `filename` text NOT NULL,
  `hashname` text NOT NULL,
  `path` text,
  `created` datetime NOT NULL,
  `created_by` bigint(20) UNSIGNED DEFAULT '0',
  `published` tinyint(1) NOT NULL,
  `mime` text NOT NULL,
  `size` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__kunena_aliases`;
CREATE TABLE IF NOT EXISTS `#__kunena_aliases` (
  `alias` varchar(255) CHARACTER SET utf8 NOT NULL,
  `type` varchar(10) CHARACTER SET utf8 NOT NULL,
  `item` varchar(32) CHARACTER SET utf8 NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT '0',
  UNIQUE KEY `alias` (`alias`),
  KEY `state` (`state`),
  KEY `item` (`item`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_aliases` (`alias`, `type`, `item`, `state`) VALUES
('announcement', 'view', 'announcement', 1),
('category', 'view', 'category', 1),
('category/create', 'layout', 'category.create', 1),
('category/default', 'layout', 'category.default', 1),
('category/edit', 'layout', 'category.edit', 1),
('category/manage', 'layout', 'category.manage', 1),
('category/moderate', 'layout', 'category.moderate', 1),
('category/user', 'layout', 'category.user', 1),
('common', 'view', 'common', 1),
('create', 'layout', 'category.create', 0),
('credits', 'view', 'credits', 1),
('default', 'layout', 'category.default', 0),
('edit', 'layout', 'category.edit', 0),
('home', 'view', 'home', 1),
('ideal-forum', 'catid', '5', 0),
('kunena-the-communication-platform-for-joomla', 'catid', '4', 0),
('main-forum', 'catid', '1', 1),
('manage', 'layout', 'category.manage', 0),
('misc', 'view', 'misc', 1),
('moderate', 'layout', 'category.moderate', 0),
('more-about-the-kunena', 'catid', '6', 0),
('search', 'view', 'search', 1),
('statistics', 'view', 'statistics', 1),
('suggestion-box', 'catid', '3', 1),
('topic', 'view', 'topic', 1),
('topics', 'view', 'topics', 1),
('user', 'view', 'user', 1),
('welcome-mat', 'catid', '2', 1);

DROP TABLE IF EXISTS `#__kunena_announcement`;
CREATE TABLE IF NOT EXISTS `#__kunena_announcement` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `title` tinytext CHARACTER SET utf8 NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `sdescription` text CHARACTER SET utf8 NOT NULL,
  `description` text CHARACTER SET utf8 NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `showdate` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_attachments`;
CREATE TABLE IF NOT EXISTS `#__kunena_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mesid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `protected` tinyint(4) NOT NULL DEFAULT '0',
  `hash` char(32) CHARACTER SET utf8 DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `folder` varchar(255) CHARACTER SET utf8 NOT NULL,
  `filetype` varchar(20) CHARACTER SET utf8 NOT NULL,
  `filename` varchar(255) CHARACTER SET utf8 NOT NULL,
  `filename_real` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `caption` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `inline` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mesid` (`mesid`),
  KEY `userid` (`userid`),
  KEY `hash` (`hash`),
  KEY `filename` (`filename`),
  KEY `filename_real` (`filename_real`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_categories`;
CREATE TABLE IF NOT EXISTS `#__kunena_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `name` tinytext CHARACTER SET utf8,
  `alias` varchar(255) CHARACTER SET utf8 NOT NULL,
  `icon` varchar(60) CHARACTER SET utf8 DEFAULT NULL,
  `icon_id` tinyint(4) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `accesstype` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT 'joomla.level',
  `access` int(11) NOT NULL DEFAULT '0',
  `pub_access` int(11) NOT NULL DEFAULT '1',
  `pub_recurse` tinyint(4) DEFAULT '1',
  `admin_access` int(11) NOT NULL DEFAULT '0',
  `admin_recurse` tinyint(4) DEFAULT '1',
  `ordering` smallint(6) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `channels` text CHARACTER SET utf8,
  `checked_out` int(11) DEFAULT NULL,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review` tinyint(4) NOT NULL DEFAULT '0',
  `allow_anonymous` tinyint(4) NOT NULL DEFAULT '0',
  `post_anonymous` tinyint(4) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8 NOT NULL,
  `headerdesc` text CHARACTER SET utf8 NOT NULL,
  `topictemplate` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_sfx` varchar(20) CHARACTER SET utf8 NOT NULL,
  `allow_polls` tinyint(4) NOT NULL DEFAULT '0',
  `topic_ordering` varchar(16) CHARACTER SET utf8 NOT NULL DEFAULT 'lastpost',
  `iconset` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT 'default',
  `numTopics` mediumint(8) NOT NULL DEFAULT '0',
  `numPosts` mediumint(8) NOT NULL DEFAULT '0',
  `last_topic_id` int(11) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `last_post_time` int(11) NOT NULL DEFAULT '0',
  `allow_ratings` tinyint(4) NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `category_access` (`accesstype`,`access`),
  KEY `published_pubaccess_id` (`published`,`pub_access`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_categories` (`id`, `parent_id`, `name`, `alias`, `icon`, `icon_id`, `locked`, `accesstype`, `access`, `pub_access`, `pub_recurse`, `admin_access`, `admin_recurse`, `ordering`, `published`, `channels`, `checked_out`, `checked_out_time`, `review`, `allow_anonymous`, `post_anonymous`, `hits`, `description`, `headerdesc`, `topictemplate`, `class_sfx`, `allow_polls`, `topic_ordering`, `iconset`, `numTopics`, `numPosts`, `last_topic_id`, `last_post_id`, `last_post_time`, `allow_ratings`, `params`) VALUES
(1, 0, 'Main Forum', 'main-forum', '', 0, 0, 'joomla.group', 0, 1, 1, 0, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'This is the main forum section. It serves as a container for categories for your topics.', 'The section header is used to display additional information about the categories of topics that it contains.', '', '', 0, 'lastpost', 'default', 0, 0, 0, 0, 0, 0, ''),
(2, 1, 'Welcome Mat', 'welcome-mat', '', 0, 0, 'joomla.group', 1, 1, 1, 0, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'We encourage new members to introduce themselves here. Get to know one another and share your interests.', 'Welcome to the Kunena forum! Tell us and our members who you are, what you like and why you became a member of this site. We welcome all new members and hope to see you around a lot!', '', '', 0, 'lastpost', 'default', 1, 1, 1, 1, 1399057228, 0, '{\"access_post\":[\"6\",\"2\",\"8\"],\"access_reply\":[\"6\",\"2\",\"8\"]}'),
(3, 1, 'Suggestion Box', 'suggestion-box', '', 0, 0, 'joomla.group', 0, 1, 1, 0, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Have some feedback and input to share? \n Don\'t be shy and drop us a note. We want to hear from you and strive to make our site better and more user friendly for our guests and members a like.', 'This is the optional category header for the Suggestion Box.', '', '', 1, 'lastpost', 'default', 0, 0, 0, 0, 0, 0, ''),
(4, 0, 'Kunena, the Communication Platform for Joomla', 'kunena-the-communication-platform-for-joomla', '', 0, 0, 'joomla.level', 1, 1, 1, 8, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Kunena is the ideal forum extension for Joomla. It\'s free, fully integrated, and no bridges or hacks are required.', 'Want to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', '', '', 0, 'lastpost', 'default', 0, 0, 0, 0, 0, 0, '{}'),
(5, 4, 'Ideal forum', 'ideal-forum', '', 0, 0, 'joomla.level', 1, 1, 1, 8, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Kunena is the ideal forum extension for Joomla. It\'s free, fully integrated, and no bridges or hacks are required.', 'Kunena is the ideal forum extension for Joomla. It\'s free, fully integrated, and no bridges or hacks are required.', '', '', 0, 'lastpost', 'default', 1, 4, 2, 5, 1418121786, 0, '{\"access_post\":[\"6\",\"2\",\"8\"],\"access_reply\":[\"6\",\"2\",\"8\"]}'),
(6, 4, 'More about the Kunena', 'more-about-the-kunena', '', 0, 0, 'joomla.level', 1, 1, 1, 8, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Want to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', 'Want to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', '', '', 0, 'lastpost', 'default', 1, 2, 3, 7, 1418122011, 0, '{\"access_post\":[\"6\",\"2\",\"8\"],\"access_reply\":[\"6\",\"2\",\"8\"]}');

DROP TABLE IF EXISTS `#__kunena_configuration`;
CREATE TABLE IF NOT EXISTS `#__kunena_configuration` (
  `id` int(11) NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_configuration` (`id`, `params`) VALUES
(1, '{\"board_title\":\"Kunena\",\"email\":\"\",\"board_offline\":\"0\",\"offline_message\":\"The Forum is currently offline for maintenance.\\r\\nCheck back soon!\",\"enablerss\":\"0\",\"threads_per_page\":\"20\",\"messages_per_page\":\"6\",\"messages_per_page_search\":\"15\",\"showhistory\":\"1\",\"historylimit\":\"6\",\"shownew\":\"1\",\"disemoticons\":\"0\",\"template\":\"tm_custom\",\"showannouncement\":\"1\",\"avataroncat\":\"0\",\"catimagepath\":\"category_images\",\"showchildcaticon\":\"1\",\"rtewidth\":\"450\",\"rteheight\":\"300\",\"enableforumjump\":\"1\",\"reportmsg\":\"1\",\"username\":\"1\",\"askemail\":\"0\",\"showemail\":\"0\",\"showuserstats\":\"1\",\"showkarma\":\"1\",\"useredit\":\"1\",\"useredittime\":\"0\",\"useredittimegrace\":\"600\",\"editmarkup\":\"1\",\"allowsubscriptions\":\"1\",\"subscriptionschecked\":\"1\",\"allowfavorites\":\"1\",\"maxsubject\":\"50\",\"maxsig\":\"300\",\"regonly\":\"0\",\"pubwrite\":\"0\",\"floodprotection\":\"0\",\"mailmod\":\"0\",\"mailadmin\":\"0\",\"captcha\":\"0\",\"mailfull\":\"1\",\"allowavatarupload\":\"1\",\"allowavatargallery\":\"1\",\"avatarquality\":\"75\",\"avatarsize\":\"2048\",\"imageheight\":\"800\",\"imagewidth\":\"800\",\"imagesize\":\"150\",\"filetypes\":\"txt,rtf,pdf,zip,tar.gz,tgz,tar.bz2\",\"filesize\":\"120\",\"showranking\":\"1\",\"rankimages\":\"1\",\"userlist_rows\":\"30\",\"userlist_online\":\"1\",\"userlist_avatar\":\"1\",\"userlist_posts\":\"1\",\"userlist_karma\":\"1\",\"userlist_email\":\"0\",\"userlist_joindate\":\"1\",\"userlist_lastvisitdate\":\"1\",\"userlist_userhits\":\"1\",\"latestcategory\":\"\",\"showstats\":\"1\",\"showwhoisonline\":\"1\",\"showgenstats\":\"1\",\"showpopuserstats\":\"1\",\"popusercount\":\"5\",\"showpopsubjectstats\":\"1\",\"popsubjectcount\":\"5\",\"showspoilertag\":\"1\",\"showvideotag\":\"1\",\"showebaytag\":\"1\",\"trimlongurls\":\"1\",\"trimlongurlsfront\":\"40\",\"trimlongurlsback\":\"20\",\"autoembedyoutube\":\"1\",\"autoembedebay\":\"1\",\"ebaylanguagecode\":\"en-us\",\"sessiontimeout\":\"1800\",\"highlightcode\":\"0\",\"rss_type\":\"topic\",\"rss_timelimit\":\"month\",\"rss_limit\":\"100\",\"rss_included_categories\":\"\",\"rss_excluded_categories\":\"\",\"rss_specification\":\"rss2.0\",\"rss_allow_html\":\"1\",\"rss_author_format\":\"name\",\"rss_author_in_title\":\"1\",\"rss_word_count\":\"0\",\"rss_old_titles\":\"1\",\"rss_cache\":\"900\",\"defaultpage\":\"recent\",\"default_sort\":\"asc\",\"sef\":\"1\",\"showimgforguest\":\"1\",\"showfileforguest\":\"1\",\"pollnboptions\":\"4\",\"pollallowvoteone\":\"1\",\"pollenabled\":\"1\",\"poppollscount\":\"5\",\"showpoppollstats\":\"1\",\"polltimebtvotes\":\"00:15:00\",\"pollnbvotesbyuser\":\"100\",\"pollresultsuserslist\":\"1\",\"maxpersotext\":\"50\",\"ordering_system\":\"mesid\",\"post_dateformat\":\"ago\",\"post_dateformat_hover\":\"datetime\",\"hide_ip\":\"1\",\"imagetypes\":\"jpg,jpeg,gif,png\",\"checkmimetypes\":\"1\",\"imagemimetypes\":\"image\\/jpeg,image\\/jpg,image\\/gif,image\\/png\",\"imagequality\":\"50\",\"thumbheight\":\"32\",\"thumbwidth\":\"32\",\"hideuserprofileinfo\":\"put_empty\",\"boxghostmessage\":\"0\",\"userdeletetmessage\":\"0\",\"latestcategory_in\":\"1\",\"topicicons\":\"0\",\"debug\":\"0\",\"catsautosubscribed\":0,\"showbannedreason\":\"0\",\"showthankyou\":\"1\",\"showpopthankyoustats\":\"1\",\"popthankscount\":\"5\",\"mod_see_deleted\":\"0\",\"bbcode_img_secure\":\"text\",\"listcat_show_moderators\":\"1\",\"lightbox\":\"1\",\"show_list_time\":\"720\",\"show_session_type\":\"0\",\"show_session_starttime\":\"0\",\"userlist_allowed\":\"1\",\"userlist_count_users\":\"1\",\"enable_threaded_layouts\":\"0\",\"category_subscriptions\":\"post\",\"topic_subscriptions\":\"every\",\"pubprofile\":\"1\",\"thankyou_max\":\"10\",\"email_recipient_count\":\"0\",\"email_recipient_privacy\":\"bcc\",\"email_visible_address\":\"\",\"captcha_post_limit\":\"0\",\"image_upload\":\"registered\",\"file_upload\":\"registered\",\"topic_layout\":\"flat\",\"time_to_create_page\":\"0\",\"show_imgfiles_manage_profile\":\"1\",\"hold_newusers_posts\":\"0\",\"hold_guest_posts\":\"0\",\"attachment_limit\":\"8\",\"pickup_category\":\"0\",\"article_display\":\"intro\",\"send_emails\":\"1\",\"fallback_english\":\"1\",\"cache\":\"1\",\"cache_time\":\"60\",\"ebay_affiliate_id\":\"5337089937\",\"iptracking\":\"1\",\"rss_feedburner_url\":\"\",\"autolink\":\"1\",\"access_component\":\"1\",\"statslink_allowed\":\"1\",\"superadmin_userlist\":\"0\",\"legacy_urls\":\"1\",\"attachment_protection\":\"0\",\"categoryicons\":1,\"avatarresizemethod\":\"1\",\"avatarcrop\":\"0\",\"user_report\":\"1\",\"searchtime\":\"365\",\"teaser\":\"0\",\"ebay_language\":\"0\",\"ebay_api_key\":\"\",\"twitter_consumer_key\":\"\",\"twitter_consumer_secret\":\"\",\"allow_change_subject\":\"1\",\"max_links\":\"6\",\"read_only\":\"0\",\"ratingenabled\":\"0\",\"url_subject_topic\":\"0\",\"log_moderation\":\"0\",\"attach_start\":\"0\",\"attach_end\":\"14\",\"google_map_api_key\":\"\",\"attachment_utf8\":\"1\",\"autoembedsoundcloud\":\"1\",\"emailheader\":\"\\/media\\/kunena\\/email\\/hero-wide.png\",\"user_status\":\"1\",\"signature\":1,\"personal\":1,\"social\":1,\"plain_email\":\"0\",\"moderator_permdelete\":0,\"avatartypes\":\"gif, jpeg, jpg, png\",\"smartlinking\":0,\"defaultavatar\":\"nophoto.png\",\"defaultavatarsmall\":\"s_nophoto.png\",\"stopforumspam_key\":\"\",\"quickreply\":1,\"avataredit\":0,\"activemenuitem\":\"\",\"mainmenu_id\":\"\",\"home_id\":\"\",\"index_id\":\"\",\"moderators_id\":\"\",\"topiclist_id\":\"\",\"misc_id\":\"\",\"profile_id\":\"\",\"search_id\":\"\",\"avatar_type\":1,\"recaptcha_publickey\":\"\",\"recaptcha_privatekey\":\"\",\"recaptcha_theme\":\"white\",\"keywords\":0,\"userkeywords\":0,\"userlist_name\":\"1\",\"usernamechange\":\"0\",\"version_check\":\"1\",\"plugins\":[]}');

DROP TABLE IF EXISTS `#__kunena_logs`;
CREATE TABLE IF NOT EXISTS `#__kunena_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `topic_id` int(11) NOT NULL DEFAULT '0',
  `target_user` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(40) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `time` int(11) NOT NULL DEFAULT '0',
  `operation` varchar(40) CHARACTER SET utf8 NOT NULL,
  `data` mediumtext CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `category_id` (`category_id`),
  KEY `topic_id` (`topic_id`),
  KEY `target_user` (`target_user`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_messages`;
CREATE TABLE IF NOT EXISTS `#__kunena_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) DEFAULT '0',
  `thread` int(11) DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `name` tinytext CHARACTER SET utf8,
  `userid` int(11) NOT NULL DEFAULT '0',
  `email` tinytext CHARACTER SET utf8,
  `subject` tinytext CHARACTER SET utf8,
  `time` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `topic_emoticon` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) DEFAULT '0',
  `hits` int(11) DEFAULT '0',
  `moved` tinyint(4) DEFAULT '0',
  `modified_by` int(7) DEFAULT NULL,
  `modified_time` int(11) DEFAULT NULL,
  `modified_reason` tinytext CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `thread` (`thread`),
  KEY `ip` (`ip`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `locked` (`locked`),
  KEY `hold_time` (`hold`,`time`),
  KEY `parent_hits` (`parent`,`hits`),
  KEY `catid_parent` (`catid`,`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_messages` (`id`, `parent`, `thread`, `catid`, `name`, `userid`, `email`, `subject`, `time`, `ip`, `topic_emoticon`, `locked`, `hold`, `ordering`, `hits`, `moved`, `modified_by`, `modified_time`, `modified_reason`) VALUES
(1, 0, 1, 2, '', 317, '', 'Welcome to Kunena!', 1399057228, '127.0.0.1', 0, 0, 0, 0, 0, 0, 846, 1423728734, ''),
(2, 0, 2, 5, 'demo', 846, '', 'Morbi tincidunt sodales neque eu rutrum', 1415103771, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444812838, ''),
(3, 2, 2, 5, 'demo', 846, '', 'General Template Issues, Questions And Problems', 1415179292, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444813202, ''),
(4, 2, 2, 5, 'lorem_ipsum', 847, '', 'Personal diary in Kunena Forum', 1418121749, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444813240, ''),
(5, 2, 2, 5, 'lorem_ipsum', 847, '', 'Multiples templates (linked to forum categories)', 1418121786, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444813776, ''),
(6, 0, 3, 6, 'lorem_ipsum', 847, '', 'Pellentesque non libero', 1418121957, '192.168.9.17', 0, 0, 0, 0, 0, 0, NULL, NULL, ''),
(7, 6, 3, 6, 'dolor_sit', 848, '', 'Pellentesque non libero', 1418122011, '192.168.9.17', 0, 0, 0, 0, 0, 0, NULL, NULL, '');

DROP TABLE IF EXISTS `#__kunena_messages_text`;
CREATE TABLE IF NOT EXISTS `#__kunena_messages_text` (
  `mesid` int(11) NOT NULL DEFAULT '0',
  `message` mediumtext CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`mesid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_messages_text` (`mesid`, `message`) VALUES
(1, 'Thank you for choosing Kunena for your community forum needs in Joomla. \r\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \r\nAdditional Kunena Resources\r\nKunena Documentation: [url]http://www.kunena.org/docs[/url] \r\nKunena Support Forum: [url]http://www.kunena.org/forum[/url] \r\nKunena Downloads: [url]http://www.kunena.org/download[/url] \r\nKunena Blog: [url]http://www.kunena.org/blog[/url] \r\nFollow Kunena on Twitter: [url]http://www.kunena.org/twitter[/url]'),
(2, 'Kunena is the ideal forum extension for Joomla. It\'s free, fully integrated, and no bridges or hacks are required.\r\n\r\nWant to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.'),
(3, 'This is a community-driven self-help category to ask questions about designing or developing your own Kunena template. Please be aware that there are rules that apply to topics posted in this category:\r\n\r\n[b]Do not use this category for:[/b]\r\nasking questions about how to make simple changes to a template designed by the Kunena project team (use K 3.0 Templates instead);\r\nadvertising your own template designs.\r\n\r\nTopics that do not meet the above guidelines may be removed without notice.'),
(4, 'Hello mates. Can i setup Kunena Forum so that some user\'s notes (but not all) will be availible for other users and some not by their wish? The main idea is to create personalized diary of the users and functionality of Kunena Forum seems to be most suitable for this.'),
(5, 'Hi.\r\n\r\nI\'m looking to have 1 template for 1 categorie and an other template for all others catégories.\r\nSomeone he already well-considered the problem ?\r\n\r\nRegards.'),
(6, 'Sed justo felis, lacinia at scelerisque a, semper et ante. Fusce posuere lacus eu mi lacinia et fringilla elit sollicitudin. Maecenas non odio nunc. In ut sollicitudin magna. Sed sit amet tincidunt odio. Mauris pharetra adipiscing urna ut accumsan. Suspendisse nec risus in felis fermentum blandit.\r\n\r\nNam nec lectus ut orci porta volutpat id at purus. Sed sagittis congue dapibus. Proin dolor metus, pharetra ut pulvinar nec, condimentum quis libero. Sed fermentum tortor ac elit tristique vel dapibus sem porta. Suspendisse aliquet posuere ultrices. Proin facilisis libero lacinia erat pretium faucibus. In tortor nunc, posuere eget commodo et, eleifend vel risus.'),
(7, 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam erat volutpat. Pellentesque non libero dui, vitae pharetra urna. Vestibulum accumsan pulvinar magna sed consectetur. Nulla congue condimentum aliquam. Donec non libero lectus, id mollis nisi. Morbi turpis magna, varius in ullamcorper nec, suscipit sagittis nibh. Nam elementum aliquam turpis eget egestas. Cras ligula nisi, interdum et vulputate nec, sagittis a tellus. In hac habitasse platea dictumst. In in sem libero. Fusce cursus, metus eu commodo hendrerit, arcu nibh consequat lectus, nec suscipit eros urna in ipsum. Praesent et enim a nisl commodo sodales non id neque. Ut sodales dignissim massa vitae hendrerit. Sed porttitor purus ut ante fermentum quis mollis velit pellentesque.\r\n\r\nEtiam nisi felis, fermentum vitae ultrices non, euismod in magna. In mattis velit ut eros tristique a congue erat consequat. Suspendisse consequat, justo eu gravida semper, ligula turpis dignissim dolor, vitae lacinia velit metus id libero. Nullam consectetur rhoncus magna, quis pharetra tortor bibendum quis. Curabitur ac ante nisl. Nullam mauris arcu, malesuada eu consectetur non, eleifend quis est. Nullam dictum, leo vulputate elementum porttitor, enim mi posuere augue, id porttitor leo sapien sed libero. Quisque est velit, aliquam bibendum vestibulum eget, tristique a odio.');

DROP TABLE IF EXISTS `#__kunena_polls`;
CREATE TABLE IF NOT EXISTS `#__kunena_polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) CHARACTER SET utf8 DEFAULT NULL,
  `threadid` int(11) NOT NULL,
  `polltimetolive` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `threadid` (`threadid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_polls_options`;
CREATE TABLE IF NOT EXISTS `#__kunena_polls_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pollid` int(11) DEFAULT NULL,
  `text` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `votes` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pollid` (`pollid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_polls_users`;
CREATE TABLE IF NOT EXISTS `#__kunena_polls_users` (
  `pollid` int(11) DEFAULT NULL,
  `userid` int(11) DEFAULT NULL,
  `votes` int(11) DEFAULT NULL,
  `lasttime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvote` int(11) DEFAULT NULL,
  UNIQUE KEY `pollid` (`pollid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_ranks`;
CREATE TABLE IF NOT EXISTS `#__kunena_ranks` (
  `rank_id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `rank_title` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `rank_min` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `rank_special` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `rank_image` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  PRIMARY KEY (`rank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_ranks` (`rank_id`, `rank_title`, `rank_min`, `rank_special`, `rank_image`) VALUES
(1, 'New Member', 0, 0, 'rank1.gif'),
(2, 'Junior Member', 20, 0, 'rank2.gif'),
(3, 'Senior Member', 40, 0, 'rank3.gif'),
(4, 'Premium Member', 80, 0, 'rank4.gif'),
(5, 'Elite Member', 160, 0, 'rank5.gif'),
(6, 'Platinum Member', 320, 0, 'rank6.gif'),
(7, 'Administrator', 0, 1, 'rankadmin.gif'),
(8, 'Moderator', 0, 1, 'rankmod.gif'),
(9, 'Spammer', 0, 1, 'rankspammer.gif'),
(10, 'Banned', 0, 1, 'rankbanned.gif');

DROP TABLE IF EXISTS `#__kunena_rate`;
CREATE TABLE IF NOT EXISTS `#__kunena_rate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `rate` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_sessions`;
CREATE TABLE IF NOT EXISTS `#__kunena_sessions` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `allowed` text CHARACTER SET utf8,
  `lasttime` int(11) NOT NULL DEFAULT '0',
  `readtopics` text CHARACTER SET utf8,
  `currvisit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `currvisit` (`currvisit`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_sessions` (`userid`, `allowed`, `lasttime`, `readtopics`, `currvisit`) VALUES
(19, 'na', 1465478134, '0', 1466687744),
(55, 'na', 1444224132, '0', 1445433740),
(283, 'na', 1452089892, '0', 1452517940),
(757, 'na', 1475675596, '0', 1476885244),
(846, 'na', 1498456854, '0', 1508412960),
(847, 'na', 1416912031, '0', 1418121958),
(848, 'na', 1432031594, '0', 1432036031),
(895, 'na', 1469090890, '0', 1469094062);

DROP TABLE IF EXISTS `#__kunena_smileys`;
CREATE TABLE IF NOT EXISTS `#__kunena_smileys` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `code` varchar(12) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `location` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `greylocation` varchar(60) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `emoticonbar` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_smileys` (`id`, `code`, `location`, `greylocation`, `emoticonbar`) VALUES
(1, 'B)', 'cool.png', 'cool-grey.png', 1),
(2, '8)', 'cool.png', 'cool-grey.png', 0),
(3, '8-)', 'cool.png', 'cool-grey.png', 0),
(4, ':-(', 'sad.png', 'sad-grey.png', 0),
(5, ':(', 'sad.png', 'sad-grey.png', 1),
(6, ':sad:', 'sad.png', 'sad-grey.png', 0),
(7, ':cry:', 'sad.png', 'sad-grey.png', 0),
(8, ':)', 'smile.png', 'smile-grey.png', 1),
(9, ':-)', 'smile.png', 'smile-grey.png', 0),
(10, ':cheer:', 'cheerful.png', 'cheerful-grey.png', 1),
(11, ';)', 'wink.png', 'wink-grey.png', 1),
(12, ';-)', 'wink.png', 'wink-grey.png', 0),
(13, ':wink:', 'wink.png', 'wink-grey.png', 0),
(14, ';-)', 'wink.png', 'wink-grey.png', 0),
(15, ':P', 'tongue.png', 'tongue-grey.png', 1),
(16, ':p', 'tongue.png', 'tongue-grey.png', 0),
(17, ':-p', 'tongue.png', 'tongue-grey.png', 0),
(18, ':-P', 'tongue.png', 'tongue-grey.png', 0),
(19, ':razz:', 'tongue.png', 'tongue-grey.png', 0),
(20, ':angry:', 'angry.png', 'angry-grey.png', 1),
(21, ':mad:', 'angry.png', 'angry-grey.png', 0),
(22, ':unsure:', 'unsure.png', 'unsure-grey.png', 1),
(23, ':o', 'shocked.png', 'shocked-grey.png', 0),
(24, ':-o', 'shocked.png', 'shocked-grey.png', 0),
(25, ':O', 'shocked.png', 'shocked-grey.png', 0),
(26, ':-O', 'shocked.png', 'shocked-grey.png', 0),
(27, ':eek:', 'shocked.png', 'shocked-grey.png', 0),
(28, ':ohmy:', 'shocked.png', 'shocked-grey.png', 1),
(29, ':huh:', 'wassat.png', 'wassat-grey.png', 1),
(30, ':?', 'confused.png', 'confused-grey.png', 0),
(31, ':-?', 'confused.png', 'confused-grey.png', 0),
(32, ':???', 'confused.png', 'confused-grey.png', 0),
(33, ':dry:', 'ermm.png', 'ermm-grey.png', 1),
(34, ':ermm:', 'ermm.png', 'ermm-grey.png', 0),
(35, ':lol:', 'grin.png', 'grin-grey.png', 1),
(36, ':X', 'sick.png', 'sick-grey.png', 0),
(37, ':x', 'sick.png', 'sick-grey.png', 0),
(38, ':sick:', 'sick.png', 'sick-grey.png', 1),
(39, ':silly:', 'silly.png', 'silly-grey.png', 1),
(40, ':y32b4:', 'silly.png', 'silly-grey.png', 0),
(41, ':blink:', 'blink.png', 'blink-grey.png', 1),
(42, ':blush:', 'blush.png', 'blush-grey.png', 1),
(43, ':oops:', 'blush.png', 'blush-grey.png', 1),
(44, ':kiss:', 'kissing.png', 'kissing-grey.png', 1),
(45, ':rolleyes:', 'blink.png', 'blink-grey.png', 0),
(46, ':roll:', 'blink.png', 'blink-grey.png', 0),
(47, ':woohoo:', 'w00t.png', 'w00t-grey.png', 1),
(48, ':side:', 'sideways.png', 'sideways-grey.png', 1),
(49, ':S', 'dizzy.png', 'dizzy-grey.png', 1),
(50, ':s', 'dizzy.png', 'dizzy-grey.png', 0),
(51, ':evil:', 'devil.png', 'devil-grey.png', 1),
(52, ':twisted:', 'devil.png', 'devil-grey.png', 0),
(53, ':whistle:', 'whistling.png', 'whistling-grey.png', 1),
(54, ':pinch:', 'pinch.png', 'pinch-grey.png', 1),
(55, ':D', 'laughing.png', 'laughing-grey.png', 0),
(56, ':-D', 'laughing.png', 'laughing-grey.png', 0),
(57, ':grin:', 'laughing.png', 'laughing-grey.png', 0),
(58, ':laugh:', 'laughing.png', 'laughing-grey.png', 0),
(59, ':|', 'neutral.png', 'neutral-grey.png', 0),
(60, ':-|', 'neutral.png', 'neutral-grey.png', 0),
(61, ':neutral:', 'neutral.png', 'neutral-grey.png', 0),
(62, ':mrgreen:', 'mrgreen.png', 'mrgreen-grey.png', 0),
(63, ':?:', 'question.png', 'question-grey.png', 0),
(64, ':!:', 'exclamation.png', 'exclamation-grey.png', 0),
(65, ':arrow:', 'arrow.png', 'arrow-grey.png', 0),
(66, ':idea:', 'idea.png', 'idea-grey.png', 0);

DROP TABLE IF EXISTS `#__kunena_thankyou`;
CREATE TABLE IF NOT EXISTS `#__kunena_thankyou` (
  `postid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `targetuserid` int(11) NOT NULL,
  `time` datetime NOT NULL,
  UNIQUE KEY `postid` (`postid`,`userid`),
  KEY `userid` (`userid`),
  KEY `targetuserid` (`targetuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_thankyou` (`postid`, `userid`, `targetuserid`, `time`) VALUES
(6, 848, 847, '2014-12-09 10:46:29');

DROP TABLE IF EXISTS `#__kunena_topics`;
CREATE TABLE IF NOT EXISTS `#__kunena_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `subject` tinytext CHARACTER SET utf8,
  `icon_id` int(11) NOT NULL DEFAULT '0',
  `label_id` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `attachments` int(11) NOT NULL DEFAULT '0',
  `poll_id` int(11) NOT NULL DEFAULT '0',
  `moved_id` int(11) NOT NULL DEFAULT '0',
  `first_post_id` int(11) NOT NULL DEFAULT '0',
  `first_post_time` int(11) NOT NULL DEFAULT '0',
  `first_post_userid` int(11) NOT NULL DEFAULT '0',
  `first_post_message` text CHARACTER SET utf8,
  `first_post_guest_name` tinytext CHARACTER SET utf8,
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `last_post_time` int(11) NOT NULL DEFAULT '0',
  `last_post_userid` int(11) NOT NULL DEFAULT '0',
  `last_post_message` text CHARACTER SET utf8,
  `last_post_guest_name` tinytext CHARACTER SET utf8,
  `rating` tinyint(6) NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `locked` (`locked`),
  KEY `hold` (`hold`),
  KEY `posts` (`posts`),
  KEY `hits` (`hits`),
  KEY `first_post_userid` (`first_post_userid`),
  KEY `last_post_userid` (`last_post_userid`),
  KEY `first_post_time` (`first_post_time`),
  KEY `last_post_time` (`last_post_time`),
  KEY `last_post_id` (`last_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_topics` (`id`, `category_id`, `subject`, `icon_id`, `label_id`, `locked`, `hold`, `ordering`, `posts`, `hits`, `attachments`, `poll_id`, `moved_id`, `first_post_id`, `first_post_time`, `first_post_userid`, `first_post_message`, `first_post_guest_name`, `last_post_id`, `last_post_time`, `last_post_userid`, `last_post_message`, `last_post_guest_name`, `rating`, `params`) VALUES
(1, 2, 'Welcome to Kunena!', 0, 0, 0, 0, 0, 1, 12, 0, 0, 0, 1, 1399057228, 317, 'Thank you for choosing Kunena for your community forum needs in Joomla. \r\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \r\nAdditional Kunena Resources\r\nKunena Documentation: [url]http://www.kunena.org/docs[/url] \r\nKunena Support Forum: [url]http://www.kunena.org/forum[/url] \r\nKunena Downloads: [url]http://www.kunena.org/download[/url] \r\nKunena Blog: [url]http://www.kunena.org/blog[/url] \r\nFollow Kunena on Twitter: [url]http://www.kunena.org/twitter[/url]', '', 1, 1399057228, 317, 'Thank you for choosing Kunena for your community forum needs in Joomla. \r\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \r\nAdditional Kunena Resources\r\nKunena Documentation: [url]http://www.kunena.org/docs[/url] \r\nKunena Support Forum: [url]http://www.kunena.org/forum[/url] \r\nKunena Downloads: [url]http://www.kunena.org/download[/url] \r\nKunena Blog: [url]http://www.kunena.org/blog[/url] \r\nFollow Kunena on Twitter: [url]http://www.kunena.org/twitter[/url]', '', 0, ''),
(2, 5, 'General template issues, questions and problems', 0, 0, 0, 0, 0, 4, 18, 0, 0, 0, 2, 1415103771, 846, 'Kunena is the ideal forum extension for Joomla. It\'s free, fully integrated, and no bridges or hacks are required.\r\n\r\nWant to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', 'demo', 5, 1418121786, 847, 'Hi.\r\n\r\nI\'m looking to have 1 template for 1 categorie and an other template for all others catégories.\r\nSomeone he already well-considered the problem ?\r\n\r\nRegards.', 'lorem_ipsum', 0, ''),
(3, 6, 'Pellentesque non libero', 0, 0, 0, 0, 0, 2, 3, 0, 0, 0, 6, 1418121957, 847, 'Sed justo felis, lacinia at scelerisque a, semper et ante. Fusce posuere lacus eu mi lacinia et fringilla elit sollicitudin. Maecenas non odio nunc. In ut sollicitudin magna. Sed sit amet tincidunt odio. Mauris pharetra adipiscing urna ut accumsan. Suspendisse nec risus in felis fermentum blandit.\r\n\r\nNam nec lectus ut orci porta volutpat id at purus. Sed sagittis congue dapibus. Proin dolor metus, pharetra ut pulvinar nec, condimentum quis libero. Sed fermentum tortor ac elit tristique vel dapibus sem porta. Suspendisse aliquet posuere ultrices. Proin facilisis libero lacinia erat pretium faucibus. In tortor nunc, posuere eget commodo et, eleifend vel risus.', 'lorem_ipsum', 7, 1418122011, 848, 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam erat volutpat. Pellentesque non libero dui, vitae pharetra urna. Vestibulum accumsan pulvinar magna sed consectetur. Nulla congue condimentum aliquam. Donec non libero lectus, id mollis nisi. Morbi turpis magna, varius in ullamcorper nec, suscipit sagittis nibh. Nam elementum aliquam turpis eget egestas. Cras ligula nisi, interdum et vulputate nec, sagittis a tellus. In hac habitasse platea dictumst. In in sem libero. Fusce cursus, metus eu commodo hendrerit, arcu nibh consequat lectus, nec suscipit eros urna in ipsum. Praesent et enim a nisl commodo sodales non id neque. Ut sodales dignissim massa vitae hendrerit. Sed porttitor purus ut ante fermentum quis mollis velit pellentesque.\r\n\r\nEtiam nisi felis, fermentum vitae ultrices non, euismod in magna. In mattis velit ut eros tristique a congue erat consequat. Suspendisse consequat, justo eu gravida semper, ligula turpis dignissim dolor, vitae lacinia velit metus id libero. Nullam consectetur rhoncus magna, quis pharetra tortor bibendum quis. Curabitur ac ante nisl. Nullam mauris arcu, malesuada eu consectetur non, eleifend quis est. Nullam dictum, leo vulputate elementum porttitor, enim mi posuere augue, id porttitor leo sapien sed libero. Quisque est velit, aliquam bibendum vestibulum eget, tristique a odio.', 'dolor_sit', 0, '');

DROP TABLE IF EXISTS `#__kunena_users`;
CREATE TABLE IF NOT EXISTS `#__kunena_users` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `status_text` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `view` varchar(8) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `signature` text CHARACTER SET utf8,
  `moderator` int(11) DEFAULT '0',
  `banned` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `posts` int(11) DEFAULT '0',
  `avatar` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `timestamp` int(11) DEFAULT NULL,
  `karma` int(11) DEFAULT '0',
  `karma_time` int(11) DEFAULT '0',
  `group_id` int(4) DEFAULT '1',
  `uhits` int(11) DEFAULT '0',
  `personalText` tinytext CHARACTER SET utf8,
  `gender` tinyint(4) NOT NULL DEFAULT '0',
  `birthdate` date NOT NULL DEFAULT '0001-01-01',
  `location` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `icq` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `yim` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `youtube` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ok` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `microsoft` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `telegram` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `vk` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `skype` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `twitter` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `facebook` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `google` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `myspace` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `linkedin` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `delicious` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `friendfeed` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `digg` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `instagram` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `qq` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `qzone` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `whatsapp` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weibo` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `wechat` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `apple` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `blogspot` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `flickr` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `bebo` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `websitename` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `websiteurl` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `rank` tinyint(4) NOT NULL DEFAULT '0',
  `hideEmail` tinyint(1) NOT NULL DEFAULT '1',
  `showOnline` tinyint(1) NOT NULL DEFAULT '1',
  `canSubscribe` tinyint(1) NOT NULL DEFAULT '-1',
  `userListtime` int(11) NOT NULL DEFAULT '-2',
  `thankyou` int(11) DEFAULT '0',
  `ip` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `socialshare` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`userid`),
  KEY `group_id` (`group_id`),
  KEY `posts` (`posts`),
  KEY `uhits` (`uhits`),
  KEY `banned` (`banned`),
  KEY `moderator` (`moderator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_users` (`userid`, `status`, `status_text`, `view`, `signature`, `moderator`, `banned`, `ordering`, `posts`, `avatar`, `timestamp`, `karma`, `karma_time`, `group_id`, `uhits`, `personalText`, `gender`, `birthdate`, `location`, `icq`, `yim`, `youtube`, `ok`, `microsoft`, `telegram`, `vk`, `skype`, `twitter`, `facebook`, `google`, `myspace`, `linkedin`, `delicious`, `friendfeed`, `digg`, `instagram`, `qq`, `qzone`, `whatsapp`, `weibo`, `wechat`, `apple`, `blogspot`, `flickr`, `bebo`, `websitename`, `websiteurl`, `rank`, `hideEmail`, `showOnline`, `canSubscribe`, `userListtime`, `thankyou`, `ip`, `socialshare`) VALUES
(19, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 1, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(55, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(220, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '', 1),
(264, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, NULL, 1),
(283, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(317, 0, '', '', NULL, 0, NULL, 0, 1, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(545, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '', 1),
(741, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(757, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '', 1),
(797, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '', 1),
(846, 0, '', '', '', 0, NULL, 0, 2, NULL, NULL, 1, 1435741740, 1, 2, '', 1, '0001-01-01', '', '', '', NULL, NULL, '', NULL, NULL, '', '', '', '', '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '', '', 0, 1, 1, 1, -2, 0, '', 1),
(847, 0, '', '', NULL, 0, NULL, 0, 3, NULL, NULL, 1, 1418121732, 1, 24, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 1, '', 1),
(848, 0, '', '', NULL, 0, NULL, 0, 1, NULL, NULL, 0, 1418121990, 1, 10, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(849, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, '', 1),
(895, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '', 1),
(898, 0, '', '', NULL, 0, NULL, 0, 0, NULL, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '', 1);

DROP TABLE IF EXISTS `#__kunena_users_banned`;
CREATE TABLE IF NOT EXISTS `#__kunena_users_banned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `ip` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `blocked` tinyint(4) NOT NULL DEFAULT '0',
  `expiration` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_time` datetime NOT NULL,
  `reason_private` text CHARACTER SET utf8,
  `reason_public` text CHARACTER SET utf8,
  `modified_by` int(11) DEFAULT NULL,
  `modified_time` datetime DEFAULT NULL,
  `comments` text CHARACTER SET utf8,
  `params` text CHARACTER SET utf8,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `ip` (`ip`),
  KEY `expiration` (`expiration`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__kunena_user_categories`;
CREATE TABLE IF NOT EXISTS `#__kunena_user_categories` (
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `role` tinyint(4) NOT NULL DEFAULT '0',
  `allreadtime` int(11) NOT NULL DEFAULT '0',
  `subscribed` tinyint(4) NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`user_id`,`category_id`),
  KEY `category_subscribed` (`category_id`,`subscribed`),
  KEY `role` (`role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_user_categories` (`user_id`, `category_id`, `role`, `allreadtime`, `subscribed`, `params`) VALUES
(757, 0, 0, 1475675596, 0, ''),
(846, 0, 0, 1444738495, 0, ''),
(846, 2, 0, 1482315775, 0, ''),
(895, 0, 0, 1467881216, 0, '');

DROP TABLE IF EXISTS `#__kunena_user_read`;
CREATE TABLE IF NOT EXISTS `#__kunena_user_read` (
  `user_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `message_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  UNIQUE KEY `user_topic_id` (`user_id`,`topic_id`),
  KEY `category_user_id` (`category_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_user_read` (`user_id`, `topic_id`, `category_id`, `message_id`, `time`) VALUES
(846, 1, 2, 1, 1508412946),
(846, 2, 5, 5, 1497499466),
(847, 2, 5, 5, 1418121885),
(847, 3, 6, 6, 1418121958),
(848, 3, 6, 7, 1418122014);

DROP TABLE IF EXISTS `#__kunena_user_topics`;
CREATE TABLE IF NOT EXISTS `#__kunena_user_topics` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `topic_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  `posts` mediumint(8) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `owner` tinyint(4) NOT NULL DEFAULT '0',
  `favorite` tinyint(4) NOT NULL DEFAULT '0',
  `subscribed` tinyint(4) NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8 NOT NULL,
  UNIQUE KEY `user_topic_id` (`user_id`,`topic_id`),
  KEY `topic_id` (`topic_id`),
  KEY `posts` (`posts`),
  KEY `owner` (`owner`),
  KEY `favorite` (`favorite`),
  KEY `subscribed` (`subscribed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_user_topics` (`user_id`, `topic_id`, `category_id`, `posts`, `last_post_id`, `owner`, `favorite`, `subscribed`, `params`) VALUES
(317, 1, 2, 1, 1, 1, 0, 0, ''),
(846, 2, 5, 2, 3, 1, 0, 1, ''),
(847, 2, 5, 2, 5, 0, 0, 1, ''),
(847, 3, 6, 1, 6, 1, 0, 1, ''),
(848, 3, 6, 1, 7, 0, 0, 1, '');

DROP TABLE IF EXISTS `#__kunena_version`;
CREATE TABLE IF NOT EXISTS `#__kunena_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(20) CHARACTER SET utf8 NOT NULL,
  `versiondate` date NOT NULL,
  `installdate` date NOT NULL,
  `build` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `versionname` varchar(40) CHARACTER SET utf8 DEFAULT NULL,
  `state` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__kunena_version` (`id`, `version`, `versiondate`, `installdate`, `build`, `versionname`, `state`) VALUES
(1, '3.0.5', '2014-03-09', '2014-05-02', '', 'Invecchiato', ''),
(2, '3.0.6', '2014-07-28', '2014-08-05', '', 'Tala', ''),
(3, '4.0.10', '2016-02-18', '2016-07-13', '', 'Villavicencio', ''),
(4, '4.0.12', '2016-10-01', '2016-10-19', '', 'Lima', ''),
(5, '5.0.8', '2017-05-15', '2017-07-04', '', 'Hoatzin', ''),
(6, '5.0.11', '2017-09-02', '2017-09-22', '', 'Kinkajou', ''),
(7, '5.0.13', '2017-12-31', '2018-01-29', '', 'Meerkat', ''),
(8, '5.0.14', '2018-03-14', '2018-03-14', '', 'Stephen Hawking', ''),
(9, '5.1.0', '2018-05-13', '2018-06-04', '5.1.0', 'Ariel', '');

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 1);

DROP TABLE IF EXISTS `#__loginradius_users`;
CREATE TABLE IF NOT EXISTS `#__loginradius_users` (
  `id` int(11) DEFAULT NULL,
  `loginradius_id` varchar(255) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `lr_picture` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=781 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 317, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 0, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 0, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 0, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 73, 78, 0, '*', 1),
(8, 'main', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 0, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 74, 75, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 0, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 76, 77, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 0, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 79, 84, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 80, 81, 0, '*', 1),
(12, 'main', 'com_messages_read', 'Read Private Message', '', 'Messaging/Read Private Message', 'index.php?option=com_messages', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-read', 0, '', 82, 83, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 85, 90, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 86, 87, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 0, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 88, 89, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 0, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 91, 92, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 0, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 93, 94, 0, '*', 1),
(18, 'main', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', 0, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 95, 100, 0, '*', 1),
(19, 'main', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', 0, 18, 2, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 96, 97, 0, '*', 1),
(20, 'main', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 0, 18, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks-cat', 0, '', 98, 99, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 0, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 101, 102, 0, '*', 1),
(23, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 0, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 103, 104, 0, '', 1),
(24, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 0, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 105, 106, 0, '*', 1),
(101, 'main-menu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 15, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"fullwidth\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"Welcome!\",\"pageclass_sfx\":\"home\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"7\",\"icemega_width\":\"100%\",\"icemega_colwidth\":\"25%, 25%, 25%, 25%\",\"icemega_cols_items\":\"1,2,1,1\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 11, 16, 1, '*', 0),
(124, 'kunenamenu', 'Forum', 'forum', '', 'forum', 'index.php?option=com_kunena&view=home&defaultmenu=125', 'component', 1, 1, 1, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"catids\":[\"0\"],\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 107, 124, 0, '*', 0),
(125, 'kunenamenu', 'Index', 'index', '', 'forum/index', 'index.php?option=com_kunena&view=category&layout=list&catid=0', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 108, 109, 0, '*', 0),
(126, 'kunenamenu', 'Recent Topics', 'recent', '', 'forum/recent', 'index.php?option=com_kunena&view=topics&mode=replies', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"topics_catselection\":\"\",\"topics_categories\":\"\",\"topics_time\":720}', 110, 111, 0, '*', 0),
(127, 'kunenamenu', 'New Topic', 'newtopic', '', 'forum/newtopic', 'index.php?option=com_kunena&view=topic&layout=create', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 112, 113, 0, '*', 0),
(128, 'kunenamenu', 'No Replies', 'noreplies', '', 'forum/noreplies', 'index.php?option=com_kunena&view=topics&mode=noreplies', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"topics_catselection\":\"\",\"topics_categories\":\"\",\"topics_time\":-1}', 114, 115, 0, '*', 0),
(129, 'kunenamenu', 'My Topics', 'mylatest', '', 'forum/mylatest', 'index.php?option=com_kunena&view=topics&layout=user&mode=default', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"topics_catselection\":\"2\",\"topics_categories\":\"0\",\"topics_time\":-1}', 116, 117, 0, '*', 0),
(130, 'kunenamenu', 'Profile', 'profile', '', 'forum/profile', 'index.php?option=com_kunena&view=user', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"integration\":1}', 118, 119, 0, '*', 0),
(131, 'kunenamenu', 'Help', 'help', '', 'forum/help', 'index.php?option=com_kunena&view=misc', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 3, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"body\":\"This help page is a menu item inside [b]Kunena Menu[\\/b], which allows easy navigation in your forum. \\n\\n You can use Joomla Menu Manager to edit items in this menu. Please go to [b]Administration[\\/b] >> [b]Menus[\\/b] >> [b]Kunena Menu[\\/b] >> [b]Help[\\/b] to edit or remove this menu item. \\n\\n In this menu item you can use Plain Text, BBCode or HTML. If you want to bind article into this page, you may use article BBCode (with article id): [code][article=full]123[\\/article][\\/code] \\n\\n If you want to create your own menu for Kunena, please start by creating [b]Home Page[\\/b] first. In that page you can select default menu item, which is shown when you enter to Kunena.\",\"body_format\":\"bbcode\"}', 120, 121, 0, '*', 0),
(132, 'kunenamenu', 'Search', 'search', '', 'forum/search', 'index.php?option=com_kunena&view=search', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 122, 123, 0, '*', 0),
(135, 'main-menu', 'History', 'history', '', 'pages/history', 'index.php?option=com_content&view=category&layout=theme3589:category&id=25', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"100\",\"num_columns\":\"2\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"history\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 26, 27, 0, '*', 0),
(136, 'main-menu', 'Our team', 'our-team', '', 'pages/our-team', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"team\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 22, 23, 0, '*', 0),
(137, 'main-menu', 'Testimonials', 'testimonials', '', 'pages/testimonials', 'index.php?option=com_content&view=category&layout=theme3589:category&id=28', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"100\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"testimonials\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 28, 29, 0, '*', 0),
(138, 'main-menu', 'FAQs', 'faqs', '', 'pages/faqs', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"Frequently asked questions\",\"pageclass_sfx\":\"faqs\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 20, 21, 0, '*', 0),
(142, 'main-menu', 'Contacts', 'contacts', '', 'contacts', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"presentation_style\":\"plain\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_misc\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 57, 58, 0, '*', 0),
(148, 'social-media', 'Facebook', '2014-05-03-08-53-37', '', '2014-05-03-08-53-37', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"Facebook\",\"menu-anchor_css\":\"fa fa-facebook\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"menu_show\":1}', 65, 66, 0, '*', 0),
(149, 'social-media', 'Google+', '2014-05-03-08-54-19', '', '2014-05-03-08-54-19', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"Google+\",\"menu-anchor_css\":\"fa fa-google-plus\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"menu_show\":1}', 69, 70, 0, '*', 0),
(150, 'social-media', 'Twitter', '2014-05-03-08-54-56', '', '2014-05-03-08-54-56', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"Twitter\",\"menu-anchor_css\":\"fa fa-twitter\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"menu_show\":1}', 67, 68, 0, '*', 0),
(152, 'social-media', 'Skype', '2014-05-03-08-56-20', '', '2014-05-03-08-56-20', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"Skype\",\"menu-anchor_css\":\"fa fa-skype\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":0,\"menu_show\":1}', 71, 72, 0, '*', 0),
(170, 'system-menu', 'Template settings', 'template-settings', '', 'template-settings', 'index.php?option=com_content&view=article&id=57', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"template_settings\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 125, 126, 0, '*', 0),
(171, 'main-menu', 'Template settings', '2014-05-03-11-32-48', '', 'pages/elements/2014-05-03-11-32-48', 'index.php?Itemid=', 'alias', 1, 426, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"aliasoptions\":\"170\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 47, 48, 0, '*', 0),
(172, 'system-menu', 'Username reminder request', 'username-reminder-request', '', 'username-reminder-request', 'index.php?option=com_users&view=remind', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 127, 128, 0, '*', 0),
(173, 'system-menu', 'Password reset', 'password-reset', '', 'password-reset', 'index.php?option=com_users&view=reset', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 129, 130, 0, '*', 0),
(174, 'system-menu', 'User registration', 'user-registration', '', 'user-registration', 'index.php?option=com_users&view=registration', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 131, 132, 0, '*', 0),
(175, 'system-menu', 'Login form', 'login-form', '', 'login-form', 'index.php?option=com_users&view=login', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 133, 134, 0, '*', 0),
(176, 'system-menu', 'Privacy policy', 'privacy-policy2', '', 'privacy-policy2', 'index.php?option=com_content&view=article&id=6', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 135, 136, 0, '*', 0),
(203, 'main-menu', 'Gallery', 'gallery', '', 'gallery', 'index.php?option=com_joomgallery&view=category&catid=2', 'component', 1, 1, 1, 10032, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"disable_global_info\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"gallery\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"3\",\"icemega_width\":\"100%\",\"icemega_colwidth\":\"20%, 80%, 100%\",\"icemega_cols_items\":\"6, 1, 1\",\"icemega_subtype\":\"menu\"}', 55, 56, 0, '*', 0),
(204, 'system-menu', '404 Page', '404', '', '404', 'index.php?option=com_content&view=article&id=65', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"404\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 137, 138, 0, '*', 0),
(280, 'social-media', 'Pinterest', '2015-01-05-08-40-38', '', '2015-01-05-08-40-38', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"Pinterest\",\"menu-anchor_css\":\"fa fa-pinterest\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"menu_show\":1}', 139, 140, 0, '*', 0),
(283, 'main-menu', 'Portfolio', 'portfolio', '', 'pages/portfolio', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"Portfolio\",\"pageclass_sfx\":\"works\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 42, 43, 0, '*', 0),
(305, 'main-menu', 'Site map', 'site-map', '', 'pages/site-map', 'index.php?option=com_content&view=category&layout=theme3589:category&id=64', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"site_map\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 34, 35, 0, '*', 0),
(309, 'what-we-offer', 'customer-friendly service', '2015-01-20-16-07-15', '', '2015-01-20-16-07-15', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 141, 142, 0, '*', 0),
(310, 'what-we-offer', '100% satisfaction', '2015-01-20-16-07-34', '', '2015-01-20-16-07-34', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 143, 144, 0, '*', 0),
(311, 'what-we-offer', 'quality guarantee', '2015-01-20-16-07-53', '', '2015-01-20-16-07-53', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 145, 146, 0, '*', 0),
(312, 'what-we-offer', 'reliability', '2015-01-20-16-08-12', '', '2015-01-20-16-08-12', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 147, 148, 0, '*', 0),
(317, 'requirements', 'B.Tech./ B.E / MCA degree in Computer Science, Engineering or a related stream.', 'b-tech-b-e-mca-degree-in-computer-science-engineering-or-a-related-stream', '', 'b-tech-b-e-mca-degree-in-computer-science-engineering-or-a-related-stream', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 149, 150, 0, '*', 0),
(318, 'requirements', '3+ years of software development experience.', '3-years-of-software-development-experience', '', '3-years-of-software-development-experience', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 151, 152, 0, '*', 0),
(319, 'requirements', '3+ years of Python / Java development projects experience.', '3-years-of-python-java-development-projects-experience', '', '3-years-of-python-java-development-projects-experience', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 153, 154, 0, '*', 0),
(320, 'requirements', 'Minimum of 4 live project roll outs.', 'minimum-of-4-live-project-roll-outs', '', 'minimum-of-4-live-project-roll-outs', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 155, 156, 0, '*', 0),
(321, 'requirements', 'Experience with third-party libraries and APIs.', 'experience-with-third-party-libraries-and-apis', '', 'experience-with-third-party-libraries-and-apis', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 157, 158, 0, '*', 0),
(322, 'requirements', 'In depth understanding and experience of either SDLC or PDLC.', 'in-depth-understanding-and-experience-of-either-sdlc-or-pdlc', '', 'in-depth-understanding-and-experience-of-either-sdlc-or-pdlc', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 159, 160, 0, '*', 0),
(323, 'requirements', 'Good Communication Skills', 'good-communication-skills', '', 'good-communication-skills', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 161, 162, 0, '*', 0),
(324, 'requirements', 'Team Player', 'team-player', '', 'team-player', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 163, 164, 0, '*', 0),
(325, 'what-we-expect-from-you', 'Design and build applications/ components using open source technology.', 'design-and-build-applications-components-using-open-source-technology', '', 'design-and-build-applications-components-using-open-source-technology', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 165, 166, 0, '*', 0),
(326, 'what-we-expect-from-you', 'Taking complete ownership of the deliveries assigned.', 'taking-complete-ownership-of-the-deliveries-assigned', '', 'taking-complete-ownership-of-the-deliveries-assigned', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 167, 168, 0, '*', 0),
(327, 'what-we-expect-from-you', 'Collaborate with cross-functional teams to define, design, and ship new features.', 'collaborate-with-cross-functional-teams-to-define-design-and-ship-new-features', '', 'collaborate-with-cross-functional-teams-to-define-design-and-ship-new-features', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 169, 170, 0, '*', 0),
(328, 'what-we-expect-from-you', 'Work with outside data sources and API\'s.', 'work-with-outside-data-sources-and-api-s', '', 'work-with-outside-data-sources-and-api-s', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 171, 172, 0, '*', 0),
(329, 'what-we-expect-from-you', 'Unit-test code for robustness, including edge cases, usability, and general reliability.', 'unit-test-code-for-robustness-including-edge-cases-usability-and-general-reliability', '', 'unit-test-code-for-robustness-including-edge-cases-usability-and-general-reliability', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 173, 174, 0, '*', 0),
(330, 'what-we-expect-from-you', 'Work on bug fixing and improving application performance.', 'work-on-bug-fixing-and-improving-application-performance', '', 'work-on-bug-fixing-and-improving-application-performance', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 175, 176, 0, '*', 0),
(331, 'user-menu', 'Login form', '2015-01-26-09-48-59', '', '2015-01-26-09-48-59', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 5, '', 0, '{\"aliasoptions\":\"175\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 177, 178, 0, '*', 0),
(332, 'user-menu', 'User profile', 'user-profile', '', 'user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 179, 180, 0, '*', 0),
(333, 'user-menu', 'Create account', '2015-01-26-09-53-51', '', '2015-01-26-09-53-51', 'index.php?Itemid=', 'alias', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 5, '', 0, '{\"aliasoptions\":\"174\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 181, 182, 0, '*', 0),
(334, 'user-menu', 'Create article', 'create-article', '', 'create-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"enable_category\":\"1\",\"catid\":\"11\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 183, 184, 0, '*', 0),
(335, 'main-menu', 'Pages', 'pages', '', 'pages', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"150px\",\"icemega_colwidth\":\"150px\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 19, 52, 0, '*', 0),
(336, 'main-menu', 'Pricing', 'pricing', '', 'pages/elements/pricing', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 426, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 45, 46, 0, '*', 0),
(342, 'main-menu', 'Forum', '2015-02-25-09-04-57', '', 'pages/2015-02-25-09-04-57', 'index.php?Itemid=124', 'alias', 1, 335, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 14, '{\"aliasoptions\":\"124\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 36, 37, 0, '*', 0),
(343, 'main-menu', 'Careers', 'careers', '', 'pages/careers', 'index.php?option=com_content&view=category&layout=theme3589:category&id=46', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 16, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"careers\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 40, 41, 0, '*', 0),
(416, 'what-we-do', 'influence policy decisions in favor of customers', '2015-02-17-20-38-27', '', '2015-02-17-20-38-27', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 185, 186, 0, '*', 0),
(417, 'what-we-do', 'support and expand efforts to fill these gaps', '2015-02-17-20-39-08', '', '2015-02-17-20-39-08', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 187, 188, 0, '*', 0),
(418, 'what-we-do', 'highlight the chronic and continuing gaps in the related data', '2015-02-17-20-39-31', '', '2015-02-17-20-39-31', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 189, 190, 0, '*', 0),
(419, 'what-we-do', 'monitor the changing business situation', '2015-02-17-20-39-53', '', '2015-02-17-20-39-53', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 191, 192, 0, '*', 0),
(422, 'system-menu', 'Search', 'search', '', 'search', 'index.php?option=com_search&view=search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"search_areas\":\"0\",\"show_date\":\"0\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\"}', 193, 194, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(426, 'main-menu', 'Elements', 'elements', '', 'pages/elements', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"elements\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 44, 49, 0, '*', 0),
(439, 'top-menu', 'Login form', '2015-04-24-14-59-37', '', '2015-04-24-14-59-37', '#modal', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 5, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 195, 196, 0, '*', 0),
(440, 'top-menu', 'User profile', 'user-profile-2', '', 'user-profile-2', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 197, 198, 0, '*', 0),
(441, 'top-menu', 'Create account', '2015-04-27-07-43-33', '', '2015-04-27-07-43-33', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 5, '', 14, '{\"aliasoptions\":\"174\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 199, 200, 0, '*', 0),
(442, 'top-menu', 'Create article', 'create-article-2', '', 'create-article-2', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 2, '', 14, '{\"enable_category\":\"1\",\"catid\":\"11\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 201, 202, 0, '*', 0),
(492, 'main', 'Komento', 'komento', '', 'komento', 'index.php?option=com_komento', 'component', 0, 1, 1, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/komento-favicon.png', 0, '{}', 203, 222, 0, '', 1),
(493, 'main', 'COM_KOMENTO_MENU_COMMENTS', 'com-komento-menu-comments', '', 'komento/com-komento-menu-comments', 'index.php?option=com_komento&view=comments', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/comments-favicon.png', 0, '{}', 204, 205, 0, '', 1),
(494, 'main', 'COM_KOMENTO_MENU_PENDINGS', 'com-komento-menu-pendings', '', 'komento/com-komento-menu-pendings', 'index.php?option=com_komento&view=pending', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/pending-favicon.png', 0, '{}', 206, 207, 0, '', 1),
(495, 'main', 'COM_KOMENTO_MENU_REPORTS', 'com-komento-menu-reports', '', 'komento/com-komento-menu-reports', 'index.php?option=com_komento&view=reports', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/reports-favicon.png', 0, '{}', 208, 209, 0, '', 1),
(496, 'main', 'COM_KOMENTO_MENU_SUBSCRIBERS', 'com-komento-menu-subscribers', '', 'komento/com-komento-menu-subscribers', 'index.php?option=com_komento&view=subscribers', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/subscribers-favicon.png', 0, '{}', 210, 211, 0, '', 1),
(497, 'main', 'COM_KOMENTO_MENU_INTEGRATIONS', 'com-komento-menu-integrations', '', 'komento/com-komento-menu-integrations', 'index.php?option=com_komento&view=integrations', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/integrations-favicon.png', 0, '{}', 212, 213, 0, '', 1),
(498, 'main', 'COM_KOMENTO_MENU_CONFIGURATION', 'com-komento-menu-configuration', '', 'komento/com-komento-menu-configuration', 'index.php?option=com_komento&view=system', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/system-favicon.png', 0, '{}', 214, 215, 0, '', 1),
(499, 'main', 'COM_KOMENTO_MENU_ACL', 'com-komento-menu-acl', '', 'komento/com-komento-menu-acl', 'index.php?option=com_komento&view=acl', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/acls-favicon.png', 0, '{}', 216, 217, 0, '', 1),
(500, 'main', 'COM_KOMENTO_MENU_MIGRATORS', 'com-komento-menu-migrators', '', 'komento/com-komento-menu-migrators', 'index.php?option=com_komento&view=migrators', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/migrators-favicon.png', 0, '{}', 218, 219, 0, '', 1),
(501, 'main', 'COM_KOMENTO_MENU_MAILQ', 'com-komento-menu-mailq', '', 'komento/com-komento-menu-mailq', 'index.php?option=com_komento&view=mailq', 'component', 0, 492, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/mailq-favicon.png', 0, '{}', 220, 221, 0, '', 1),
(513, 'user-menu', 'Log  Out', '2015-01-26-09-48-60', '', '2015-01-26-09-48-60', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 2, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"#modal\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 223, 224, 0, '*', 0),
(514, 'top-menu', 'Log Out', '2015-04-24-14-59-38', '', '2015-04-24-14-59-38', '#modal', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 2, ' ', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"icemega_subtitle\":\"\",\"icemega_cols\":\"1\",\"icemega_width\":\"\",\"icemega_colwidth\":\"\",\"icemega_cols_items\":\"\",\"icemega_subtype\":\"menu\",\"icemega_anchorsmenuitem\":\"124\"}', 225, 226, 0, '*', 0),
(563, 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', 0, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 1, 'class:joomlaupdate', 0, '{}', 227, 228, 0, '', 1),
(577, 'main', 'COM_ASSOCIATIONS', 'com-associations', '', 'com-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 10168, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 229, 230, 0, '', 1),
(578, 'header-menu', '800-2345-6789', '800-2345-6789', '', '800-2345-6789', 'tel:800-2345-6789', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"material-icons-local_phone telephone\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 231, 232, 0, '*', 0),
(579, 'header-menu', 'advisto@demolink.org', 'advisto-demolink-org', '', 'advisto-demolink-org', 'mailto:advisto@demolink.org', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"link-underline\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 233, 234, 0, '*', 0),
(580, 'navigation', 'About us', 'about2', '', 'about2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"aliasoptions\":\"584\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 235, 236, 0, '*', 0),
(581, 'navigation', 'Blog', 'blog2', '', 'blog2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"aliasoptions\":\"285\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 237, 238, 0, '*', 0),
(582, 'navigation', 'Gallery', 'gallery2', '', 'gallery2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"203\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 239, 240, 0, '*', 0),
(583, 'navigation', 'Contacts', 'contacts2', '', 'contacts2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"142\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 241, 242, 0, '*', 0),
(584, 'main-menu', 'About', 'about-us', '', 'about-us', 'index.php?option=com_content&view=category&layout=theme3589:category&id=9', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"about\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 17, 18, 0, '*', 0),
(608, 'main-menu', 'Latest posts', 'latest-posts', '', 'home/latest-posts', 'index.php?Itemid=', 'alias', 1, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"611\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 12, 13, 0, '*', 0),
(610, 'main-menu', 'Latest works', 'latest-works', '', 'home/latest-works', 'index.php?Itemid=', 'alias', 1, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"283\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 14, 15, 0, '*', 0),
(611, 'main-menu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_content&view=category&layout=blog&id=11', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"4\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"1\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 53, 54, 0, '*', 0),
(612, 'main-menu', 'Search', 'search-menu', '', 'search-menu', '#modal', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"menu-search\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}', 63, 64, 0, '*', 0),
(622, 'main-menu', 'Login', 'login-menu-drop', '', 'login-menu-drop', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_css\":\"menu-login-form\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 59, 62, 0, '*', 0),
(623, 'main-menu', 'Login or register', 'login-or-register', '', 'login-menu-drop/login-or-register', '#', 'url', 1, 622, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1}', 60, 61, 0, '*', 0),
(653, 'main', 'COM_JOOMGALLERY', 'com-joomgallery', '', 'com-joomgallery', 'index.php?option=com_joomgallery', 'component', 1, 1, 1, 10032, 0, '0000-00-00 00:00:00', 0, 1, '../media/joomgallery/images/joom_main.png', 0, '{}', 243, 270, 0, '', 1),
(654, 'main', 'COM_JOOMGALLERY_CATEGORY_MANAGER', 'com-joomgallery-category-manager', '', 'com-joomgallery/com-joomgallery-category-manager', 'index.php?option=com_joomgallery&controller=categories', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_categories.png', 0, '{}', 244, 245, 0, '', 1),
(655, 'main', 'COM_JOOMGALLERY_IMAGE_MANAGER', 'com-joomgallery-image-manager', '', 'com-joomgallery/com-joomgallery-image-manager', 'index.php?option=com_joomgallery&controller=images', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_pictures.png', 0, '{}', 246, 247, 0, '', 1),
(656, 'main', 'COM_JOOMGALLERY_COMMENTS_MANAGER', 'com-joomgallery-comments-manager', '', 'com-joomgallery/com-joomgallery-comments-manager', 'index.php?option=com_joomgallery&controller=comments', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_comments.png', 0, '{}', 248, 249, 0, '', 1),
(657, 'main', 'COM_JOOMGALLERY_IMAGE_UPLOAD', 'com-joomgallery-image-upload', '', 'com-joomgallery/com-joomgallery-image-upload', 'index.php?option=com_joomgallery&controller=upload', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_pictureupload.png', 0, '{}', 250, 251, 0, '', 1),
(658, 'main', 'COM_JOOMGALLERY_AJAX_UPLOAD', 'com-joomgallery-ajax-upload', '', 'com-joomgallery/com-joomgallery-ajax-upload', 'index.php?option=com_joomgallery&controller=ajaxupload', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_ajaxupload.png', 0, '{}', 252, 253, 0, '', 1),
(659, 'main', 'COM_JOOMGALLERY_BATCH_UPLOAD', 'com-joomgallery-batch-upload', '', 'com-joomgallery/com-joomgallery-batch-upload', 'index.php?option=com_joomgallery&controller=batchupload', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_batchupload.png', 0, '{}', 254, 255, 0, '', 1),
(660, 'main', 'COM_JOOMGALLERY_FTP_UPLOAD', 'com-joomgallery-ftp-upload', '', 'com-joomgallery/com-joomgallery-ftp-upload', 'index.php?option=com_joomgallery&controller=ftpupload', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_ftpupload.png', 0, '{}', 256, 257, 0, '', 1),
(661, 'main', 'COM_JOOMGALLERY_JAVA_UPLOAD', 'com-joomgallery-java-upload', '', 'com-joomgallery/com-joomgallery-java-upload', 'index.php?option=com_joomgallery&controller=jupload', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_jupload.png', 0, '{}', 258, 259, 0, '', 1),
(662, 'main', 'COM_JOOMGALLERY_CONFIGURATION_MANAGER', 'com-joomgallery-configuration-manager', '', 'com-joomgallery/com-joomgallery-configuration-manager', 'index.php?option=com_joomgallery&controller=config', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_config.png', 0, '{}', 260, 261, 0, '', 1),
(663, 'main', 'COM_JOOMGALLERY_CUSTOMIZE_CSS', 'com-joomgallery-customize-css', '', 'com-joomgallery/com-joomgallery-customize-css', 'index.php?option=com_joomgallery&controller=cssedit', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_css.png', 0, '{}', 262, 263, 0, '', 1),
(664, 'main', 'COM_JOOMGALLERY_MIGRATION_MANAGER', 'com-joomgallery-migration-manager', '', 'com-joomgallery/com-joomgallery-migration-manager', 'index.php?option=com_joomgallery&controller=migration', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_migration.png', 0, '{}', 264, 265, 0, '', 1),
(665, 'main', 'COM_JOOMGALLERY_MAINTENANCE_MANAGER', 'com-joomgallery-maintenance-manager', '', 'com-joomgallery/com-joomgallery-maintenance-manager', 'index.php?option=com_joomgallery&controller=maintenance', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_maintenance.png', 0, '{}', 266, 267, 0, '', 1),
(666, 'main', 'COM_JOOMGALLERY_HELP', 'com-joomgallery-help', '', 'com-joomgallery/com-joomgallery-help', 'index.php?option=com_joomgallery&controller=help', 'component', 1, 653, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_information.png', 0, '{}', 268, 269, 0, '', 1),
(745, 'main', 'COM_SLOGIN_MAIN_MENU', 'com-slogin-main-menu', '', 'com-slogin-main-menu', 'index.php?option=com_slogin', 'component', 1, 1, 1, 10143, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_slogin/icon_16x16.png', 0, '{}', 271, 272, 0, '', 1),
(746, 'main-menu', 'Partners', 'partners', '', 'pages/partners', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 38, 39, 0, '*', 0),
(747, 'main-menu', 'Single Team', 'single-team', '', 'pages/single-team', 'index.php?option=com_content&view=article&id=164', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 24, 25, 0, '*', 0),
(748, 'main-menu', '404 page', '404-page', '', 'pages/404-page', 'index.php?option=com_content&view=article&id=65', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"404\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 50, 51, 0, '*', 0),
(749, 'main-menu', 'Services', 'services', '', 'pages/services', 'index.php?option=com_content&view=category&layout=theme3589:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 30, 31, 0, '*', 0),
(750, 'main-menu', 'Single service', 'single-service', '', 'pages/single-service', 'index.php?option=com_content&view=article&id=174', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 32, 33, 0, '*', 0),
(759, 'main', 'COM_KUNENA', 'com-kunena', '', 'com-kunena', 'index.php?option=com_kunena', 'component', 1, 1, 1, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-logo-white.png', 0, '{}', 273, 300, 0, '', 1),
(760, 'main', 'COM_KUNENA_DASHBOARD', 'com-kunena-dashboard', '', 'com-kunena/com-kunena-dashboard', 'index.php?option=com_kunena&view=cpanel', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 274, 275, 0, '', 1),
(761, 'main', 'COM_KUNENA_CATEGORY_MANAGER', 'com-kunena-category-manager', '', 'com-kunena/com-kunena-category-manager', 'index.php?option=com_kunena&view=categories', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 276, 277, 0, '', 1),
(762, 'main', 'COM_KUNENA_USER_MANAGER', 'com-kunena-user-manager', '', 'com-kunena/com-kunena-user-manager', 'index.php?option=com_kunena&view=users', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 278, 279, 0, '', 1),
(763, 'main', 'COM_KUNENA_FILE_MANAGER', 'com-kunena-file-manager', '', 'com-kunena/com-kunena-file-manager', 'index.php?option=com_kunena&view=attachments', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 280, 281, 0, '', 1),
(764, 'main', 'COM_KUNENA_EMOTICON_MANAGER', 'com-kunena-emoticon-manager', '', 'com-kunena/com-kunena-emoticon-manager', 'index.php?option=com_kunena&view=smilies', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 282, 283, 0, '', 1),
(765, 'main', 'COM_KUNENA_RANK_MANAGER', 'com-kunena-rank-manager', '', 'com-kunena/com-kunena-rank-manager', 'index.php?option=com_kunena&view=ranks', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 284, 285, 0, '', 1),
(766, 'main', 'COM_KUNENA_TEMPLATE_MANAGER', 'com-kunena-template-manager', '', 'com-kunena/com-kunena-template-manager', 'index.php?option=com_kunena&view=templates', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 286, 287, 0, '', 1),
(767, 'main', 'COM_KUNENA_CONFIGURATION', 'com-kunena-configuration', '', 'com-kunena/com-kunena-configuration', 'index.php?option=com_kunena&view=config', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 288, 289, 0, '', 1),
(768, 'main', 'COM_KUNENA_PLUGIN_MANAGER', 'com-kunena-plugin-manager', '', 'com-kunena/com-kunena-plugin-manager', 'index.php?option=com_kunena&view=plugins', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 290, 291, 0, '', 1),
(769, 'main', 'COM_KUNENA_LOG_MANAGER', 'com-kunena-log-manager', '', 'com-kunena/com-kunena-log-manager', 'index.php?option=com_kunena&view=logs', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 292, 293, 0, '', 1),
(770, 'main', 'COM_KUNENA_MENU_STATISTICS', 'com-kunena-menu-statistics', '', 'com-kunena/com-kunena-menu-statistics', 'index.php?option=com_kunena&view=statistics', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 294, 295, 0, '', 1),
(771, 'main', 'COM_KUNENA_FORUM_TOOLS', 'com-kunena-forum-tools', '', 'com-kunena/com-kunena-forum-tools', 'index.php?option=com_kunena&view=tools', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 296, 297, 0, '', 1),
(772, 'main', 'COM_KUNENA_TRASH_MANAGER', 'com-kunena-trash-manager', '', 'com-kunena/com-kunena-trash-manager', 'index.php?option=com_kunena&view=trash', 'component', 1, 759, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 298, 299, 0, '', 1),
(773, 'main', 'AcyMailing', 'acymailing', '', 'acymailing', 'index.php?option=com_acymailing', 'component', 1, 1, 1, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acymailing.png', 0, '{}', 301, 316, 0, '', 1),
(774, 'main', 'Users', 'users', '', 'acymailing/users', 'index.php?option=com_acymailing&ctrl=subscriber', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-users.png', 0, '{}', 302, 303, 0, '', 1),
(775, 'main', 'Lists', 'lists', '', 'acymailing/lists', 'index.php?option=com_acymailing&ctrl=list', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acylist.png', 0, '{}', 304, 305, 0, '', 1),
(776, 'main', 'Newsletters', 'newsletters', '', 'acymailing/newsletters', 'index.php?option=com_acymailing&ctrl=newsletter', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-newsletter.png', 0, '{}', 306, 307, 0, '', 1),
(777, 'main', 'Templates', 'templates', '', 'acymailing/templates', 'index.php?option=com_acymailing&ctrl=template', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acytemplate.png', 0, '{}', 308, 309, 0, '', 1),
(778, 'main', 'Queue', 'queue', '', 'acymailing/queue', 'index.php?option=com_acymailing&ctrl=queue', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-process.png', 0, '{}', 310, 311, 0, '', 1),
(779, 'main', 'Statistics', 'statistics', '', 'acymailing/statistics', 'index.php?option=com_acymailing&ctrl=stats', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-stats.png', 0, '{}', 312, 313, 0, '', 1),
(780, 'main', 'Configuration', 'configuration', '', 'acymailing/configuration', 'index.php?option=com_acymailing&ctrl=cpanel', 'component', 1, 773, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acyconfig.png', 0, '{}', 314, 315, 0, '', 1);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(2, 0, 'kunenamenu', 'Kunena Menu', 'This is the default Kunena menu. It is used as the top navigation for Kunena. It can be publish in any module position. Simply unpublish items that are not required.', 0),
(3, 0, 'system-menu', 'System Menu', '', 0),
(5, 0, 'social-media', 'Social Media', '', 0),
(12, 0, 'main-menu', 'Main menu', '', 0),
(13, 0, 'what-we-offer', 'What we offer', '', 0),
(14, 0, 'requirements', 'Requirements', '', 0),
(15, 0, 'what-we-expect-from-you', 'What we Expect from you?', '', 0),
(16, 0, 'user-menu', 'User menu', '', 0),
(17, 0, 'what-we-do', 'What we do', '', 0),
(18, 0, 'top-menu', 'Top menu', '', 0),
(19, 679, 'header-menu', 'Header menu', '', 0),
(20, 713, 'navigation', 'Navigation', '', 0);

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__messages` (`message_id`, `user_id_from`, `user_id_to`, `folder_id`, `date_time`, `state`, `priority`, `subject`, `message`) VALUES
(1, 846, 910, 0, '2018-06-25 16:06:04', 0, 0, 'An image has been downloaded', 'The image with the title Suspendisse (Filename: first_category_1_20140903_1689763756.jpg) has been downloaded by Guest!'),
(2, 322, 322, 0, '2018-06-25 16:06:04', -2, 0, 'New Comment', 'A new comment from Guest has been submitted. This comment needs to be approved before it can be published.'),
(5, 729, 729, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from ejhjkesh has been submitted. This comment needs to be approved before it can be published.'),
(6, 729, 729, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from ejhjkesh has been submitted. This comment needs to be approved before it can be published.'),
(7, 729, 729, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from dbdrt has been submitted. This comment needs to be approved before it can be published.'),
(8, 729, 729, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from rgdrvdr has been submitted. This comment needs to be approved before it can be published.'),
(9, 729, 729, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from 65rd has been submitted. This comment needs to be approved before it can be published.'),
(10, 729, 729, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from vsrtdrtrd has been submitted. This comment needs to be approved before it can be published.'),
(12, 504, 504, 0, '2018-06-25 16:06:04', 0, 0, 'New Comment', 'A new comment from xcz has been submitted. This comment needs to be approved before it can be published.'),
(13, 502, 502, 0, '2018-06-25 16:06:04', 0, 0, 'Error sending email', 'An error was encountered when sending the user registration email. The error is: Could not instantiate mail function. The user who attempted to register is: asggas'),
(14, 602, 602, 0, '2018-06-25 16:06:04', 0, 0, 'Error sending email', 'An error was encountered when sending the user registration email. The error is: Could not instantiate mail function. The user who attempted to register is: asggas'),
(15, 793, 793, 0, '2018-06-25 16:06:04', 0, 0, 'Error sending email', 'An error was encountered when sending the user registration email. The error is: Could not instantiate mail function. The user who attempted to register is: asggas');

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=299 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 56, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 57, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(4, 58, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(8, 59, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 60, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 61, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(12, 62, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 63, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 64, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 65, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 68, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 69, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(94, 62, 'Recent templates', '', '', 5, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_templates', 1, 1, '', 1, '*'),
(103, 167, 'Search', '', '', 1, '404-search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"1\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(104, 168, 'JoomGallery News', '', '', 1, 'joom_cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_feed', 1, 1, 'cache=1\n    cache_time=15\n    moduleclass_sfx=\n    rssurl=http://www.en.joomgallery.net/feed/rss.html\n    rssrtl=0\n    rsstitle=1\n    rssdesc=0\n    rssimage=1\n    rssitems=3\n    rssitemdesc=1\n    word_count=200', 1, '*'),
(115, 210, 'TM Ajax Contact Form', '', '', 1, 'contact-form', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_ajax_contact_form', 1, 0, '{\"pretext\":\"\",\"fields_list\":\"{\\\"label\\\":[\\\"Name\\\",\\\"Email\\\",\\\"Phone\\\",\\\"Time\\\",\\\"date\\\",\\\"Message\\\"],\\\"name\\\":[\\\"name\\\",\\\"email\\\",\\\"phone\\\",\\\"time\\\",\\\"date\\\",\\\"message\\\"],\\\"type\\\":[\\\"text\\\",\\\"email\\\",\\\"text\\\",\\\"times\\\",\\\"date\\\",\\\"textarea\\\"],\\\"options_list\\\":[\\\"{\\\\\\\"option_name\\\\\\\":[],\\\\\\\"option_value\\\\\\\":[]}\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"title\\\":[\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"req\\\":[\\\"1\\\",\\\"1\\\",\\\"0\\\",\\\"1\\\",\\\"1\\\",\\\"1\\\"],\\\"bootstrap_size\\\":[\\\"4\\\",\\\"4\\\",\\\"4\\\",\\\"6\\\",\\\"6\\\",\\\"12\\\"]}\",\"admin_email\":\"admin@admin.com\",\"cc_email\":\"\",\"bcc_email\":\"\",\"success_notify\":\"Thank You! Your message has been sent.\",\"failure_notify\":\"Something went wrong, please try again later.\",\"captcha_failure_notify\":\"Please enter a correct Captcha answer.\",\"captcha_req\":\"0\",\"reset_publish\":\"1\",\"br_name\":\"Clear\",\"bs_name\":\"Send\",\"labels_pos\":\"1\",\"textarea_minlength\":\"20\",\"time_format\":\"1\",\"date_format\":\"DD.MM.YYYY\",\"gdpr_check\":\"1\",\"moduleclass_sfx\":\"\",\"layout\":\"_:default\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(118, 289, 'Detailed', '', '', 1, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"35\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"4\",\"columns\":\"4\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h5\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"right\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"pricing_detailed\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(122, 310, 'Simple', '', '', 2, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"36\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"3\",\"columns\":\"3\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h5\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"right\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"pricing_simple\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(145, 348, 'Accordion 1', 'For \"Elements\" page', '', 11, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{\"catid\":[\"18\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"custom\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"6\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(159, 377, 'Careers accordion', '', '', 1, 'careers-accordion-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{\"catid\":[\"47\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(160, 380, 'Apply now', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_ajax_contact_form', 1, 1, '{\"pretext\":\"Fill in the application form below and get your dream career of a lifetime.\",\"fields_list\":\"{\\\"label\\\":[\\\"Name\\\",\\\"Last Name\\\",\\\"Email\\\",\\\"Age\\\",\\\"City\\\",\\\"Position\\\",\\\"Expected Salary\\\",\\\"Start Date\\\",\\\"Website\\\",\\\"Experience\\\",\\\"Application\\\"],\\\"name\\\":[\\\"name\\\",\\\"lastname\\\",\\\"email\\\",\\\"age\\\",\\\"city\\\",\\\"position\\\",\\\"salary\\\",\\\"date\\\",\\\"website\\\",\\\"experience\\\",\\\"application\\\"],\\\"type\\\":[\\\"text\\\",\\\"text\\\",\\\"email\\\",\\\"text\\\",\\\"text\\\",\\\"select\\\",\\\"text\\\",\\\"text\\\",\\\"text\\\",\\\"textarea\\\",\\\"textarea\\\"],\\\"options_list\\\":[\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"{\\\\\\\"option_name\\\\\\\":[\\\\\\\"Chief Accountant\\\\\\\",\\\\\\\"Sales manager\\\\\\\",\\\\\\\"Sales assistant\\\\\\\",\\\\\\\"Office manager\\\\\\\"],\\\\\\\"option_value\\\\\\\":[\\\\\\\"Chief Accountant\\\\\\\",\\\\\\\"Sales manager\\\\\\\",\\\\\\\"Sales assistant\\\\\\\",\\\\\\\"Office manager\\\\\\\"]}\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"title\\\":[\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"req\\\":[\\\"1\\\",\\\"1\\\",\\\"1\\\",\\\"1\\\",\\\"1\\\",\\\"1\\\",\\\"1\\\",\\\"0\\\",\\\"0\\\",\\\"0\\\",\\\"1\\\"],\\\"bootstrap_size\\\":[\\\"6\\\",\\\"6\\\",\\\"12\\\",\\\"6\\\",\\\"6\\\",\\\"12\\\",\\\"6\\\",\\\"6\\\",\\\"12\\\",\\\"12\\\",\\\"12\\\"]}\",\"admin_email\":\"admin@admin.com\",\"cc_email\":\"\",\"bcc_email\":\"\",\"success_notify\":\"Thank You! Your message has been sent.\",\"failure_notify\":\"Something went wrong, please try again later.\",\"captcha_failure_notify\":\"Please enter a correct Captcha answer.\",\"captcha_req\":\"0\",\"reset_publish\":\"0\",\"br_name\":\"Clear\",\"bs_name\":\"Send\",\"labels_pos\":\"1\",\"textarea_minlength\":\"20\",\"time_format\":\"1\",\"moduleclass_sfx\":\"careers_form\",\"layout\":\"_:default\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(161, 382, 'Requirements', '', '', 1, 'careers-accordion-requirements', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"requirements\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" requirements\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(162, 383, 'What we Expect from you?', '', '', 1, 'careers-accordion-expect', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"what-we-expect-from-you\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" expect\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(163, 387, 'Careers accordion', '', '', 1, 'careers-accordion-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{\"catid\":[\"47\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(164, 388, 'Careers accordion', '', '', 1, 'careers-accordion-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{\"catid\":[\"47\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(165, 389, 'Careers accordion', '', '', 1, 'careers-accordion-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{\"catid\":[\"47\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(166, 390, 'Pages', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"main-menu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"site_map\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h4\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(167, 391, 'Blog posts', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":\"1\",\"count\":\"0\",\"show_front\":\"show\",\"category_filtering_type\":\"1\",\"catid\":[\"11\"],\"show_child_category_articles\":\"1\",\"levels\":\"10\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"publish_up\",\"article_ordering_direction\":\"DESC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"link_titles\":\"1\",\"show_date\":\"0\",\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":\"0\",\"show_hits\":\"0\",\"show_author\":\"0\",\"show_introtext\":\"0\",\"introtext_limit\":\"100\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" site_map\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h4\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(168, 392, 'Portfolio posts', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":\"1\",\"count\":\"0\",\"show_front\":\"show\",\"category_filtering_type\":\"1\",\"catid\":[\"31\"],\"show_child_category_articles\":\"1\",\"levels\":\"10\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"a.ordering\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"link_titles\":\"1\",\"show_date\":\"0\",\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":\"0\",\"show_hits\":\"0\",\"show_author\":\"0\",\"show_introtext\":\"0\",\"introtext_limit\":\"100\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" site_map\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h4\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(169, 393, 'User menu', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"user-menu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"site_map\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h4\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(170, 395, 'Breadcrumbs', '', '', 1, 'breadcrumbs', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 0, '{\"showHere\":\"0\",\"showHome\":\"1\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"theme3589:first-last-item\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(171, 398, 'Our team', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"26\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"9\",\"columns\":\"3\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h5\",\"show_introtext\":\"1\",\"introtext_limit\":\"150\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"team\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(173, 400, 'Frequently asked questions', '', '', 3, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 1, '{\"catid\":[\"27\"],\"count\":\"100\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"If you need help, we have a list of frequently asked questions and answers. We strive to give you the best buying experience possible. Click a question below to view the answer. \",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(183, 437, 'Tabs', 'For \"Elements\" page', '', 13, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstraptabs', 1, 1, '{\"catid\":[\"57\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"8\",\"bootstrap_offset\":\"2\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(184, 442, 'Accordion 2', 'For \"Elements\" page', '', 10, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{\"catid\":[\"18\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"6\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(189, 456, 'Pricing Tables', 'For \"Elements\" page', '', 14, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"35\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"4\",\"columns\":\"4\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h5\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"right\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"pricing_detailed\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(190, 457, 'Simple', 'For \"Elements\" page', '', 15, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"36\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"3\",\"columns\":\"3\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h5\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"right\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"pricing_simple\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(192, 459, 'Accordions and Toggles', 'For \"Elements\" page', '', 9, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"title_only\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(195, 462, 'Menu search', '', '', 1, 'modal', 0, '0000-00-00 00:00:00', '2018-06-25 16:06:04', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"1\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\" \",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"101\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" modal_search\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(234, 780, 'Text Elements', '', '', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 0, '{\"article_id\":\"121\",\"item_heading\":\"h4\",\"item_title\":\"0\",\"link_titles\":\"\",\"published_on\":\"0\",\"show_intro_image\":\"1\",\"readmore\":\"0\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(235, 781, 'TM Ajax Style Switcher', '', '', 1, 'fixed-sidebar-left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_style_switcher', 1, 0, '{\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(238, 784, 'Portfolio', '', '', 4, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_portfolio', 1, 0, '{\"catid\":[\"31\"],\"show_child_category_articles\":\"1\",\"levels\":\"1\",\"count\":\"6\",\"columns\":\"3\",\"show_filter\":\"1\",\"show_sort\":\"1\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h4\",\"limit_introtext\":\"0\",\"show_introtext\":\"1\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"show_modify_date\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(239, 785, 'Linear bars', '', '', 5, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_progress_bars', 1, 1, '{\"pretext\":\"\",\"choose_type\":\"0\",\"thickness\":\"60\",\"columns\":\"2\",\"items_data2\":\"{\\\"item_name\\\":[\\\"Name\\\"],\\\"item_value\\\":[\\\"30\\\"],\\\"item_color1\\\":[\\\"#eaeaea\\\"],\\\"item_color2\\\":[\\\"#eaeaea\\\"],\\\"item_color3\\\":[\\\"#f5f5f5\\\"]}\",\"items_data\":\"{\\\"item_name\\\":[\\\"HTML\\/CSS\\\",\\\"Java Script\\\",\\\"PHP\\\",\\\"UI\\/UX Design\\\"],\\\"item_value\\\":[\\\"70\\\",\\\"54\\\",\\\"87\\\",\\\"65\\\"],\\\"item_color\\\":[\\\"#abcc37\\\",\\\"#79ccf2\\\",\\\"#f5bf2f\\\",\\\"#f54b0f\\\"]}\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(240, 786, 'Radial bars', '', '', 6, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_progress_bars', 1, 1, '{\"pretext\":\"\",\"choose_type\":\"1\",\"thickness\":\"60\",\"columns\":\"4\",\"items_data2\":\"{\\\"item_name\\\":[\\\"HTML\\/CSS\\\",\\\"Java Script\\\",\\\"PHP\\\",\\\"UI\\/UX Design\\\"],\\\"item_value\\\":[\\\"30\\\",\\\"88\\\",\\\"44\\\",\\\"55\\\"],\\\"item_color1\\\":[\\\"#bd2828\\\",\\\"#2244a1\\\",\\\"#991313\\\",\\\"#22420d\\\"],\\\"item_color2\\\":[\\\"#1e7d77\\\",\\\"#8a1313\\\",\\\"#8c6e1c\\\",\\\"#cc29b1\\\"],\\\"item_color3\\\":[\\\"#f5f5f5\\\",\\\"#f5f5f5\\\",\\\"#f5f5f5\\\",\\\"#f5f5f5\\\"]}\",\"items_data\":\"{\\\"item_name\\\":[\\\"Name\\\"],\\\"item_value\\\":[\\\"30\\\"],\\\"item_color\\\":[\\\"#eaeaea\\\"]}\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(241, 787, 'Tags', '', '', 5, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tags_popular', 1, 1, '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":\"1\",\"display_count\":0,\"no_results_text\":\"0\",\"minsize\":1,\"maxsize\":2,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(242, 788, 'Recent posts', '', '', 6, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"11\"],\"show_child_category_articles\":\"1\",\"levels\":\"10\",\"count\":\"5\",\"columns\":\"1\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h6\",\"show_introtext\":\"0\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"1\",\"createdby\":\"1\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"theme3589:recent-post\",\"masonry\":\"0\",\"moduleclass_sfx\":\"recent_posts\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(243, 789, 'Categories', '', '', 2, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{\"parent\":\"11\",\"show_description\":\"0\",\"numitems\":\"0\",\"show_children\":\"0\",\"count\":\"0\",\"maxlevel\":\"0\",\"layout\":\"_:default\",\"item_heading\":\"5\",\"moduleclass_sfx\":\" blog_categories\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(248, 794, 'Blog categories', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{\"parent\":\"11\",\"show_description\":\"0\",\"numitems\":\"0\",\"show_children\":\"0\",\"count\":\"0\",\"maxlevel\":\"0\",\"layout\":\"_:default\",\"item_heading\":\"5\",\"moduleclass_sfx\":\" blog_categories_megamenu\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(249, 795, 'Latest posts', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"11\"],\"show_child_category_articles\":\"1\",\"levels\":\"10\",\"count\":\"3\",\"columns\":\"1\",\"ordering\":\"a.publish_up\",\"article_ordering_direction\":\"DESC\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h6\",\"show_introtext\":\"0\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"left\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"theme3589:recent-post\",\"masonry\":\"0\",\"moduleclass_sfx\":\"latest_posts\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(251, 797, 'Latest works', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"31\"],\"show_child_category_articles\":\"1\",\"levels\":\"5\",\"count\":\"2\",\"columns\":\"2\",\"ordering\":\"a.publish_up\",\"article_ordering_direction\":\"DESC\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"1\",\"item_heading\":\"h4\",\"show_introtext\":\"0\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(252, 801, 'Login form megamenu', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_slogin', 1, 0, '{\"show_login_form\":1,\"slogin_link_profile\":\"0\",\"slogin_link_auch_edit\":\"1\",\"inittext\":\"\",\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"secretkey\":\"\",\"layout\":\"theme3589:megamenu\",\"moduleclass_sfx\":\"login_megamenu\",\"cache\":\"0\",\"load_css\":\"1\",\"load_js\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(253, 802, 'Social menu', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '2018-06-27 16:24:08', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"social-media\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"social-menu\",\"window_open\":\"\",\"layout\":\"theme3589:social\",\"moduleclass_sfx\":\"social-menu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(268, 817, 'Counters', 'For \"Elements\" page', '', 8, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_counters', 1, 1, '{\"pretext\":\"\",\"columns\":\"4\",\"animation_speed\":\"6000\",\"items_data\":\"{\\\"item_name\\\":[\\\"COFFEE CUPS\\\",\\\"EXHIBITIONS\\\",\\\"ARTISTS\\\",\\\"VISITORS\\\"],\\\"item_value\\\":[\\\"358\\\",\\\"94\\\",\\\"156\\\",\\\"1245\\\"],\\\"item_symbol\\\":[\\\"\\\",\\\"\\\",\\\"\\\",\\\"\\\"],\\\"item_decimals\\\":[\\\"0\\\",\\\"0\\\",\\\"0\\\",\\\"0\\\"],\\\"item_icon_class\\\":[\\\"linearicons linearicons-coffee-cup\\\",\\\"linearicons linearicons-picture2\\\",\\\"linearicons linearicons-brush\\\",\\\"linearicons linearicons-users-plus\\\"]}\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(269, 818, 'Google map', '', '', 2, 'map', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_tm_google_map', 1, 0, '{\"pretext\":\"\",\"api_key\":\"AIzaSyAwH60q5rWrS8bXwpkZwZwhw9Bw0pqKTZM\",\"map_height\":\"400px\",\"map_zoom_level\":\"15\",\"marker-base\":\"images\\/gmap_marker.png\",\"marker-active\":\"images\\/gmap_marker_active.png\",\"items_data\":\"{\\\"item_x\\\":[\\\"-73.9874068\\\"],\\\"item_y\\\":[\\\"40.643180\\\"],\\\"item_label\\\":[\\\"2130 Fulton Street San Diego, CA 94117-1080 USA\\\"],\\\"item_image\\\":[\\\"\\\"]}\",\"map_styles\":\"[{\\\"featureType\\\":\\\"administrative.country\\\",\\\"elementType\\\":\\\"labels.text\\\",\\\"stylers\\\":[{\\\"visibility\\\":\\\"on\\\"}]}]\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(273, 822, 'Portfolio default', '', '', 4, 'position-6', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_portfolio', 1, 1, '{\"catid\":[\"31\"],\"show_child_category_articles\":\"1\",\"levels\":\"1\",\"count\":\"6\",\"columns\":\"3\",\"show_filter\":\"1\",\"show_sort\":\"1\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h4\",\"limit_introtext\":\"0\",\"show_introtext\":\"1\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"show_modify_date\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(274, 823, 'Portfolio masonry', '', '', 4, 'position-6', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_portfolio', 1, 1, '{\"catid\":[\"31\"],\"show_child_category_articles\":\"1\",\"levels\":\"1\",\"count\":\"6\",\"columns\":\"3\",\"show_filter\":\"1\",\"show_sort\":\"1\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h4\",\"limit_introtext\":\"0\",\"show_introtext\":\"1\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"show_modify_date\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"masonry\":\"1\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(275, 825, 'Working time', '', '<p>Our support available to help you 24 hours a day, seven days a week.</p>\r\n<ul class=\"scheduled-time\">\r\n<li><i class=\"fa fa-clock-o\"></i> Mon–Fri: 08:00–18:00</li>\r\n<li><i class=\"fa fa-clock-o\"></i> Sat: 08:00–14:00</li>\r\n<li><i class=\"fa fa-clock-o\"></i> Sun: Closed</li>\r\n</ul>', 3, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"working-time\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(276, 827, 'Do You Have any Questions?', '', '', 4, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 0, '{\"article_id\":\"167\",\"item_heading\":\"h5\",\"item_title\":\"1\",\"link_titles\":\"0\",\"published_on\":\"0\",\"category_on\":\"0\",\"show_intro_image\":\"1\",\"readmore\":\"0\",\"mod_button\":\"1\",\"custom_link_title\":\"Contact us\",\"custom_link_route\":\"1\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"142\",\"pretext\":\"\",\"layout\":\"theme3589:questions\",\"moduleclass_sfx\":\"questions\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(277, 835, 'Partners', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"73\"],\"show_child_category_articles\":\"1\",\"levels\":\"1\",\"count\":\"6\",\"columns\":\"1\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h4\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"theme3589:partners\",\"masonry\":\"0\",\"moduleclass_sfx\":\"partners\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(278, 843, 'Services prices', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"35\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"4\",\"columns\":\"4\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"0\",\"link_titles\":\"0\",\"item_heading\":\"h5\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"1\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"pricing_detailed\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(279, 844, 'Popular questions', '', '', 1, 'none', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 1, '{\"catid\":[\"27\"],\"count\":\"100\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h5\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*'),
(280, 845, 'Our services', '', '', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"74\"],\"show_child_category_articles\":\"1\",\"levels\":\"2\",\"count\":\"6\",\"columns\":\"3\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h4\",\"show_introtext\":\"1\",\"introtext_limit\":\"120\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"default-services\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h5\",\"header_class\":\"\",\"style\":\"theme3589-themeHtml5\"}', 0, '*');
INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(282, 847, 'Google map footer', '', '', 1, 'map', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_google_map', 1, 0, '{\"pretext\":\"\",\"api_key\":\"AIzaSyAwH60q5rWrS8bXwpkZwZwhw9Bw0pqKTZM\",\"map_height\":\"736px\",\"map_zoom_level\":\"15\",\"marker-base\":\"images\\/gmap_marker.png\",\"marker-active\":\"images\\/gmap_marker_active.png\",\"items_data\":\"{\\\"item_x\\\":[\\\"-73.9874068\\\"],\\\"item_y\\\":[\\\"40.643180\\\"],\\\"item_label\\\":[\\\"2130 Fulton Street San Diego, CA 94117-1080 USA\\\"],\\\"item_image\\\":[\\\"\\\"]}\",\"map_styles\":\"[\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"water\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#e9e9e9\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 17\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"landscape\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#f5f5f5\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 20\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"road.highway\\\",\\r\\n        \\\"elementType\\\": \\\"geometry.fill\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#ffffff\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 17\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"road.highway\\\",\\r\\n        \\\"elementType\\\": \\\"geometry.stroke\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#ffffff\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 29\\r\\n            },\\r\\n            {\\r\\n                \\\"weight\\\": 0.2\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"road.arterial\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#ffffff\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 18\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"road.local\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#ffffff\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 16\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"poi\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#f5f5f5\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 21\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"poi.park\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#dedede\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 21\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"elementType\\\": \\\"labels.text.stroke\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"visibility\\\": \\\"on\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"color\\\": \\\"#ffffff\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 16\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"elementType\\\": \\\"labels.text.fill\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"saturation\\\": 36\\r\\n            },\\r\\n            {\\r\\n                \\\"color\\\": \\\"#333333\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 40\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"elementType\\\": \\\"labels.icon\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"visibility\\\": \\\"off\\\"\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"transit\\\",\\r\\n        \\\"elementType\\\": \\\"geometry\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#f2f2f2\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 19\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"administrative\\\",\\r\\n        \\\"elementType\\\": \\\"geometry.fill\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#fefefe\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 20\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\\"featureType\\\": \\\"administrative\\\",\\r\\n        \\\"elementType\\\": \\\"geometry.stroke\\\",\\r\\n        \\\"stylers\\\": [\\r\\n            {\\r\\n                \\\"color\\\": \\\"#fefefe\\\"\\r\\n            },\\r\\n            {\\r\\n                \\\"lightness\\\": 17\\r\\n            },\\r\\n            {\\r\\n                \\\"weight\\\": 1.2\\r\\n            }\\r\\n        ]\\r\\n    }\\r\\n]\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"map_footer\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(283, 848, 'Get in Touch', '', '<p><i class=\"linearicons linearicons-map-marker\"></i>WEST, LONDON MUSEUM</p>\r\n<p><i class=\"linearicons linearicons-telephone\"></i><a href=\"74951234567\">+7-495-1234567</a>, <a href=\"74951234568\">+7-495-1234568</a></p>\r\n<p><i class=\"linearicons linearicons-clock3\"></i><b>Monday to Friday:</b> 9.00 am to 8.00 pm EST</p>\r\n<p class=\"dat\"><b>Saturday:</b> 10.00 am to 6.00 pm EST</span>\r\n<p><i class=\"linearicons linearicons-envelope\"></i><a href=\"mailto:info@demolink.org\">info@demolink.org</a></p>\r\n{loadmodule mod_menu, Social menu}\r\n\r\n', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"address\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"11\",\"bootstrap_offset\":\"1\",\"header_tag\":\"h1\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(284, 849, 'Welcome img', '', '<img src=\"images/home/page1_img1.jpg\" alt=\"\"/>', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"wel_img\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"6\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(285, 851, 'Welcome to artesma', '', '', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{\"article_id\":\"180\",\"item_heading\":\"h1\",\"item_title\":\"1\",\"link_titles\":\"\",\"published_on\":\"0\",\"category_on\":\"0\",\"show_intro_image\":\"1\",\"readmore\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"welcome\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"4\",\"bootstrap_offset\":\"1\",\"header_tag\":\"h6\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(286, 852, 'Exhibitions', '', '<p>We display, borrow and collect artworks from around the world.\r\nManages a permanent collection numbering over 6000 objects in total. The gallery is frequented by art lovers looking to find and buy original artwork.</p>', 1, 'position-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"exhibitions\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"10\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(287, 853, 'Exhibitions gallery', '', '', 1, 'position-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_owl_carousel', 1, 0, '{\"catid\":[\"70\",\"71\",\"72\"],\"image\":\"1\",\"item_title\":\"0\",\"link_titles\":\"\",\"published\":\"0\",\"item_heading\":\"h4\",\"show_tags\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"readmore\":\"0\",\"count\":\"6\",\"ordering\":\"a.publish_up\",\"direction\":\"0\",\"pretext\":\"\",\"layout\":\"theme3589:fancybox\",\"moduleclass_sfx\":\"home_gallery\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"items\":\"2\",\"autoplay\":\"1\",\"autoplay_speed\":\"5000\",\"scene_padding_0\":\"0\",\"items_padding_0\":\"30\",\"use_responsive\":\"1\",\"scene_padding_1200\":\"0\",\"items_padding_1200\":\"30\",\"scene_padding_992\":\"0\",\"items_padding_992\":\"30\",\"scene_padding_768\":\"0\",\"items_padding_768\":\"30\",\"scene_padding_480\":\"0\",\"items_padding_480\":\"30\",\"navigation\":\"1\",\"pagination\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"8\",\"bootstrap_offset\":\"3\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(288, 855, 'Home services 1', '', '', 1, 'position-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"75\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"3\",\"columns\":\"3\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h2\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"home_serv_1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(289, 860, 'exhibitions', '', '', 1, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 0, '{\"article_id\":\"184\",\"item_heading\":\"h6\",\"item_title\":\"1\",\"link_titles\":\"\",\"published_on\":\"0\",\"category_on\":\"0\",\"show_intro_image\":\"1\",\"readmore\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"layout\":\"theme3589:title-in\",\"moduleclass_sfx\":\"exhibitions\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h6\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(290, 861, 'our blog', '', '<h1>Events & Programs</h1>', 1, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"our_blog center\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h6\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(291, 862, 'Home Blog', '', '', 1, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"49\"],\"show_child_category_articles\":\"1\",\"levels\":\"2\",\"count\":\"3\",\"columns\":\"3\",\"ordering\":\"a.ordering\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h2\",\"show_introtext\":\"1\",\"introtext_limit\":\"200\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"1\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"theme3589:blog\",\"masonry\":\"0\",\"moduleclass_sfx\":\"home_blog\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(292, 867, 'who we are', '', '', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{\"article_id\":\"187\",\"item_heading\":\"h1\",\"item_title\":\"1\",\"link_titles\":\"\",\"published_on\":\"0\",\"category_on\":\"0\",\"show_intro_image\":\"1\",\"readmore\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"layout\":\"theme3589:title-in\",\"moduleclass_sfx\":\"we_are\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h6\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(293, 870, 'About services', '', '', 1, 'position-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{\"catid\":[\"76\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"4\",\"columns\":\"2\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"\",\"item_heading\":\"h2\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"theme3589:custom\",\"masonry\":\"0\",\"moduleclass_sfx\":\"about_services1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"9\",\"bootstrap_offset\":\"3\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(294, 875, 'meet the Team', '', '', 1, 'position-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"center meet\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h6\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(295, 876, 'Our Artists', '', '', 1, 'position-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{\"catid\":[\"26\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"count\":\"4\",\"columns\":\"4\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"578\",\"pretext\":\"\",\"item_title\":\"1\",\"link_titles\":\"1\",\"item_heading\":\"h2\",\"show_introtext\":\"1\",\"introtext_limit\":\"0\",\"show_tags\":\"0\",\"show_category\":\"0\",\"show_hits\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"1\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"masonry\":\"0\",\"moduleclass_sfx\":\"team\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h1\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(296, 877, 'what people say', '', '', 1, 'position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_owl_carousel', 1, 1, '{\"catid\":[\"28\"],\"image\":\"0\",\"item_title\":\"0\",\"link_titles\":\"\",\"published\":\"0\",\"item_heading\":\"h4\",\"show_tags\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"readmore\":\"0\",\"count\":\"5\",\"ordering\":\"a.publish_up\",\"direction\":\"1\",\"pretext\":\"Testimonials\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"people_say\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"items\":\"1\",\"autoplay\":\"1\",\"autoplay_speed\":\"5000\",\"scene_padding_0\":\"50\",\"items_padding_0\":\"50\",\"use_responsive\":\"1\",\"scene_padding_1200\":\"50\",\"items_padding_1200\":\"50\",\"scene_padding_992\":\"50\",\"items_padding_992\":\"50\",\"scene_padding_768\":\"50\",\"items_padding_768\":\"50\",\"scene_padding_480\":\"50\",\"items_padding_480\":\"50\",\"navigation\":\"1\",\"pagination\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"8\",\"bootstrap_offset\":\"2\",\"header_tag\":\"h6\",\"header_class\":\"center\",\"style\":\"0\"}', 0, '*'),
(297, 878, 'Questions img', '', '<img src=\"images/about/page2_img2.jpg\" alt=\"\"/>', 1, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"q_img\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"5\",\"bootstrap_offset\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(298, 879, 'FAQ', '', '', 1, 'position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 1, '{\"catid\":[\"18\"],\"count\":\"3\",\"ordering\":\"a.ordering\",\"collapsed\":\"1\",\"mod_button\":\"0\",\"custom_link_title\":\"\",\"custom_link_route\":\"0\",\"custom_link_url\":\"http:\\/\\/\",\"custom_link_menu\":\"124\",\"pretext\":\"Popular Questions\",\"show_tags\":\"0\",\"published\":\"0\",\"createdby\":\"0\",\"intro_image\":\"0\",\"intro_image_align\":\"none\",\"image\":\"0\",\"readmore\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"custom faq\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"6\",\"bootstrap_offset\":\"1\",\"header_tag\":\"h6\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(79, 0),
(86, 0),
(94, 0),
(103, 0),
(104, 0),
(115, 142),
(118, 336),
(122, 336),
(126, 0),
(127, 0),
(128, 0),
(129, 0),
(130, 0),
(131, 0),
(145, 426),
(159, 0),
(160, 343),
(161, 0),
(162, 0),
(163, 0),
(164, 0),
(165, 0),
(166, 305),
(167, 305),
(168, 305),
(169, 305),
(170, -101),
(171, 136),
(173, 138),
(183, 426),
(184, 426),
(189, 426),
(190, 426),
(192, 426),
(195, 0),
(234, 426),
(235, 0),
(238, 283),
(239, 426),
(240, 426),
(241, 611),
(242, 611),
(243, 611),
(249, 0),
(251, 0),
(252, 0),
(253, 0),
(268, 426),
(269, 142),
(275, 136),
(275, 746),
(275, 747),
(276, 136),
(276, 746),
(276, 747),
(277, 746),
(278, 0),
(279, 0),
(280, 749),
(282, 0),
(283, 0),
(284, 101),
(285, 101),
(286, 101),
(287, 101),
(288, 101),
(289, 101),
(290, 101),
(291, 101),
(292, 584),
(293, 584),
(294, 584),
(295, 584),
(296, 584),
(297, 584),
(298, 584);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7072 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(1, 'SEND_DATE', 'Send Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(2, 'ACTIVATED', 'Activated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(3, 'AFFECTED', 'Attached', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(4, 'PROCESS_CONFIRMATION', 'Are you sure you want to proceed?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(5, 'ERROR_SAVING', 'Error Saving', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(6, 'JOOMEXT_SUCC_SAVED', 'Successfully Saved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(7, 'SUCC_DELETE_ELEMENTS', 'Successfully deleted %s record(s)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(8, 'CONTACT', 'Please Contact us at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(9, 'SUCC_MOVED', 'Successfully Moved Element', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(10, 'ERROR_ORDERING', 'Error Ordering Elements', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(11, 'PUBLISH_CLICK', 'Click here to Publish', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(12, 'UNPUBLISH_CLICK', 'Click here to Unpublish', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(13, 'UNSCHEDULE_CLICK', 'Click here to Unschedule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(14, 'SUBSCRIBE_CLICK', 'Click here to Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(15, 'UNSUBSCRIBE_CLICK', 'Click here to Unsubscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(16, 'CONFIRMATION_CLICK', 'Click here to Confirm the Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(17, 'ENTER_SUBJECT', 'Please enter a Subject', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(18, 'CREATED_DATE', 'Created Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(19, 'RECEIVE_HTML', 'Receive HTML', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(20, 'JOOMEXT_YES', 'Yes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(21, 'JOOMEXT_NO', 'No', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(22, 'JOOMEXT_FILTER', 'Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(23, 'JOOMEXT_GO', 'Go', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(24, 'JOOMEXT_RESET', 'Reset', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(25, 'ACY_CPANEL', 'Dashboard', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(26, 'NAMECAPTION', 'Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(27, 'EMAILCAPTION', 'E-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(28, 'SUBSCRIBECAPTION', 'Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(29, 'UNSUBSCRIBECAPTION', 'Unsubscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(30, 'ALREADY_CONFIRMED', 'You have already confirmed your subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(31, 'SUBSCRIPTION_CONFIRMED', 'Your subscription has been confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(32, 'JOOMEXT_SUBJECT', 'Subject', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(33, 'MAILING_LISTS', 'Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(34, 'CONFIRMATION_SENT', 'A confirmation e-mail has been sent, please click on the confirmation link in order to confirm your subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(35, 'SUBSCRIPTION_OK', 'You have successfully subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(36, 'UNSUBSCRIPTION_OK', 'You have successfully unsubscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(37, 'UNSUBSCRIPTION_NOT_IN_LIST', 'You were not subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(38, 'SUBSCRIPTION_UPDATED_OK', 'Subscription successfully updated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(39, 'ALREADY_SUBSCRIBED', 'You are already subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(40, 'NOT_IN_LIST', 'The e-mail address %s is not in the list of users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(41, 'SCHEDULE', 'Schedule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(42, 'UNSCHEDULE', 'Unschedule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(43, 'SUCC_UNSCHED', 'Newsletter unscheduled Successfully', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(44, 'SPECIFY_DATE', 'Please specify a date to schedule your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(45, 'DATE_FUTURE', 'Please specify a date in the future', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(46, 'AUTOSEND_DATE', 'The Newsletter %s will be automatically sent at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(47, 'NB_SCHED_NEWS', '%s Newsletters scheduled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(48, 'NO_SCHED', 'No Scheduled Newsletter needed to be generated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(49, 'SCHED_NEWS', 'The Newsletter is scheduled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(50, 'SCHEDULE_NEWS', 'Scheduled Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(51, 'SEND_CONTINUE', 'Do you want to continue the send process?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(52, 'CONTINUE', 'Continue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(53, 'SENT_BY', 'Sent by', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(54, 'WRITABLE_FOLDER', 'Please make sure the folder ( %s ) is writeable', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(55, 'ACCEPTED_TYPE', 'This file type ( %s ) is not accepted, the accepted file types are : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(56, 'FAIL_UPLOAD', 'Could not upload the file %s to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(57, 'FAIL_SAVE', 'Could not save the file %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(58, 'BROWSE_FILE', 'Please browse for a file to import', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(59, 'FAIL_OPEN', 'Could not open the file %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(60, 'ADD_ATTACHMENT', 'Attach a new file', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(61, 'MAX_UPLOAD', '( total max upload file size : %s )', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(62, 'ALLOWED_FILES', 'Allowed files', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(63, 'UPLOAD_FOLDER', 'Upload folder', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(64, 'VALID_EMAIL', 'Please enter a valid e-mail address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(65, 'ONLY_LOGGED', 'The subscription is restricted to logged in users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(66, 'ASK_LOG', 'Please log in', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(67, 'INVALID_KEY', 'Key/User not found, please contact the Administrator of this website', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(68, 'NOT_VALID_EMAIL', 'The e-mail address %s is not valid', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(69, 'NAME_MISSING', 'Please enter your name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(70, 'AUTONEWSLETTERS', 'Auto-Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(71, 'AUTONEW', 'Auto-Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(72, 'NO_AUTONEWSLETTERS', 'No Auto-Newsletter needed to be generated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(73, 'NEWSLETTER_GENERATED', 'Newsletter Generated [%s] : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(74, 'NEWSLETTER_NOT_GENERATED', 'Auto-Newsletter [%s] not generated : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(75, 'AUTONEWS_SEND', 'Send the generated Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(76, 'AUTONEWS_WAIT', 'Wait for the confirmation before sending', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(77, 'GENERATE', 'Generate', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(78, 'AUTONEWS_NOT_PUBLISHED', 'The Auto-Newsletter %s is not published', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(79, 'AUTONEWS_NOT_READY', 'The next generate date of the Auto-Newsletter %s has not been reached', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(80, 'EMPTY_LOG', 'The log file is empty', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(81, 'SUCC_DELETE_LOG', 'Log file successfully deleted', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(82, 'ERROR_DELETE_LOG', 'Could not delete the Log file', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(83, 'EXIST_LOG', 'Log file does not exists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(84, 'THANK_YOU_SHARING', 'Thank you for your contribution', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(85, 'ALLOW_VISITOR', 'Allow non-logged in users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(86, 'REQUIRE_CONFIRM', 'Require Confirmation (double opt-in)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(87, 'MESSAGES', 'Messages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(88, 'DISPLAY_MSG_SUBSCRIPTION', 'Display a message on subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(89, 'DISPLAY_MSG_CONFIRM', 'Display a message on confirmation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(90, 'DISPLAY_MSG_WELCOME', 'Display a message when sending the welcome e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(91, 'DISPLAY_MSG_UNSUB', 'Display a message when sending the unsubscribe e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(92, 'NOTIFICATIONS', 'Notifications', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(93, 'NOTIF_CREATE', 'When a new user is created, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(94, 'NOTIF_REFUSE', 'When a user refuses to receive e-mails, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(95, 'NOTIF_UNSUBALL', 'When a user unsubscribes from all Lists, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(96, 'REDIRECTIONS', 'Redirections', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(97, 'REDIRECTION_CONFIRM', 'Redirection after Confirmation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(98, 'REDIRECTION_UNSUB', 'Redirection after Unsubscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(99, 'JOOMEXT_NAME', 'Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(100, 'JOOMEXT_EMAIL', 'E-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(101, 'USERS', 'Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(102, 'NO_SUBSCRIBER', 'No subscriber found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(103, 'NO_RECEIVER', 'No receiver found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(104, 'USER_INFORMATIONS', 'User Information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(105, 'IP', 'IP', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(106, 'USER_ID', 'User ID', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(107, 'VISITOR', 'Visitor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(108, 'ACY_GROUP', 'Group', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(109, 'EDIT_JOOMLA_USER', 'Edit User Profile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(110, 'QUEUE', 'Queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(111, 'CONFIRM_DELETE_QUEUE', 'Are you sure you want to delete those %s records?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(112, 'PRIORITY', 'Priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(113, 'NEWS_PRIORITY', 'Newsletter priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(114, 'FOLLOW_PRIORITY', 'Follow-up priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(115, 'TRY', 'Try', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(116, 'ADDED_QUEUE', '%s e-mails have been added to the queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(117, 'AUTOSEND_CONFIRMATION', 'The system will send them automatically as soon as possible', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(118, 'ALREADY_QUEUED', 'There are already %s e-mails in the queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(119, 'DELETE_QUEUE', 'Please delete those e-mails before scheduling your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(120, 'QUEUE_NEXT_TRY', 'Next try in %s minutes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(121, 'QUEUE_DOUBLE', 'Send process running in parallel detected, the system stopped but you will be able to resume it', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(122, 'ADDED_QUEUE_SCHEDULE', '%s emails have been added to the queue for the Scheduled Newsletter [ID %s] %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(123, 'QUEUE_READY', 'The following e-mails are ready to be sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(124, 'EMAIL_READY', '[ID %s] %s to %s users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(125, 'QUEUE_SCHED', '[ID %s] %s will be sent after %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(126, 'QUEUE_STATUS', 'Queue status at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(127, 'QUEUE_NEXT_SCHEDULE', 'The next e-mail will be sent after %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(128, 'PROCESS', 'Process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(129, 'NO_PROCESS', 'There is nothing to send', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(130, 'NB_PENDING_EMAIL', 'There are %s e-mails in the queue for the Newsletter %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(131, 'ACY_CRON_TRIGGERED', 'AcyMailing Triggered at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(132, 'CRON_NEXT', 'The system won\'t be triggered before %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(133, 'ACY_CRON_PROCESS', '%s messages processed : %s successful, %s failed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(134, 'CREATE_CRON', 'Create/Edit your Cron task', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(135, 'UNSUB_CURRENT', 'Unsubscribe from this Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(136, 'UNSUB_ALL', 'Unsubscribe from all Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(137, 'UNSUB_FULL', 'Do not receive any e-mails from this website in the future', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(138, 'CONFIRM_UNSUB_FULL', 'You won\'t receive any e-mails from this website in the future', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(139, 'CONFIRM_UNSUB_ALL', 'You have been unsubscribed from all Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(140, 'CONFIRM_UNSUB_CURRENT', 'You have been unsubscribed from the Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(141, 'ERROR_NOT_SUBSCRIBED', 'You were not subscribed to any Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(142, 'ERROR_NOT_SUBSCRIBED_CURRENT', 'You were not subscribed to the selected Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(143, 'ACCEPT_TERMS', 'Please check the Terms and Conditions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(144, 'JOOMEXT_TERMS', 'Terms and Conditions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(145, 'UNSUBSCRIBE', 'Unsubscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(146, 'UNSUBSCRIBED', 'Unsubscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(147, 'NO_SUBSCRIPTION', 'No Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(148, 'PENDING_SUBSCRIPTION', 'Wait Confirmation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(149, 'SUBSCRIBED', 'Subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(150, 'ALL_STATUS', 'All Status', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(151, 'ACCEPT_REFUSE', 'Accept / Refuse', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(152, 'ACCEPT_EMAIL', 'Accept E-Mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(153, 'REFUSE_EMAIL', 'Refuse E-Mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(154, 'SUBSCRIPTION', 'Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(155, 'ENABLED_DISABLED', 'Enabled / Disabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(156, 'ENABLED', 'Enabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(157, 'DISABLED', 'Disabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(158, 'UNSUBSCRIBERS', 'Unsubscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(159, 'SUBSCRIBERS', 'Subscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(160, 'SUBSCRIBE_ALL', 'Subscribe to all', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(161, 'SUBSCRIBE', 'Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(162, 'REMOVE', 'Remove', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(163, 'CONFIRMED', 'Confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(164, 'STATUS', 'Status', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(165, 'SUBSCRIPTION_DATE', 'Subscription Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(166, 'UNSUBSCRIPTION_DATE', 'Unsubscription Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(167, 'USER_REFUSE', 'This user refuses to receive future messages from your website', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(168, 'SAVE_CHANGES', 'Save Changes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(169, 'SEND_EMPTY', 'There is no Subject or Body in this e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(170, 'SEND_ERROR', 'Error Sending Message %s to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(171, 'SEND_SUCCESS', 'Message %s successfully sent to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(172, 'SEND_ERROR_PUBLISHED', 'The e-mail ID %s is not published', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(173, 'SEND_ERROR_USER', 'User not found : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(174, 'SEND_ERROR_CONFIRMED', 'The User %s is not confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(175, 'SEND_ERROR_APPROVED', 'The User %s is not enabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(176, 'SEND_ERROR_ACCEPT', 'The User %s does not accept e-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(177, 'SEND_PROCESS', 'Send Process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(178, 'SEND_REFRESH_TIMEOUT', 'Process refreshed to avoid a time limit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(179, 'SEND_REFRESH_CONNECTION', 'Process refreshed to avoid a possible loss of connection', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(180, 'SEND_STOPED', 'The Send Process stopped because there are too many errors', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(181, 'SEND_KEPT_ALL', 'The system kept all non delivered e-mails in the queue, so you will be able to resume the send process later', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(182, 'SEND_CHECKONE', 'Please verify your mail configuration and make sure you can send a test of this e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(183, 'SEND_ADVISE_LIMITATION', 'If you recently, successfully, sent a lot of e-mails, those errors may also be due to your server limitations', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(184, 'SEND_REFUSE', 'Your server apparently refuses to send more e-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(185, 'SEND_CONTINUE_COMMERCIAL', 'Using one of our commercial versions, the system would be able to continue automatically the send process using a Cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(186, 'SEND_CONTINUE_AUTO', 'If you configured a cron task, the system will automatically continue the send process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(187, 'TITLE_ONLY', 'Title Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(188, 'INTRO_ONLY', 'Intro Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(189, 'FULL_TEXT', 'Full text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(190, 'ACY_EACH_TIME', 'Each time AcyMailing is triggered', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(191, 'ACY_ONLY_ACTION', 'Only if AcyMailing executes an action', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(192, 'SIMPLIFIED_REPORT', 'Simplified Report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(193, 'DETAILED_REPORT', 'Detailed Report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(194, 'ALL_EMAILS', 'All E-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(195, 'FILTER_SELECT', 'Select a filter type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(196, 'ACYMAILING_LIST', 'AcyMailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(197, 'ACYMAILING_FIELD', 'AcyMailing Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(198, 'JOOMLA_FIELD', 'Joomla User Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(199, 'CB_FIELD', 'Community Builder Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(200, 'ALL_CREATORS', 'All Creators', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(201, 'ALL_LISTS', 'All lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(202, 'ALL_USERS', 'All Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(203, 'AUTO_ONLY', 'Automatic Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(204, 'AUTO_MAN', 'Automatic / Manual', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(205, 'MANUAL_ONLY', 'Manual Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(206, 'OTHER', 'Other', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(207, 'MANAGER', 'Manager', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(208, 'ADMINISTRATOR', 'Administrator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(209, 'SUPER_ADMIN', 'Super Administrator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(210, 'NO_UNSUB_MESSAGE', 'No unsubscribe message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(211, 'NO_WELCOME_MESSAGE', 'No welcome message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(212, 'EDIT_EMAIL', 'Edit the e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(213, 'CREATE_EMAIL', 'Create a new e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(214, 'ALL_URLS', 'All URLs', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(215, 'HTML_VERSION', 'HTML Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(216, 'TEXT_VERSION', 'Text Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(217, 'INFOS', 'Infos', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(218, 'HOURS', 'Hours', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(219, 'DAYS', 'Days', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(220, 'WEEKS', 'Weeks', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(221, 'MONTHS', 'Months', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(222, 'NB_SUB_UNSUB', 'Number of subscribers/unsubscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(223, 'SUB_HISTORY', 'Subscription History', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(224, 'STATISTICS', 'Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(225, 'GLOBAL_STATISTICS', 'Global Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(226, 'DETAILED_STATISTICS', 'Detailed Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(227, 'OPEN', 'E-mail Opens', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(228, 'OPEN_UNIQUE', 'Unique Opens', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(229, 'OPEN_TOTAL', 'Total Opens', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(230, 'NOT_OPEN', 'Not Opened', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(231, 'OPEN_DATE', 'Open Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(232, 'PERCENT_OPEN', '%s of HTML e-mails have been opened', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(233, 'SENT_HTML', 'Sent in HTML', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(234, 'SENT_TEXT', 'Sent in Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(235, 'FAILED', 'Failed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(236, 'CHARTS', 'Charts', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(237, 'RECEIVED_VERSION', 'Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(238, 'URL', 'URL', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(239, 'URL_NAME', 'URL Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(240, 'URL_EDIT', 'Edit the URL', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(241, 'UNIQUE_HITS', 'Unique Hits', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(242, 'TOTAL_HITS', 'Total Hits', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(243, 'CLICK_STATISTICS', 'Click Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(244, 'CLICKED_LINK', 'Clicked a link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(245, 'PERCENT_CLICK', '%s of users clicked on a link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(246, 'TOTAL_EMAIL_SENT', '%s e-mails sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(247, 'FORWARDED', 'Forwarded', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(248, 'EMAIL_NAME', 'E-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(249, 'SEND_HTML', 'Send HTML Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(250, 'NEXT_GENERATE', 'Next Generate Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(251, 'GENERATE_FREQUENCY', 'Generate Frequency', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(252, 'FREQUENCY', 'Frequency', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(253, 'ISSUE_NB', 'Issue Number', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(254, 'GENERATE_MODE', 'Generating mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(255, 'NOTIFICATION_TO', 'Send notification to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(256, 'EVERY', 'Every', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(257, 'CREATOR', 'Creator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(258, 'ATTACHMENTS', 'Attachments', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(259, 'ATTACHED_FILES', 'Attached Files', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(260, 'NEWSLETTERS', 'Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(261, 'NEWSLETTER', 'Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(262, 'JOOMEXT_VISIBLE', 'Visible', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(263, 'JOOMEXT_ALIAS', 'Alias', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(264, 'TEMPLATE_NAME', 'Template Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(265, 'ACY_TEMPLATE', 'Template', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(266, 'BACKGROUND_COLOUR', 'Background Colour', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(267, 'FOLLOWUP', 'Follow up', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(268, 'CAMPAIGN', 'Campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(269, 'DELAY', 'Delay', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(270, 'FOLLOWUP_ADD', 'Add a new follow-up', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(271, 'CAMPAIGN_START', 'When a user subscribes to one of the following lists, this user will start receiving the campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(272, 'NUM_FOLLOWUP_CAMPAIGN', 'There are %s follow-ups in this Campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(273, 'SENDER_INFORMATIONS', 'Sender Information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(274, 'FROM_NAME', 'From Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(275, 'FROM_ADDRESS', 'From Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(276, 'REPLYTO_NAME', 'Reply-to Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(277, 'REPLYTO_ADDRESS', 'Reply-to Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(278, 'BOUNCE_ADDRESS', 'Bounce Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(279, 'LIST', 'List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(280, 'LISTS', 'Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(281, 'LIST_NAME', 'List Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(282, 'RECEIVE', 'Receive', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(283, 'LIST_CREATE', 'Please create a list first', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(284, 'LIST_RECEIVERS', 'The Newsletter will be sent to the following selected lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(285, 'NEWSLETTER_SENT_TO', 'This Newsletter will be sent to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(286, 'LIST_PUBLISH', 'Please enable this list first', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(287, 'EMAIL_AFFECT', 'Please assign this Email to one or several enabled lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(288, 'COLOUR', 'Colour', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(289, 'MSG_UNSUB', 'Unsubscribe Message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(290, 'MSG_WELCOME', 'Welcome Message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(291, 'NB_PENDING', 'Number of pending users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(292, 'SUB_USERS', 'Subscribe Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(293, 'ACCESS_LEVEL', 'Access Level', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(294, 'ACCESS_LEVEL_SUB', 'View/Subscription Access', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(295, 'ACCESS_LEVEL_MANAGE', 'Front-End Management', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(296, 'SEND_TEST', 'Send a test', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(297, 'SEND_TEST_TO', 'Send a test to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(298, 'EMAIL_ADDRESS', 'Email Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(299, 'SEND_VERSION', 'Send Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(300, 'HTML', 'HTML', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(301, 'JOOMEXT_TEXT', 'Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(302, 'SEND', 'Send', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(303, 'CRON', 'Cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(304, 'NEXT_RUN', 'Next Run time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(305, 'CRON_URL', 'Cron URL', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(306, 'REPORT', 'Report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(307, 'REPORT_SEND', 'Send a report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(308, 'REPORT_SEND_TO', 'Send the report to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(309, 'REPORT_SAVE', 'Save the report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(310, 'REPORT_SAVE_TO', 'Save the report to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(311, 'REPORT_DELETE', 'Delete the report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(312, 'REPORT_SEE', 'See the report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(313, 'REPORT_EDIT', 'Edit Report Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(314, 'LAST_CRON', 'Last Cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(315, 'LAST_RUN', 'Last Run time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(316, 'CRON_TRIGGERED_IP', 'Triggered from the IP', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(317, 'MAIL_CONFIG', 'Mail Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(318, 'QUEUE_PROCESS', 'Queue process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(319, 'PLUGINS', 'Plugins', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(320, 'LANGUAGES', 'Languages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(321, 'MAILER_METHOD', 'Mailer Method', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(322, 'ENCODING_FORMAT', 'Encoding Format', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(323, 'CHARSET', 'Charset', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(324, 'WORD_WRAPPING', 'Word Wrapping', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(325, 'HOSTNAME', 'Hostname', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(326, 'EMBED_IMAGES', 'Embed Images', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(327, 'EMBED_ATTACHMENTS', 'Embed Attachments', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(328, 'MULTIPLE_PART', 'Send Multiple Part', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(329, 'SENDMAIL_PATH', 'SendMail Path', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(330, 'SMTP_CONFIG', 'SMTP Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(331, 'SMTP_SERVER', 'Server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(332, 'SMTP_PORT', 'Port', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(333, 'SMTP_SECURE', 'Secure Method', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(334, 'SMTP_ALIVE', 'Keep Alive', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(335, 'SMTP_AUTHENT', 'Authentication', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(336, 'SMTP_PASSWORD', 'Password', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(337, 'MAX_NB_TRY', 'Maximum number of tries', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(338, 'QUEUE_PROCESSING', 'Queue Processing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(339, 'EDIT_CONF_MAIL', 'Edit Confirmation Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(340, 'EDIT_NOTIFICATION_MAIL', 'Edit Notification Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(341, 'EDIT_LANGUAGE_FILE', 'Edit the language File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(342, 'ADD_LANGUAGE_FILE', 'Add the language File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(343, 'CONFIGURATION', 'Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(344, 'SHARE', 'Share', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(345, 'SHARE_CONFIRMATION_1', 'This Language File will be sent to the Acyba translation team and may be included in the next version.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(346, 'SHARE_CONFIRMATION_2', 'By sharing this file, you allow Acyba to use your work for any purpose.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(347, 'SHARE_CONFIRMATION_3', 'You can add a personal message in the following area which will be included in the e-mail sent to the team.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(348, 'LOAD_ENGLISH_1', 'AcyMailing is actually not translated in this language.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(349, 'LOAD_ENGLISH_2', 'The English version will be loaded so that you can translate it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(350, 'LOAD_ENGLISH_3', 'Once you are done, don\'t forget to share your translation with the rest of the community!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(351, 'LOAD_LATEST_LANGUAGE', 'Load the latest version from our server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(352, 'INTERFACE', 'Interfaces', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(353, 'SHOW_FOOTER', 'Display the brand', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(354, 'FOOTER', 'Footer', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(355, 'MENU', 'Menu', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(356, 'ACYMAILING_MENU', 'Menu Linked to AcyMailing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(357, 'PLUG_INTE', 'Integrations with AcyMailing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(358, 'PLUG_TAG', 'Plugins for the tag system', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(359, 'FORWARD_FEATURE', 'Enable the Forward to a friend', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(360, 'FEATURES', 'Features', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(361, 'ADD_NAMES', 'Add Names', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(362, 'TEST_EMAIL', 'If you receive this message, that means your configuration is Ok', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(363, 'USE_SEF', 'Use SEF Urls', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(364, 'CSS_MODULE_DESC', 'Select the css file you want to load for the front-end Module', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(365, 'CSS_FRONTEND_DESC', 'Select the css file you want to load for the front-end Component', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(366, 'CSS_BACKEND_DESC', 'Select the css file you want to load for the back-end', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(367, 'CSS_MODULE', 'Module CSS File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(368, 'CSS_FRONTEND', 'Component Front-end CSS File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(369, 'CSS_BACKEND', 'Back-end CSS File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(370, 'USE_SEF_DESC', 'You have the possibility to add SEF Urls in the Newsletter itself or keep normal URLs.<br />This option will only apply to e-mails sent from the front-end.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(371, 'ADD_NAMES_DESC', 'Add the Name of the user in the header of the e-mail.<br />Some Mail Servers don\'t accept names, in that case you have to disable this option.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(372, 'FROM_NAME_DESC', 'Default From Name used in all your Newsletters.<br />You can override this property for each Newsletter you write', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(373, 'FROM_ADDRESS_DESC', 'Default E-mail address used as <b><i>from</i></b> in all your Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(374, 'REPLYTO_NAME_DESC', 'Default <b><i>Reply To</i></b> Name used in all your Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(375, 'REPLYTO_ADDRESS_DESC', 'Default E-mail address used as <b><i>reply-to</i></b> in all your Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(376, 'BOUNCE_ADDRESS_DESC', 'This e-mail address will receive all the automatic responses from your receivers.<br />If you don\'t know what this field is, please leave it empty as this field can block your send process if it\'s not configured properly.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(377, 'MAILER_METHOD_DESC', 'Mailer method used to send your e-mails.<br />We recommend the <b><i>PHP Mail Function</i></b>.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(378, 'ENCODING_FORMAT_DESC', 'Encoding format used for all your Newsletters.<br />We recommend <b><i>8-Bit</i></b>.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(379, 'CHARSET_DESC', 'Charset used for all your Newsletters.<br />We recommend <b><i>UTF-8</i></b>.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(380, 'WORD_WRAPPING_DESC', 'Some servers don\'t allow you to send e-mails with more than xx characters per line.<br />This parameter enables you to set this limitation.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(381, 'HOSTNAME_DESC', 'Sets the host name to use in Message-Id and Received headers and as default HELO string.<br />Leave this field empty if you don\'t know what is it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(382, 'EMBED_IMAGES_DESC', 'Should AcyMailing embed your pictures inside the Newsletter?<br />If so, the send process will take more time but the recipient won\'t have to download the picture from your website.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(383, 'EMBED_ATTACHMENTS_DESC', 'Should AcyMailing embed your attachments inside the Newsletter?<br />If not, AcyMailing will add a list of attachments with links to your website in order to download them.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(384, 'MULTIPLE_PART_DESC', 'Should AcyMailing send multiple part e-mails?<br />If so, AcyMailing will send the text and the html version in the e-mail so that depending on the recipient, the appropriate version will be opened.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(385, 'SENDMAIL_PATH_DESC', 'Path used to call the SendMail function.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(386, 'SMTP_SERVER_DESC', 'SMTP Server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(387, 'SMTP_PORT_DESC', 'SMTP Port', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(388, 'SMTP_SECURE_DESC', 'Should AcyMailing use an SMTP Secure Connection?<br />For GMail, you should select SSL.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(389, 'SMTP_ALIVE_DESC', 'Should AcyMailing keep your SMTP Connection opened during the send Process?<br />We recommend to turn ON this option.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(390, 'SMTP_AUTHENT_DESC', 'If you need a username and a password to connect to your SMTP Server, please turn ON this option.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(391, 'USERNAME_DESC', 'Username used to connect to your SMTP Server.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(392, 'SMTP_PASSWORD_DESC', 'Password used to connect to your SMTP Server.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(393, 'CRON_URL_DESC', 'Cron URL to trigger AcyMailing.<br />You should enter this URL to create your cron task.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(394, 'REPORT_SEND_DESC', 'When should AcyMailing send a report?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(395, 'REPORT_SAVE_DESC', 'Which report should AcyMailing save in the log file?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(396, 'REPORT_SEND_TO_DESC', 'You can enter one or several e-mail addresses so that AcyMailing will send the report to those users.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(397, 'REPORT_SAVE_TO_DESC', 'Location of the log file.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(398, 'LAST_RUN_DESC', 'Last time AcyMailing executed actions via the cron URL.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini');
INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(399, 'CRON_TRIGGERED_IP_DESC', 'AcyMailing has been triggered by the following IP.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(400, 'REPORT_DESC', 'Latest report generated by AcyMailing.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(401, 'ALLOWED_FILES_DESC', 'List of allowed file extensions for the attachments.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(402, 'UPLOAD_FOLDER_DESC', 'Folder in which the attachments will be uploaded.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(403, 'DISPLAY_MSG_SUBSCRIPTION_DESC', 'Should AcyMailing display a confirmation message when the user subscribes to your website?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(404, 'DISPLAY_MSG_CONFIRM_DESC', 'Should AcyMailing display a confirmation message when the user confirms their subscription?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(405, 'DISPLAY_MSG_WELCOME_DESC', 'Should AcyMailing display a confirmation message when AcyMailing sends a welcome e-mail?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(406, 'DISPLAY_MSG_UNSUB_DESC', 'Should AcyMailing display a confirmation message when AcyMailing sends an unsubscribe e-mail?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(407, 'ACYMAILING_MENU_DESC', 'Select the Menu you want to link to AcyMailing.<br />Users having problems with access levels should select a menu which is accessible to non-registered users.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(408, 'EDITOR_DESC', 'Select the editor you want to use when editing your AcyMailing E-mails.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(409, 'SHOW_FOOTER_DESC', 'Display the AcyMailing footer on each page?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(410, 'MAX_NB_TRY_DESC', 'If AcyMailing can not send the e-mail after X tries, AcyMailing will delete the e-mail from the queue.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(411, 'QUEUE_PROCESSING_DESC', 'If you use the <b><i>automatic only</i></b> method, AcyMailing will always use the automatic process and won\'t even start the manual send process if you send an e-mail from the back-end.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(412, 'NEWS_PRIORITY_DESC', 'When AcyMailing queues your e-mails, it will order them depending on the send date and the priority.<br />So, if you want your Newsletter to be sent immediately, you can enter a lower number and it will be sent before the others.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(413, 'FOLLOW_PRIORITY_DESC', 'Priority for the Follow-up messages.<br />Usually, you want those e-mails to be sent immediately, so they need a lower number than Newsletters.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(414, 'ALLOW_VISITOR_DESC', 'Do you allow non-logged in visitors to subscribe to your Mailing Lists?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(415, 'REQUIRE_CONFIRM_DESC', 'Should the user have to click on a confirmation link before being considered as a subscriber?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(416, 'NOTIF_CREATE_DESC', 'Send an e-mail to those e-mail addresses each time a new user is created.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(417, 'NOTIF_UNSUBALL_DESC', 'Send an e-mail to those e-mail addresses if a user unsubscribes from all your lists.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(418, 'NOTIF_REFUSE_DESC', 'Send an e-mail to those e-mail addresses if a user refuses to receive messages from your website.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(419, 'REDIRECTION_CONFIRM_DESC', 'Enter the url you want the user to be redirected to after he clicks on the confirmation link in the confirmation e-mail.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(420, 'REDIRECTION_UNSUB_DESC', 'Enter the url you want the user to be redirected to after he unsubscribes.<br />This redirection URL does not apply to the Module Unsubscription! Please edit the AcyMailing module for that.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(421, 'FORWARD_DESC', 'If you select <b><i>No</i></b>, the forward to a friend function won\'t be enabled on your website.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(422, 'FE_INTERFACE', 'Front-end Interface', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(423, 'DEFAULT_SENDER', 'Creator as <b><i>Sender</i></b>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(424, 'DEFAULT_REPLY', 'Creator as <b><i>Reply-to</i></b>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(425, 'DEFAULT_SENDER_DESC', 'Do you want the logged-in user to be the default <b><i>sender</i></b> of a Newsletter created from the front-end?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(426, 'DEFAULT_REPLY_DESC', 'Do you want the logged-in user to be the default <b><i>reply-to</i></b> of a Newsletter created from the front-end?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(427, 'FRONTEND_PRINT', 'Print Icon', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(428, 'FRONTEND_PDF', 'PDF Icon', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(429, 'FRONTEND_PRINT_DESC', 'Do you want AcyMailing to add a Print Icon on the archive Newsletter?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(430, 'FRONTEND_PDF_DESC', 'Do you want AcyMailing to add a PDF Icon on the archive Newsletter?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(431, 'ALLOW_MODIFICATION_DESC', 'Do you allow the user to modify his data without being identified?<br />If you select <b><i>No</i></b>, the data entered by the user cannot be changed afterwards except if he\'s identified by the system.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(432, 'ALLOW_MODIFICATION', 'Allow user data modifications without identification', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(433, 'ONLY_SUBSCRIPTION', 'Only his subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(434, 'IDENTIFICATION_SENT', 'An email to verify your identity has been sent to you.<br />Please click on the link in the email to be able to modify your subscription.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(435, 'QUEUE_PAUSE', 'Pause between two batches', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(436, 'QUEUE_PAUSE_DESC', 'If you use the manual send process, you can configure AcyMailing to make a pause between two batches to throttle your send process (in seconds).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(437, 'SHOW_DESCRIPTION', 'Display list description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(438, 'SHOW_DESCRIPTION_DESC', 'Display the list description on the archive Newsletters?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(439, 'SHOW_SENDDATE', 'Display send-date column', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(440, 'SHOW_SENDDATE_DESC', 'Display the send-date on the archive Newsletters?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(441, 'SHOW_FILTER', 'Display Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(442, 'SHOW_FILTER_DESC', 'Display the filter on the archive Newsletters?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(443, 'ACY_ERROR_INSTALLAGAIN', 'And then click here to trigger the install process again.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(444, 'DISPLAY_MSG_CONFIRMATION', 'Display a message when sending the confirmation e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(445, 'DISPLAY_MSG_CONFIRMATION_DESC', 'Should AcyMailing display a confirmation message when AcyMailing sends the confirmation e-mails?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(446, 'DISPLAY_MSG_UNSUBSCRIPTION', 'Display a message on unsubscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(447, 'DISPLAY_MSG_UNSUBSCRIPTION_DESC', 'Should AcyMailing display a message when the user unsubscribes from your website?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB