<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$app = JFactory::getApplication('site');
$template = $app->getTemplate(true);
JHtml::_('formbehavior.chosen', 'select');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');
?>
<section class="page-blog page-blog__<?php echo $this->pageclass_sfx;?>" itemscope itemtype="http://schema.org/Blog">
	<?php if ($this->params->get('show_page_heading', 1)) : ?>
	<header class="page_header">
		<<?php echo $template->params->get('blogPageHeading', 'h3'); ?>><?php echo $this->escape($this->params->get('page_heading')); ?></<?php echo $template->params->get('blogPageHeading', 'h3'); ?>>
	</header>
	<?php endif;

	if ($this->params->get('show_category_title', 1) or $this->params->get('page_subheading')) : ?>
	<header class="category_title">
		<h2> <?php echo $this->escape($this->params->get('page_subheading'));
			if ($this->params->get('show_category_title')) : ?>
			<span class="subheading-category"><?php echo $this->category->title;?></span>
			<?php endif; ?>
		</h2>
	</hader>
	<?php endif;

	if ($this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) : ?>
	<article class="category_desc">
		<?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
		<img src="<?php echo $this->category->getParams()->get('image'); ?>"/>
		<?php endif;
		if ($this->params->get('show_description') && $this->category->description) :
		echo JHtml::_('content.prepare', $this->category->description, '', 'com_content.category');
		endif; ?>
		<div class="clr"></div>
	</article>
	<?php endif;

	$leadingcount = 0;
	if (!empty($this->lead_items)) : ?>
	<div class="items-leading">
		<?php foreach ($this->lead_items as &$item) : ?>
		<article class="leading-<?php echo $leadingcount; ?><?php echo $item->state == 0 ? ' system-unpublished' : null; ?> item" id="item-<?php echo $item->id; ?>">
			<?php
			$this->item = &$item;
			echo $this->loadTemplate('item');
			?>
		</article>
		<div class="clearfix"></div>
		<?php	$leadingcount++;
		endforeach; ?>
	</div><!-- end items-leading -->
	<div class="clearfix"></div>
	<?php endif;


	$introcount = (count($this->intro_items));
	$counter = 0;
	if (!empty($this->intro_items)) :
	foreach ($this->intro_items as $key => &$item) :
	$rowcount = (((int) $key) % (int) $this->columns) + 1;
	$row = $counter / $this->columns;

	if ($rowcount == 1) : ?>
	<div class="items-row cols-<?php echo (int) $this->columns;?> row">
	<?php endif; ?>
		<div class="col-sm-<?php echo round((12 / $this->columns));?>">
			<article class="item column-<?php echo $rowcount;?><?php echo $item->state == 0 ? ' system-unpublished' : null; ?>" id="item-<?php echo $item->id; ?>">
				<?php
				$this->item = &$item;
				echo $this->loadTemplate('item');
				?>
			</article><!-- end item -->
			<?php $counter++; ?>
		</div><!-- end spann -->
		<?php if (($rowcount == $this->columns) or ($counter == $introcount)): ?>			
	</div><!-- end row -->
	<?php endif;
	endforeach;
	endif;
	
	if (!empty($this->link_items)) : ?>
	<div class="items-more">
		<?php echo $this->loadTemplate('links'); ?>
	</div>
	<?php endif;


	if (!empty($this->children[$this->category->id])&& $this->maxLevel != 0) : ?>
	<div class="category_children">
		<h3> <?php echo JTEXT::_('JGLOBAL_SUBCATEGORIES'); ?> </h3>
		<?php echo $this->loadTemplate('children'); ?>
	</div>
	<?php endif;
	if (($this->params->def('show_pagination', 1) == 1  || ($this->params->get('show_pagination') == 2)) && ($this->pagination->get('pages.total') > 1)) : ?>
	<footer class="pagination">
		<?php if ($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter"> <?php echo $this->pagination->getPagesCounter(); ?> </p>
		<?php endif;
		echo $this->pagination->getPagesLinks(); ?>
	</footer>
	<?php  endif; ?>
</section>