<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$app = JFactory::getApplication('site');
$template = $app->getTemplate(true);

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

// If the page class is defined, add to class as suffix.
// It will be a separate class if the user starts it with a space
?>
<section class="page-featured page-featured__<?php echo $this->pageclass_sfx;?>">
	<?php if ($this->params->get('show_page_heading') != 0) : ?>
	<header class="page_header">
		<?php echo '<'.$template->params->get('categoryItemHeading','h4').'>'.$this->escape($this->params->get('page_heading')).'</'.$template->params->get('categoryItemHeading','h4').'>'; ?>
	</header>
	<?php endif;

	$leadingcount = 0;
	if (!empty($this->lead_items)) : ?>
	<div class="items-leading">
		<?php foreach ($this->lead_items as &$item) : ?>
		<div class="leading-<?php echo $leadingcount; ?><?php echo $item->state == 0 ? ' system-unpublished' : null; ?>">
			<?php
			$this->item = &$item;
			echo $this->loadTemplate('item');
			?>
		</div>
		<div class="clearfix"></div>
		<?php	$leadingcount++;
		endforeach; ?>
	</div>
	<div class="clearfix"></div>
	<?php endif;
	$introcount = (count($this->intro_items));
	$counter = 0;
	if (!empty($this->intro_items)) :
	foreach ($this->intro_items as $key => &$item) :

	$rowcount = (((int) $key) % (int) $this->columns) + 1;
	$row = $counter / $this->columns;

	if ($rowcount == 1) : ?>
	<div class="items-row cols-<?php echo (int) $this->columns;?> row">
		<?php endif; ?>
		<article class="item column-<?php echo $rowcount;?><?php echo $item->state == 0 ? ' system-unpublished' : null; ?> col-sm-<?php echo round((12 / $this->columns));?>">
			<?php
			$this->item = &$item;
			echo $this->loadTemplate('item');
			?>
			<div class="clearfix"></div>
		</article>
		<?php $counter++;

		if (($rowcount == $this->columns) or ($counter == $introcount)): ?>

	</div>
	<?php endif;

	endforeach;
	endif;

	if (!empty($this->link_items)) : ?>
	<div class="items-more">
		<?php echo $this->loadTemplate('links'); ?>
	</div>
	<?php endif;

	if ($this->params->def('show_pagination', 2) == 1  || ($this->params->get('show_pagination') == 2 && $this->pagination->pagesTotal > 1)) : ?>
	<div class="pagination">
		<?php if ($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter pull-right"><?php echo $this->pagination->getPagesCounter(); ?></p>
		<?php  endif;
		echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>
</section>